(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     16637,        620]
NotebookOptionsPosition[     12938,        495]
NotebookOutlinePosition[     14318,        534]
CellTagsIndexPosition[     14233,        529]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["LINEAR REGRESSION PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Regression Package" :> 
          Documentation`HelpLookup[
           "paclet:LinearRegression/tutorial/LinearRegression"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Linear Regression Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DesignedRegress" :> 
          Documentation`HelpLookup[
           "paclet:LinearRegression/ref/DesignedRegress"], "Regress" :> 
          Documentation`HelpLookup["paclet:LinearRegression/ref/Regress"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"DesignedRegress\"\>", 
       2->"\<\"Regress\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["DesignMatrix", "ObjectName",
 CellID->28768],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"DesignMatrix", "[", 
       RowBox[{
        StyleBox["data", "TI"], ",", 
        StyleBox["funs", "TI"], ",", 
        StyleBox["vars", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the design matrix for ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " as a linear combination of the functions ",
     Cell[BoxData[
      StyleBox["funs", "TI"]], "InlineFormula"],
     " of the variables ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17040]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " row of a design matrix contains the values of the basis functions ",
 Cell[BoxData[
  StyleBox["funs", "TI"]], "InlineFormula"],
 " evaluated at the values for the ",
 Cell[BoxData[
  SuperscriptBox[
   StyleBox["i", "TI"], 
   StyleBox["th", "TI"]]], "InlineFormula"],
 " element in ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->135812673],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " can have the",
 " ",
 "form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["1", "TR"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["1", "TR"]], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["1", "TR"]]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["2", "TR"]], ",", 
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["2", "TR"]], ",", "\[Ellipsis]", ",", 
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["2", "TR"]]}], "}"}], ",", "\[Ellipsis]"}], "}"}]], 
  "InlineFormula"],
 ", where the number of coordinates ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ",", " ", 
   StyleBox["y", "TI"], ",", " ", "\[Ellipsis]"}]], "InlineFormula"],
 " is equal to the number of variables in the list ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 ". "
}], "Notes",
 CellID->9501],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  StyleBox["data", "TI"]], "InlineFormula"],
 " can also be of the form ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["1", "TR"]], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "}"}]], "InlineFormula"],
 ", with a single coordinate assumed to take values ",
 Cell[BoxData[
  RowBox[{
   StyleBox["1", "TR"], ",", 
   StyleBox["2", "TR"], ",", 
   StyleBox["\[Ellipsis]", "TI"]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->754525989],

Cell[TextData[{
 "The argument ",
 Cell[BoxData[
  StyleBox["funs", "TI"]], "InlineFormula"],
 " can be any list of functions that depend only on the variables ",
 Cell[BoxData[
  StyleBox["vars", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17482],

Cell["The following option can be given:", "Notes",
 CellID->31531],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["IncludeConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:LinearRegression/ref/IncludeConstant"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell["\<\
whether to automatically include a constant as one of the functions\
\>", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->12933],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IncludeConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/IncludeConstant"], "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 ", the constant ",
 Cell[BoxData["1"], "InlineFormula"],
 " is included as the first entry in the list of basis functions if a \
constant is not included in ",
 Cell[BoxData[
  StyleBox["funs", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23779]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->27420709],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->73462940],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->469515497],

Cell["Design matrix for a straight line:", "ExampleText",
 CellID->661075337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", "x", ",", "x"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->72485236],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->20430781]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->425291669],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->32041527],

Cell["Design matrix for a quadratic curve:", "ExampleText",
 CellID->600399778],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22088603],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3", ",", "9"}], "}"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{213, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->214857677]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5725],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "IncludeConstant",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->288],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->77372468],

Cell["Design matrix for a quadratic curve without a constant term:", \
"ExampleText",
 CellID->183416150],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "6"}], "}"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"x", "^", "2"}]}], "}"}], ",", "x", ",", 
   RowBox[{"IncludeConstant", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->224608113],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "9"}], "}"}]}], "}"}]], "Output",
 ImageSize->{158, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->217207557]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2095],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DesignedRegress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/DesignedRegress"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Regress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/Regress"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24365]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->20663],

Cell[TextData[ButtonBox["Linear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/tutorial/LinearRegression"]], "Tutorials",
 CellID->12259]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"DesignMatrix - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 20.6966170}", "context" -> 
    "LinearRegression`", 
    "keywords" -> {"design matrix", "linear regression", "least squares"}, 
    "index" -> True, "label" -> "Linear Regression Package Symbol", 
    "language" -> "en", "paclet" -> "LinearRegression Package", "status" -> 
    "None", "summary" -> 
    "DesignMatrix[data, funs, vars] gives the design matrix for data as a \
linear combination of the functions funs of the variables vars.", 
    "synonyms" -> {}, "title" -> "DesignMatrix", "type" -> "Symbol", "uri" -> 
    "LinearRegression/ref/DesignMatrix"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[7107, 256, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->27420709]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 14091, 522}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1368, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1991, 62, 50, 1, 70, "ObjectName",
 CellID->28768],
Cell[2044, 65, 775, 24, 70, "Usage",
 CellID->17040]
}, Open  ]],
Cell[CellGroupData[{
Cell[2856, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3334, 111, 515, 19, 70, "Notes",
 CellID->135812673],
Cell[3852, 132, 1150, 43, 70, "Notes",
 CellID->9501],
Cell[5005, 177, 589, 22, 70, "Notes",
 CellID->754525989],
Cell[5597, 201, 256, 9, 70, "Notes",
 CellID->17482],
Cell[5856, 212, 67, 1, 70, "Notes",
 CellID->31531],
Cell[5926, 215, 588, 16, 70, "3ColumnTableMod",
 CellID->12933],
Cell[6517, 233, 553, 18, 70, "Notes",
 CellID->23779]
}, Closed]],
Cell[CellGroupData[{
Cell[7107, 256, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->27420709],
Cell[CellGroupData[{
Cell[7491, 270, 147, 5, 70, "ExampleSection",
 CellID->73462940],
Cell[7641, 277, 141, 4, 70, "Input",
 CellID->469515497],
Cell[7785, 283, 77, 1, 70, "ExampleText",
 CellID->661075337],
Cell[CellGroupData[{
Cell[7887, 288, 212, 7, 28, "Input",
 CellID->72485236],
Cell[8102, 297, 467, 17, 36, "Output",
 CellID->20430781]
}, Open  ]],
Cell[8584, 317, 125, 3, 70, "ExampleDelimiter",
 CellID->425291669],
Cell[8712, 322, 140, 4, 70, "Input",
 CellID->32041527],
Cell[8855, 328, 79, 1, 70, "ExampleText",
 CellID->600399778],
Cell[CellGroupData[{
Cell[8959, 333, 433, 15, 70, "Input",
 CellID->22088603],
Cell[9395, 350, 439, 15, 36, "Output",
 CellID->214857677]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9883, 371, 217, 7, 70, "ExampleSection",
 CellID->5725],
Cell[CellGroupData[{
Cell[10125, 382, 230, 7, 70, "ExampleSubsection",
 CellID->288],
Cell[10358, 391, 140, 4, 70, "Input",
 CellID->77372468],
Cell[10501, 397, 105, 2, 70, "ExampleText",
 CellID->183416150],
Cell[CellGroupData[{
Cell[10631, 403, 492, 16, 70, "Input",
 CellID->224608113],
Cell[11126, 421, 361, 13, 36, "Output",
 CellID->217207557]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11560, 442, 310, 9, 70, "SeeAlsoSection",
 CellID->2095],
Cell[11873, 453, 497, 17, 70, "SeeAlso",
 CellID->24365]
}, Open  ]],
Cell[CellGroupData[{
Cell[12407, 475, 314, 9, 70, "TutorialsSection",
 CellID->20663],
Cell[12724, 486, 172, 4, 70, "Tutorials",
 CellID->12259]
}, Open  ]],
Cell[12911, 493, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

