(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10618,        386]
NotebookOptionsPosition[      7863,        295]
NotebookOutlinePosition[      9192,        332]
CellTagsIndexPosition[      9108,        327]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["LINEAR REGRESSION PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Linear Regression Package" :> 
          Documentation`HelpLookup[
           "paclet:LinearRegression/tutorial/LinearRegression"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Linear Regression Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Regress" :> 
          Documentation`HelpLookup["paclet:LinearRegression/ref/Regress"], 
          "DesignMatrix" :> 
          Documentation`HelpLookup[
           "paclet:LinearRegression/ref/DesignMatrix"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Regress\"\>", 
       2->"\<\"DesignMatrix\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["IncludeConstant", "ObjectName",
 CellID->900],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["IncludeConstant"], "InlineFormula"],
     " \[LineSeparator]is an option for ",
     Cell[BoxData[
      ButtonBox["Regress",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      ButtonBox["DesignMatrix",
       BaseStyle->"Link",
       ButtonData->"paclet:LinearRegression/ref/DesignMatrix"]], 
      "InlineFormula"],
     " that specifies whether a constant term is automatically included in \
the model."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32591]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The default setting ",
 Cell[BoxData[
  RowBox[{"IncludeConstant", "->", 
   ButtonBox["True",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/True"]}]], "InlineFormula"],
 " adds a constant term to the set of basis functions if a constant is not \
already included."
}], "Notes",
 CellID->1655],

Cell[TextData[{
 "The setting ",
 Cell[BoxData[
  RowBox[{"IncludeConstant", "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " leaves the set of basis functions unchanged."
}], "Notes",
 CellID->142084574],

Cell[TextData[{
 "In the output of ",
 Cell[BoxData[
  ButtonBox["DesignMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignMatrix"]], 
  "InlineFormula"],
 ", the constant term is included as the first column."
}], "Notes",
 CellID->176636240]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->10044212],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->205256543],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<LinearRegression`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->200458712],

Cell["\<\
Design matrices with and without a constant automatically included:\
\>", "ExampleText",
 CellID->661075337],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "x", "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->942129852],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "2"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4"}], "}"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{209, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->393399901]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignMatrix", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3", ",", "4"}], "}"}], ",", 
   RowBox[{"{", "x", "}"}], ",", "x", ",", 
   RowBox[{"IncludeConstant", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->114780142],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "1", "}"}], ",", 
   RowBox[{"{", "2", "}"}], ",", 
   RowBox[{"{", "3", "}"}], ",", 
   RowBox[{"{", "4", "}"}]}], "}"}]], "Output",
 GeneratedCell->True,
 CellAutoOverwrite->True,
 ImageSize->{136, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->183739871]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6483],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Regress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/Regress"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DesignMatrix",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/DesignMatrix"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->27595]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6359],

Cell[TextData[ButtonBox["Linear Regression Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:LinearRegression/tutorial/LinearRegression"]], "Tutorials",
 CellID->27624]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"IncludeConstant - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 26.3998880}", "context" -> 
    "LinearRegression`", "keywords" -> {}, "index" -> True, "label" -> 
    "Linear Regression Package Symbol", "language" -> "en", "paclet" -> 
    "LinearRegression Package", "status" -> "None", "summary" -> 
    "IncludeConstant is an option for Regress and DesignMatrix that specifies \
whether a constant term is automatically included in the model.", 
    "synonyms" -> {}, "title" -> "IncludeConstant", "type" -> "Symbol", "uri" -> 
    "LinearRegression/ref/IncludeConstant"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4204, 147, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->10044212]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 8966, 320}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1369, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1992, 63, 51, 1, 70, "ObjectName",
 CellID->900],
Cell[2046, 66, 743, 22, 70, "Usage",
 CellID->32591]
}, Open  ]],
Cell[CellGroupData[{
Cell[2826, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3304, 110, 316, 10, 70, "Notes",
 CellID->1655],
Cell[3623, 122, 268, 9, 70, "Notes",
 CellID->142084574],
Cell[3894, 133, 273, 9, 70, "Notes",
 CellID->176636240]
}, Closed]],
Cell[CellGroupData[{
Cell[4204, 147, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->10044212],
Cell[CellGroupData[{
Cell[4588, 161, 148, 5, 70, "ExampleSection",
 CellID->205256543],
Cell[4739, 168, 141, 4, 70, "Input",
 CellID->200458712],
Cell[4883, 174, 118, 3, 70, "ExampleText",
 CellID->661075337],
Cell[CellGroupData[{
Cell[5026, 181, 234, 7, 28, "Input",
 CellID->942129852],
Cell[5263, 190, 468, 17, 36, "Output",
 CellID->393399901]
}, Open  ]],
Cell[CellGroupData[{
Cell[5768, 212, 292, 8, 28, "Input",
 CellID->114780142],
Cell[6063, 222, 368, 13, 36, "Output",
 CellID->183739871]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6492, 242, 310, 9, 70, "SeeAlsoSection",
 CellID->6483],
Cell[6805, 253, 491, 17, 70, "SeeAlso",
 CellID->27595]
}, Open  ]],
Cell[CellGroupData[{
Cell[7333, 275, 313, 9, 70, "TutorialsSection",
 CellID->6359],
Cell[7649, 286, 172, 4, 70, "Tutorials",
 CellID->27624]
}, Open  ]],
Cell[7836, 293, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

