(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    108490,       3247]
NotebookOptionsPosition[    100001,       2985]
NotebookOutlinePosition[    102763,       3042]
CellTagsIndexPosition[    102720,       3039]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["LINEAR REGRESSION PACKAGE TUTORIAL", "PacletNameCell"], Cell[
    TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AdjustedRSquared" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/AdjustedRSquared"], "ANOVATable" :> 
         Documentation`HelpLookup["paclet:RegressionCommon/ref/ANOVATable"], 
         "BestFit" :> 
         Documentation`HelpLookup["paclet:RegressionCommon/ref/BestFit"], 
         "BestFitParameters" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/BestFitParameters"], 
         "BestFitParametersDelta" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/BestFitParametersDelta"], 
         "CatcherMatrix" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/CatcherMatrix"], 
         "CoefficientOfVariation" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/CoefficientOfVariation"], "CookD" :> 
         Documentation`HelpLookup["paclet:RegressionCommon/ref/CookD"], 
         "CorrelationMatrix" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/CorrelationMatrix"], 
         "CovarianceMatrix" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/CovarianceMatrix"], 
         "CovarianceMatrixDetRatio" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/CovarianceMatrixDetRatio"], 
         "DesignedRegress" :> 
         Documentation`HelpLookup[
          "paclet:LinearRegression/ref/DesignedRegress"], "DesignMatrix" :> 
         Documentation`HelpLookup["paclet:LinearRegression/ref/DesignMatrix"],
          "DurbinWatsonD" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/DurbinWatsonD"], "EigenstructureTable" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/EigenstructureTable"], 
         "EstimatedVariance" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/EstimatedVariance"], "FitResiduals" :> 
         Documentation`HelpLookup["paclet:RegressionCommon/ref/FitResiduals"],
          "HatDiagonal" :> 
         Documentation`HelpLookup["paclet:RegressionCommon/ref/HatDiagonal"], 
         "JackknifedVariance" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/JackknifedVariance"], 
         "MeanPredictionCITable" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/MeanPredictionCITable"], 
         "ParameterCITable" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/ParameterCITable"], 
         "ParameterConfidenceRegion" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/ParameterConfidenceRegion"], 
         "ParameterTable" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/ParameterTable"], 
         "PartialSumOfSquares" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/PartialSumOfSquares"], 
         "PredictedResponse" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/PredictedResponse"], 
         "PredictedResponseDelta" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/PredictedResponseDelta"], "Regress" :> 
         Documentation`HelpLookup["paclet:LinearRegression/ref/Regress"], 
         "RSquared" :> 
         Documentation`HelpLookup["paclet:RegressionCommon/ref/RSquared"], 
         "SequentialSumOfSquares" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/SequentialSumOfSquares"], 
         "SinglePredictionCITable" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/SinglePredictionCITable"], 
         "StandardizedResiduals" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/StandardizedResiduals"], 
         "StudentizedResiduals" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/StudentizedResiduals"], 
         "VarianceInflation" :> 
         Documentation`HelpLookup[
          "paclet:RegressionCommon/ref/VarianceInflation"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"AdjustedRSquared\"\>", 
      2->"\<\"ANOVATable\"\>", 3->"\<\"BestFit\"\>", 
      4->"\<\"BestFitParameters\"\>", 5->"\<\"BestFitParametersDelta\"\>", 
      6->"\<\"CatcherMatrix\"\>", 7->"\<\"CoefficientOfVariation\"\>", 
      8->"\<\"CookD\"\>", 9->"\<\"CorrelationMatrix\"\>", 
      10->"\<\"CovarianceMatrix\"\>", 11->"\<\"CovarianceMatrixDetRatio\"\>", 
      12->"\<\"DesignedRegress\"\>", 13->"\<\"DesignMatrix\"\>", 
      14->"\<\"DurbinWatsonD\"\>", 15->"\<\"EigenstructureTable\"\>", 
      16->"\<\"EstimatedVariance\"\>", 17->"\<\"FitResiduals\"\>", 
      18->"\<\"HatDiagonal\"\>", 19->"\<\"JackknifedVariance\"\>", 
      20->"\<\"MeanPredictionCITable\"\>", 21->"\<\"ParameterCITable\"\>", 
      22->"\<\"ParameterConfidenceRegion\"\>", 23->"\<\"ParameterTable\"\>", 
      24->"\<\"PartialSumOfSquares\"\>", 25->"\<\"PredictedResponse\"\>", 
      26->"\<\"PredictedResponseDelta\"\>", 27->"\<\"Regress\"\>", 
      28->"\<\"RSquared\"\>", 29->"\<\"SequentialSumOfSquares\"\>", 
      30->"\<\"SinglePredictionCITable\"\>", 
      31->"\<\"StandardizedResiduals\"\>", 32->"\<\"StudentizedResiduals\"\>",
       33->"\<\"VarianceInflation\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Linear Regression Package", "Title",
 CellID->31317],

Cell[TextData[{
 "The built\[Hyphen]in function ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 " finds a least\[Hyphen]squares fit to a list of data as a linear \
combination of the specified basis functions. The functions ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["DesignedRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
  "InlineFormula"],
 " provided in this package augment ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 " by giving a list of commonly required diagnostics such as the coefficient \
of determination ",
 Cell[BoxData[
  ButtonBox["RSquared",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RSquared"]], "InlineFormula"],
 ", the analysis of variance table ",
 Cell[BoxData[
  ButtonBox["ANOVATable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ANOVATable"]], "InlineFormula"],
 ", and the mean squared error ",
 Cell[BoxData[
  ButtonBox["EstimatedVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/EstimatedVariance"]], 
  "InlineFormula"],
 ". The output of regression functions can be controlled so that only needed \
information is produced. The ",
 ButtonBox["Nonlinear Regression Package",
  BaseStyle->"Link",
  ButtonData->"paclet:NonlinearRegression/guide/NonlinearRegressionPackage"],
 " provides analogous functionality for nonlinear models."
}], "Text",
 CellID->22815],

Cell[TextData[{
 "The basis functions ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["f", "TI"], 
    StyleBox["j", "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " specify the predictors as functions of the independent variables. The \
resulting model for the response variable is ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]], "=", 
    SubscriptBox["\[Beta]", "1"], 
    SubscriptBox[
     StyleBox["f", "TI"], 
     RowBox[{"1", 
      StyleBox["i", "TI"]}]], "+", 
    SubscriptBox["\[Beta]", "2"], 
    SubscriptBox[
     StyleBox["f", "TI"], 
     RowBox[{"2", 
      StyleBox["i", "TI"]}]], "+", "\[Ellipsis]", "+", 
    SubscriptBox["\[Beta]", 
     StyleBox["p", "TI"]], 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox[
      RowBox[{"p", "i"}], "TI"]], "+", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["i", "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", where ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["y", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is the ",
 Cell[BoxData[
  FormBox[
   StyleBox["i", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 "response, ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["f", "TI"], 
    StyleBox[
     RowBox[{"j", "i"}], "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is the ",
 Cell[BoxData[
  FormBox[
   StyleBox["j", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " basis function evaluated at the ",
 Cell[BoxData[
  FormBox[
   StyleBox["i", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " observation, and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["e", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is the ",
 Cell[BoxData[
  FormBox[
   StyleBox["i", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " residual error."
}], "Text",
 CellID->23759],

Cell[TextData[{
 "Estimates of the coefficients ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox["\[Beta]", "1"], ",", "\[Ellipsis]", ",", 
    SubscriptBox["\[Beta]", 
     StyleBox["p", "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " are calculated to minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", 
     StyleBox["i", "TI"],
     LimitsPositioning->True], 
    SubsuperscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["i", "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", the error or residual sum of squares. For example, simple linear \
regression is accomplished by defining the basis functions as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], "1"], "=", "1"}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " and ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], "2"], "=", 
    StyleBox["x", "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", in which case ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "1"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[Beta]", "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " are found to minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderscriptBox["\[Sum]", 
     StyleBox["i", "TI"],
     LimitsPositioning->True], 
    SuperscriptBox[
     RowBox[{"[", 
      RowBox[{
       SubscriptBox[
        StyleBox["y", "TI"], 
        StyleBox["i", "TI"]], "-", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Beta]", "1"], "+", 
         SubscriptBox["\[Beta]", "2"], 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["i", "TI"]]}], ")"}]}], "]"}], "2"]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ". "
}], "Text",
 CellID->21964],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Regress",
      BaseStyle->"Link",
      ButtonData->"paclet:LinearRegression/ref/Regress"], "[", 
     RowBox[{
      StyleBox["data", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["1", "TI"], ",", 
        StyleBox["x", "TI"], ",", 
        SuperscriptBox[
         StyleBox["x", "TI"], "2"]}], "}"}], ",", 
      StyleBox["x", "TI"]}], "]"}], Cell[TextData[{
     "fits a list of data points",
     " ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " ",
     "to a quadratic model "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Regress",
      BaseStyle->"Link",
      ButtonData->"paclet:LinearRegression/ref/Regress"], "[", 
     RowBox[{
      StyleBox["data", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        StyleBox["1", "TI"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], "2"], ",", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], "1"], 
         SubscriptBox[
          StyleBox["x", "TI"], "2"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["1", "TR"]], ",", 
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["2", "TR"]]}], "}"}]}], "]"}], Cell[TextData[{
     "fits",
     " ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " ",
     "to a model that includes interaction between independent variables ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "1"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "2"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Regress",
      BaseStyle->"Link",
      ButtonData->"paclet:LinearRegression/ref/Regress"], "[", 
     RowBox[{
      StyleBox["data", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], "2"], 
        StyleBox["\[Ellipsis]", "TI"]}], "}"}], ",", 
      StyleBox["vars", "TI"]}], "]"}], Cell[TextData[{
     "fits",
     " ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " ",
     "to a model as a linear combination of the functions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " of variables",
     " ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->755],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->3347],

Cell[TextData[{
 "The arguments of ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 " are of the same form as those of ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 ". The data can be a list of vectors, each vector consisting of the observed \
values of the independent variables and the associated response. The basis \
functions ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["f", "TI"], 
    StyleBox["j", "TI"]], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " must be functions of the symbols given as variables. These symbols \
correspond to the independent variables represented in the data. By default, \
a constant function ",
 Cell[BoxData[
  RowBox[{
   SubscriptBox[
    StyleBox["f", "TI"], 
    StyleBox["j", "TI"]], "=", "1"}]], "InlineFormula"],
 " is added to the list of basis functions if not explicitly given in the \
list of basis functions. "
}], "Text",
 CellID->7030],

Cell[TextData[{
 "The data can also be a vector of data points. In this case, ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 " assumes that this vector represents the values of a response variable with \
the independent variable having values ",
 Cell[BoxData[
  FormBox["1", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", ",
 Cell[BoxData[
  FormBox["2", TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", \[Ellipsis] . "
}], "Text",
 CellID->1413],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     StyleBox["{", "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], "1"]], "InlineFormula"], 
     StyleBox[",", "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], "2"]], "InlineFormula"], 
     StyleBox[",", "MR"], 
     StyleBox[" ", "MR"], 
     StyleBox["\[Ellipsis]", "MR"], 
     StyleBox[" ", "MR"], 
     StyleBox["}", "MR"]}], Cell[TextData[{
     "data points specified by a list of response values, where a single \
independent variable is assumed to take the values ",
     Cell[BoxData["1"], "InlineFormula"],
     ", ",
     Cell[BoxData["2"], "InlineFormula"],
     ", \[Ellipsis] "
    }], "TableText"]},
   {
    RowBox[{
     StyleBox[
      RowBox[{"{", "{"}], "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "11"]], "InlineFormula"], 
     StyleBox[
      RowBox[{",", " "}], "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "12"]], "InlineFormula"], 
     StyleBox[
      RowBox[{",", " ", "\[Ellipsis]", " ", ",", " "}], "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], "1"]], "InlineFormula"], 
     StyleBox[
      RowBox[{"}", ",", "{"}], "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "21"]], "InlineFormula"], 
     StyleBox[
      RowBox[{",", " "}], "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], "22"]], "InlineFormula"], 
     StyleBox[
      RowBox[{",", " ", "\[Ellipsis]", " ", ",", " "}], "MR"], Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], "2"]], "InlineFormula"], 
     StyleBox[
      RowBox[{
       RowBox[{"}", ",", " ", "\[Ellipsis]"}], " ", "}"}], "MR"], " "}], Cell[
    TextData[{
     "data points specified by a matrix, where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox[
        RowBox[{"i", "k"}], "TI"]]], "InlineFormula"],
     " is the value of the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " case of the ",
     Cell[BoxData[
      StyleBox["k", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " independent variable, and ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["y", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " response "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->11813],

Cell[TextData[{
 "Ways of specifying data in ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->19603],

Cell["This loads the package. ", "MathCaption",
 CellID->591],

Cell[BoxData[
 RowBox[{"<<", "LinearRegression`"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->24629],

Cell["\<\
These data contained ordered pairs of a single predictor and a response.\
\>", "MathCaption",
 CellID->29344],

Cell[BoxData[
 RowBox[{
  RowBox[{"data", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0.055", ",", "90"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.091", ",", "97"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.138", ",", "107"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.167", ",", "124"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.182", ",", "142"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.211", ",", "150"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.232", ",", "172"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.248", ",", "189"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.284", ",", "209"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.351", ",", "253"}], "}"}]}], "}"}]}], ";"}]], "Input",
 CellLabel->"In[8]:=",
 CellID->31416],

Cell["This is a plot of the data. ", "MathCaption",
 CellID->6485],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", "data", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->31227],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{0.055, 90.}, {0.091, 97.}, {0.138, 107.}, {0.167, 124.}, {
     0.182, 142.}, {0.211, 150.}, {0.232, 172.}, {0.248, 189.}, {0.284, 
     209.}, {0.351, 253.}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{0.055, 0.351}, {90., 253.}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 107},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->674759877]
}, Open  ]],

Cell[TextData[{
 "This is the output for fitting the model ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["y", "TI"], 
     StyleBox["i", "TI"]], "=", 
    SubscriptBox["\[Beta]", "0"], "+", 
    SubscriptBox["\[Beta]", "1"], 
    SubsuperscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"], "2"], "+", 
    SubscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["i", "TI"]]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 "."
}], "MathCaption",
 CellID->20594],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Regress", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SuperscriptBox["x", "2"]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[10]:=",
 CellID->29739],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["1",
          HoldForm], "88.19401431869144`", "4.211668077193905`", 
         "20.94040002730989`", "2.838358659218443`*^-8"},
        {
         TagBox[
          SuperscriptBox["x", "2"],
          HoldForm], "1430.6838233610404`", "73.69505688361102`", 
         "19.413565629246552`", "5.1467165196328324`*^-8"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {{1, $CellContext`x^2}, {
         "Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.979214653236027`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9766164848905303`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "64.91289776072267`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "24464.79681791422`", "24464.79681791422`", 
        "376.88653044106303`", "5.1467165196328324`*^-8"},
       {"\<\"Error\"\>", "8", "519.3031820857814`", 
        "64.91289776072267`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "9", "24984.1`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[2.0999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 24464.79681791422, 24464.79681791422, 376.88653044106303`, 
        5.1467165196328324`*^-8}, {8, 519.3031820857814, 64.91289776072267}, {
       9, 24984.1}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 ImageSize->{537, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->6219540]
}, Open  ]],

Cell[TextData[{
 "You can use ",
 Cell[BoxData[
  ButtonBox["Fit",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Fit"]], "InlineFormula"],
 " if you only want the fitted function. "
}], "MathCaption",
 CellID->11387],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Fit", "[", 
  RowBox[{"data", ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", 
     SuperscriptBox["x", "2"]}], "}"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->23967],

Cell[BoxData[
 RowBox[{"88.19401431869146`", "\[InvisibleSpace]", "+", 
  RowBox[{"1430.6838233610406`", " ", 
   SuperscriptBox["x", "2"]}]}]], "Output",
 ImageSize->{124, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->219403052]
}, Open  ]],

Cell[BoxData[GridBox[{
   {Cell["option name", "TableHeader"], Cell["default value", "TableHeader"], 
    " "},
   {
    ButtonBox["IncludeConstant",
     BaseStyle->"Link",
     ButtonData->"paclet:LinearRegression/ref/IncludeConstant"], 
    ButtonBox["True",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/True"], Cell[
    "constant automatically included in model ", "TableText"]},
   {
    ButtonBox["RegressionReport",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/RegressionReport"], 
    ButtonBox["SummaryReport",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/SummaryReport"], Cell[
    "fit diagnostics to include", "TableText"]},
   {
    ButtonBox["Weights",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/Weights"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "list of weights for each point or pure function", "TableText"]},
   {
    ButtonBox["BasisNames",
     BaseStyle->"Link",
     ButtonData->"paclet:LinearRegression/ref/BasisNames"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "names of basis elements for table headings ", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}}},
 CellID->13300],

Cell[TextData[{
 "Options for ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 "."
}], "Caption",
 CellID->384],

Cell[TextData[{
 "Two of the options of ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 " influence the method of calculation. ",
 Cell[BoxData[
  ButtonBox["IncludeConstant",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/IncludeConstant"]], 
  "InlineFormula"],
 " has a default setting ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 ", which causes a constant term to be added to the model even if it is not \
specified in the basis functions. To fit a model without this constant term, \
specify ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IncludeConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/IncludeConstant"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " and do not include a constant in the basis functions. "
}], "Text",
 CellID->17996],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["Weights",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Weights"]], "InlineFormula"],
 " option allows you to implement weighted least squares by specifying a list \
of weights, one for each data point; the default ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weights",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/Weights"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " implies a weight of unity for each data point. When ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weights",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/Weights"], "->", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["w", "TI"], 
      StyleBox["1", "TR"]], ",", "\[Ellipsis]", ",", 
     SubscriptBox[
      StyleBox["w", "TI"], 
      StyleBox["n", "TI"]]}], "}"}]}]], "InlineFormula"],
 ", the parameter estimates are chosen to minimize the weighted sum of \
squared residuals ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["i", "TI"], "=", "1"}], 
     StyleBox["n", "TI"],
     LimitsPositioning->True], 
    SubscriptBox[
     StyleBox["w", "TI"], 
     StyleBox["i", "TI"]], " ", 
    SubsuperscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["i", "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ". "
}], "Text",
 CellID->4335],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Weights",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Weights"]], "InlineFormula"],
 " can also specify a pure function of the response. For example, to choose \
parameter estimates to minimize ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{
      StyleBox["i", "TI"], "=", "1"}], 
     StyleBox["n", "TI"],
     LimitsPositioning->True], 
    SqrtBox[
     SubscriptBox[
      StyleBox["y", "TI"], 
      StyleBox["i", "TI"]]], " ", 
    SubsuperscriptBox[
     StyleBox["e", "TI"], 
     StyleBox["i", "TI"], "2"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", set ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Weights",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/Weights"], "->", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      ButtonBox["Sqrt",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sqrt"], "[", "#", "]"}], "&"}], ")"}]}]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->31587],

Cell[TextData[{
 "The options ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["BasisNames",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/BasisNames"]], "InlineFormula"],
 " affect the form and content of the output. If ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " is not specified, ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 " automatically gives a list including values for ",
 Cell[BoxData[
  ButtonBox["ParameterTable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterTable"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["RSquared",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RSquared"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["AdjustedRSquared",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/AdjustedRSquared"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["EstimatedVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/EstimatedVariance"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ANOVATable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ANOVATable"]], "InlineFormula"],
 ". This set of objects comprises the default ",
 Cell[BoxData[
  ButtonBox["SummaryReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/SummaryReport"]], 
  "InlineFormula"],
 ". The option ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " can be used to specify a single object or a list of objects so that more \
(or less) than the default set of results is included in the output.",
 " ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RegressionReportValues",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/RegressionReportValues"], "[", 
   ButtonBox["Regress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/Regress"], "]"}]], 
  "InlineFormula"],
 " gives the objects that may be included in the ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " list for the ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 " function. "
}], "Text",
 CellID->23714],

Cell[TextData[{
 "With the option ",
 Cell[BoxData[
  ButtonBox["BasisNames",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/BasisNames"]], "InlineFormula"],
 ", you can label the headings of predictors in tables such as ",
 Cell[BoxData[
  ButtonBox["ParameterTable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterTable"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ParameterCITable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->6146],

Cell[TextData[{
 "The regression functions will also accept any option that can be specified \
for ",
 Cell[BoxData[
  ButtonBox["SingularValueList",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SingularValueList"]], "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["StudentTCI",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/StudentTCI"]], "InlineFormula"],
 ". In particular, the numerical tolerance for the internal singular value \
decomposition is specified using ",
 Cell[BoxData[
  ButtonBox["Tolerance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Tolerance"]], "InlineFormula"],
 ", and the confidence level for hypothesis testing and confidence intervals \
is specified using ",
 Cell[BoxData[
  ButtonBox["ConfidenceLevel",
   BaseStyle->"Link",
   ButtonData->"paclet:HypothesisTesting/ref/ConfidenceLevel"]], 
  "InlineFormula"],
 ". "
}], "Text",
 CellID->17849],

Cell[BoxData[GridBox[{
   {
    ButtonBox["BestFit",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/BestFit"], Cell[
    "best fit function ", "TableText"]},
   {
    ButtonBox["BestFitParameters",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/BestFitParameters"], Cell[
    "best fit parameter estimates", "TableText"]},
   {
    ButtonBox["ANOVATable",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/ANOVATable"], Cell[
    "analysis of variance table", "TableText"]},
   {
    ButtonBox["EstimatedVariance",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/EstimatedVariance"], Cell[
    "estimated error variance ", "TableText"]},
   {
    ButtonBox["ParameterTable",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/ParameterTable"], Cell["\<\
table of parameter information including standard errors and test statistics \
\
\>", "TableText"]},
   {
    ButtonBox["ParameterCITable",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"], Cell[
    "table of confidence intervals for the parameters", "TableText"]},
   {
    ButtonBox["ParameterConfidenceRegion",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/ParameterConfidenceRegion"], 
    Cell["ellipsoidal joint confidence region for the parameters", 
     "TableText"]},
   {
    RowBox[{
     ButtonBox["ParameterConfidenceRegion",
      BaseStyle->"Link",
      ButtonData->"paclet:RegressionCommon/ref/ParameterConfidenceRegion"], 
     "[", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["i1", "TI"]], ",", 
       SubscriptBox[
        StyleBox["f", "TI"], 
        StyleBox["i2", "TI"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}], Cell[TextData[{
     "ellipsoidal conditional joint confidence region for the parameters ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["i1", "TI"]], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], 
         StyleBox["i2", "TI"]], ",", 
        StyleBox["\[Ellipsis]", "TR"]}], "}"}]], "InlineFormula"]
    }], "TableText"]},
   {
    ButtonBox["FitResiduals",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/FitResiduals"], Cell["\<\
differences between the observed responses and the predicted responses \
\>", "TableText"]},
   {
    ButtonBox["PredictedResponse",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/PredictedResponse"], Cell["\<\
fitted values obtained by evaluating the best fit function at the observed \
values of the independent variables\
\>", "TableText"]},
   {
    ButtonBox["SinglePredictionCITable",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/SinglePredictionCITable"], 
    Cell["\<\
table of confidence intervals for predicting a single observation of the \
response variable \
\>", "TableText"]},
   {
    ButtonBox["MeanPredictionCITable",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/MeanPredictionCITable"], 
    Cell["\<\
table of confidence intervals for predicting the expected value of the \
response variable\
\>", "TableText"]},
   {
    ButtonBox["RSquared",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/RSquared"], Cell[
    "coefficient of determination ", "TableText"]},
   {
    ButtonBox["AdjustedRSquared",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/AdjustedRSquared"], Cell[
    "adjusted coefficient of determination ", "TableText"]},
   {
    ButtonBox["CoefficientOfVariation",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/CoefficientOfVariation"], Cell[
    "coefficient of variation ", "TableText"]},
   {
    ButtonBox["CovarianceMatrix",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/CovarianceMatrix"], Cell[
    "covariance matrix of the parameters ", "TableText"]},
   {
    ButtonBox["CorrelationMatrix",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/CorrelationMatrix"], Cell[
    "correlation matrix of the parameters ", "TableText"]}
  }]], "DefinitionBox",
 CellID->17046],

Cell[TextData[{
 "Some ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " values."
}], "Caption",
 CellID->29221],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["ANOVATable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ANOVATable"]], "InlineFormula"],
 ", a table for analysis of variance, provides a comparison of the given \
model to a smaller one including only a constant term. If ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IncludeConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/IncludeConstant"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is specified, then the smaller model is reduced to the data. The table \
includes the degrees of freedom, the sum of squares and the mean squares due \
to the model (in the row labeled ",
 Cell[BoxData["Model"], "InlineFormula"],
 ") and due to the residuals (in the row labeled ",
 Cell[BoxData["Error"], "InlineFormula"],
 "). The residual mean square is also available in ",
 Cell[BoxData[
  ButtonBox["EstimatedVariance",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/EstimatedVariance"]], 
  "InlineFormula"],
 ", and is calculated by dividing the residual sum of squares by its degrees \
of freedom. The ",
 Cell[BoxData[
  FormBox[
   StyleBox["F", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 "\[Hyphen]test compares the two models using the ratio of their mean \
squares. If the value of ",
 Cell[BoxData[
  FormBox[
   StyleBox["F", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is large, the null hypothesis supporting the smaller model is rejected. "
}], "Text",
 CellID->5191],

Cell[TextData[{
 "To evaluate the importance of each basis function, you can get information \
about the parameter estimates from the parameter table obtained by including \
",
 Cell[BoxData[
  ButtonBox["ParameterTable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterTable"]], 
  "InlineFormula"],
 " in the list specified by ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 ". This table includes the estimates, their standard errors, and ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 "\[Hyphen]statistics for testing whether each parameter is zero. The ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 "\[Hyphen]values are calculated by comparing the obtained statistic to the \
",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " distribution with ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["n", "TI"], "-", 
    StyleBox["p", "TI"]}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " degrees of freedom, where ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is the sample size and ",
 Cell[BoxData[
  FormBox[
   StyleBox["p", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " is the number of predictors. Confidence intervals for the parameter \
estimates, also based on the ",
 Cell[BoxData[
  FormBox[
   StyleBox["t", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " distribution, can be found by specifying ",
 Cell[BoxData[
  ButtonBox["ParameterCITable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterCITable"]], 
  "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["ParameterConfidenceRegion",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ParameterConfidenceRegion"]], 
  "InlineFormula"],
 " specifies the ellipsoidal joint confidence region of all fit parameters. \
",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ParameterConfidenceRegion",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/ParameterConfidenceRegion"], "[",
    
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["i1", "TI"]], ",", 
     SubscriptBox[
      StyleBox["f", "TI"], 
      StyleBox["i2", "TI"]], ",", "\[Ellipsis]"}], "}"}], "]"}]], 
  "InlineFormula"],
 " specifies the joint conditional confidence region of the fit parameters \
associated with basis functions ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["i1", "TI"]], ",", 
    SubscriptBox[
     StyleBox["f", "TI"], 
     StyleBox["i2", "TI"]], ",", "\[Ellipsis]"}], "}"}]]],
 ", a subset of the complete set of basis functions. "
}], "Text",
 CellID->29125],

Cell[TextData[{
 "The square of the multiple correlation coefficient is called the \
coefficient of determination ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox[
    StyleBox["R", "TI"], "2"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", and is given by the ratio of the model sum of squares to the total sum of \
squares. It is a summary statistic that describes the relationship between \
the predictors and the response variable. ",
 Cell[BoxData[
  ButtonBox["AdjustedRSquared",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/AdjustedRSquared"]], 
  "InlineFormula"],
 " is defined as ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     OverscriptBox[
      StyleBox["R", "TI"], "_"], "2"], "=", "1", "-", 
    RowBox[{"(", 
     FractionBox[
      RowBox[{
       StyleBox["n", "TI"], "-", "1"}], 
      RowBox[{
       StyleBox["n", "TI"], "-", 
       StyleBox["p", "TI"]}]], ")"}], 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SuperscriptBox[
       StyleBox["R", "TI"], "2"]}], ")"}]}], TraditionalForm]], 
  "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 ", and gives an adjusted value that you can use to compare subsequent \
subsets of models. The coefficient of variation is given by the ratio of the \
residual root mean square to the mean of the response variable. If the \
response is strictly positive, this is sometimes used to measure the relative \
magnitude of error variation. "
}], "Text",
 CellID->30991],

Cell[TextData[{
 "Each row in ",
 Cell[BoxData[
  ButtonBox["MeanPredictionCITable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/MeanPredictionCITable"]], 
  "InlineFormula"],
 " gives the confidence interval for the mean response at each of the values \
of the independent variables. Each row in ",
 Cell[BoxData[
  ButtonBox["SinglePredictionCITable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/SinglePredictionCITable"]], 
  "InlineFormula"],
 " gives the confidence interval for a single observed response at each of \
the values of the independent variables. ",
 Cell[BoxData[
  ButtonBox["MeanPredictionCITable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/MeanPredictionCITable"]], 
  "InlineFormula"],
 " ",
 "gives a region likely to contain the regression curve, while ",
 Cell[BoxData[
  ButtonBox["SinglePredictionCITable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/SinglePredictionCITable"]], 
  "InlineFormula"],
 " gives a region likely to contain all possible observations. "
}], "Text",
 CellID->406],

Cell["\<\
The following gives the residuals, the confidence interval table for the \
predicted response of single observations, and the parameter joint confidence \
region. \
\>", "MathCaption",
 CellID->21442],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"regress", "=", 
  RowBox[{"Regress", "[", 
   RowBox[{"data", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      SuperscriptBox["x", "2"]}], "}"}], ",", "x", ",", 
    RowBox[{"RegressionReport", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "FitResiduals", ",", "SinglePredictionCITable", ",", 
       "ParameterConfidenceRegion"}], "}"}]}]}], "]"}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->1323],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"FitResiduals", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2.521832884358588`"}], ",", 
      RowBox[{"-", "3.041507059944223`"}], ",", 
      RowBox[{"-", "8.4399570507791`"}], ",", 
      RowBox[{"-", "4.094355468407514`"}], ",", "6.41601471629744`", ",", 
      RowBox[{"-", "1.8894888185483296`"}], ",", "6.800859572723908`", ",", 
      "12.813207809311137`", ",", "5.412751224300507`", ",", 
      RowBox[{"-", "11.455692040594954`"}]}], "}"}]}], ",", 
   RowBox[{"SinglePredictionCITable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         TagBox["\<\"Observed\"\>",
          HoldForm], 
         TagBox["\<\"Predicted\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"CI\"\>",
          HoldForm]},
        {"90.`", "92.52183288435859`", "9.011409868996786`", 
         RowBox[{"{", 
          RowBox[{"71.74148446243235`", ",", "113.30218130628482`"}], "}"}]},
        {"97.`", "100.04150705994422`", "8.884269134919002`", 
         RowBox[{"{", 
          RowBox[{"79.55434569655425`", ",", "120.5286684233342`"}], "}"}]},
        {"107.`", "115.4399570507791`", "8.672220520843053`", 
         RowBox[{"{", 
          RowBox[{"95.44178066831257`", ",", "135.43813343324564`"}], "}"}]},
        {"124.`", "128.0943554684075`", "8.54926346670695`", 
         RowBox[{"{", 
          RowBox[{"108.37971856123136`", ",", "147.80899237558367`"}], 
          "}"}]},
        {"142.`", "135.58398528370256`", "8.499232352925054`", 
         RowBox[{"{", 
          RowBox[{"115.98472033179634`", ",", "155.1832502356088`"}], "}"}]},
        {"150.`", "151.88948881854833`", "8.450412204432498`", 
         RowBox[{"{", 
          RowBox[{"132.40280333094722`", ",", "171.37617430614944`"}], 
          "}"}]},
        {"172.`", "165.1991404272761`", "8.47230014158135`", 
         RowBox[{"{", 
          RowBox[{"145.66198126609865`", ",", "184.73629958845353`"}], 
          "}"}]},
        {"189.`", "176.18679219068886`", "8.531940559449222`", 
         RowBox[{"{", 
          RowBox[{"156.5121019792828`", ",", "195.86148240209494`"}], "}"}]},
        {"209.`", "203.5872487756995`", "8.83820790329205`", 
         RowBox[{"{", 
          RowBox[{"183.20630480291388`", ",", "223.9681927484851`"}], "}"}]},
        {"253.`", "264.45569204059495`", "10.20722769903688`", 
         RowBox[{"{", 
          RowBox[{"240.9177827576454`", ",", "287.9936013235445`"}], "}"}]}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {None, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, TableDepth -> 2, 
       TableHeadings -> {None, {"Observed", "Predicted", "SE", "CI"}}]]]}], 
   ",", 
   RowBox[{"ParameterConfidenceRegion", "\[Rule]", 
    RowBox[{"Ellipsoid", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"88.19401431869144`", ",", "1430.6838233610404`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{"220.3029907679948`", ",", "7.6006025025069475`"}], "}"}], ",",
       
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "0.04551402870847317`"}], ",", "0.9989636996361401`"}],
          "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0.9989636996361401`", ",", "0.04551402870847315`"}], 
         "}"}]}], "}"}]}], "]"}]}]}], "}"}]], "Output",
 ImageSize->{514, 251},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->60798766]
}, Open  ]],

Cell["This is a list of the residuals extracted from the output. ", \
"MathCaption",
 CellID->20737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"errors", "=", 
  RowBox[{"FitResiduals", "/.", "\[InvisibleSpace]", "regress"}]}]], "Input",
 CellLabel->"In[14]:=",
 CellID->9375],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", "2.521832884358588`"}], ",", 
   RowBox[{"-", "3.041507059944223`"}], ",", 
   RowBox[{"-", "8.4399570507791`"}], ",", 
   RowBox[{"-", "4.094355468407514`"}], ",", "6.41601471629744`", ",", 
   RowBox[{"-", "1.8894888185483296`"}], ",", "6.800859572723908`", ",", 
   "12.813207809311137`", ",", "5.412751224300507`", ",", 
   RowBox[{"-", "11.455692040594954`"}]}], "}"}]], "Output",
 ImageSize->{384, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->206120088]
}, Open  ]],

Cell["\<\
The observed response, the predicted response, the standard errors of the \
predicted response, and the confidence intervals may also be extracted. \
\>", "MathCaption",
 CellID->9806],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"{", 
    RowBox[{"observed", ",", "predicted", ",", "se", ",", "ci"}], "}"}], "=", 
   
   RowBox[{"Transpose", "[", 
    RowBox[{
     RowBox[{"(", 
      RowBox[{
      "SinglePredictionCITable", "/.", "\[InvisibleSpace]", "regress"}], 
      ")"}], "\[LeftDoubleBracket]", "1", "\[RightDoubleBracket]"}], "]"}]}], 
  ";"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->26724],

Cell["This plots the predicted responses against the residuals. ", \
"MathCaption",
 CellID->10293],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{"Transpose", "[", 
   RowBox[{"{", 
    RowBox[{"predicted", ",", "errors"}], "}"}], "]"}], "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->28596],

Cell[BoxData[
 GraphicsBox[{{}, 
   {Hue[0.67, 0.6, 0.6], 
    PointBox[{{92.52183288435859, -2.521832884358588}, {
     100.04150705994422`, -3.041507059944223}, {
     115.4399570507791, -8.4399570507791}, {
     128.0943554684075, -4.094355468407514}, {135.58398528370256`, 
     6.41601471629744}, {151.88948881854833`, -1.8894888185483296`}, {
     165.1991404272761, 6.800859572723908}, {176.18679219068886`, 
     12.813207809311137`}, {203.5872487756995, 5.412751224300507}, {
     264.45569204059495`, -11.455692040594954`}}]}, {}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  PlotRange->{{92.52183288435859, 264.45569204059495`}, {-11.455692040594954`,
    12.813207809311137`}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 106},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->140924700]
}, Open  ]],

Cell[TextData[{
 "Here the predicted responses and lower and upper confidence limits are \
paired with the corresponding ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " values. "
}], "MathCaption",
 CellID->29670],

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"xval", "=", 
     RowBox[{"data", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}]}], ";", "\[IndentingNewLine]", 
    
    RowBox[{"predicted", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"xval", ",", "predicted"}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"lowerCI", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"xval", ",", 
        RowBox[{"First", "/@", "ci"}]}], "}"}], "]"}]}], ";", 
    "\[IndentingNewLine]", 
    RowBox[{"upperCI", "=", 
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{"xval", ",", 
        RowBox[{"Last", "/@", "ci"}]}], "}"}], "]"}]}]}], ")"}], 
  ";"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->4046],

Cell[TextData[{
 "This displays the raw data, fitted curve, and the ",
 Cell[BoxData[
  FormBox[
   RowBox[{"95", "%"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " confidence intervals for the predicted responses of single observations. "
}], "MathCaption",
 CellID->14663],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListPlot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"data", ",", "predicted", ",", "lowerCI", ",", "upperCI"}], "}"}],
    ",", 
   RowBox[{"Joined", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"False", ",", "True", ",", "True", ",", "True"}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", "Automatic", ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{".05", ",", ".05"}], "}"}], "]"}], ",", "Gray"}], "}"}], 
      ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Dashing", "[", 
         RowBox[{"{", 
          RowBox[{".05", ",", ".05"}], "}"}], "]"}], ",", "Gray"}], "}"}]}], 
     "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->28182],

Cell[BoxData[
 GraphicsBox[{{{}, {}, {}, 
    {Hue[0.9060679774997897, 0.6, 0.6], 
     LineBox[{{0.055, 92.52183288435859}, {0.091, 100.04150705994422`}, {
      0.138, 115.4399570507791}, {0.167, 128.0943554684075}, {0.182, 
      135.58398528370256`}, {0.211, 151.88948881854833`}, {0.232, 
      165.1991404272761}, {0.248, 176.18679219068886`}, {0.284, 
      203.5872487756995}, {0.351, 264.45569204059495`}}]}, 
    {GrayLevel[0.5], Dashing[{0.05, 0.05}], 
     LineBox[{{0.055, 71.74148446243235}, {0.091, 79.55434569655425}, {0.138, 
      95.44178066831257}, {0.167, 108.37971856123136`}, {0.182, 
      115.98472033179634`}, {0.211, 132.40280333094722`}, {0.232, 
      145.66198126609865`}, {0.248, 156.5121019792828}, {0.284, 
      183.20630480291388`}, {0.351, 240.9177827576454}}]}, 
    {GrayLevel[0.5], Dashing[{0.05, 0.05}], 
     LineBox[{{0.055, 113.30218130628482`}, {0.091, 120.5286684233342}, {
      0.138, 135.43813343324564`}, {0.167, 147.80899237558367`}, {0.182, 
      155.1832502356088}, {0.211, 171.37617430614944`}, {0.232, 
      184.73629958845353`}, {0.248, 195.86148240209494`}, {0.284, 
      223.9681927484851}, {0.351, 287.9936013235445}}]}}, {{}, 
    {Hue[0.67, 0.6, 0.6], 
     PointBox[{{0.055, 90.}, {0.091, 97.}, {0.138, 107.}, {0.167, 124.}, {
      0.182, 142.}, {0.211, 150.}, {0.232, 172.}, {0.248, 189.}, {0.284, 
      209.}, {0.351, 253.}}]}, {}, {}, {}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  ImageMargins->{{0., 0.}, {0., 0.}},
  ImageSize->Automatic,
  PlotRange->{{0.055, 0.351}, {71.74148446243235, 287.9936013235445}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{364, 212},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->217075312]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 " may be used to display an ",
 Cell[BoxData[
  ButtonBox["Ellipsoid",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/Ellipsoid"]], "InlineFormula"],
 " object. This is the joint ",
 Cell[BoxData[
  FormBox[
   RowBox[{"95", "%"}], TraditionalForm]], "InlineFormula",
  GridBoxOptions->{
  GridBoxItemSize->{
   "Columns" -> {{Automatic}}, "ColumnsIndexed" -> {}, "Rows" -> {{1.}}, 
    "RowsIndexed" -> {}}}],
 " confidence region for the regression parameters. "
}], "MathCaption",
 CellID->14721],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Graphics", "[", 
  RowBox[{
   RowBox[{"ParameterConfidenceRegion", "/.", "regress"}], ",", 
   RowBox[{"Axes", "\[Rule]", "True"}], ",", 
   RowBox[{"AxesLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Constant\>\"", ",", "\"\<x Squared\>\""}], "}"}]}], ",", 
   "\[IndentingNewLine]", 
   RowBox[{"AspectRatio", "\[Rule]", "1"}]}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->23071],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{360, 334},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->61584315]
}, Open  ]],

Cell[TextData[{
 "This package provides numerous diagnostics for evaluating the data and the \
fit. The ",
 Cell[BoxData[
  ButtonBox["HatDiagonal",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"]], "InlineFormula"],
 " gives the leverage of each point, measuring whether each observation of \
the independent variables is unusual. ",
 Cell[BoxData[
  ButtonBox["CookD",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/CookD"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PredictedResponseDelta",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/PredictedResponseDelta"]], 
  "InlineFormula"],
 " are influence diagnostics, simultaneously measuring whether the \
independent variables and the response variable are unusual. Unfortunately, \
these diagnostics are primarily useful in detecting single outliers. In \
particular, the diagnostics may indicate a single outlier, but deleting that \
observation and recomputing the diagnostics may indicate others. All of these \
diagnostics are subject to this masking effect."
}], "Text",
 CellID->2040],

Cell[BoxData[GridBox[{
   {
    ButtonBox["HatDiagonal",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/HatDiagonal"], Cell[TextData[{
     "diagonal of the hat matrix ",
     Cell[BoxData[
      RowBox[{
       StyleBox["X", "TI"], 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           StyleBox["X", "TI"], 
           StyleBox["T", "TI"]], 
          StyleBox["X", "TI"]}], ")"}], 
        RowBox[{"-", "1"}]], 
       SuperscriptBox[
        StyleBox["X", "TI"], 
        StyleBox["T", "TI"]]}]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      StyleBox["X", "TI"]], "InlineFormula"],
     " is the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " (weighted) design matrix "
    }], "TableText"]},
   {
    ButtonBox["JackknifedVariance",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/JackknifedVariance"], Cell[
    TextData[{
     StyleBox["{", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], "1"]], "InlineFormula"],
     StyleBox[", \[Ellipsis] , ", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     StyleBox["}", "MR"],
     ", where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is the estimated error variance computed using the data with the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " case deleted "
    }], "TableText"]},
   {
    ButtonBox["StandardizedResiduals",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/StandardizedResiduals"], 
    Cell["\<\
fit residuals scaled by their standard errors, computed using the estimated \
error variance\
\>", "TableText"]},
   {
    ButtonBox["StudentizedResiduals",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/StudentizedResiduals"], 
    Cell["\<\
fit residuals scaled by their standard errors, computed using the jackknifed \
estimated error variances\
\>", "TableText"]},
   {
    ButtonBox["CookD",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/CookD"], Cell[TextData[{
     StyleBox["{", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], "1"]], "InlineFormula"],
     StyleBox[", \[Ellipsis] , ", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     StyleBox["}", "MR"],
     ", where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is Cook\[CloseCurlyQuote]s squared distance diagnostic for evaluating \
whether the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " case is an outlier "
    }], "TableText"]},
   {
    ButtonBox["PredictedResponseDelta",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/PredictedResponseDelta"], Cell[
    TextData[{
     StyleBox["{", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], "1"]], "InlineFormula"],
     StyleBox[", \[Ellipsis] , ", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     StyleBox["}", "MR"],
     ", where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is Kuh and Welsch\[CloseCurlyQuote]s DFFITS diagnostic giving the \
standardized signed difference in the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " predicted response, between using all the data and the data with the ",
     
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " case deleted "
    }], "TableText"]},
   {
    ButtonBox["BestFitParametersDelta",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/BestFitParametersDelta"], Cell[
    TextData[{
     StyleBox["{{", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], "11"]], "InlineFormula"],
     StyleBox[", \[Ellipsis] , ", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       RowBox[{"1", 
        StyleBox["p", "TI"]}]]], "InlineFormula"],
     StyleBox["}, \[Ellipsis] , {", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       RowBox[{
        StyleBox["n", "TI"], "1"}]]], "InlineFormula"],
     StyleBox[", \[Ellipsis] , ", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox[
        RowBox[{"n", "p"}], "TI"]]], "InlineFormula"],
     StyleBox["}}", "MR"],
     ", where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["d", "TI"], 
       StyleBox[
        RowBox[{"i", "j"}], "TI"]]], "InlineFormula"],
     " is Kuh and Welsch\[CloseCurlyQuote]s DFBETAS diagnostic giving the \
standardized signed difference in the ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " parameter estimate, between using all the data and the data with the ",
     
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " case deleted "
    }], "TableText"]},
   {
    ButtonBox["CovarianceMatrixDetRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/CovarianceMatrixDetRatio"], 
    Cell[TextData[{
     StyleBox["{", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], "1"]], "InlineFormula"],
     StyleBox[", \[Ellipsis] , ", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     StyleBox["}", "MR"],
     ", where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["r", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is Kuh and Welsch\[CloseCurlyQuote]s COVRATIO diagnostic giving the \
ratio of the determinant of the parameter covariance matrix computed using \
the data with the ",
     Cell[BoxData[
      StyleBox["i", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " case deleted, to the determinant of the parameter covariance matrix \
computed using the original data "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->529159570],

Cell["Diagnostics for detecting outliers.", "Caption",
 CellID->20301],

Cell[TextData[{
 "Some diagnostics indicate the degree to which individual basis functions \
contribute to the fit, or whether the basis functions are involved in a \
collinear relationship. The sum of the elements in the ",
 Cell[BoxData[
  ButtonBox["SequentialSumOfSquares",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/SequentialSumOfSquares"]], 
  "InlineFormula"],
 " vector gives the model sum of squares listed in the ",
 Cell[BoxData[
  ButtonBox["ANOVATable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/ANOVATable"]], "InlineFormula"],
 ". Each element corresponds to the increment in the model sum of squares \
obtained by sequentially adding each nonconstant basis function to the model. \
Each element in the ",
 Cell[BoxData[
  ButtonBox["PartialSumOfSquares",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/PartialSumOfSquares"]], 
  "InlineFormula"],
 " vector gives the increase in the model sum of squares due to adding the \
corresponding nonconstant basis function to a model consisting of all other \
basis functions. ",
 Cell[BoxData[
  ButtonBox["SequentialSumOfSquares",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/SequentialSumOfSquares"]], 
  "InlineFormula"],
 " is useful in determining the degree of a univariate polynomial model, \
while ",
 Cell[BoxData[
  ButtonBox["PartialSumOfSquares",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/PartialSumOfSquares"]], 
  "InlineFormula"],
 " is useful in trimming a large set of predictors. ",
 Cell[BoxData[
  ButtonBox["VarianceInflation",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/VarianceInflation"]], 
  "InlineFormula"],
 " or ",
 Cell[BoxData[
  ButtonBox["EigenstructureTable",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/EigenstructureTable"]], 
  "InlineFormula"],
 " may also be used for predictor set trimming. "
}], "Text",
 CellID->13426],

Cell[BoxData[GridBox[{
   {
    ButtonBox["PartialSumOfSquares",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/PartialSumOfSquares"], 
    Cell["\<\
a list giving the increase in the model sum of squares due to adding each \
nonconstant basis function to the model consisting of the remaining basis \
functions \
\>", "TableText"]},
   {
    ButtonBox["SequentialSumOfSquares",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/SequentialSumOfSquares"], 
    Cell["\<\
a list giving a partitioning of the model sum of squares, one element for \
each nonconstant basis function added sequentially to the model \
\>", "TableText"]},
   {
    ButtonBox["VarianceInflation",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/VarianceInflation"], Cell[
    TextData[{
     StyleBox["{", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], "1"]], "InlineFormula"],
     StyleBox[", \[Ellipsis] , ", "MR"],
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["p", "TI"]]], "InlineFormula"],
     StyleBox["}", "MR"],
     ", where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["v", "TI"], 
       StyleBox["j", "TI"]]], "InlineFormula"],
     " is the variance inflation factor associated with the ",
     Cell[BoxData[
      StyleBox["j", "TI"]], "InlineFormula"],
     Cell[BoxData[
      SuperscriptBox["\[Null]", "th"]], "InlineFormula"],
     " parameter "
    }], "TableText"]},
   {
    ButtonBox["EigenstructureTable",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/EigenstructureTable"], 
    Cell["\<\
table giving the eigenstructure of the correlation matrix of the nonconstant \
basis functions\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->396748024],

Cell["\<\
Diagnostics for evaluating basis functions and detecting collinearity.\
\>", "Caption",
 CellID->8124],

Cell[TextData[{
 "The Durbin\[Hyphen]Watson ",
 StyleBox["d",
  FontSlant->"Italic"],
 " statistic is used for testing the existence of a first\[Hyphen]order \
autoregressive process. The statistic takes on values between 0 and 4, with \
values near the middle of that range",
 " ",
 "indicating uncorrelated errors, an underlying assumption of the regression \
model. Critical values for the statistic vary with sample size, the number of \
parameters in the model, and the desired significance. These values can be \
found in published tables."
}], "Text",
 CellID->23622],

Cell[BoxData[GridBox[{
   {
    ButtonBox["DurbinWatsonD",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/DurbinWatsonD"], Cell[
    TextData[{
     "Durbin\[Hyphen]Watson ",
     Cell[BoxData[
      StyleBox["d", "TI"]], "InlineFormula"],
     " statistic"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->284949088],

Cell["Correlated errors diagnostic.", "Caption",
 CellID->4825],

Cell[TextData[{
 "Other statistics not mentioned here can be computed with the help of the \
catcher matrix. This matrix catches all the information the predictors have \
about the parameter vector. This matrix can be exported from ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 " by specifying ",
 Cell[BoxData[
  ButtonBox["CatcherMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/CatcherMatrix"]], 
  "InlineFormula"],
 " with the ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " option. "
}], "Text",
 CellID->941],

Cell[BoxData[GridBox[{
   {
    ButtonBox["CatcherMatrix",
     BaseStyle->"Link",
     ButtonData->"paclet:RegressionCommon/ref/CatcherMatrix"], Cell[
    TextData[{
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " by ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " matrix ",
     Cell[BoxData[
      StyleBox["C", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      RowBox[{
       StyleBox["C", "TI"], "\[CenterDot]", 
       StyleBox["y", "TI"]}]], "InlineFormula"],
     " is the estimated parameter vector and ",
     Cell[BoxData[
      StyleBox["y", "TI"]], "InlineFormula"],
     " is the response vector "
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->43156369],

Cell["\<\
Matrix describing the parameter information provided by the predictors.\
\>", "Caption",
 CellID->9648],

Cell[TextData[{
 "Frequently, linear regression is applied to an existing design matrix \
rather than the original data. A design matrix is a list containing the basis \
functions evaluated at the observed values of the independent variable. If \
your data are already in the form of a design matrix with a corresponding \
vector of response data, you can use ",
 Cell[BoxData[
  ButtonBox["DesignedRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
  "InlineFormula"],
 " for the same analyses as provided by ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 ". ",
 Cell[BoxData[
  ButtonBox["DesignMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignMatrix"]], 
  "InlineFormula"],
 " puts your data in the form of a design matrix. "
}], "Text",
 CellID->20076],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DesignedRegress",
      BaseStyle->"Link",
      ButtonData->"paclet:LinearRegression/ref/DesignedRegress"], "[", 
     RowBox[{
      StyleBox["designmatrix", "TI"], ",", 
      StyleBox["response", "TI"]}], "]"}], Cell[TextData[{
     "fits the model represented by ",
     Cell[BoxData[
      StyleBox["designmatrix", "TI"]], "InlineFormula"],
     " given the vector ",
     Cell[BoxData[
      StyleBox["response", "TI"]], "InlineFormula"],
     " of response data"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["DesignMatrix",
      BaseStyle->"Link",
      ButtonData->"paclet:LinearRegression/ref/DesignMatrix"], "[", 
     RowBox[{
      StyleBox["data", "TI"], ",", 
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["f", "TI"], "1"], ",", 
        SubscriptBox[
         StyleBox["f", "TI"], "2"], 
        StyleBox["\[Ellipsis]", "TI"]}], "}"}], ",", 
      StyleBox["vars", "TI"]}], "]"}], Cell[TextData[{
     "gives the design matrix for modeling",
     " ",
     Cell[BoxData[
      StyleBox["data", "TI"]], "InlineFormula"],
     " ",
     "as a linear combination of the functions ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["f", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " of variables",
     " ",
     Cell[BoxData[
      StyleBox["vars", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->597169351],

Cell["Functions for linear regression using a design matrix.", "Caption",
 CellID->4574],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DesignMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignMatrix"]], 
  "InlineFormula"],
 " takes the same arguments as ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 ". It can be used to get the necessary arguments for ",
 Cell[BoxData[
  ButtonBox["DesignedRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
  "InlineFormula"],
 ", or to check whether you correctly specified your basis functions. When \
you use ",
 Cell[BoxData[
  ButtonBox["DesignMatrix",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignMatrix"]], 
  "InlineFormula"],
 ", the constant term is always included in the model unless ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["IncludeConstant",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/IncludeConstant"], "->", 
   ButtonBox["False",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/False"]}]], "InlineFormula"],
 " is specified. Every option of ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 " except ",
 Cell[BoxData[
  ButtonBox["IncludeConstant",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/IncludeConstant"]], 
  "InlineFormula"],
 " is accepted by ",
 Cell[BoxData[
  ButtonBox["DesignedRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
  "InlineFormula"],
 ". ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RegressionReportValues",
    BaseStyle->"Link",
    ButtonData->"paclet:RegressionCommon/ref/RegressionReportValues"], "[", 
   ButtonBox["DesignedRegress",
    BaseStyle->"Link",
    ButtonData->"paclet:LinearRegression/ref/DesignedRegress"], "]"}]], 
  "InlineFormula"],
 " gives the values that may be included in the ",
 Cell[BoxData[
  ButtonBox["RegressionReport",
   BaseStyle->"Link",
   ButtonData->"paclet:RegressionCommon/ref/RegressionReport"]], 
  "InlineFormula"],
 " list for the ",
 Cell[BoxData[
  ButtonBox["DesignedRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
  "InlineFormula"],
 " function. "
}], "Text",
 CellID->32678],

Cell["\<\
This is the design matrix used in the previous regression analysis. \
\>", "MathCaption",
 CellID->18067],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"mat", "=", 
  RowBox[{"DesignMatrix", "[", 
   RowBox[{"data", ",", 
    RowBox[{"{", 
     RowBox[{"1", ",", 
      SuperscriptBox["x", "2"]}], "}"}], ",", "x"}], "]"}]}]], "Input",
 CellLabel->"In[27]:=",
 CellID->4660],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.003025`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.008281`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.019044000000000002`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.027889000000000004`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.033124`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.044521`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.053824000000000004`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.061503999999999996`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.08065599999999999`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.`", ",", "0.12320099999999999`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{539, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]=",
 CellID->115952187]
}, Open  ]],

Cell["Here is the vector of observed responses. ", "MathCaption",
 CellID->6812],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"response", "=", 
  RowBox[{"data", "[", 
   RowBox[{"[", 
    RowBox[{"All", ",", 
     RowBox[{"-", "1"}]}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[28]:=",
 CellID->32554],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "90", ",", "97", ",", "107", ",", "124", ",", "142", ",", "150", ",", "172",
    ",", "189", ",", "209", ",", "253"}], "}"}]], "Output",
 ImageSize->{315, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[28]=",
 CellID->136058729]
}, Open  ]],

Cell[TextData[{
 "The result of ",
 Cell[BoxData[
  ButtonBox["DesignedRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
  "InlineFormula"],
 " is equivalent to that of ",
 Cell[BoxData[
  ButtonBox["Regress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/Regress"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellID->277],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignedRegress", "[", 
  RowBox[{"mat", ",", "response", ",", 
   RowBox[{"BasisNames", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<Constant\>\"", ",", "\"\<x Squared\>\""}], "}"}]}]}], 
  "]"}]], "Input",
 CellLabel->"In[29]:=",
 CellID->10994],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"ParameterTable", "\[Rule]", 
    TagBox[
     TagBox[GridBox[{
        {
         StyleBox["\[Null]",
          ShowStringCharacters->False], 
         TagBox["\<\"Estimate\"\>",
          HoldForm], 
         TagBox["\<\"SE\"\>",
          HoldForm], 
         TagBox["\<\"TStat\"\>",
          HoldForm], 
         TagBox["\<\"PValue\"\>",
          HoldForm]},
        {
         TagBox["\<\"Constant\"\>",
          HoldForm], "88.19401431869144`", "4.211668077193905`", 
         "20.94040002730989`", "2.838358659218443`*^-8"},
        {
         TagBox["\<\"x Squared\"\>",
          HoldForm], "1430.6838233610404`", "73.69505688361102`", 
         "19.413565629246552`", "5.1467165196328324`*^-8"}
       },
       GridBoxAlignment->{
        "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}},
          "RowsIndexed" -> {}},
       GridBoxDividers->{
        "Columns" -> {False, True, {False}, False}, "ColumnsIndexed" -> {}, 
         "Rows" -> {False, True, {False}, False}, "RowsIndexed" -> {}},
       GridBoxSpacings->{"Columns" -> {
           Offset[0.27999999999999997`], {
            Offset[0.7]}, 
           Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
           Offset[0.2], {
            Offset[0.4]}, 
           Offset[0.2]}, "RowsIndexed" -> {}}],
      {OutputFormsDump`HeadedRows, OutputFormsDump`HeadedColumns}],
     Function[BoxForm`e$, 
      MatrixForm[
      BoxForm`e$, 
       TableHeadings -> {{"Constant", "x Squared"}, {
         "Estimate", "SE", "TStat", "PValue"}}]]]}], ",", 
   RowBox[{"RSquared", "\[Rule]", "0.979214653236027`"}], ",", 
   RowBox[{"AdjustedRSquared", "\[Rule]", "0.9766164848905303`"}], ",", 
   RowBox[{"EstimatedVariance", "\[Rule]", "64.91289776072267`"}], ",", 
   RowBox[{"ANOVATable", "\[Rule]", 
    InterpretationBox[GridBox[{
       {"\<\"\"\>", "\<\"DF\"\>", "\<\"SumOfSq\"\>", "\<\"MeanSq\"\>", \
"\<\"FRatio\"\>", "\<\"PValue\"\>"},
       {"\<\"Model\"\>", "1", "24464.79681791422`", "24464.79681791422`", 
        "376.88653044106303`", "5.1467165196328324`*^-8"},
       {"\<\"Error\"\>", "8", "519.3031820857814`", 
        "64.91289776072267`", "\<\"\"\>", "\<\"\"\>"},
       {"\<\"Total\"\>", "9", "24984.1`", "\<\"\"\>", "\<\"\"\>", "\<\"\"\>"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[2.0999999999999996`]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}],
     TableForm[{{
       1, 24464.79681791422, 24464.79681791422, 376.88653044106303`, 
        5.1467165196328324`*^-8}, {8, 519.3031820857814, 64.91289776072267}, {
       9, 24984.1}}, 
      TableHeadings -> {{"Model", "Error", "Total"}, {
        "DF", "SumOfSq", "MeanSq", "FRatio", "PValue"}}]]}]}], 
  "}"}]], "Output",
 ImageSize->{537, 129},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[29]=",
 CellID->68440496]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["DesignedRegress",
      BaseStyle->"Link",
      ButtonData->"paclet:LinearRegression/ref/DesignedRegress"], "[", 
     RowBox[{
      StyleBox["svd", "TI"], ",", 
      StyleBox["response", "TI"]}], "]"}], Cell[TextData[{
     "fits the model represented by",
     " ",
     Cell[BoxData[
      StyleBox["svd", "TI"]], "InlineFormula"],
     ", the singular value decomposition of a design matrix,",
     " ",
     "given the vector ",
     Cell[BoxData[
      StyleBox["response", "TI"]], "InlineFormula"],
     " ",
     "of response data"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->368483489],

Cell["\<\
Linear regression using the singular value decomposition of a design matrix.\
\>", "Caption",
 CellID->30922],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["DesignedRegress",
   BaseStyle->"Link",
   ButtonData->"paclet:LinearRegression/ref/DesignedRegress"]], 
  "InlineFormula"],
 " will also accept the singular value decomposition of the design matrix. If \
the regression is not weighted, this approach will save recomputing the \
design matrix decomposition. "
}], "Text",
 CellID->23928],

Cell["\<\
This is the singular value decomposition of the design matrix. \
\>", "MathCaption",
 CellID->27160],

Cell[BoxData[
 RowBox[{
  RowBox[{"svd", "=", 
   RowBox[{"SingularValueDecomposition", "[", "mat", "]"}]}], ";"}]], "Input",\

 CellLabel->"In[31]:=",
 CellID->4716],

Cell["\<\
When several responses are of interest, this will save recomputing the design \
matrix decomposition. \
\>", "MathCaption",
 CellID->29767],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"DesignedRegress", "[", 
  RowBox[{"svd", ",", "response", ",", 
   RowBox[{"RegressionReport", "\[Rule]", "BestFitParameters"}]}], 
  "]"}]], "Input",
 CellLabel->"In[32]:=",
 CellID->11743],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"BestFitParameters", "\[Rule]", 
   RowBox[{"{", 
    RowBox[{"88.1940143186915`", ",", "1430.6838233610408`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{270, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[32]=",
 CellID->67324383]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Linear Regression Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 27.1342818}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Linear Regression Package Tutorial", "language" -> "en", "paclet" -> 
    "LinearRegression Package", "status" -> "None", "summary" -> 
    "The built-in function Fit finds a least-squares fit to a list of data as \
a linear combination of the specified basis functions. The functions Regress \
and DesignedRegress provided in this package augment Fit by giving a list of \
commonly required diagnostics such as the coefficient of determination \
RSquared, the analysis of variance table ANOVATable, and the mean squared \
error EstimatedVariance. The output of regression functions can be controlled \
so that only needed information is produced. The Nonlinear Regression Package \
provides analogous functionality for nonlinear models. The basis functions \
f_j specify the predictors as functions of the independent variables. The \
resulting model for the response variable is \
y_i=\\[Beta]_1f_1i+\\[Beta]_2f_2i+...+\\[Beta]_pf_pi+e_i, where y_i is the \
i^thresponse, f_ji is the j^th basis function evaluated at the i^th \
observation, and e_i is the i^th residual error. Estimates of the \
coefficients \\[Beta]_1,...,\\[Beta]_p are calculated to minimize \
UnderscriptBox[\\[Sum], StyleBox[i, TI], LimitsPositioning -> \
True]SubsuperscriptBox[StyleBox[e, TI], StyleBox[i, TI], 2], the error or \
residual sum of squares. For example, simple linear regression is \
accomplished by defining the basis functions as f_1=1 and f_2=x, in which \
case \\[Beta]_1 and \\[Beta]_2 are found to minimize UnderscriptBox[\\[Sum], \
StyleBox[i, TI], LimitsPositioning -> \
True][y_i-(\\[Beta]_1+\\[Beta]_2x_i)]^2. ", "synonyms" -> {}, "title" -> 
    "Linear Regression Package", "type" -> "Tutorial", "uri" -> 
    "LinearRegression/tutorial/LinearRegression"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 5700, 114, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[6325, 141, 58, 1, 70, "Title",
 CellID->31317],
Cell[6386, 144, 1680, 47, 70, "Text",
 CellID->22815],
Cell[8069, 193, 4152, 135, 70, "Text",
 CellID->23759],
Cell[12224, 330, 2789, 92, 70, "Text",
 CellID->21964],
Cell[15016, 424, 2679, 94, 70, "DefinitionBox",
 CellID->755],
Cell[17698, 520, 195, 8, 70, "Caption",
 CellID->3347],
Cell[17896, 530, 1193, 34, 70, "Text",
 CellID->7030],
Cell[19092, 566, 808, 23, 70, "Text",
 CellID->1413],
Cell[19903, 591, 2643, 80, 70, "DefinitionBox",
 CellID->11813],
Cell[22549, 673, 217, 8, 70, "Caption",
 CellID->19603],
Cell[22769, 683, 61, 1, 70, "MathCaption",
 CellID->591],
Cell[22833, 686, 100, 3, 70, "Input",
 CellID->24629],
Cell[22936, 691, 119, 3, 70, "MathCaption",
 CellID->29344],
Cell[23058, 696, 826, 26, 70, "Input",
 CellID->31416],
Cell[23887, 724, 66, 1, 70, "MathCaption",
 CellID->6485],
Cell[CellGroupData[{
Cell[23978, 729, 103, 3, 70, "Input",
 CellID->31227],
Cell[24084, 734, 590, 17, 128, "Output",
 CellID->674759877]
}, Open  ]],
Cell[24689, 754, 633, 22, 70, "MathCaption",
 CellID->20594],
Cell[CellGroupData[{
Cell[25347, 780, 212, 7, 70, "Input",
 CellID->29739],
Cell[25562, 789, 3222, 80, 150, "Output",
 CellID->6219540]
}, Open  ]],
Cell[28799, 872, 219, 8, 70, "MathCaption",
 CellID->11387],
Cell[CellGroupData[{
Cell[29043, 884, 208, 7, 70, "Input",
 CellID->23967],
Cell[29254, 893, 286, 8, 36, "Output",
 CellID->219403052]
}, Open  ]],
Cell[29555, 904, 1459, 40, 70, "DefinitionBox3Col",
 CellID->13300],
Cell[31017, 946, 200, 8, 70, "Caption",
 CellID->384],
Cell[31220, 956, 1021, 30, 70, "Text",
 CellID->17996],
Cell[32244, 988, 1619, 52, 70, "Text",
 CellID->4335],
Cell[33866, 1042, 1173, 41, 70, "Text",
 CellID->31587],
Cell[35042, 1085, 2752, 88, 70, "Text",
 CellID->23714],
Cell[37797, 1175, 591, 20, 70, "Text",
 CellID->6146],
Cell[38391, 1197, 911, 27, 70, "Text",
 CellID->17849],
Cell[39305, 1226, 4290, 121, 70, "DefinitionBox",
 CellID->17046],
Cell[43598, 1349, 223, 9, 70, "Caption",
 CellID->29221],
Cell[43824, 1360, 1844, 47, 70, "Text",
 CellID->5191],
Cell[45671, 1409, 3880, 117, 70, "Text",
 CellID->29125],
Cell[49554, 1528, 1717, 48, 70, "Text",
 CellID->30991],
Cell[51274, 1578, 1108, 30, 70, "Text",
 CellID->406],
Cell[52385, 1610, 210, 5, 70, "MathCaption",
 CellID->21442],
Cell[CellGroupData[{
Cell[52620, 1619, 435, 13, 70, "Input",
 CellID->1323],
Cell[53058, 1634, 4094, 100, 272, "Output",
 CellID->60798766]
}, Open  ]],
Cell[57167, 1737, 100, 2, 70, "MathCaption",
 CellID->20737],
Cell[CellGroupData[{
Cell[57292, 1743, 155, 4, 70, "Input",
 CellID->9375],
Cell[57450, 1749, 573, 14, 54, "Output",
 CellID->206120088]
}, Open  ]],
Cell[58038, 1766, 194, 4, 70, "MathCaption",
 CellID->9806],
Cell[58235, 1772, 423, 14, 70, "Input",
 CellID->26724],
Cell[58661, 1788, 99, 2, 70, "MathCaption",
 CellID->10293],
Cell[CellGroupData[{
Cell[58785, 1794, 199, 6, 70, "Input",
 CellID->28596],
Cell[58987, 1802, 954, 23, 127, "Output",
 CellID->140924700]
}, Open  ]],
Cell[59956, 1828, 400, 12, 70, "MathCaption",
 CellID->29670],
Cell[60359, 1842, 819, 27, 70, "Input",
 CellID->4046],
Cell[61181, 1871, 412, 11, 70, "MathCaption",
 CellID->14663],
Cell[CellGroupData[{
Cell[61618, 1886, 813, 25, 70, "Input",
 CellID->28182],
Cell[62434, 1913, 1853, 37, 233, "Output",
 CellID->217075312]
}, Open  ]],
Cell[64302, 1953, 654, 20, 70, "MathCaption",
 CellID->14721],
Cell[CellGroupData[{
Cell[64981, 1977, 422, 11, 65, "Input",
 CellID->23071],
Cell[65406, 1990, 6992, 119, 355, "Output",
 Evaluatable->False,
 CellID->61584315]
}, Open  ]],
Cell[72413, 2112, 1129, 26, 70, "Text",
 CellID->2040],
Cell[73545, 2140, 6889, 214, 70, "DefinitionBox",
 CellID->529159570],
Cell[80437, 2356, 70, 1, 70, "Caption",
 CellID->20301],
Cell[80510, 2359, 1976, 51, 70, "Text",
 CellID->13426],
Cell[82489, 2412, 1816, 54, 70, "DefinitionBox",
 CellID->396748024],
Cell[84308, 2468, 112, 3, 70, "Caption",
 CellID->8124],
Cell[84423, 2473, 574, 13, 70, "Text",
 CellID->23622],
Cell[85000, 2488, 346, 12, 70, "DefinitionBox",
 CellID->284949088],
Cell[85349, 2502, 63, 1, 70, "Caption",
 CellID->4825],
Cell[85415, 2505, 746, 22, 70, "Text",
 CellID->941],
Cell[86164, 2529, 746, 25, 70, "DefinitionBox",
 CellID->43156369],
Cell[86913, 2556, 113, 3, 70, "Caption",
 CellID->9648],
Cell[87029, 2561, 926, 24, 70, "Text",
 CellID->20076],
Cell[87958, 2587, 1475, 48, 70, "DefinitionBox",
 CellID->597169351],
Cell[89436, 2637, 88, 1, 70, "Caption",
 CellID->4574],
Cell[89527, 2640, 2345, 74, 70, "Text",
 CellID->32678],
Cell[91875, 2716, 115, 3, 70, "MathCaption",
 CellID->18067],
Cell[CellGroupData[{
Cell[92015, 2723, 245, 8, 70, "Input",
 CellID->4660],
Cell[92263, 2733, 945, 27, 54, "Output",
 CellID->115952187]
}, Open  ]],
Cell[93223, 2763, 80, 1, 70, "MathCaption",
 CellID->6812],
Cell[CellGroupData[{
Cell[93328, 2768, 199, 7, 70, "Input",
 CellID->32554],
Cell[93530, 2777, 310, 9, 36, "Output",
 CellID->136058729]
}, Open  ]],
Cell[93855, 2789, 390, 14, 70, "MathCaption",
 CellID->277],
Cell[CellGroupData[{
Cell[94270, 2807, 274, 8, 70, "Input",
 CellID->10994],
Cell[94547, 2817, 3226, 79, 150, "Output",
 CellID->68440496]
}, Open  ]],
Cell[97788, 2899, 665, 22, 70, "DefinitionBox",
 CellID->368483489],
Cell[98456, 2923, 119, 3, 70, "Caption",
 CellID->30922],
Cell[98578, 2928, 381, 10, 70, "Text",
 CellID->23928],
Cell[98962, 2940, 110, 3, 70, "MathCaption",
 CellID->27160],
Cell[99075, 2945, 166, 6, 70, "Input",
 CellID->4716],
Cell[99244, 2953, 149, 4, 70, "MathCaption",
 CellID->29767],
Cell[CellGroupData[{
Cell[99418, 2961, 214, 6, 70, "Input",
 CellID->11743],
Cell[99635, 2969, 312, 10, 36, "Output",
 CellID->67324383]
}, Open  ]]
}, Open  ]],
Cell[99974, 2983, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

