(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     14420,        479]
NotebookOptionsPosition[     10027,        354]
NotebookOutlinePosition[     11901,        396]
CellTagsIndexPosition[     11858,        393]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "GuideColorBar"],

Cell[CellGroupData[{

Cell["Multivariate Statistics Package", "GuideTitle",
 CellID->942062912],

Cell["\[NonBreakingSpace]", "GuideAbstract",
 CellID->1],

Cell[CellGroupData[{

Cell["Location Measures", "GuideFunctionsSubsection",
 CellID->399956826],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpatialMedian",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/SpatialMedian"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " median based on minimum Euclidean distance"
}], "GuideText",
 CellID->460410767],

Cell[TextData[{
 Cell[TextData[ButtonBox["SimplexMedian",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/SimplexMedian"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MultivariateTrimmedMean",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/MultivariateTrimmedMean"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->2975455]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dispersion and Association Measures", "GuideFunctionsSubsection",
 CellID->24485452],

Cell[TextData[{
 Cell[TextData[ButtonBox["MultivariateMeanDeviation",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/MultivariateMeanDeviation"]],
   "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " multivariate extension of mean deviation"
}], "GuideText",
 CellID->42651672],

Cell[TextData[{
 Cell[TextData[ButtonBox["SpearmanRankCorrelation",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/SpearmanRankCorrelation"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " Spearman's correlation coefficient"
}], "GuideText",
 CellID->134539157],

Cell[TextData[{
 Cell[TextData[ButtonBox["TotalVariation",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/TotalVariation"]], 
  "InlineFunctionSans"],
 " ",
 " trace of a covariance matrix"
}], "GuideText",
 CellID->344575290],

Cell[TextData[{
 Cell[TextData[ButtonBox["GeneralizedVariance",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/GeneralizedVariance"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MultivariateMedianDeviation",
  BaseStyle->"Link",
  ButtonData->
   "paclet:MultivariateStatistics/ref/MultivariateMedianDeviation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["KendallRankCorrelation",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/KendallRankCorrelation"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PrincipalComponents",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/PrincipalComponents"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->538634740]
}, Open  ]],

Cell[CellGroupData[{

Cell["Higher Moments", "GuideFunctionsSubsection",
 CellID->289307162],

Cell[TextData[{
 Cell[TextData[ButtonBox["MultivariateSkewness",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/MultivariateSkewness"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " multivariate extension of skewness"
}], "GuideText",
 CellID->779489886],

Cell[TextData[{
 Cell[TextData[ButtonBox["MultivariateKurtosis",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/MultivariateKurtosis"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " multivariate extension of kurtosis"
}], "GuideText",
 CellID->93271807]
}, Open  ]],

Cell[CellGroupData[{

Cell["Regional Measures", "GuideFunctionsSubsection",
 CellID->848092446],

Cell[TextData[{
 Cell[TextData[ButtonBox["EllipsoidQuantile",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuantile"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " ellipsoidal quantile locus"
}], "GuideText",
 CellID->388703195],

Cell[TextData[{
 Cell[TextData[ButtonBox["EllipsoidProbability",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidProbability"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " probability for ellipsoidal region"
}], "GuideText",
 CellID->1519434],

Cell[TextData[{
 Cell[TextData[ButtonBox["EllipsoidQuartiles",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuartiles"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolytopeQuantile",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuantile"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["PolytopeQuartiles",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuartiles"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["Polytope",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/Polytope"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->99678707],

Cell["\t", "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],

Cell[CellGroupData[{

Cell["Distributions Related to the Multivariate Normal", \
"GuideFunctionsSubsection",
 CellID->666183036],

Cell[TextData[{
 Cell[TextData[ButtonBox["MultinormalDistribution",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/MultinormalDistribution"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " multivariate normal distribution"
}], "GuideText",
 CellID->150637195],

Cell[TextData[{
 Cell[TextData[ButtonBox["MultivariateTDistribution",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/MultivariateTDistribution"]],
   "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " multivariate extension of Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution"
}], "GuideText",
 CellID->108168133],

Cell[TextData[{
 Cell[TextData[ButtonBox["HotellingTSquareDistribution",
  BaseStyle->"Link",
  ButtonData->
   "paclet:MultivariateStatistics/ref/HotellingTSquareDistribution"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["QuadraticFormDistribution",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/QuadraticFormDistribution"]],
   "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["WishartDistribution",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/WishartDistribution"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->4121278],

Cell["\t", "GuideDelimiterSubsection",
 CellID->251067191]
}, Open  ]],

Cell[CellGroupData[{

Cell["Multivariate Discrete Distributions", "GuideFunctionsSubsection",
 CellID->338690602],

Cell[TextData[{
 Cell[TextData[ButtonBox["MultinomialDistribution",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/MultinomialDistribution"]], 
  "InlineFunctionSans"],
 " ",
 StyleBox["\[LongDash]", "GuideEmDash"],
 " multivariate extension of binomial distribution"
}], "GuideText",
 CellID->530406300],

Cell[TextData[{
 Cell[TextData[ButtonBox["NegativeMultinomialDistribution",
  BaseStyle->"Link",
  ButtonData->
   "paclet:MultivariateStatistics/ref/NegativeMultinomialDistribution"]], 
  "InlineFunctionSans"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledVerySmallSquare]", "InlineSeparator"],
 " ",
 Cell[TextData[ButtonBox["MultiPoissonDistribution",
  BaseStyle->"Link",
  ButtonData->"paclet:MultivariateStatistics/ref/MultiPoissonDistribution"]], 
  "InlineFunctionSans"]
}], "InlineGuideFunctionListing",
 CellID->365594387]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["TUTORIALS", "GuideTutorialsSection",
 CellID->415694126],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"GuideTutorial",
 CellID->495904497]
}, Open  ]],

Cell[CellGroupData[{

Cell["MORE ABOUT", "GuideMoreAboutSection",
 CellID->23220180],

Cell[TextData[ButtonBox["Descriptive Statistics",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/DescriptiveStatistics"]], "GuideMoreAbout",
 CellID->113822380],

Cell[TextData[ButtonBox["Continuous Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/ContinuousStatisticalDistributions"]], "GuideMoreAbout",
 CellID->84797929],

Cell[TextData[ButtonBox["Discrete Statistical Distributions",
 BaseStyle->"Link",
 ButtonData->
  "paclet:guide/DiscreteStatisticalDistributions"]], "GuideMoreAbout",
 CellID->87833421],

Cell[TextData[ButtonBox["Random Number Generation",
 BaseStyle->"Link",
 ButtonData->"paclet:guide/RandomNumberGeneration"]], "GuideMoreAbout",
 CellID->65246185]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Multivariate Statistics Package - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 27.5561676}", "context" -> 
    "MultivariateStatistics`", 
    "keywords" -> {
     "multivariate analysis", "multivariate distribution", 
      "multivariate statistics"}, "index" -> True, "label" -> 
    "Multivariate Statistics Package Guide", "language" -> "en", "paclet" -> 
    "MultivariateStatistics Package", "status" -> "None", "summary" -> 
    "SpatialMedian -- median based on minimum Euclidean distance, \
MultivariateMeanDeviation -- multivariate extension of mean deviation, \
SpearmanRankCorrelation -- Spearman's correlation coefficient, TotalVariation \
-- trace of a covariance matrix, MultivariateSkewness -- multivariate \
extension of skewness, MultivariateKurtosis -- multivariate extension of \
kurtosis, EllipsoidQuantile -- ellipsoidal quantile locus, \
EllipsoidProbability -- probability for ellipsoidal region, \
MultinormalDistribution -- multivariate normal distribution, \
MultivariateTDistribution -- multivariate extension of Student t \
distribution, MultinomialDistribution -- multivariate extension of binomial \
distribution", "synonyms" -> {}, "title" -> "Multivariate Statistics Package",
     "type" -> "Guide", "uri" -> 
    "MultivariateStatistics/guide/MultivariateStatisticsPackage"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 26, 0, 8, "GuideColorBar"],
Cell[CellGroupData[{
Cell[619, 25, 73, 1, 70, "GuideTitle",
 CellID->942062912],
Cell[695, 28, 56, 1, 70, "GuideAbstract",
 CellID->1],
Cell[CellGroupData[{
Cell[776, 33, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->399956826],
Cell[852, 36, 302, 9, 70, "GuideText",
 CellID->460410767],
Cell[1157, 47, 486, 13, 70, "InlineGuideFunctionListing",
 CellID->2975455]
}, Open  ]],
Cell[CellGroupData[{
Cell[1680, 65, 90, 1, 70, "GuideFunctionsSubsection",
 CellID->24485452],
Cell[1773, 68, 323, 9, 70, "GuideText",
 CellID->42651672],
Cell[2099, 79, 314, 9, 70, "GuideText",
 CellID->134539157],
Cell[2416, 90, 249, 8, 70, "GuideText",
 CellID->344575290],
Cell[2668, 100, 1030, 28, 70, "InlineGuideFunctionListing",
 CellID->538634740]
}, Open  ]],
Cell[CellGroupData[{
Cell[3735, 133, 70, 1, 70, "GuideFunctionsSubsection",
 CellID->289307162],
Cell[3808, 136, 308, 9, 70, "GuideText",
 CellID->779489886],
Cell[4119, 147, 307, 9, 70, "GuideText",
 CellID->93271807]
}, Open  ]],
Cell[CellGroupData[{
Cell[4463, 161, 73, 1, 70, "GuideFunctionsSubsection",
 CellID->848092446],
Cell[4539, 164, 294, 9, 70, "GuideText",
 CellID->388703195],
Cell[4836, 175, 306, 9, 70, "GuideText",
 CellID->1519434],
Cell[5145, 186, 969, 27, 70, "InlineGuideFunctionListing",
 CellID->99678707],
Cell[6117, 215, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->311258892]
}, Open  ]],
Cell[CellGroupData[{
Cell[6212, 221, 106, 2, 70, "GuideFunctionsSubsection",
 CellID->666183036],
Cell[6321, 225, 312, 9, 70, "GuideText",
 CellID->150637195],
Cell[6636, 236, 393, 12, 70, "GuideText",
 CellID->108168133],
Cell[7032, 250, 780, 21, 70, "InlineGuideFunctionListing",
 CellID->4121278],
Cell[7815, 273, 58, 1, 70, "GuideDelimiterSubsection",
 CellID->251067191]
}, Open  ]],
Cell[CellGroupData[{
Cell[7910, 279, 91, 1, 70, "GuideFunctionsSubsection",
 CellID->338690602],
Cell[8004, 282, 327, 9, 70, "GuideText",
 CellID->530406300],
Cell[8334, 293, 530, 14, 70, "InlineGuideFunctionListing",
 CellID->365594387]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[8913, 313, 62, 1, 70, "GuideTutorialsSection",
 CellID->415694126],
Cell[8978, 316, 200, 5, 70, "GuideTutorial",
 CellID->495904497]
}, Open  ]],
Cell[CellGroupData[{
Cell[9215, 326, 62, 1, 70, "GuideMoreAboutSection",
 CellID->23220180],
Cell[9280, 329, 160, 3, 70, "GuideMoreAbout",
 CellID->113822380],
Cell[9443, 334, 189, 4, 70, "GuideMoreAbout",
 CellID->84797929],
Cell[9635, 340, 185, 4, 70, "GuideMoreAbout",
 CellID->87833421],
Cell[9823, 346, 162, 3, 70, "GuideMoreAbout",
 CellID->65246185]
}, Open  ]],
Cell[10000, 352, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

