(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15255,        546]
NotebookOptionsPosition[     12130,        441]
NotebookOutlinePosition[     13455,        478]
CellTagsIndexPosition[     13370,        473]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Variance" :> Documentation`HelpLookup["paclet:ref/Variance"], 
          "TotalVariation" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/TotalVariation"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Variance\"\>", 
       2->"\<\"TotalVariation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["GeneralizedVariance", "ObjectName",
 CellID->12582],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"GeneralizedVariance", "[", 
       StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the generalized variance for ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7448]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"GeneralizedVariance", "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 " effectively gives the determinant of the covariance matrix for ",
 Cell[BoxData[
  StyleBox["matrix", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->30205783],

Cell[TextData[{
 "For numeric ",
 Cell[BoxData[
  StyleBox["matrix", "TI"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{"GeneralizedVariance", "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 " is equal to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Apply",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Apply"], "[", 
   RowBox[{
    ButtonBox["Times",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Times"], ",", " ", 
    RowBox[{
     ButtonBox["Variance",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/Variance"], "[", 
     RowBox[{
      ButtonBox["PrincipalComponents",
       BaseStyle->"Link",
       ButtonData->"paclet:MultivariateStatistics/ref/PrincipalComponents"], 
      "[", 
      StyleBox["matrix", "TI"], "]"}], "]"}]}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5002]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21179459],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->147074538],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->332989057],

Cell["Generalized variance of bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GeneralizedVariance", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"a", ",", "b"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"c", ",", "d"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"e", ",", "f"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19771377],

Cell[BoxData[
 RowBox[{
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["c", "2"]}], "12"], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", "a", " ", "b", " ", "c", " ", "d"}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["d", "2"]}], "12"], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   SuperscriptBox["b", "2"], " ", "c", " ", "e"}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", "a", " ", "b", " ", "d", " ", "e"}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", "b", " ", "c", " ", "d", " ", "e"}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", "a", " ", 
   SuperscriptBox["d", "2"], " ", "e"}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["b", "2"], " ", 
    SuperscriptBox["e", "2"]}], "12"], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", "b", " ", "d", " ", 
   SuperscriptBox["e", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["d", "2"], " ", 
    SuperscriptBox["e", "2"]}], "12"], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", "a", " ", "b", " ", "c", " ", "f"}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", "b", " ", 
   SuperscriptBox["c", "2"], " ", "f"}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", 
   SuperscriptBox["a", "2"], " ", "d", " ", "f"}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", "a", " ", "c", " ", "d", " ", "f"}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", "a", " ", "b", " ", "e", " ", "f"}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", "b", " ", "c", " ", "e", " ", "f"}], "+", 
  RowBox[{
   FractionBox["1", "6"], " ", "a", " ", "d", " ", "e", " ", "f"}], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", "c", " ", "d", " ", "e", " ", "f"}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["a", "2"], " ", 
    SuperscriptBox["f", "2"]}], "12"], "-", 
  RowBox[{
   FractionBox["1", "6"], " ", "a", " ", "c", " ", 
   SuperscriptBox["f", "2"]}], "+", 
  FractionBox[
   RowBox[{
    SuperscriptBox["c", "2"], " ", 
    SuperscriptBox["f", "2"]}], "12"]}]], "Output",
 ImageSize->{403, 99},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->159326738]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->29311],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->166255842],

Cell["\<\
Generalized variance is equivalent to the determinant of the covariance \
matrix:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->143789359],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GeneralizedVariance", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], "}"}], "]"}], "\[Equal]", 
  RowBox[{"Det", "[", 
   RowBox[{"Covariance", "[", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"0", ",", "2"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"3", ",", "4"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"4", ",", "2"}], "}"}]}], "}"}], "]"}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10528200],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->710201]
}, Open  ]],

Cell["\<\
Generalized variance is equal to the product of principal component \
variances:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->454163553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"GeneralizedVariance", "[", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "2"}], "}"}]}], "}"}], "]"}], "==", 
  RowBox[{"Apply", "[", 
   RowBox[{"Times", ",", 
    RowBox[{"Variance", "[", 
     RowBox[{"PrincipalComponents", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"1", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"3", ",", "4"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"4", ",", "2"}], "}"}]}], "}"}], "]"}], "]"}]}], 
   "]"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->676513535],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->165177603]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->415],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Variance",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Variance"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TotalVariation",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/TotalVariation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->24765]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->26358],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->17843]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"GeneralizedVariance - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 28.6655710}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {"generalized variance"}, 
    "index" -> True, "label" -> "Multivariate Statistics Package Symbol", 
    "language" -> "en", "paclet" -> "MultivariateStatistics Package", 
    "status" -> "None", "summary" -> 
    "GeneralizedVariance[matrix] gives the generalized variance for matrix.", 
    "synonyms" -> {}, "title" -> "GeneralizedVariance", "type" -> "Symbol", 
    "uri" -> "MultivariateStatistics/ref/GeneralizedVariance"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4231, 148, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->21179459]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 13228, 466}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1379, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2002, 62, 57, 1, 70, "ObjectName",
 CellID->12582],
Cell[2062, 65, 483, 15, 70, "Usage",
 CellID->7448]
}, Open  ]],
Cell[CellGroupData[{
Cell[2582, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3060, 102, 292, 9, 70, "Notes",
 CellID->30205783],
Cell[3355, 113, 839, 30, 70, "Notes",
 CellID->5002]
}, Closed]],
Cell[CellGroupData[{
Cell[4231, 148, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->21179459],
Cell[CellGroupData[{
Cell[4615, 162, 148, 5, 70, "ExampleSection",
 CellID->147074538],
Cell[4766, 169, 147, 4, 70, "Input",
 CellID->332989057],
Cell[4916, 175, 214, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[5155, 184, 324, 11, 28, "Input",
 CellID->19771377],
Cell[5482, 197, 2174, 66, 120, "Output",
 CellID->159326738]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7705, 269, 233, 7, 70, "ExampleSection",
 CellID->29311],
Cell[7941, 278, 147, 4, 70, "Input",
 CellID->166255842],
Cell[8091, 284, 269, 8, 70, "ExampleText",
 CellID->143789359],
Cell[CellGroupData[{
Cell[8385, 296, 784, 26, 70, "Input",
 CellID->10528200],
Cell[9172, 324, 158, 5, 36, "Output",
 CellID->710201]
}, Open  ]],
Cell[9345, 332, 268, 8, 70, "ExampleText",
 CellID->454163553],
Cell[CellGroupData[{
Cell[9638, 344, 881, 29, 70, "Input",
 CellID->676513535],
Cell[10522, 375, 161, 5, 36, "Output",
 CellID->165177603]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10744, 387, 309, 9, 70, "SeeAlsoSection",
 CellID->415],
Cell[11056, 398, 486, 17, 70, "SeeAlso",
 CellID->24765]
}, Open  ]],
Cell[CellGroupData[{
Cell[11579, 420, 314, 9, 70, "TutorialsSection",
 CellID->26358],
Cell[11896, 431, 192, 5, 70, "Tutorials",
 CellID->17843]
}, Open  ]],
Cell[12103, 439, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

