(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     33179,       1213]
NotebookOptionsPosition[     26795,        989]
NotebookOutlinePosition[     28296,       1030]
CellTagsIndexPosition[     28210,       1025]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MultinormalDistribution" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultinormalDistribution"], 
          "MultivariateTDistribution" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultivariateTDistribution"], 
          "FRatioDistribution" :> 
          Documentation`HelpLookup["paclet:ref/FRatioDistribution"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"MultinormalDistribution\"\>", 
       2->"\<\"MultivariateTDistribution\"\>", 
       3->"\<\"FRatioDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["HotellingTSquareDistribution", "ObjectName",
 CellID->22842],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"HotellingTSquareDistribution", "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents Hotelling's ",
     Cell[BoxData[
      SuperscriptBox["T", "2"]], "InlineFormula"],
     " distribution with dimensionality parameter ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " and degrees of freedom parameter ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     StyleBox[".", "TI"]
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9407]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["HotellingTSquareDistribution"], "InlineFormula"],
 " is a univariate distribution derived from the multivariate normal \
distribution."
}], "Notes",
 CellID->661575508],

Cell[TextData[{
 "The probability density for value ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in Hotelling's ",
 Cell[BoxData[
  SuperscriptBox["T", "2"]], "InlineFormula"],
 " distribution is proportional to ",
 Cell[BoxData[
  RowBox[{
   SuperscriptBox[
    StyleBox["x", "TI"], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{
      StyleBox["p", "TI"], "/", "2"}]}]], 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{
       StyleBox["x", "TI"], "/", 
       StyleBox["m", "TI"]}]}], ")"}], 
    RowBox[{
     RowBox[{"-", 
      RowBox[{"(", 
       RowBox[{
        StyleBox["m", "TI"], "+", "1"}], ")"}]}], "/", "2"}]]}]], 
  "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], ">", "0"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->424730070],

Cell[TextData[{
 "The parameters ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " can be any positive real numbers such that ",
 Cell[BoxData[
  FormBox[
   RowBox[{"m", ">", "p"}], TraditionalForm]], "InlineMath"],
 "."
}], "Notes",
 CellID->343064664],

Cell[TextData[{
 Cell[BoxData["HotellingTSquareDistribution"], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1355]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->702495764],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->384967962],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->8423819],

Cell[TextData[{
 "The mean of a Hotelling ",
 Cell[BoxData[
  SuperscriptBox["T", "2"]], "InlineFormula"],
 " distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"HotellingTSquareDistribution", "[", 
   RowBox[{"p", ",", "m"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24173],

Cell[BoxData[
 FractionBox[
  RowBox[{"m", " ", "p"}], 
  RowBox[{
   RowBox[{"-", "1"}], "+", "m", "-", "p"}]]], "Output",
 ImageSize->{63, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->6201495]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246746483],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->913113998],

Cell["The variance:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->472395019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"HotellingTSquareDistribution", "[", 
   RowBox[{"p", ",", "m"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8902],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
   SuperscriptBox["m", "2"], " ", "p"}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], "+", "m", "-", "p"}], ")"}], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "m", "-", "p"}], ")"}], "2"]}]]], "Output",
 ImageSize->{153, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->812942175]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->443377084],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"HotellingTSquareDistribution", "[", 
    RowBox[{"p", ",", "m"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30324],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["m", 
    RowBox[{
     RowBox[{"-", "p"}], "/", "2"}]], " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox["p", "2"]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["x", "m"]}], ")"}], 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "m"}], ")"}]}]]}], 
  RowBox[{"Beta", "[", 
   RowBox[{
    FractionBox["p", "2"], ",", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "m", "-", "p"}], ")"}]}]}], "]"}]]], "Output",
 ImageSize->{158, 53},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->28991764]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"HotellingTSquareDistribution", "[", 
      RowBox[{"5", ",", "10"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "50"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20649],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 118},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->428102799]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21725],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->774206223],

Cell[TextData[{
 "Generate a set of pseudorandom numbers that follow a Hotelling ",
 Cell[BoxData[
  SuperscriptBox["T", "2"]], "InlineFormula"],
 " distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->24449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"HotellingTSquareDistribution", "[", 
    RowBox[{"5", ",", "10"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "4.28504042565135`", ",", "12.256432778410053`", ",", "5.18213340182399`", 
   ",", "3.349029966147899`", ",", "7.685529520123531`", ",", 
   "7.855761142133001`", ",", "3.2299226782609938`", ",", 
   "5.376493246328504`", ",", "15.640802610421591`", ",", 
   "3.2095053513482226`"}], "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->52100766]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3561],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->80424363],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"HotellingTSquareDistribution", "[", 
   RowBox[{"p", ",", "m"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6096],

Cell[BoxData[
 FractionBox[
  RowBox[{"2", " ", 
   SqrtBox["2"], " ", 
   SqrtBox[
    RowBox[{
     RowBox[{"-", "3"}], "+", "m", "-", "p"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "m", "+", "p"}], ")"}]}], 
  RowBox[{
   SqrtBox[
    RowBox[{
     RowBox[{"-", "1"}], "+", "m"}]], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "5"}], "+", "m", "-", "p"}], ")"}], " ", 
   SqrtBox["p"]}]]], "Output",
 ImageSize->{187, 40},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->77343566]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2948],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->421059815],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"HotellingTSquareDistribution", "[", 
   RowBox[{"p", ",", "m"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6916],

Cell[BoxData[
 RowBox[{"3", "+", 
  FractionBox[
   RowBox[{"12", " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "3"}], "+", "m", "-", "p"}], ")"}], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "m", "-", "p"}], ")"}], "2"]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "22"}], "+", 
         RowBox[{"5", " ", 
          RowBox[{"(", 
           RowBox[{"1", "+", "m", "-", "p"}], ")"}]}]}], ")"}], " ", "p"}]}], 
     ")"}]}], 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "1"}], "+", "m"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "7"}], "+", "m", "-", "p"}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", "5"}], "+", "m", "-", "p"}], ")"}], " ", 
    "p"}]]}]], "Output",
 ImageSize->{396, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->642112316]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->24339],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->310944845],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->4348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Integrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"HotellingTSquareDistribution", "[", 
      RowBox[{"p", ",", "m"}], "]"}], ",", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"0", "<", "p", "<", "m"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->121610214],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->136643438]
}, Open  ]],

Cell[TextData[{
 "Hotelling ",
 Cell[BoxData[
  SuperscriptBox["T", "2"]], "InlineFormula"],
 " variables are related to F-ratio variables by a multiplicative constant:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->265834504],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"y", "=", 
   RowBox[{"x", 
    RowBox[{"(", 
     RowBox[{"m", " ", 
      RowBox[{"p", "/", 
       RowBox[{"(", 
        RowBox[{"m", "-", "p", "+", "1"}], ")"}]}]}], ")"}]}]}], 
  ";"}], "\n", 
 RowBox[{
  RowBox[{"PDF", "[", 
   RowBox[{
    RowBox[{"HotellingTSquareDistribution", "[", 
     RowBox[{"p", ",", "m"}], "]"}], ",", "y"}], "]"}], "*", 
  RowBox[{"D", "[", 
   RowBox[{"y", ",", "x"}], "]"}]}]}], "Input",
 CellLabel->"In[3]:=",
 CellID->205042421],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["m", 
    RowBox[{"1", "-", 
     FractionBox["p", "2"]}]], " ", "p", " ", 
   SuperscriptBox[
    RowBox[{"(", 
     FractionBox[
      RowBox[{"m", " ", "p", " ", "x"}], 
      RowBox[{"1", "+", "m", "-", "p"}]], ")"}], 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox["p", "2"]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{"p", " ", "x"}], 
       RowBox[{"1", "+", "m", "-", "p"}]]}], ")"}], 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "m"}], ")"}]}]]}], 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", "m", "-", "p"}], ")"}], " ", 
   RowBox[{"Beta", "[", 
    RowBox[{
     FractionBox["p", "2"], ",", 
     RowBox[{
      FractionBox["1", "2"], " ", 
      RowBox[{"(", 
       RowBox[{"1", "+", "m", "-", "p"}], ")"}]}]}], "]"}]}]]], "Output",
 ImageSize->{223, 56},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->446720617]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"FRatioDistribution", "[", 
    RowBox[{"p", ",", 
     RowBox[{"1", "+", "m", "-", "p"}]}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->24161211],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "m", "-", "p"}], ")"}], 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "m", "-", "p"}], ")"}]}]], " ", 
   SuperscriptBox["p", 
    RowBox[{"p", "/", "2"}]], " ", 
   SuperscriptBox["x", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     FractionBox["p", "2"]}]], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", "m", "-", "p", "+", 
      RowBox[{"p", " ", "x"}]}], ")"}], 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "1"}], "-", "m"}], ")"}]}]]}], 
  RowBox[{"Beta", "[", 
   RowBox[{
    FractionBox["p", "2"], ",", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{"1", "+", "m", "-", "p"}], ")"}]}]}], "]"}]]], "Output",
 ImageSize->{309, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->773387916]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{
   RowBox[{"%", "\[Equal]", "%"}], ",", 
   RowBox[{"Assumptions", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"x", ">", "0"}], ",", 
      RowBox[{"m", ">", "p", ">", "0"}]}], "}"}]}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->29420744],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->26654028]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->28928],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->496919360],

Cell[TextData[{
 Cell[BoxData["HotellingTSquareDistribution"], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  RowBox[{
   StyleBox["m", "TI"], "<", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"HotellingTSquareDistribution", "[", 
   RowBox[{"5", ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95470147],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"HotellingTSquareDistribution", "[", 
   RowBox[{"5", ",", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{282, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->123433520]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["HotellingTSquareDistribution"], "InlineFormula"],
 " is not defined when p is less than 0:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->322608174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"HotellingTSquareDistribution", "[", 
   RowBox[{
    RowBox[{"-", "5"}], ",", "2"}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->209078008],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"HotellingTSquareDistribution", "[", 
   RowBox[{
    RowBox[{"-", "5"}], ",", "2"}], "]"}], "]"}]], "Output",
 ImageSize->{289, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->488005878]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15418],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->12787706],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"HotellingTSquareDistribution", "[", 
    RowBox[{"p", ",", "m"}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"p", "\[Rule]", "1"}], ",", 
    RowBox[{"m", "\[Rule]", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2647],

Cell[BoxData[
 RowBox[{
  FractionBox["1", "5"], "-", 
  FractionBox[
   RowBox[{"2", " ", "\[ImaginaryI]"}], "5"]}]], "Output",
 ImageSize->{50, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->13661521]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23973],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultinormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/MultinormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultivariateTDistribution",
    BaseStyle->"Link",
    ButtonData->
     "paclet:MultivariateStatistics/ref/MultivariateTDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["FRatioDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/FRatioDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->14979]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5189],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->8544]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"HotellingTSquareDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 28.8999520}", "context" -> 
    "MultivariateStatistics`", 
    "keywords" -> {
     "Hotelling t square", "multivariate analysis", 
      "multivariate hypothesis testing"}, "index" -> True, "label" -> 
    "Multivariate Statistics Package Symbol", "language" -> "en", "paclet" -> 
    "MultivariateStatistics Package", "status" -> "None", "summary" -> 
    "HotellingTSquareDistribution[p, m] represents Hotelling's T^2 \
distribution with dimensionality parameter p and degrees of freedom parameter \
m.", "synonyms" -> {}, "title" -> "HotellingTSquareDistribution", "type" -> 
    "Symbol", "uri" -> 
    "MultivariateStatistics/ref/HotellingTSquareDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5559, 197, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->702495764]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 28067, 1018}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1649, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2272, 67, 66, 1, 70, "ObjectName",
 CellID->22842],
Cell[2341, 70, 771, 23, 70, "Usage",
 CellID->9407]
}, Open  ]],
Cell[CellGroupData[{
Cell[3149, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3627, 115, 199, 5, 70, "Notes",
 CellID->661575508],
Cell[3829, 122, 838, 34, 70, "Notes",
 CellID->424730070],
Cell[4670, 158, 334, 13, 70, "Notes",
 CellID->343064664],
Cell[5007, 173, 515, 19, 70, "Notes",
 CellID->1355]
}, Closed]],
Cell[CellGroupData[{
Cell[5559, 197, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->702495764],
Cell[CellGroupData[{
Cell[5944, 211, 148, 5, 70, "ExampleSection",
 CellID->384967962],
Cell[6095, 218, 145, 4, 70, "Input",
 CellID->8423819],
Cell[6243, 224, 295, 10, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[6563, 238, 175, 5, 28, "Input",
 CellID->24173],
Cell[6741, 245, 251, 9, 51, "Output",
 CellID->6201495]
}, Open  ]],
Cell[7007, 257, 125, 3, 70, "ExampleDelimiter",
 CellID->246746483],
Cell[7135, 262, 147, 4, 70, "Input",
 CellID->913113998],
Cell[7285, 268, 193, 5, 70, "ExampleText",
 CellID->472395019],
Cell[CellGroupData[{
Cell[7503, 277, 178, 5, 70, "Input",
 CellID->8902],
Cell[7684, 284, 528, 19, 57, "Output",
 CellID->812942175]
}, Open  ]],
Cell[8227, 306, 119, 3, 70, "ExampleDelimiter",
 CellID->675],
Cell[8349, 311, 147, 4, 70, "Input",
 CellID->443377084],
Cell[8499, 317, 204, 5, 70, "ExampleText",
 CellID->6303],
Cell[CellGroupData[{
Cell[8728, 326, 199, 6, 70, "Input",
 CellID->30324],
Cell[8930, 334, 793, 30, 74, "Output",
 CellID->28991764]
}, Open  ]],
Cell[CellGroupData[{
Cell[9760, 369, 321, 10, 28, "Input",
 CellID->20649],
Cell[10084, 381, 2478, 45, 139, "Output",
 Evaluatable->False,
 CellID->428102799]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12611, 432, 216, 7, 70, "ExampleSection",
 CellID->21725],
Cell[12830, 441, 147, 4, 70, "Input",
 CellID->774206223],
Cell[12980, 447, 335, 10, 70, "ExampleText",
 CellID->24449],
Cell[CellGroupData[{
Cell[13340, 461, 207, 6, 70, "Input",
 CellID->5765],
Cell[13550, 469, 474, 12, 54, "Output",
 CellID->52100766]
}, Open  ]],
Cell[14039, 484, 120, 3, 70, "ExampleDelimiter",
 CellID->3561],
Cell[14162, 489, 146, 4, 70, "Input",
 CellID->80424363],
Cell[CellGroupData[{
Cell[14333, 497, 178, 5, 70, "Input",
 CellID->6096],
Cell[14514, 504, 568, 22, 61, "Output",
 CellID->77343566]
}, Open  ]],
Cell[15097, 529, 120, 3, 70, "ExampleDelimiter",
 CellID->2948],
Cell[15220, 534, 147, 4, 70, "Input",
 CellID->421059815],
Cell[CellGroupData[{
Cell[15392, 542, 178, 5, 70, "Input",
 CellID->6916],
Cell[15573, 549, 1120, 40, 58, "Output",
 CellID->642112316]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[16742, 595, 233, 7, 70, "ExampleSection",
 CellID->24339],
Cell[16978, 604, 147, 4, 70, "Input",
 CellID->310944845],
Cell[17128, 610, 228, 5, 70, "ExampleText",
 CellID->4348],
Cell[CellGroupData[{
Cell[17381, 619, 423, 12, 70, "Input",
 CellID->121610214],
Cell[17807, 633, 158, 5, 36, "Output",
 CellID->136643438]
}, Open  ]],
Cell[17980, 641, 345, 10, 70, "ExampleText",
 CellID->265834504],
Cell[CellGroupData[{
Cell[18350, 655, 501, 18, 70, "Input",
 CellID->205042421],
Cell[18854, 675, 1085, 39, 77, "Output",
 CellID->446720617]
}, Open  ]],
Cell[CellGroupData[{
Cell[19976, 719, 228, 7, 70, "Input",
 CellID->24161211],
Cell[20207, 728, 1003, 36, 69, "Output",
 CellID->773387916]
}, Open  ]],
Cell[CellGroupData[{
Cell[21247, 769, 316, 10, 70, "Input",
 CellID->29420744],
Cell[21566, 781, 160, 5, 36, "Output",
 CellID->26654028]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21775, 792, 226, 7, 70, "ExampleSection",
 CellID->28928],
Cell[22004, 801, 147, 4, 70, "Input",
 CellID->496919360],
Cell[22154, 807, 383, 13, 70, "ExampleText",
 CellID->8964],
Cell[CellGroupData[{
Cell[22562, 824, 178, 5, 70, "Input",
 CellID->95470147],
Cell[22743, 831, 268, 8, 36, "Output",
 CellID->123433520]
}, Open  ]],
Cell[23026, 842, 298, 8, 70, "ExampleText",
 CellID->322608174],
Cell[CellGroupData[{
Cell[23349, 854, 199, 6, 70, "Input",
 CellID->209078008],
Cell[23551, 862, 288, 9, 36, "Output",
 CellID->488005878]
}, Open  ]],
Cell[23854, 874, 121, 3, 70, "ExampleDelimiter",
 CellID->15418],
Cell[23978, 879, 146, 4, 70, "Input",
 CellID->12787706],
Cell[24127, 885, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[24433, 897, 309, 10, 70, "Input",
 CellID->2647],
Cell[24745, 909, 257, 9, 51, "Output",
 CellID->13661521]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25063, 925, 311, 9, 70, "SeeAlsoSection",
 CellID->23973],
Cell[25377, 936, 832, 27, 70, "SeeAlso",
 CellID->14979]
}, Open  ]],
Cell[CellGroupData[{
Cell[26246, 968, 313, 9, 70, "TutorialsSection",
 CellID->5189],
Cell[26562, 979, 191, 5, 70, "Tutorials",
 CellID->8544]
}, Open  ]],
Cell[26768, 987, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

