(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     25712,        951]
NotebookOptionsPosition[     20398,        768]
NotebookOutlinePosition[     21814,        807]
CellTagsIndexPosition[     21729,        802]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PoissonDistribution" :> 
          Documentation`HelpLookup["paclet:ref/PoissonDistribution"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"PoissonDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MultiPoissonDistribution", "ObjectName",
 CellID->21339],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MultiPoissonDistribution", "[", 
       RowBox[{
        SubscriptBox[
         StyleBox["\[Mu]", "TR"], 
         StyleBox["0", "TR"]], ",", 
        StyleBox["\[Mu]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a multivariate Poisson distribution with \
mean vector ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["\[Mu]", "TR"], 
        StyleBox["0", "TR"]], "+", 
       StyleBox["\[Mu]", "TR"]}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->19827]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The multivariate Poisson distribution ",
 Cell[BoxData[
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{
    SubscriptBox[
     StyleBox["\[Mu]", "TR"], 
     StyleBox["0", "TR"]], ",", 
    StyleBox["\[Mu]", "TR"]}], "]"}]], "InlineFormula"],
 " with ",
 Cell[BoxData[
  RowBox[{
   StyleBox["\[Mu]", "TR"], "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["\[Mu]", "TR"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["\[Mu]", "TR"], 
      StyleBox["2", "TR"]], ",", "\[Ellipsis]"}], "}"}]}]], "InlineFormula"],
 " is the distribution followed by a Poisson with mean ",
 Cell[BoxData[
  SubscriptBox["\[Mu]", "0"]], "InlineFormula"],
 " summed with a vector of independent Poissons with means ",
 Cell[BoxData[
  SubscriptBox["\[Mu]", "1"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox["\[Mu]", "2"]], "InlineFormula"],
 ",\[Ellipsis]."
}], "Notes",
 CellID->612636944],

Cell[TextData[{
 "The parameter ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["\[Mu]", "TR"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " and the elements of the vector ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " can be any positive numbers."
}], "Notes",
 CellID->18566],

Cell[TextData[{
 Cell[BoxData["MultiPoissonDistribution"], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["PDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->82602880]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->474632035],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->109169607],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->354566591],

Cell["The mean of a multivariate Poisson distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{
    SubscriptBox["\[Mu]", "0"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Mu]", "1"], ",", " ", 
      SubscriptBox["\[Mu]", "2"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Mu]", "0"], "+", 
    SubscriptBox["\[Mu]", "1"]}], ",", 
   RowBox[{
    SubscriptBox["\[Mu]", "0"], "+", 
    SubscriptBox["\[Mu]", "2"]}]}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->431500513]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246746483],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->1007134308],

Cell["The variances of each dimension:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->472395019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{
    SubscriptBox["\[Mu]", "0"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Mu]", "1"], ",", " ", 
      SubscriptBox["\[Mu]", "2"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    SubscriptBox["\[Mu]", "0"], "+", 
    SubscriptBox["\[Mu]", "1"]}], ",", 
   RowBox[{
    SubscriptBox["\[Mu]", "0"], "+", 
    SubscriptBox["\[Mu]", "2"]}]}], "}"}]], "Output",
 ImageSize->{105, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->359513120]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->299929388],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultiPoissonDistribution", "[", 
    RowBox[{
     SubscriptBox["\[Mu]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Mu]", "1"], ",", " ", 
       SubscriptBox["\[Mu]", "2"]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30324],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["\[ExponentialE]", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["\[Mu]", "0"]}], "-", 
     SubscriptBox["\[Mu]", "1"], "-", 
     SubscriptBox["\[Mu]", "2"]}]], " ", 
   RowBox[{"HypergeometricU", "[", 
    RowBox[{
     RowBox[{"-", "x"}], ",", 
     RowBox[{"1", "-", "x", "+", "y"}], ",", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SubscriptBox["\[Mu]", "1"], " ", 
        SubscriptBox["\[Mu]", "2"]}], 
       SubscriptBox["\[Mu]", "0"]]}]}], "]"}], " ", 
   SubsuperscriptBox["\[Mu]", "1", "x"], " ", 
   SubsuperscriptBox["\[Mu]", "2", "y"], " ", 
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SubscriptBox["\[Mu]", "1"], " ", 
        SubscriptBox["\[Mu]", "2"]}], 
       SubscriptBox["\[Mu]", "0"]]}], ")"}], 
    RowBox[{"-", "x"}]]}], 
  RowBox[{
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "x"}], "]"}], " ", 
   RowBox[{"Gamma", "[", 
    RowBox[{"1", "+", "y"}], "]"}]}]]], "Output",
 ImageSize->{396, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->483602252]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8552],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->535059345],

Cell["\<\
Generate a set of pseudorandom vectors that follow a multivariate Poisson \
distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->24449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"MultiPoissonDistribution", "[", 
    RowBox[{"5", ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "10"}], "}"}]}], "]"}], ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"11", ",", "19", ",", "22"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "4", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", "6", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "5", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "5", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6", ",", "18"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "8", ",", "5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "4", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "6", ",", "15"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "6", ",", "16"}], "}"}]}], "}"}]], "Output",
 ImageSize->{447, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->389867754]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3561],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->101071397],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{
    SubscriptBox["\[Mu]", "0"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Mu]", "1"], ",", " ", 
      SubscriptBox["\[Mu]", "2"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["1", 
    SqrtBox[
     RowBox[{
      SubscriptBox["\[Mu]", "0"], "+", 
      SubscriptBox["\[Mu]", "1"]}]]], ",", 
   FractionBox["1", 
    SqrtBox[
     RowBox[{
      SubscriptBox["\[Mu]", "0"], "+", 
      SubscriptBox["\[Mu]", "2"]}]]]}], "}"}]], "Output",
 ImageSize->{147, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158177591]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2948],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->32942996],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{
    SubscriptBox["\[Mu]", "0"], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Mu]", "1"], ",", " ", 
      SubscriptBox["\[Mu]", "2"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6916],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"3", "+", 
    FractionBox["1", 
     RowBox[{
      SubscriptBox["\[Mu]", "0"], "+", 
      SubscriptBox["\[Mu]", "1"]}]]}], ",", 
   RowBox[{"3", "+", 
    FractionBox["1", 
     RowBox[{
      SubscriptBox["\[Mu]", "0"], "+", 
      SubscriptBox["\[Mu]", "2"]}]]}]}], "}"}]], "Output",
 ImageSize->{152, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->42533674]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->22184],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->66768499],

Cell[TextData[{
 Cell[BoxData["MultiPoissonDistribution"], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  SubscriptBox["\[Mu]", "0"]], "InlineFormula"],
 " is not positive:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{
    RowBox[{"-", "3"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Mu]", "1"], ",", " ", 
      SubscriptBox["\[Mu]", "2"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95470147],

Cell[BoxData[
 RowBox[{
  RowBox[{"MultiPoissonDistribution", "::", "\<\"posparm\"\>"}], ":", 
  " ", "\<\"Parameter \\!\\(-3\\) is expected to be positive. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:MultivariateStatistics/ref/MultiPoissonDistribution\\\"\
, ButtonNote -> \
\\\"MultivariateStatistics`MultiPoissonDistribution::posparm\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellID->100237199],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{
    RowBox[{"-", "3"}], ",", 
    TagBox[
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Mu]", "1"], ",", 
       SubscriptBox["\[Mu]", "2"]}], "}"}],
     Short]}], "]"}], "]"}]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23885700]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["MultiPoissonDistribution"], "InlineFormula"],
 " is not defined when any of the elements of ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " is not positive:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->322608174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{
    SubscriptBox["\[Mu]", "0"], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"-", "2"}], ",", " ", 
      SubscriptBox["\[Mu]", "2"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->209078008],

Cell[BoxData[
 RowBox[{
  RowBox[{"MultiPoissonDistribution", "::", "\<\"meanvect\"\>"}], ":", 
  " ", "\<\"The parameter \\!\\({\\(\\(-2\\)\\), \[Mu]\\_2}\\) is expected to \
be a vector of positive values. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:MultivariateStatistics/ref/MultiPoissonDistribution\\\"\
, ButtonNote -> \\\"MultivariateStatistics`MultiPoissonDistribution::meanvect\
\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->293609543],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultiPoissonDistribution", "[", 
   RowBox[{
    SubscriptBox["\[Mu]", "0"], ",", 
    TagBox[
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "2"}], ",", 
       SubscriptBox["\[Mu]", "2"]}], "}"}],
     Short]}], "]"}], "]"}]], "Output",
 ImageSize->{305, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->358885388]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15418],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->126832575],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"MultiPoissonDistribution", "[", 
    RowBox[{
     SubscriptBox["\[Mu]", "0"], ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Mu]", "1"], ",", " ", 
       SubscriptBox["\[Mu]", "2"]}], "}"}]}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Mu]", "0"], "\[Rule]", 
     RowBox[{"-", "5"}]}], ",", 
    RowBox[{
     SubscriptBox["\[Mu]", "1"], "\[Rule]", 
     RowBox[{"1", "/", "2"}]}], ",", " ", 
    RowBox[{
     SubscriptBox["\[Mu]", "2"], "\[Rule]", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2647],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["9", "2"]}], ",", 
   RowBox[{
    RowBox[{"-", "5"}], "+", "\[ImaginaryI]"}]}], "}"}]], "Output",
 ImageSize->{84, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->761137441]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1684],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["PoissonDistribution",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/PoissonDistribution"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->10158]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22090],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->29713]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MultiPoissonDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 36.3688932}", "context" -> 
    "MultivariateStatistics`", 
    "keywords" -> {"multivariate Poisson distribution"}, "index" -> True, 
    "label" -> "Multivariate Statistics Package Symbol", "language" -> "en", 
    "paclet" -> "MultivariateStatistics Package", "status" -> "None", 
    "summary" -> 
    "MultiPoissonDistribution[\\[Mu]_0, \\[Mu]] represents a multivariate \
Poisson distribution with mean vector \\[Mu]_0 + \\[Mu].", "synonyms" -> {}, 
    "title" -> "MultiPoissonDistribution", "type" -> "Symbol", "uri" -> 
    "MultivariateStatistics/ref/MultiPoissonDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5019, 180, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->474632035]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 21586, 795}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1263, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1886, 60, 62, 1, 70, "ObjectName",
 CellID->21339],
Cell[1951, 63, 740, 24, 70, "Usage",
 CellID->19827]
}, Open  ]],
Cell[CellGroupData[{
Cell[2728, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3206, 109, 952, 32, 70, "Notes",
 CellID->612636944],
Cell[4161, 143, 298, 11, 70, "Notes",
 CellID->18566],
Cell[4462, 156, 520, 19, 70, "Notes",
 CellID->82602880]
}, Closed]],
Cell[CellGroupData[{
Cell[5019, 180, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->474632035],
Cell[CellGroupData[{
Cell[5404, 194, 148, 5, 70, "ExampleSection",
 CellID->109169607],
Cell[5555, 201, 147, 4, 70, "Input",
 CellID->354566591],
Cell[5705, 207, 223, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[5953, 216, 315, 10, 28, "Input",
 CellID->24173],
Cell[6271, 228, 364, 13, 36, "Output",
 CellID->431500513]
}, Open  ]],
Cell[6650, 244, 125, 3, 70, "ExampleDelimiter",
 CellID->246746483],
Cell[6778, 249, 148, 4, 70, "Input",
 CellID->1007134308],
Cell[6929, 255, 212, 5, 70, "ExampleText",
 CellID->472395019],
Cell[CellGroupData[{
Cell[7166, 264, 318, 10, 70, "Input",
 CellID->8902],
Cell[7487, 276, 364, 13, 36, "Output",
 CellID->359513120]
}, Open  ]],
Cell[7866, 292, 119, 3, 70, "ExampleDelimiter",
 CellID->675],
Cell[7988, 297, 147, 4, 70, "Input",
 CellID->299929388],
Cell[8138, 303, 204, 5, 70, "ExampleText",
 CellID->6303],
Cell[CellGroupData[{
Cell[8367, 312, 393, 13, 70, "Input",
 CellID->30324],
Cell[8763, 327, 1171, 39, 69, "Output",
 CellID->483602252]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9983, 372, 215, 7, 70, "ExampleSection",
 CellID->8552],
Cell[10201, 381, 147, 4, 70, "Input",
 CellID->535059345],
Cell[10351, 387, 273, 8, 70, "ExampleText",
 CellID->24449],
Cell[CellGroupData[{
Cell[10649, 399, 272, 9, 70, "Input",
 CellID->5765],
Cell[10924, 410, 884, 27, 54, "Output",
 CellID->389867754]
}, Open  ]],
Cell[11823, 440, 120, 3, 70, "ExampleDelimiter",
 CellID->3561],
Cell[11946, 445, 147, 4, 70, "Input",
 CellID->101071397],
Cell[CellGroupData[{
Cell[12118, 453, 318, 10, 70, "Input",
 CellID->6096],
Cell[12439, 465, 448, 17, 56, "Output",
 CellID->158177591]
}, Open  ]],
Cell[12902, 485, 120, 3, 70, "ExampleDelimiter",
 CellID->2948],
Cell[13025, 490, 146, 4, 70, "Input",
 CellID->32942996],
Cell[CellGroupData[{
Cell[13196, 498, 318, 10, 70, "Input",
 CellID->6916],
Cell[13517, 510, 469, 17, 53, "Output",
 CellID->42533674]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[14035, 533, 226, 7, 70, "ExampleSection",
 CellID->22184],
Cell[14264, 542, 146, 4, 70, "Input",
 CellID->66768499],
Cell[14413, 548, 358, 11, 70, "ExampleText",
 CellID->8964],
Cell[CellGroupData[{
Cell[14796, 563, 310, 10, 70, "Input",
 CellID->95470147],
Cell[15109, 575, 469, 10, 70, "Message",
 CellID->100237199],
Cell[15581, 587, 423, 15, 36, "Output",
 CellID->23885700]
}, Open  ]],
Cell[16019, 605, 383, 11, 70, "ExampleText",
 CellID->322608174],
Cell[CellGroupData[{
Cell[16427, 620, 311, 10, 70, "Input",
 CellID->209078008],
Cell[16741, 632, 517, 9, 70, "Message",
 CellID->293609543],
Cell[17261, 643, 424, 15, 36, "Output",
 CellID->358885388]
}, Open  ]],
Cell[17700, 661, 121, 3, 70, "ExampleDelimiter",
 CellID->15418],
Cell[17824, 666, 147, 4, 70, "Input",
 CellID->126832575],
Cell[17974, 672, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[18280, 684, 634, 21, 70, "Input",
 CellID->2647],
Cell[18917, 707, 301, 11, 51, "Output",
 CellID->761137441]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19279, 725, 310, 9, 70, "SeeAlsoSection",
 CellID->1684],
Cell[19592, 736, 218, 6, 70, "SeeAlso",
 CellID->10158]
}, Open  ]],
Cell[CellGroupData[{
Cell[19847, 747, 314, 9, 70, "TutorialsSection",
 CellID->22090],
Cell[20164, 758, 192, 5, 70, "Tutorials",
 CellID->29713]
}, Open  ]],
Cell[20371, 766, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

