(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     32155,       1180]
NotebookOptionsPosition[     25850,        959]
NotebookOutlinePosition[     27225,        997]
CellTagsIndexPosition[     27140,        992]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"BinomialDistribution" :> 
          Documentation`HelpLookup["paclet:ref/BinomialDistribution"], 
          "NegativeMultinomialDistribution" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/\
NegativeMultinomialDistribution"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"BinomialDistribution\"\>", 
       2->"\<\"NegativeMultinomialDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MultinomialDistribution", "ObjectName",
 CellID->24070],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MultinomialDistribution", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["p", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a multinomial distribution with ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " trials and probability vector ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32453]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability for a vector ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " of nonnegative integers ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["1", "TR"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["2", "TR"]]], "InlineFormula"],
 ", \[Ellipsis] ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["p", "TI"], "]"}]]], "InlineFormula"],
 " in a multinomial distribution is ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["n", "TI"], "!"}], 
   RowBox[{"\[Product]", 
    RowBox[{"(", 
     RowBox[{
      SuperscriptBox[
       SubscriptBox[
        StyleBox["p", "TI"], 
        StyleBox["i", "TI"]], 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]]], "/", 
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], "!"}]}], ")"}]}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->612636944],

Cell[TextData[{
 "The number of trials ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " can be any positive integer, and ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " can be any vector of nonnegative real numbers that sum to unity."
}], "Notes",
 CellID->20304],

Cell[TextData[{
 Cell[BoxData["MultinomialDistribution"], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["RandomInteger",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomInteger"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->82602880]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->673914067],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->612795811],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->127050494],

Cell["The mean of a multinomial distribution:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultinomialDistribution", "[", 
   RowBox[{"n", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "1"], ",", " ", 
      SubscriptBox["p", "2"], ",", " ", 
      SubscriptBox["p", "3"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"n", " ", 
    SubscriptBox["p", "1"]}], ",", 
   RowBox[{"n", " ", 
    SubscriptBox["p", "2"]}], ",", 
   RowBox[{"n", " ", 
    SubscriptBox["p", "3"]}]}], "}"}]], "Output",
 ImageSize->{108, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->489126194]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246746483],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->107004229],

Cell["The variances of each dimension:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->472395019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"MultinomialDistribution", "[", 
   RowBox[{"n", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "1"], ",", " ", 
      SubscriptBox["p", "2"], ",", " ", 
      SubscriptBox["p", "3"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SubscriptBox["p", "1"]}], ")"}], " ", 
    SubscriptBox["p", "1"]}], ",", 
   RowBox[{"n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SubscriptBox["p", "2"]}], ")"}], " ", 
    SubscriptBox["p", "2"]}], ",", 
   RowBox[{"n", " ", 
    RowBox[{"(", 
     RowBox[{"1", "-", 
      SubscriptBox["p", "3"]}], ")"}], " ", 
    SubscriptBox["p", "3"]}]}], "}"}]], "Output",
 ImageSize->{256, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->106447198]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->572933769],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultinomialDistribution", "[", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["p", "1"], ",", " ", 
       SubscriptBox["p", "2"], ",", " ", 
       SubscriptBox["p", "3"]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y", ",", 
     RowBox[{"n", "-", "x", "-", "y"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30324],

Cell[BoxData[
 RowBox[{
  RowBox[{"Multinomial", "[", 
   RowBox[{"x", ",", 
    RowBox[{"n", "-", "x", "-", "y"}], ",", "y"}], "]"}], " ", 
  SubsuperscriptBox["p", "1", "x"], " ", 
  SubsuperscriptBox["p", "2", "y"], " ", 
  SubsuperscriptBox["p", "3", 
   RowBox[{"n", "-", "x", "-", "y"}]]}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->290584324]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->19957],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->678581675],

Cell["\<\
Generate a set of pseudorandom vectors that follow a multinomial \
distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->24449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomInteger", "[", 
  RowBox[{
   RowBox[{"MultinomialDistribution", "[", 
    RowBox[{"20", ",", 
     RowBox[{"{", 
      RowBox[{".2", ",", ".3", ",", ".5"}], "}"}]}], "]"}], ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"6", ",", "5", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "7", ",", "9"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", "6", ",", "12"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "6", ",", "13"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1", ",", "5", ",", "14"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "7", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", "7", ",", "6"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5", ",", "7", ",", "8"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", "6", ",", "10"}], "}"}]}], "}"}]], "Output",
 ImageSize->{371, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->94474021]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3561],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->16433103],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"MultinomialDistribution", "[", 
   RowBox[{"n", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "1"], ",", " ", 
      SubscriptBox["p", "2"], ",", " ", 
      SubscriptBox["p", "3"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"1", "-", 
     RowBox[{"2", " ", 
      SubscriptBox["p", "1"]}]}], 
    SqrtBox[
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["p", "1"]}], ")"}], " ", 
      SubscriptBox["p", "1"]}]]], ",", 
   FractionBox[
    RowBox[{"1", "-", 
     RowBox[{"2", " ", 
      SubscriptBox["p", "2"]}]}], 
    SqrtBox[
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["p", "2"]}], ")"}], " ", 
      SubscriptBox["p", "2"]}]]], ",", 
   FractionBox[
    RowBox[{"1", "-", 
     RowBox[{"2", " ", 
      SubscriptBox["p", "3"]}]}], 
    SqrtBox[
     RowBox[{"n", " ", 
      RowBox[{"(", 
       RowBox[{"1", "-", 
        SubscriptBox["p", "3"]}], ")"}], " ", 
      SubscriptBox["p", "3"]}]]]}], "}"}]], "Output",
 ImageSize->{319, 35},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->554001119]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2948],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->35432017],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"MultinomialDistribution", "[", 
   RowBox[{"n", ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "1"], ",", " ", 
      SubscriptBox["p", "2"], ",", " ", 
      SubscriptBox["p", "3"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6916],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzlWElv00AUHjsxYRFJSUoBiSWRoEUg4AAoASFutCeuqNeoosuhUNIICVHw
T8tPC54tcj+/yTwvidJiKbHfvH2Zsd/7PBwffj0ejo/2ht2d0fDk8GjvtLv9
fZQs1QIhgr9CiO5dkTxPkyf1k1ec/PSjfnor/2sWOxWd5E+C9eQeJXdRU2QS
LRqA23bwRuYeAv4K4Hfm8IdGj4tf4jeUaW+A6jbAEcCUVfPoP3nko5U1j3yk
xyiifOT32Y9wR0Vp08ROq7cXJVtmtpXc60QG0LfIQde/gNoQdmlbV0q2FMls
1ShueGS2SC70k/LbzzW41BZxasPPpfdCsdxJDZE5fVYrYvMtS58XVEx4XO+W
YBmevDwudV4qzfKd0CtkJ11zoZHJt0tSv6/QgtXbhyibV03IdTMd2Qy2Z7D4
psM8UBZTfOhp5KD7cEn0XmXq7QAcktnoGm77JSgv1ICWNQme6wQP0ny8gLpu
MHRtsCL9EmDE3wf4S8X0D4jM+61+pZxO73jpPcraLUH1EKh6LLt+Avwb4DO2
FGnDmbn/YXFJWIJ4AhwAbDsqrLv9gnTaGtznyrrMmYzfxwfGwwZJjZ7s56JG
vwNNl+otrxGeRDMrJ5OJ2Um7amfFcWzo1ghfZ18cBfh8+uTuTtpr5UFARtv3
Xh0DjKf8qQdPx5J6L8/yk1ofmXWspB+OdbrCfD0u7jWEv7GkqtVMbf3KsXrC
0mN362tYb0/Pzztc8wyLX3PIyTsXucWQEwo6C2k85pL2fgDwOsBYf77cr+T8
JFMZGBufF3Ts7kzPZ56KuMTL74YyM4fHTD1lJylPUnIWqYecaWW47wFMdyS+
87ZJclXTx2xWYuEie78tVjSqmcmQ/YuXi7fTsBbmTxa4c4k6K4bV1EY1Fi9y
xvOUsGG1LUYbdO3Yb59Fnh922kO+N5zUGOH/67yoxkKbXT07ekRolm8cbidf
dHbyrKDesrOi54Qfy9DbckY7DWMXh1bYuV/e+cmLknqLzohwItNckt42GW3s
WVG7b/7Tr1gedg6+rPjkKVhNe2Q8bLejpHgnR/1CXAOz3s7FpWAFxDplwT+F
yoOK\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{382, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->497509865]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21588],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->68034751],

Cell["The probability density function sums to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->4348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Sum", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"MultinomialDistribution", "[", 
      RowBox[{"10", ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "3"}], ",", " ", 
         RowBox[{"1", "/", "6"}], ",", " ", 
         RowBox[{"1", "/", "2"}]}], "}"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y", ",", 
       RowBox[{"10", "-", "x", "-", "y"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16031],

Cell[BoxData["1"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19336638]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->504067836],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->267584673],

Cell["\<\
A bivariate multinomial distribution is a binomial distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->81489686],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultinomialDistribution", "[", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"1", "-", "p"}]}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"n", "-", "x"}]}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14093519],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}], 
   RowBox[{"n", "-", "x"}]], " ", 
  SuperscriptBox["p", "x"], " ", 
  RowBox[{"Multinomial", "[", 
   RowBox[{
    RowBox[{"n", "-", "x"}], ",", "x"}], "]"}]}]], "Output",
 ImageSize->{215, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->207942870]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"BinomialDistribution", "[", 
    RowBox[{"n", ",", "p"}], "]"}], ",", "x"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->148958097],

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "-", "p"}], ")"}], 
   RowBox[{"n", "-", "x"}]], " ", 
  SuperscriptBox["p", "x"], " ", 
  RowBox[{"Binomial", "[", 
   RowBox[{"n", ",", "x"}], "]"}]}]], "Output",
 ImageSize->{174, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->352920568]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullSimplify", "[", 
  RowBox[{"%", "==", "%%"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->564587024],

Cell[BoxData["True"], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->492219771]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->12955],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->117520568],

Cell[TextData[{
 Cell[BoxData["MultinomialDistribution"], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 " is not a positive integer:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultinomialDistribution", "[", 
   RowBox[{
    RowBox[{"-", "2"}], ",", 
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["p", "1"], ",", " ", 
      SubscriptBox["p", "2"], ",", 
      SubscriptBox["p", "3"], ",", 
      SubscriptBox["p", "4"]}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95470147],

Cell[BoxData[
 RowBox[{
  RowBox[{"MultinomialDistribution", "::", "\<\"posint\"\>"}], ":", 
  " ", "\<\"The parameter \\!\\(-2\\) describing the number of trials is \
expected to be a positive integer. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, \
ButtonData:>\\\"paclet:MultivariateStatistics/ref/MultinomialDistribution\\\",\
 ButtonNote -> \
\\\"MultivariateStatistics`MultinomialDistribution::posint\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellID->232771262],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultinomialDistribution", "[", 
   RowBox[{
    RowBox[{"-", "2"}], ",", 
    TagBox[
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["p", "1"], ",", 
       SubscriptBox["p", "2"], ",", 
       SubscriptBox["p", "3"], ",", 
       SubscriptBox["p", "4"]}], "}"}],
     Short]}], "]"}], "]"}]], "Output",
 ImageSize->{345, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->86587555]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["MultinomialDistribution"], "InlineFormula"],
 " is not defined when the elements of ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " do not sum to 1:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->322608174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultinomialDistribution", "[", 
   RowBox[{"n", ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"1", "/", "2"}], ",", "2"}], "}"}]}], "]"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->209078008],

Cell[BoxData[
 RowBox[{
  RowBox[{"MultinomialDistribution", "::", "\<\"probvect\"\>"}], ":", 
  " ", "\<\"The parameter \\!\\({1\\/2, 2}\\) is expected to be a vector of \
cell probabilities, each entry between 0 and 1, and all entries summing to \
unity. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:MultivariateStatistics/ref/MultinomialDistribution\\\",\
 ButtonNote -> \\\"MultivariateStatistics`MultinomialDistribution::probvect\\\
\"]\\)\"\>"}]], "Message", "MSG",
 CellID->6691823],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultinomialDistribution", "[", 
   RowBox[{"n", ",", 
    TagBox[
     RowBox[{"{", 
      RowBox[{
       FractionBox["1", "2"], ",", "2"}], "}"}],
     Short]}], "]"}], "]"}]], "Output",
 ImageSize->{283, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->138081482]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15418],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->18382224],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"MultinomialDistribution", "[", 
    RowBox[{"n", ",", 
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["p", "1"], ",", " ", 
       SubscriptBox["p", "2"], ",", 
       SubscriptBox["p", "3"]}], "}"}]}], "]"}], "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"n", "\[Rule]", 
     RowBox[{"-", "5"}]}], ",", 
    RowBox[{
     SubscriptBox["p", "1"], "\[Rule]", 
     RowBox[{"1", "/", "2"}]}], ",", " ", 
    RowBox[{
     SubscriptBox["p", "2"], "\[Rule]", "2"}], ",", 
    RowBox[{
     SubscriptBox["p", "3"], "\[Rule]", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2647],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"-", 
    FractionBox["5", "2"]}], ",", 
   RowBox[{"-", "10"}], ",", 
   RowBox[{
    RowBox[{"-", "5"}], " ", "\[ImaginaryI]"}]}], "}"}]], "Output",
 ImageSize->{107, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->506984670]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8734],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["BinomialDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/BinomialDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NegativeMultinomialDistribution",
    BaseStyle->"Link",
    ButtonData->
     "paclet:MultivariateStatistics/ref/NegativeMultinomialDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20344]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21003],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->9001]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MultinomialDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 34.8688548}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {"multinomial trials"}, "index" -> 
    True, "label" -> "Multivariate Statistics Package Symbol", "language" -> 
    "en", "paclet" -> "MultivariateStatistics Package", "status" -> "None", 
    "summary" -> 
    "MultinomialDistribution[n, p] represents a multinomial distribution with \
n trials and probability vector p.", "synonyms" -> {}, "title" -> 
    "MultinomialDistribution", "type" -> "Symbol", "uri" -> 
    "MultivariateStatistics/ref/MultinomialDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5287, 190, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->673914067]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 26997, 985}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1478, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2101, 64, 61, 1, 70, "ObjectName",
 CellID->24070],
Cell[2165, 67, 645, 20, 70, "Usage",
 CellID->32453]
}, Open  ]],
Cell[CellGroupData[{
Cell[2847, 92, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3325, 109, 1108, 44, 70, "Notes",
 CellID->612636944],
Cell[4436, 155, 292, 9, 70, "Notes",
 CellID->20304],
Cell[4731, 166, 519, 19, 70, "Notes",
 CellID->82602880]
}, Closed]],
Cell[CellGroupData[{
Cell[5287, 190, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->673914067],
Cell[CellGroupData[{
Cell[5672, 204, 148, 5, 70, "ExampleSection",
 CellID->612795811],
Cell[5823, 211, 147, 4, 70, "Input",
 CellID->127050494],
Cell[5973, 217, 214, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[6212, 226, 319, 10, 28, "Input",
 CellID->24173],
Cell[6534, 238, 358, 13, 36, "Output",
 CellID->489126194]
}, Open  ]],
Cell[6907, 254, 125, 3, 70, "ExampleDelimiter",
 CellID->246746483],
Cell[7035, 259, 147, 4, 70, "Input",
 CellID->107004229],
Cell[7185, 265, 212, 5, 70, "ExampleText",
 CellID->472395019],
Cell[CellGroupData[{
Cell[7422, 274, 322, 10, 70, "Input",
 CellID->8902],
Cell[7747, 286, 619, 22, 36, "Output",
 CellID->106447198]
}, Open  ]],
Cell[8381, 311, 119, 3, 70, "ExampleDelimiter",
 CellID->675],
Cell[8503, 316, 147, 4, 70, "Input",
 CellID->572933769],
Cell[8653, 322, 204, 5, 70, "ExampleText",
 CellID->6303],
Cell[CellGroupData[{
Cell[8882, 331, 443, 14, 70, "Input",
 CellID->30324],
Cell[9328, 347, 438, 13, 36, "Output",
 CellID->290584324]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9815, 366, 216, 7, 70, "ExampleSection",
 CellID->19957],
Cell[10034, 375, 147, 4, 70, "Input",
 CellID->678581675],
Cell[10184, 381, 264, 8, 70, "ExampleText",
 CellID->24449],
Cell[CellGroupData[{
Cell[10473, 393, 274, 9, 70, "Input",
 CellID->5765],
Cell[10750, 404, 879, 27, 54, "Output",
 CellID->94474021]
}, Open  ]],
Cell[11644, 434, 120, 3, 70, "ExampleDelimiter",
 CellID->3561],
Cell[11767, 439, 146, 4, 70, "Input",
 CellID->16433103],
Cell[CellGroupData[{
Cell[11938, 447, 322, 10, 70, "Input",
 CellID->6096],
Cell[12263, 459, 988, 37, 56, "Output",
 CellID->554001119]
}, Open  ]],
Cell[13266, 499, 120, 3, 70, "ExampleDelimiter",
 CellID->2948],
Cell[13389, 504, 146, 4, 70, "Input",
 CellID->35432017],
Cell[CellGroupData[{
Cell[13560, 512, 322, 10, 70, "Input",
 CellID->6916],
Cell[13885, 524, 1314, 26, 70, "Output",
 Evaluatable->False,
 CellID->497509865]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[15248, 556, 233, 7, 70, "ExampleSection",
 CellID->21588],
Cell[15484, 565, 146, 4, 70, "Input",
 CellID->68034751],
Cell[15633, 571, 222, 5, 70, "ExampleText",
 CellID->4348],
Cell[CellGroupData[{
Cell[15880, 580, 654, 20, 70, "Input",
 CellID->16031],
Cell[16537, 602, 157, 5, 36, "Output",
 CellID->19336638]
}, Open  ]],
Cell[16709, 610, 125, 3, 70, "ExampleDelimiter",
 CellID->504067836],
Cell[16837, 615, 147, 4, 70, "Input",
 CellID->267584673],
Cell[16987, 621, 251, 7, 70, "ExampleText",
 CellID->81489686],
Cell[CellGroupData[{
Cell[17263, 632, 353, 12, 70, "Input",
 CellID->14093519],
Cell[17619, 646, 399, 14, 36, "Output",
 CellID->207942870]
}, Open  ]],
Cell[CellGroupData[{
Cell[18055, 665, 195, 6, 70, "Input",
 CellID->148958097],
Cell[18253, 673, 371, 13, 36, "Output",
 CellID->352920568]
}, Open  ]],
Cell[CellGroupData[{
Cell[18661, 691, 133, 4, 70, "Input",
 CellID->564587024],
Cell[18797, 697, 161, 5, 36, "Output",
 CellID->492219771]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[19007, 708, 226, 7, 70, "ExampleSection",
 CellID->12955],
Cell[19236, 717, 147, 4, 70, "Input",
 CellID->117520568],
Cell[19386, 723, 360, 11, 70, "ExampleText",
 CellID->8964],
Cell[CellGroupData[{
Cell[19771, 738, 373, 12, 70, "Input",
 CellID->95470147],
Cell[20147, 752, 512, 11, 70, "Message",
 CellID->232771262],
Cell[20662, 765, 488, 17, 36, "Output",
 CellID->86587555]
}, Open  ]],
Cell[21165, 785, 371, 11, 70, "ExampleText",
 CellID->322608174],
Cell[CellGroupData[{
Cell[21561, 800, 252, 8, 70, "Input",
 CellID->209078008],
Cell[21816, 810, 562, 10, 70, "Message",
 CellID->6691823],
Cell[22381, 822, 367, 13, 51, "Output",
 CellID->138081482]
}, Open  ]],
Cell[22763, 838, 121, 3, 70, "ExampleDelimiter",
 CellID->15418],
Cell[22887, 843, 146, 4, 70, "Input",
 CellID->18382224],
Cell[23036, 849, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[23342, 861, 662, 22, 70, "Input",
 CellID->2647],
Cell[24007, 885, 332, 12, 51, "Output",
 CellID->506984670]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[24400, 904, 310, 9, 70, "SeeAlsoSection",
 CellID->8734],
Cell[24713, 915, 550, 18, 70, "SeeAlso",
 CellID->20344]
}, Open  ]],
Cell[CellGroupData[{
Cell[25300, 938, 314, 9, 70, "TutorialsSection",
 CellID->21003],
Cell[25617, 949, 191, 5, 70, "Tutorials",
 CellID->9001]
}, Open  ]],
Cell[25823, 957, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

