(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    106718,       2496]
NotebookOptionsPosition[    100213,       2269]
NotebookOutlinePosition[    101720,       2310]
CellTagsIndexPosition[    101633,       2305]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NormalDistribution" :> 
          Documentation`HelpLookup["paclet:ref/NormalDistribution"], 
          "MultivariateTDistribution" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultivariateTDistribution"], 
          "QuadraticFormDistribution" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/QuadraticFormDistribution"], 
          "HotellingTSquareDistribution" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/HotellingTSquareDistribution"], 
          "WishartDistribution" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/WishartDistribution"]}, #, 2]& ,
         Evaluator -> Automatic], {1->"\<\"NormalDistribution\"\>", 
       2->"\<\"MultivariateTDistribution\"\>", 
       3->"\<\"QuadraticFormDistribution\"\>", 
       4->"\<\"HotellingTSquareDistribution\"\>", 
       5->"\<\"WishartDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MultinormalDistribution", "ObjectName",
 CellID->26035],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MultinormalDistribution", "[", 
       RowBox[{
        StyleBox["\[Mu]", "TR"], ",", 
        StyleBox["\[CapitalSigma]", "TR"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a multivariate normal (Gaussian) \
distribution with mean vector ",
     Cell[BoxData[
      StyleBox["\[Mu]", "TR"]], "InlineFormula"],
     " and covariance matrix ",
     Cell[BoxData[
      StyleBox["\[CapitalSigma]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->7878]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for vector ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a multivariate normal distribution is proportional to ",
 Cell[BoxData[
  SuperscriptBox["\[ExponentialE]", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        StyleBox["x", "TI"], "-", 
        StyleBox["\[Mu]", "TR"]}], ")"}], ".", 
      SuperscriptBox[
       StyleBox["\[CapitalSigma]", "TR"], 
       RowBox[{"-", "1"}]], ".", 
      RowBox[{"(", 
       RowBox[{
        StyleBox["x", "TI"], "-", 
        StyleBox["\[Mu]", "TR"]}], ")"}]}]}], "/", "2"}]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->8428],

Cell[TextData[{
 "The mean ",
 Cell[BoxData[
  StyleBox["\[Mu]", "TR"]], "InlineFormula"],
 " can be any vector of real numbers, and ",
 Cell[BoxData[
  StyleBox["\[CapitalSigma]", "TR"]], "InlineFormula"],
 " can be any symmetric positive definite ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], "\[Times]", 
   StyleBox["p", "TI"]}]], "InlineFormula"],
 " matrix with ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], "=", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["\[Mu]", "TR"], "]"}]}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->149538583],

Cell[TextData[{
 Cell[BoxData["MultinormalDistribution"], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1355]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->408056504],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->156352354],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->81224717],

Cell[TextData[{
 "The mean of a bivariate normal distribution with correlation ",
 Cell[BoxData[
  StyleBox["\[Rho]", "TR"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Mu]", "1"], ",", 
      SubscriptBox["\[Mu]", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox[
         SubscriptBox["\[Sigma]", "11"], "2"], ",", 
        RowBox[{"\[Rho]", "*", 
         SubscriptBox["\[Sigma]", "11"], "*", 
         SubscriptBox["\[Sigma]", "22"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Rho]", "*", 
         SubscriptBox["\[Sigma]", "11"], "*", 
         SubscriptBox["\[Sigma]", "22"]}], ",", 
        SuperscriptBox[
         SubscriptBox["\[Sigma]", "22"], "2"]}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubscriptBox["\[Mu]", "1"], ",", 
   SubscriptBox["\[Mu]", "2"]}], "}"}]], "Output",
 ImageSize->{55, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->416421874]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246746483],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->212054166],

Cell["The variances of each dimension:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->472395019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      SubscriptBox["\[Mu]", "1"], ",", 
      SubscriptBox["\[Mu]", "2"]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{
        SuperscriptBox[
         SubscriptBox["\[Sigma]", "11"], "2"], ",", 
        RowBox[{"\[Rho]", "*", 
         SubscriptBox["\[Sigma]", "11"], "*", 
         SubscriptBox["\[Sigma]", "22"]}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"\[Rho]", "*", 
         SubscriptBox["\[Sigma]", "11"], "*", 
         SubscriptBox["\[Sigma]", "22"]}], ",", 
        SuperscriptBox[
         SubscriptBox["\[Sigma]", "22"], "2"]}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   SubsuperscriptBox["\[Sigma]", "11", "2"], ",", 
   SubsuperscriptBox["\[Sigma]", "22", "2"]}], "}"}]], "Output",
 ImageSize->{65, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->21576294]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->135497143],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultinormalDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Mu]", "1"], ",", 
       SubscriptBox["\[Mu]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["\[Sigma]", "11"], "2"], ",", 
         RowBox[{"\[Rho]", "*", 
          SubscriptBox["\[Sigma]", "11"], "*", 
          SubscriptBox["\[Sigma]", "22"]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Rho]", "*", 
          SubscriptBox["\[Sigma]", "11"], "*", 
          SubscriptBox["\[Sigma]", "22"]}], ",", 
         SuperscriptBox[
          SubscriptBox["\[Sigma]", "22"], "2"]}], "}"}]}], "}"}]}], "]"}], 
   ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30324],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{488, 63},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->440539547]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"MultinormalDistribution", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "4"}], ",", "4"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2"}], ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20649],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 142},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->3125200]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->529],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->791735966],

Cell["\<\
Generate a set of pseudorandom vectors that follow a trivariate normal \
distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->24449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"MultinormalDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"2", ",", 
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "3"}], ",", "0", ",", 
         RowBox[{"2", "/", "3"}]}], "}"}]}], "}"}]}], "]"}], ",", "10"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
    "0.35497086743858464`", ",", "3.780273835693341`", ",", 
     "3.0679357298773233`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.3570804990183729`", ",", "2.5778887560466286`", ",", 
     "3.9937240480983123`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.6854365491117163`", ",", "2.636153984316124`", ",", 
     "3.4845417114306203`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.48891534865744424`", ",", "1.4838868219144503`", ",", 
     "3.4049169412428455`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.2837480133714552`"}], ",", "3.188968124463586`", ",", 
     "3.635953731364229`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.19411688931257`"}], ",", "1.2813247690002463`", ",", 
     "5.957880882262536`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "4.1325906958098795`", ",", "2.2337283026741144`", ",", 
     "3.4397245062717303`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.34331114654435324`"}], ",", "1.336635557353473`", ",", 
     "3.5390082148943702`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "1.1801219835574952`", ",", "4.0140098598929965`", ",", 
     "2.9773531212056152`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "2.3473692674963265`", ",", "3.8630251885781024`", ",", 
     "3.398210656819759`"}], "}"}]}], "}"}]], "Output",
 ImageSize->{412, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->734388353]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3561],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->437021843],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->158812855]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2948],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->12922356],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"0", ",", "0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6916],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"3", ",", "3"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->88266525]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13452],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->219181136],

Cell["\<\
Equal probability contours for a bivariate normal distribution:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->2750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"MultinormalDistribution", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19414],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyFfXdYlUfzNiDEFktM7Bp7LFFjjCWWZI8mFtQYWyKxK2KJir13o7FgNHZj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   "], {{{}, 
     {RGBColor[0.3609173543952161, 0.17477102553986373`, 0.624293319444474], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxVmGmwlmUZx5/nfZbDInCQw2EREELUA7g0WbIeUEBAtLHMRmuaZsiZShxp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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUtsVVUUhs+5e+9zbIsUhEsBH1BQE8QHxoTwUBKkpiBUtEVHGhOYGEFK
glIgYcCEUMDXwAEPoy2I0aiJBmJUhLa3JPJSBhoh4WU00YlRQUEjUr8/P4OV
u/79r732unuv9Z/mpZ3tKytZlq3DIvZ1kWVP4LTivxyy7Dh4AXg6uBt8Z5ll
k7AjeZadArfjD8LPga/y+xfxl7FdcMtZW8RaGzFXg2P2wr2LPQU+T46JcDuI
eQX8HXYUrsracfxN2I3gEVg/Rc4hfiZcD/g0/i/wbez9BvwqfgdrL+CvZW0U
eDS2iPiGlGWPw/0DHoDvgd+Ovw6bCncXNo3a5hIzPzmH9tZz5in83cS/Cd6J
TYHvBn9C/AHi10fXoLN/xjrhq9gbqpX9C/AfxWq57/AC+c5gU8A95NsF14dt
IPZf+Hn4ddQ8AFewVoJvLl2LcizBz1h7AH8c564g11vga5n/cwf+bcR8i1+t
+O5PEFfkfoOTxPfpTnPf2RH8YXpD/I3YO+A92Dn4DvBCuBr7h8h/Jbj2c9jb
wf/hSc4bif0AbuK8Y3CvRffK5uC36sXagt/sOWKXR+e+n/jT+HeU7qUx4Gn4
zyT3zgXWnsa/m7Uz+M3wiVwBm02uT8FD0Xeiu9jDnkdK95h66zf2HFJ94IGK
73g8fEp+uzrwWHAT9kHmnvud2IvYPvwX1Q9wf5P7PfxLrDXCrQGvCu5J5e4C
/5T7jOHgg9G92ofdyv7m0r39Ffgs/BB2IPgOx1FLK/xF9Rc1/MreltK1zyLf
+9FvpLfpDZ6927Hvg2ewQbmIeQj/EHYD+HPwg/gHsbXkf0l9Qvxc8jWyd3jp
s/Tmx9S/xAzmnhHVtjK5d1VjE3gM9h/xLfAn8LdHa8M29ZhmBbuq3oXfBldL
jlVPbgH3gx/OHfNn4TvW3e4Pnq0ZpWdZM1Zf+j/rv9bUE+ydV/ou1JOj2HtT
4VlRzg/xG0rH7s09O+cLz5ZmaCu5BpJr03/4o3BPqZf0xt3gzYVnX29YgRtN
jt1w+8ABHLFZuWe+N1oTpAXSuHq4W4jfEnyHE0q/ud5aM6jZuE81Bc/IwmhN
khZJY9Vbq5PPUo8tBQ+Sfz18F3y7+jt5to7C78DfmfyWP4LX4Hcl++rhRvx7
S8/SSdYew38+Ote14FpGJM+WapIW9KuHgzVhcmkNkXaox6QdE5K1TRoyP1oT
pAXSzHvwp5Y+SzP6UeE30Vs8C14Mt/r6bMZobVRNqkUaeTj6G1K9rjG1whot
bdYdbIi+A/131fh6tMZIW3TnefIZyq03+jj6G6Jvh95Q3xb1rHpV3xhp/6XC
vadvgGYjFtYSzcgKzTY5Z1f8jdJsjk+efc2otLclWZulwdKC1mQtkSZ8CR5W
ePY1k8uiNU9aJw38TFpceDalYV+A6wrPrmZWZ3dG351q+B9XpPPu
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4959477755625611, 0.40955246095889924`, 0.8140949114316224], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmHuwV1UVx3/nnH3OQUARFEEEAR+BPARBER9XnZHHhQsYpDmNSKJgZgqk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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlneMVWUQxd+7797vAgu7SttlqXa6YAQ0CJJQF5ZVNiIxQaSIGEAWBQUV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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6131970419166699, 0.6068992098011899, 0.9106243660185815], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1WHds1VUUfu/d8YAwLBgKgiCgEbAqFNFYigyhCBohbJswtTKMyBTCEKFA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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlnmwV2MYx8/v/M55fzGVSWYq0spo1SZGi4qKYpTSIqONVlOSUlSj7YbU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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7124756464188814, 0.7664123026707163, 0.9128876124189509], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFV21M11UU/r3d+9+iD8L44BcWFGRl6hLaWKYo1ejNlCCFijCwLDYpCi2T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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVtsVlUQhc/Z/9m7ifiAhlciJcV6AwLUhIjQi3cjUhShlTQlBRVJrKIF
L0VuNSESrdByiSAkhgSj0MrFy4PPolGjQLFUIFGCD1IqAiIG6YPfyuJh/n+t
mdn7zJ49M7u85cUnWkOWZR1IgbTzM5iyrKeUZfXwB8GPIhdwejvPsu3Y55Zl
2Z383wyfxf+qmGUPYX8S/9PgX5EtrN+G7ij4MNINfw++G3wH+50EL0Fq4Qfh
C7F3sf5N+O3wX7DNZ/854HnIVfg2+Hrs0+Fn4a3wPvgHxLCJ9RvQRWJLSK7v
sV8Tvpexh5J1tdjqkHHgldiPY5uGzx+sbWa/cvBhdEfhR5AW+CJkBP57sF/m
e/8gy7FtzJyLCsWYOycHsO3lfw/2NuQz+CHsK0pesxJ+DPuJ4JzNBb+DbjZ4
EfuNBfehG4APsufjrJ2FXIS/Dp8P/hppL3n/GsWDfwEvKSZ4LfZz4DX4n8PW
CB+Gd8JvA29Ftz44x1XEfzcyhvWtfP8CtvPssQvbNcWH/yC6quA7eAp+vvBd
TIV/ge+X8odXIvuwv4S9M3MOPoG/UDhXTfCZ8MeSc68zLcZ2hfUfg+uJ4RFs
Z9BVBNfcRXADuv+Cz3AAPJJ4D5VcMzXw0/iMCT7zK/CXk+9SOe0Ar00+u+68
E/wu0ghfh30ruKlw7ufB2+FvJOdaOdHdHSS+ZcF3eC98AP9RwTV4CrwO+8zg
GroPex2ylPWNwblbBa8oOYcbwKfUH+Cp6B5O7jH11l/oVis36o/ca5SLV+G3
lJyTZvVasm8l0o39G3QN+N+QO7Y27KNLjrEe24rCtTQyOFbFoG8r5knwyapR
9Ro5WAvuQG4K1i1TvuA/5t7zaXAz+9WBRwfn/n58/gy+gwfA3fi8lVs3HbwU
nwXggNRF97x6XTWzBdsP0b1+I/Ia65cjfbnPXF3mM+usQ/AJ0WfSWa7krg3V
rGpVNfJ+cg+o9hXjKPCUMs8i7VkePeM029SzXfJPniU6s3ppc3Stqqc0O2ZE
x64ZMgA+rhywfiO6HazdiXwYfOZBbGeRNuwarL+Dz0T31nb4WHy7Ct+VZsz3
2DYXPrtq8lv4JviI3He6G7w/utfVk+pdzVDNTvXwTvhH17lq6iT4RPQslm4I
3IOU547xX/Dn0b2qntsF/i66F/TNn8H90bN0NntMId6q5Nh15hng6uReUY0v
0CxIrnWdWd/q1Z0Hf3M19r3RudAb8xX4mnzgE7D/Db4UbVOP9Se/MXpb9GZU
wm9NjqU/eDaOS8aakc+DFyfv1YuMB9+VXMt6YzRrJ0bXimbus9ieQcbDe5Dn
NFsKY8U0CT6E7OPbvwXP2o7Cb4lm7kK9jTpT8JuwH74Emcj6lpJrvTp6Fqvm
1TudyJzgHmoo3EPqHen0Vk5O/pbeTL1lx6JrS29az/U3Rfevb2o21JS5FzQj
7sE2DdmRe+Ze0v7Js1m6T+HD0blRjD8VfuP0tumN11mPRL/NOnMv9qvRb51y
tKbwjNZs1p1q9g4XPqtm8P/DFBQV
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8067470133746156, 0.8617095149476302, 0.8942670655419712], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1VktvVVUUPvecvXdnDiiatJhGhF7KpA6gXNHwsJ0wAAo1EqiFEAVbYrVR
ZoheUwZAIIFUG4y52ktNbGucEP0BTnTkjPKuA4P4gNLy6gASq9/n9znYWWvv
vfZ6fmuds/yNoZ538yzLfsAqsJZg8yyYn0tZ9l3Msp9SlpXB3wc/BX4M/Nvg
D2BVIX8K+zLeDIE/BH4pVg/4J5TDehrrl5BluyHfDLlh7J/DOgyZedA9sDUO
2oa7Nbn03cVqB18FHQHtB20sad+S6+1q0C6sGdqH7taod/tBbwXpo45l1vMO
zr5JssezzlwxLpYU+JegQzgbsX99kN8FXW/iugI6mSRzFOc7omIcLClflKmB
r+TKyXuQ2QCZs+Af5soP4zqG8x+h559cul8Lelu3Hytpt6TcMW+M+7Fzyjjn
StJftyz1r4Ketqi7Ceibj7qjr7SzAvRPnO0LylsNZ+cQbxPzXCiP1M2cbC6U
K8a1HftnQPfi3bmkO+ar2fFW/I7+9IE/D77VWJguCQ+/F7LH/TR8qAXVsR30
V5wPlPRu3m83QuZRUHybYHMj1u1cGFhXKB+bovJ71hirFMLZTeOEuarifgpy
w8R1odzW7dvyQv78gfujSX4yX2POJ/1hPHw7wxom5YPYXx8lt8TY+T8P5UK5
YBzjjmUY8seS7opCd9T9KXR8lWSj7DPaYp99H3XWY9zSxltB8VCG2CxbvtW2
6DNztjcpxt2g94Pw2A27E8Y0MU48EBfE8r0onvltcY88yvWONb0XpIv7RdAd
Sfefg+7HXRf0nYSOE1FYYe+uNs6rOOuGzJZcdWa9ibfGIJ51/xYyHwf1XJvf
sRZHoP+DpDqxD0cc7wT9DcLkAnHCnsS766A3sEbBT4J+EdQ77IlB9wXtfZIL
e1dwdjVqT9yMGufs6Xb3NX1i7mibWGmyb33uS8pMGvOsxx74eycYC+BXYV0B
/2pSvfs89+q5YmJenrjXa847+5Q5rVuWfd9rPLdCz8Wg/a0o7NIf9sRjzwnO
s2Zj5jjuZ4JwO4e361gzz8wHzjXPeoPOX4D8dJA/3TjfnjS3UkOWxQb10GdJ
c5YzljNmMqhv+t171PMXzm9HxTDgmc3zrXi7Lcn2waB5xFk05l4hhjnL5zzn
FiCzOQrfHbC/tkGzZC10rEnC1CxkdoJf8DzjWZPz1esavcw6BPUrv1d/J2H7
MvhLUXPlGuj1oG8X67DgWrS4Dv/NTNxfjIrnRejoSIp5fRLmiIkpyPQkxUOM
NxrzHyZ9k4jx98EfTvq+LnpGM4cXCuGRORuNin/c/TLgHNLHlVF+rgCtJMXK
78nr/qY8wPnDqJ5nTw56RnGGERODnpejxj7jmHcsp3G/K2j2EPM155P4IpZ7
Xc9++8OYDznPN/DupSSd7JkJzzZipeocduK+C2vWvi0r1Hc3Yfe3KHvE+PNR
tlhP5oXxE5sfReHzAujXQTXqBC5eadB3jPWadc3mouYXe+spfi+S7PEf5Iz/
Q9i/nMvs4Y6oGOj/vwWJH8I=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlMlvjlEUxt/v63vvt7NQJIYIqsWmFm21JaZ2I0FLDYlqm5aoiKGhK/NQ
C0JCKk1FTCG0ho3wB/gD7Aw1lKBITDV2QaL8njwW583znOHe8557zpm8rq1u
WzZJkhYkRVbwKQlJ8iuTJLPykuQNfFdMksngIhwPwDcitfA2+CZ838FngEuQ
l+Aq/D+BJyIr4U/x6QKXE/MBfAOZxPkX0dXhuwJpABeiu4r/IPaz4ALkPvgR
0ok9H/429Z26azqyE/wc3ThwFbI8Rz7oxuKbnzq3XfDqrHNsAS/hvu//eT/2
OfCR4C3ErMHeiG4BuY5HdwFchm4ztjHIXPA85CL4JPV6kToH3S3/PvgOzpuQ
5zM/wg/Bi+Dl8J/4NsHz4L3wc9ifoNvEeaMzrs3N4NqqRs3Y3wfXqpqYBeD5
wXdfwl6f+p/1r83oWoNzUi7F+ifljuzHNoj/F+4ejPYdwF6BrQGecPYw9pCz
Tvguuq/gHs6bCj+PVMKvpX6rC8gfYoeRn1nfMQX7Hux14Hrsj+EPgt/uFD69
2L4Fx+rM1+BS4l9h6+a+fcoVWQRvwN6O7Rj8XsY1PU98f/Bb6T32YN8b3Qtt
3DkVWwEyKuOalmOriP5X6aaBC6Nz60N3UvWEf1D+6AqDa6jafYYf5r6tyBru
/gIvDe5p9fJv+CrwUXQ1+K/n/kbOijnXTj3Sie1M9Nsdgr8J/mf961limog/
HX1XO/E10TOnWfuBlHLWQLDvO2K+KZfoXtKMbI/uUdViPPY7+A4F91ZRxrNc
FP2vmukryj34LTVfP8C3g317su5N/bP+VT2q3uiA/826Rx4G7wjtBs3kvOiZ
16yrhrPhldG9rJnRrvgefLZ2xgn1W+paaWZL9O/IrTz3wOrUM6j+rct6dqcF
965muDb1G6j26hHF9gX3ls64DG/VzCXeKdoFb4N7QzvhOnhD6lprvq4F64QV
s5j42ujaH0O3PLpmqtWQ9g28LOe3eIBuaXSMfLVTFua8Y7RbPuNzHVtX8Kyq
hw7Cq3K29aPriNYJa0ccwXdE8Fuqp56pdsHvqx26VrUKzkdv0h3dw+pd7axl
2r2pc9VM7o7OWblqh1dH96R6UTu6GDwzeNY0s5q148G118z9A+Q7whI=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.895905938362459, 0.8914416407073892, 0.8543239470456391], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlL1PVFEQxd+7u29tiDVgssTvRDBIoYid/4AKBjVqTCCRRJYVtXN3Idhp
QcCEgkYpBBVLW/8Eajex0MLAWmj8aGwQ9fwyp5jcue/OnXvmzJl3cHJ27G7K
suyRrCR7n2dZr+ye/MFylp2STch/qm//8og7XmRZA9P+o84fyp+Vvyl/pIg4
cnCfPBtaRytZtpdHvuk8cm5prcsm5dcEoktnB7Rfl78hW8hiP2gM1wTwZQoM
8777QP5Z5R6W7eismUcecr4Rlk3ZjL6v6dt9xezqvCP/jvHXOJedUcxAinUx
D2zdKd7grR77rCf8zpcU+XirrbVf+5bWP7KTKe4teV+VXS0FB9TF/W951Ad/
n8rBIeuU+VzOAxM5+XbU318p5mcRHP1OwTf9oXfPU3D/WetKCt7g45g5uSwO
xipxjzrA0DS+efP5RLnHFX9R5zvyO7JnKXoOd/AGfzv2qbXH9Z5XjWv0Lg+s
C84JPy3rCh7n/P0vupC9071OCpw117zo+FWdbbuur66NuoinB9RVT8FBH7wq
x6VK8Fe1nuC8zzyhnxGdn6tEDjS1bl213DPib6ToHXvw0Qty7rk3C66laQ2A
vWM808YKTjiAE95Hi3X76IU3yH+oFL2jhw33ktqZF/Tf6/ljBsD5S/y/Lgd2
+tu0lj7Qq3L0nn3becgNj+RZVd23ytGr8RQ42u5Vn/uy7H5RI/0f3Rca+K67
P2RvSxELFuIHPDct67ptPKuui7vkuF4Of9CzDrYez1PdszLvvs1ZQ+Qf8r8I
/NuuhTz7he1xEfPKPDBjYD5dxMzveo6vpMiHptkTP6c6WpXgnp5cKIU+eGfI
/ylqGTc/aKTqmm+X4/8yY812Wbc1807fV7yfMH5wk5P/FNqYtraq5nlKMS8q
gYPYIddbNQe82+066p6Phjm8qdilIupEazPW2GF9O1LEe+Skb7wLL1vWbb81
SO+Gi/hfo/H/CAjAyg==
         "],
         VertexColors->None], 
        PolygonBox[{{1511, 1509, 669, 670}, {1109, 1366, 536, 591}, {1124, 
         1334, 508, 603}, {1253, 1376, 469, 378}, {1616, 1790, 955, 400}, {
         1114, 1590, 740, 669}, {1151, 1126, 846, 621}, {1376, 1661, 802, 
         469}, {1318, 1688, 833, 384}, {1449, 1151, 621, 620}, {1181, 1448, 
         619, 660}, {1192, 1519, 676, 678}, {1115, 1379, 555, 597}, {1617, 
         1260, 400, 509}, {1589, 1592, 741, 362}, {1388, 1320, 397, 566}, {
         1380, 1387, 566, 556}, {1379, 1124, 603, 555}, {1150, 1115, 597, 
         492}, {1448, 1593, 742, 619}, {1512, 1125, 620, 671}, {1416, 1417, 
         591, 459}, {1378, 1150, 492, 554}, {1366, 1116, 598, 536}, {1368, 
         1245, 367, 381}, {1316, 1242, 738, 491}, {1775, 1589, 362, 946}, {
         1594, 1243, 743, 742}, {1367, 1378, 554, 537}, {1519, 1191, 677, 
         676}, {1699, 1428, 401, 846}, {1520, 1704, 855, 677}, {1337, 1705, 
         856, 511}, {1705, 1521, 678, 856}, {1428, 1619, 758, 401}, {1118, 
         1512, 671, 833}, {1660, 1511, 670, 802}, {1789, 1380, 556, 955}, {
         1704, 1335, 509, 855}, {1618, 1193, 511, 758}, {1317, 1318, 384, 
         367}, {1334, 1381, 557, 508}, {1381, 1367, 537, 557}, {1242, 1497, 
         660, 738}, {1649, 1294, 459, 507}, {1590, 1774, 946, 740}, {1320, 
         1319, 378, 397}, {1243, 1333, 507, 743}, {1591, 1315, 491, 741}, {
         1423, 1368, 381, 598}},
         VertexColors->None]}]}, 
     {RGBColor[0.9411759999999999, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[
       PolygonBox[{{1115, 1150, 113}, {1379, 1115, 113}, {1378, 1367, 113}, {
        1334, 1124, 113}, {1124, 1379, 113}, {1150, 1378, 113}, {1381, 1334, 
        113}, {1367, 1381, 113}},
        VertexColors->None]]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1150, 1115, 1379, 1124, 1334, 1381, 1367, 1378, 1150}],
        "0.12`"],
       Annotation[#, 0.12, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1873, 1510, 1509, 1511, 1660, 1661, 1376, 1253, 1385, 1254, 
         1402, 1319, 1320, 1388, 1387, 1380, 1789, 1790, 1616, 1260, 1617, 
         1189, 1335, 1704, 1520, 1191, 1519, 1192, 1521, 1705, 1337, 1193, 
         1618, 1619, 1428, 1699, 1126, 1151, 1449, 1450, 1125, 1512, 1118, 
         1688, 1318, 1317, 1382, 1246, 1401, 1245, 1368, 1423, 1116, 1366, 
         1109, 1417, 1416, 1294, 1649, 1183, 1333, 1243, 1594, 1593, 1448, 
         1181, 1497, 1242, 1316, 1315, 1591, 1592, 1589, 1775, 1774, 1590, 
         1114, 1873}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1500, 1182, 1447, 1499, 1498, 1108, 1332, 1103, 1407, 1406, 
         1236, 1327, 1326, 1360, 1148, 1314, 1235, 1573, 1575, 1574, 1331, 
         1107, 1493, 1494, 1491, 1180, 1492, 1496, 1495, 1773, 1587, 1588, 
         1506, 1508, 1507, 1844, 1845, 1657, 1659, 1658, 1252, 1614, 1615, 
         1611, 1613, 1612, 1377, 1857, 1858, 1665, 1667, 1666, 1259, 1625, 
         1265, 1624, 1264, 1518, 1190, 1457, 1627, 1733, 1155, 1628, 1336, 
         1797, 1798, 1629, 1268, 1342, 1341, 1137, 1343, 1344, 1269, 1429, 
         1706, 1133, 1156, 1630, 1524, 1525, 1460, 1734, 1459, 1523, 1522, 
         1127, 1152, 1452, 1451, 1514, 1513, 1120, 1690, 1426, 1603, 1602, 
         1248, 1598, 1599, 1424, 1687, 1117, 1369, 1110, 1420, 1419, 1651, 
         1650, 1239, 1595, 1244, 1415, 1680, 1500}],
        "0.08`"],
       Annotation[#, 0.08, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1479, 1171, 1441, 1170, 1570, 1232, 1569, 1231, 1770, 1147, 
         1313, 1234, 1571, 1233, 1572, 1878, 1179, 1750, 1488, 1490, 1489, 
         1772, 1585, 1586, 1503, 1505, 1504, 1843, 1300, 1654, 1656, 1655, 
         1251, 1609, 1610, 1606, 1608, 1607, 1375, 1855, 1856, 1662, 1664, 
         1663, 1258, 1622, 1623, 1620, 1262, 1621, 1389, 1626, 1266, 1431, 
         1267, 1339, 1338, 1136, 1712, 1528, 1196, 1458, 1197, 1635, 1636, 
         1634, 1273, 1529, 1198, 1465, 1637, 1638, 1274, 1639, 1530, 1531, 
         1467, 1640, 1641, 1275, 1532, 1199, 1469, 1642, 1713, 1875, 1276, 
         1808, 1714, 1715, 1345, 1346, 1270, 1430, 1707, 1463, 1462, 1461, 
         1527, 1526, 1128, 1153, 1454, 1453, 1516, 1515, 1694, 1693, 1427, 
         1605, 1604, 1249, 1600, 1601, 1425, 1689, 1119, 1370, 1112, 1422, 
         1421, 1653, 1652, 1240, 1596, 1597, 1418, 1681, 1682, 1361, 1411, 
         1410, 1409, 1292, 1330, 1329, 1580, 1581, 1579, 1578, 1446, 1175, 
         1576, 1577, 1405, 1679, 1484, 1174, 1445, 1173, 1483, 1677, 1678, 
         1481, 1727, 1482, 1443, 1172, 1480, 1676, 1479}],
        "0.06`"],
       Annotation[#, 0.06, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1765, 1674, 1675, 1102, 1325, 1762, 1763, 1761, 1223, 1310, 
         1145, 1560, 1222, 1476, 1165, 1440, 1561, 1562, 1224, 1477, 1166, 
         1442, 1563, 1564, 1225, 1478, 1167, 1444, 1565, 1566, 1568, 1567, 
         1355, 1356, 1226, 1403, 1404, 1098, 1328, 1104, 1486, 1487, 1485, 
         1176, 1582, 1238, 1408, 1237, 1359, 1228, 1648, 1293, 1412, 1413, 
         1414, 1362, 1111, 1684, 1683, 1832, 1831, 1247, 1833, 1834, 1685, 
         1686, 1113, 1371, 1121, 1692, 1691, 1847, 1846, 1255, 1783, 1256, 
         1695, 1696, 1517, 1188, 1455, 1456, 1154, 1129, 1754, 1755, 1735, 
         1736, 1157, 1134, 1708, 1800, 1799, 1200, 1810, 1811, 1809, 1277, 
         1159, 1138, 1717, 1716, 1278, 1350, 1349, 1723, 1722, 1538, 1207, 
         1470, 1206, 1537, 1721, 1536, 1205, 1468, 1204, 1535, 1720, 1534, 
         1203, 1466, 1202, 1533, 1719, 1140, 1396, 1397, 1307, 1670, 1866, 
         1865, 1340, 1633, 1158, 1872, 1632, 1464, 1195, 1631, 1271, 1432, 
         1711, 1393, 1263, 1669, 1304, 1668, 1303, 1862, 1386, 1793, 1794, 
         1792, 1796, 1795, 1257, 1853, 1854, 1850, 1852, 1851, 1374, 1785, 
         1786, 1784, 1788, 1787, 1250, 1842, 1299, 1841, 1298, 1502, 1184, 
         1751, 1501, 1584, 1583, 1771, 1748, 1749, 1745, 1747, 1746, 1767, 
         1230, 1766, 1769, 1768, 1312, 1764, 1765}],
        "0.04`"],
       Annotation[#, 0.04, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1867, 1219, 1309, 1221, 1874, 1220, 1324, 1100, 1869, 1229, 
         1311, 1146, 1101, 1743, 1744, 1728, 1729, 1149, 1106, 1364, 1365, 
         1297, 1839, 1296, 1840, 1373, 1781, 1782, 1753, 1186, 1752, 1187, 
         1848, 1849, 1697, 1698, 1123, 1384, 1131, 1701, 1700, 1302, 1859, 
         1261, 1860, 1861, 1702, 1703, 1132, 1392, 1135, 1710, 1709, 1803, 
         1802, 1194, 1737, 1804, 1805, 1807, 1806, 1394, 1305, 1863, 1306, 
         1864, 1272, 1395, 1718, 1643, 1282, 1812, 1201, 1738, 1813, 1814, 
         1816, 1815, 1398, 1399, 1308, 1433, 1434, 1435, 1400, 1141, 1540, 
         1541, 1539, 1209, 1542, 1724, 1544, 1210, 1543, 1211, 1545, 1725, 
         1547, 1212, 1546, 1213, 1548, 1726, 1550, 1214, 1549, 1552, 1551, 
         1142, 1351, 1818, 1285, 1817, 1286, 1321, 1161, 1283, 1284, 1208, 
         1281, 1871, 1139, 1160, 1279, 1876, 1280, 1348, 1347, 1801, 1759, 
         1760, 1756, 1758, 1757, 1791, 1390, 1391, 1301, 1870, 1130, 1383, 
         1122, 1732, 1731, 1730, 1185, 1779, 1780, 1776, 1778, 1777, 1372, 
         1836, 1837, 1835, 1295, 1838, 1241, 1829, 1830, 1826, 1828, 1827, 
         1363, 1822, 1823, 1821, 1825, 1824, 1178, 1741, 1177, 1742, 1105, 
         1358, 1099, 1868, 1291, 1227, 1357, 1289, 1647, 1290, 1820, 1169, 
         1739, 1168, 1740, 1097, 1353, 1354, 1288, 1646, 1287, 1819, 1352, 
         1645, 1144, 1877, 1644, 1439, 1164, 1475, 1218, 1559, 1558, 1438, 
         1163, 1474, 1217, 1557, 1556, 1437, 1162, 1473, 1216, 1555, 1554, 
         1436, 1472, 1471, 1553, 1143, 1673, 1672, 1671, 1215, 1323, 1322, 
         1096, 1867}],
        "0.02`"],
       Annotation[#, 0.02, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-3, 3}, {-3, 3}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 183},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->801690082]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6645],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->48036384],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->4348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"MultinormalDistribution", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], ",", 
     
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16031],

Cell[BoxData["0.9999999512780305`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->4422206]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->23995],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->158299417],

Cell[TextData[{
 Cell[BoxData["MultinormalDistribution"], "InlineFormula"],
 " is not defined when \[Mu] is not a vector of real numbers:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "I"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95470147],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "\[ImaginaryI]"}], "}"}]], "Output",
 ImageSize->{45, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->129877500]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["MultinormalDistribution"], "InlineFormula"],
 " is not defined when the dimensions of \[Mu] and ",
 Cell[BoxData[
  StyleBox["\[CapitalSigma]", "TR"]], "InlineFormula"],
 " are not consistent:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->322608174],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        RowBox[{"1", "/", "2"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->209078008],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", 
        FractionBox["1", "2"]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["1", "2"], ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Output",
 ImageSize->{402, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->741262253]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["MultinormalDistribution"], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["\[CapitalSigma]", "TR"]], "InlineFormula"],
 " is not symmetric and positive definite:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->3568],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->5392],

Cell[BoxData[
 RowBox[{
  RowBox[{"MultinormalDistribution", "::", "\<\"cmsym\"\>"}], ":", 
  " ", "\<\"The covariance matrix must be symmetric. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:MultivariateStatistics/ref/MultinormalDistribution\\\",\
 ButtonNote -> \
\\\"MultivariateStatistics`.`MultinormalDistribution::cmsym\\\"]\\)\"\>"}]], \
"Message", "MSG",
 CellID->218921587],

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultinormalDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"2", ",", "8"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        FractionBox["1", "2"], ",", "1"}], "}"}]}], "}"}]}], "]"}], 
  "]"}]], "Output",
 ImageSize->{380, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->269955865]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15418],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->760144715],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Mean", "[", 
   RowBox[{"MultinormalDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       SubscriptBox["\[Mu]", "1"], ",", 
       SubscriptBox["\[Mu]", "2"]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         SuperscriptBox[
          SubscriptBox["\[Sigma]", "11"], "2"], ",", 
         RowBox[{"\[Rho]", "*", 
          SubscriptBox["\[Sigma]", "11"], "*", 
          SubscriptBox["\[Sigma]", "22"]}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"\[Rho]", "*", 
          SubscriptBox["\[Sigma]", "11"], "*", 
          SubscriptBox["\[Sigma]", "22"]}], ",", 
         SuperscriptBox[
          SubscriptBox["\[Sigma]", "22"], "2"]}], "}"}]}], "}"}]}], "]"}], 
   "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{
     SubscriptBox["\[Mu]", "1"], "\[Rule]", "1"}], ",", 
    RowBox[{
     SubscriptBox["\[Mu]", "2"], "\[Rule]", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2647],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"1", ",", "\[ImaginaryI]"}], "}"}]], "Output",
 ImageSize->{45, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->291405448]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->11274],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultivariateTDistribution",
    BaseStyle->"Link",
    ButtonData->
     "paclet:MultivariateStatistics/ref/MultivariateTDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["QuadraticFormDistribution",
    BaseStyle->"Link",
    ButtonData->
     "paclet:MultivariateStatistics/ref/QuadraticFormDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HotellingTSquareDistribution",
    BaseStyle->"Link",
    ButtonData->
     "paclet:MultivariateStatistics/ref/HotellingTSquareDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["WishartDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/WishartDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22810]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32492],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->10297]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MultinormalDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 35.2126136}", "context" -> 
    "MultivariateStatistics`", 
    "keywords" -> {
     "multivariate normal distribution", 
      "multivariate Gaussian distribution"}, "index" -> True, "label" -> 
    "Multivariate Statistics Package Symbol", "language" -> "en", "paclet" -> 
    "MultivariateStatistics Package", "status" -> "None", "summary" -> 
    "MultinormalDistribution[\\[Mu], \\[CapitalSigma]] represents a \
multivariate normal (Gaussian) distribution with mean vector \\[Mu] and \
covariance matrix \\[CapitalSigma].", "synonyms" -> {}, "title" -> 
    "MultinormalDistribution", "type" -> "Symbol", "uri" -> 
    "MultivariateStatistics/ref/MultinormalDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5814, 195, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->408056504]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 101490, 2298}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2050, 48, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2673, 75, 61, 1, 70, "ObjectName",
 CellID->26035],
Cell[2737, 78, 705, 21, 70, "Usage",
 CellID->7878]
}, Open  ]],
Cell[CellGroupData[{
Cell[3479, 104, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3957, 121, 671, 23, 70, "Notes",
 CellID->8428],
Cell[4631, 146, 633, 23, 70, "Notes",
 CellID->149538583],
Cell[5267, 171, 510, 19, 70, "Notes",
 CellID->1355]
}, Closed]],
Cell[CellGroupData[{
Cell[5814, 195, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->408056504],
Cell[CellGroupData[{
Cell[6199, 209, 148, 5, 70, "ExampleSection",
 CellID->156352354],
Cell[6350, 216, 146, 4, 70, "Input",
 CellID->81224717],
Cell[6499, 222, 319, 10, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[6843, 236, 815, 26, 30, "Input",
 CellID->24173],
Cell[7661, 264, 257, 9, 36, "Output",
 CellID->416421874]
}, Open  ]],
Cell[7933, 276, 125, 3, 70, "ExampleDelimiter",
 CellID->246746483],
Cell[8061, 281, 147, 4, 70, "Input",
 CellID->212054166],
Cell[8211, 287, 212, 5, 70, "ExampleText",
 CellID->472395019],
Cell[CellGroupData[{
Cell[8448, 296, 818, 26, 70, "Input",
 CellID->8902],
Cell[9269, 324, 284, 9, 39, "Output",
 CellID->21576294]
}, Open  ]],
Cell[9568, 336, 119, 3, 70, "ExampleDelimiter",
 CellID->675],
Cell[9690, 341, 147, 4, 70, "Input",
 CellID->135497143],
Cell[9840, 347, 204, 5, 70, "ExampleText",
 CellID->6303],
Cell[CellGroupData[{
Cell[10069, 356, 909, 29, 30, "Input",
 CellID->30324],
Cell[10981, 387, 2879, 51, 84, "Output",
 Evaluatable->False,
 CellID->440539547]
}, Open  ]],
Cell[CellGroupData[{
Cell[13897, 443, 786, 27, 47, "Input",
 CellID->20649],
Cell[14686, 472, 19275, 320, 163, "Output",
 Evaluatable->False,
 CellID->3125200]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[34010, 798, 214, 7, 70, "ExampleSection",
 CellID->529],
Cell[34227, 807, 147, 4, 70, "Input",
 CellID->791735966],
Cell[34377, 813, 270, 8, 70, "ExampleText",
 CellID->24449],
Cell[CellGroupData[{
Cell[34672, 825, 733, 24, 70, "Input",
 CellID->5765],
Cell[35408, 851, 1566, 47, 105, "Output",
 CellID->734388353]
}, Open  ]],
Cell[36989, 901, 120, 3, 70, "ExampleDelimiter",
 CellID->3561],
Cell[37112, 906, 147, 4, 70, "Input",
 CellID->437021843],
Cell[CellGroupData[{
Cell[37284, 914, 446, 16, 70, "Input",
 CellID->6096],
Cell[37733, 932, 203, 7, 36, "Output",
 CellID->158812855]
}, Open  ]],
Cell[37951, 942, 120, 3, 70, "ExampleDelimiter",
 CellID->2948],
Cell[38074, 947, 146, 4, 70, "Input",
 CellID->12922356],
Cell[CellGroupData[{
Cell[38245, 955, 446, 16, 70, "Input",
 CellID->6916],
Cell[38694, 973, 202, 7, 36, "Output",
 CellID->88266525]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38945, 986, 223, 7, 70, "ExampleSection",
 CellID->13452],
Cell[39171, 995, 147, 4, 70, "Input",
 CellID->219181136],
Cell[39321, 1001, 246, 7, 70, "ExampleText",
 CellID->2750],
Cell[CellGroupData[{
Cell[39592, 1012, 791, 27, 70, "Input",
 CellID->19414],
Cell[40386, 1041, 49209, 827, 70, "Output",
 CellID->801690082]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[89644, 1874, 232, 7, 70, "ExampleSection",
 CellID->6645],
Cell[89879, 1883, 146, 4, 70, "Input",
 CellID->48036384],
Cell[90028, 1889, 228, 5, 70, "ExampleText",
 CellID->4348],
Cell[CellGroupData[{
Cell[90281, 1898, 833, 28, 70, "Input",
 CellID->16031],
Cell[91117, 1928, 174, 5, 36, "Output",
 CellID->4422206]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[91340, 1939, 226, 7, 70, "ExampleSection",
 CellID->23995],
Cell[91569, 1948, 147, 4, 70, "Input",
 CellID->158299417],
Cell[91719, 1954, 309, 8, 70, "ExampleText",
 CellID->8964],
Cell[CellGroupData[{
Cell[92053, 1966, 446, 16, 70, "Input",
 CellID->95470147],
Cell[92502, 1984, 215, 7, 36, "Output",
 CellID->129877500]
}, Open  ]],
Cell[92732, 1994, 400, 11, 70, "ExampleText",
 CellID->322608174],
Cell[CellGroupData[{
Cell[93157, 2009, 457, 16, 70, "Input",
 CellID->209078008],
Cell[93617, 2027, 542, 19, 51, "Output",
 CellID->741262253]
}, Open  ]],
Cell[94174, 2049, 387, 11, 70, "ExampleText",
 CellID->3568],
Cell[CellGroupData[{
Cell[94586, 2064, 413, 15, 70, "Input",
 CellID->5392],
Cell[95002, 2081, 453, 9, 70, "Message",
 CellID->218921587],
Cell[95458, 2092, 505, 18, 51, "Output",
 CellID->269955865]
}, Open  ]],
Cell[95978, 2113, 121, 3, 70, "ExampleDelimiter",
 CellID->15418],
Cell[96102, 2118, 147, 4, 70, "Input",
 CellID->760144715],
Cell[96252, 2124, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[96558, 2136, 1028, 33, 70, "Input",
 CellID->2647],
Cell[97589, 2171, 215, 7, 36, "Output",
 CellID->291405448]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[97865, 2185, 311, 9, 70, "SeeAlsoSection",
 CellID->11274],
Cell[98179, 2196, 1446, 47, 70, "SeeAlso",
 CellID->22810]
}, Open  ]],
Cell[CellGroupData[{
Cell[99662, 2248, 314, 9, 70, "TutorialsSection",
 CellID->32492],
Cell[99979, 2259, 192, 5, 70, "Tutorials",
 CellID->10297]
}, Open  ]],
Cell[100186, 2267, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

