(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10864,        391]
NotebookOptionsPosition[      8270,        306]
NotebookOutlinePosition[      9594,        343]
CellTagsIndexPosition[      9510,        338]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MultivariateSkewness" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultivariateSkewness"], 
          "Kurtosis" :> Documentation`HelpLookup["paclet:ref/Kurtosis"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MultivariateSkewness\"\>", 
       2->"\<\"Kurtosis\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MultivariateKurtosis", "ObjectName",
 CellID->10980],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MultivariateKurtosis", "[", 
       StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a multivariate kurtosis coefficient for ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27157]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MultivariateKurtosis"], "InlineFormula"],
 " is a univariate measure of kurtosis for multivariate data."
}], "Notes",
 CellID->194946078],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MultivariateKurtosis", "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    StyleBox["n", "TI"]], 
   RowBox[{"\[Sum]", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["i", "TI"]], "-", 
         OverscriptBox[
          StyleBox["x", "TI"], "_"]}], ")"}], ".", 
       SuperscriptBox[
        StyleBox["\[CapitalSigma]", "TR"], 
        RowBox[{"-", "1"}]], ".", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["i", "TI"]], "-", 
         OverscriptBox[
          StyleBox["x", "TI"], "_"]}], ")"}]}], ")"}], "2"]}]}]], 
  "InlineFormula"],
 " where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["matrix", "TI"], "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", "\[Ellipsis]", ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["n", "TI"]]}], "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox[
    StyleBox["x", "TI"], "_"], "=", 
   RowBox[{
    ButtonBox["Mean",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mean"], "[", 
    StyleBox["matrix", "TI"], "]"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[CapitalSigma]", "TR"]], "InlineFormula"],
 " is the estimated population covariance matrix."
}], "Notes",
 CellID->20472],

Cell[TextData[{
 "For a matrix with ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " columns, a value of the multivariate kurtosis coefficient close to ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], 
   RowBox[{"(", 
    RowBox[{
     StyleBox["p", "TI"], "+", "2"}], ")"}]}]], "InlineFormula"],
 " indicates approximate multinormality."
}], "Notes",
 CellID->23622]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->71593251],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->86929018],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->74884949],

Cell["Multivariate kurtosis for bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultivariateKurtosis", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "7"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"8", ",", "10"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142954831],

Cell[BoxData["5"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->481853056]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4282],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultivariateSkewness",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/MultivariateSkewness"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Kurtosis",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Kurtosis"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17065]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->17852],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->21660]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MultivariateKurtosis - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 36.6970266}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {"kurtosis"}, "index" -> True, 
    "label" -> "Multivariate Statistics Package Symbol", "language" -> "en", 
    "paclet" -> "MultivariateStatistics Package", "status" -> "None", 
    "summary" -> 
    "MultivariateKurtosis[matrix] gives a multivariate kurtosis coefficient \
for matrix.", "synonyms" -> {}, "title" -> "MultivariateKurtosis", "type" -> 
    "Symbol", "uri" -> "MultivariateStatistics/ref/MultivariateKurtosis"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5337, 189, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->71593251]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9368, 331}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1398, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2021, 62, 58, 1, 70, "ObjectName",
 CellID->10980],
Cell[2082, 65, 496, 15, 70, "Usage",
 CellID->27157]
}, Open  ]],
Cell[CellGroupData[{
Cell[2615, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3093, 102, 168, 4, 70, "Notes",
 CellID->194946078],
Cell[3264, 108, 1647, 61, 70, "Notes",
 CellID->20472],
Cell[4914, 171, 386, 13, 70, "Notes",
 CellID->23622]
}, Closed]],
Cell[CellGroupData[{
Cell[5337, 189, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->71593251],
Cell[CellGroupData[{
Cell[5721, 203, 147, 5, 70, "ExampleSection",
 CellID->86929018],
Cell[5871, 210, 146, 4, 70, "Input",
 CellID->74884949],
Cell[6020, 216, 216, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[6261, 225, 388, 13, 28, "Input",
 CellID->142954831],
Cell[6652, 240, 158, 5, 36, "Output",
 CellID->481853056]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6871, 252, 310, 9, 70, "SeeAlsoSection",
 CellID->4282],
Cell[7184, 263, 498, 17, 70, "SeeAlso",
 CellID->17065]
}, Open  ]],
Cell[CellGroupData[{
Cell[7719, 285, 314, 9, 70, "TutorialsSection",
 CellID->17852],
Cell[8036, 296, 192, 5, 70, "Tutorials",
 CellID->21660]
}, Open  ]],
Cell[8243, 304, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

