(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10759,        389]
NotebookOptionsPosition[      8158,        303]
NotebookOutlinePosition[      9490,        341]
CellTagsIndexPosition[      9406,        336]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MultivariateKurtosis" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultivariateKurtosis"], 
          "Skewness" :> Documentation`HelpLookup["paclet:ref/Skewness"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MultivariateKurtosis\"\>", 
       2->"\<\"Skewness\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MultivariateSkewness", "ObjectName",
 CellID->20513],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MultivariateSkewness", "[", 
       StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a multivariate coefficient of skewness for ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->4886]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MultivariateSkewness"], "InlineFormula"],
 " is a univariate measure of skewness for multivariate data."
}], "Notes",
 CellID->194946078],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{"MultivariateSkewness", "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   FractionBox["1", 
    SuperscriptBox[
     StyleBox["n", "TI"], "2"]], 
   RowBox[{
    SubscriptBox[
     StyleBox["\[Sum]", "TI"], 
     StyleBox["i", "TI"]], 
    RowBox[{
     SubscriptBox[
      StyleBox["\[Sum]", "TI"], 
      StyleBox["j", "TI"]], 
     SuperscriptBox[
      RowBox[{"(", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["i", "TI"]], "-", 
          OverscriptBox[
           StyleBox["x", "TI"], "_"]}], ")"}], ".", 
        SuperscriptBox[
         StyleBox["\[CapitalSigma]", "TR"], 
         RowBox[{"-", "1"}]], ".", 
        RowBox[{"(", 
         RowBox[{
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["j", "TI"]], "-", 
          OverscriptBox[
           StyleBox["x", "TI"], "_"]}], ")"}]}], ")"}], "3"]}]}]}]], 
  "InlineFormula"],
 " where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["matrix", "TI"], "=", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["2", "TR"]], ",", "\[Ellipsis]", ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["n", "TI"]]}], "}"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  RowBox[{
   OverscriptBox[
    StyleBox["x", "TI"], "_"], "=", 
   RowBox[{
    ButtonBox["Mean",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Mean"], "[", 
    StyleBox["matrix", "TI"], "]"}]}]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["\[CapitalSigma]", "TR"]], "InlineFormula"],
 " is the estimated population covariance matrix."
}], "Notes",
 CellID->20472],

Cell["\<\
A value of multivariate skewness close to zero indicates elliptical symmetry.\
\
\>", "Notes",
 CellID->28433]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->61664253],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->101059672],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->205800393],

Cell["Multivariate skewness for bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MultivariateSkewness", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"3", ",", "4"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"5", ",", "10"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->142954831],

Cell[BoxData["2"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->144043800]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->2739],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultivariateKurtosis",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/MultivariateKurtosis"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Skewness",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Skewness"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->8415]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14972],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->20896]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MultivariateSkewness - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 37.3376680}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {"skewness"}, "index" -> True, 
    "label" -> "Multivariate Statistics Package Symbol", "language" -> "en", 
    "paclet" -> "MultivariateStatistics Package", "status" -> "None", 
    "summary" -> 
    "MultivariateSkewness[matrix] gives a multivariate coefficient of \
skewness for matrix.", "synonyms" -> {}, "title" -> "MultivariateSkewness", 
    "type" -> "Symbol", "uri" -> 
    "MultivariateStatistics/ref/MultivariateSkewness"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5285, 188, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->61664253]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9264, 329}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1398, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2021, 62, 58, 1, 70, "ObjectName",
 CellID->20513],
Cell[2082, 65, 499, 15, 70, "Usage",
 CellID->4886]
}, Open  ]],
Cell[CellGroupData[{
Cell[2618, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3096, 102, 168, 4, 70, "Notes",
 CellID->194946078],
Cell[3267, 108, 1858, 69, 70, "Notes",
 CellID->20472],
Cell[5128, 179, 120, 4, 70, "Notes",
 CellID->28433]
}, Closed]],
Cell[CellGroupData[{
Cell[5285, 188, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->61664253],
Cell[CellGroupData[{
Cell[5669, 202, 148, 5, 70, "ExampleSection",
 CellID->101059672],
Cell[5820, 209, 147, 4, 70, "Input",
 CellID->205800393],
Cell[5970, 215, 216, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[6211, 224, 327, 11, 28, "Input",
 CellID->142954831],
Cell[6541, 237, 158, 5, 36, "Output",
 CellID->144043800]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6760, 249, 310, 9, 70, "SeeAlsoSection",
 CellID->2739],
Cell[7073, 260, 497, 17, 70, "SeeAlso",
 CellID->8415]
}, Open  ]],
Cell[CellGroupData[{
Cell[7607, 282, 314, 9, 70, "TutorialsSection",
 CellID->14972],
Cell[7924, 293, 192, 5, 70, "Tutorials",
 CellID->20896]
}, Open  ]],
Cell[8131, 301, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

