(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    120412,       2690]
NotebookOptionsPosition[    114138,       2472]
NotebookOutlinePosition[    115572,       2511]
CellTagsIndexPosition[    115485,       2506]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"StudentTDistribution" :> 
          Documentation`HelpLookup["paclet:ref/StudentTDistribution"], 
          "MultinormalDistribution" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/MultinormalDistribution"], 
          "HotellingTSquareDistribution" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/HotellingTSquareDistribution"]},\
 #, 2]& , Evaluator -> Automatic], {1->"\<\"StudentTDistribution\"\>", 
       2->"\<\"MultinormalDistribution\"\>", 
       3->"\<\"HotellingTSquareDistribution\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MultivariateTDistribution", "ObjectName",
 CellID->29679],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MultivariateTDistribution", "[", 
       RowBox[{
        StyleBox["r", "TI"], ",", 
        StyleBox["m", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents the multivariate Student ",
     Cell[BoxData[
      StyleBox["t", "TI"]], "InlineFormula"],
     " distribution with correlation matrix ",
     Cell[BoxData[
      StyleBox["r", "TI"]], "InlineFormula"],
     " and degrees of freedom parameter ",
     Cell[BoxData[
      StyleBox["m", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14294]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The probability density for vector ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " in a multivariate ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution is proportional to ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{"(", 
    RowBox[{"1", "+", 
     RowBox[{
      RowBox[{
       StyleBox["x", "TI"], ".", 
       SuperscriptBox[
        StyleBox["r", "TI"], 
        RowBox[{"-", "1"}]], ".", 
       StyleBox["x", "TI"]}], "/", 
      StyleBox["m", "TI"]}]}], ")"}], 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"(", 
      RowBox[{
       StyleBox["m", "TI"], "+", 
       RowBox[{
        ButtonBox["Length",
         BaseStyle->"Link",
         ButtonData->"paclet:ref/Length"], "[", 
        StyleBox["r", "TI"], "]"}]}], ")"}]}], "/", "2"}]]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->8428],

Cell[TextData[{
 "The correlation matrix ",
 Cell[BoxData[
  StyleBox["r", "TI"]], "InlineFormula"],
 " can be any symmetric matrix, with unit diagonal elements, and offdiagonal \
elements between ",
 Cell[BoxData[
  RowBox[{"-", "1"}]], "InlineFormula"],
 " and ",
 Cell[BoxData["1"], "InlineFormula"],
 "."
}], "Notes",
 CellID->12798],

Cell[TextData[{
 "The multivariate Student ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 "-distribution characterizes the ratio of a standardized multinormal to the \
standard deviation common to each variate."
}], "Notes",
 CellID->16744],

Cell[TextData[{
 Cell[BoxData["MultivariateTDistribution"], "InlineFormula"],
 " can be used with such functions as ",
 Cell[BoxData[
  ButtonBox["Mean",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Mean"]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["CDF",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/CDF"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["RandomReal",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/RandomReal"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1355]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->748265802],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(3)", "ExampleCount"]
}], "ExampleSection",
 CellID->20145572],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->163071191],

Cell[TextData[{
 "The mean of a bivariate ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution with 10 degrees of freedom:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Mean", "[", 
  RowBox[{"MultivariateTDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "\[Rho]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Rho]", ",", "1"}], "}"}]}], "}"}], ",", "10"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24173],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0"}], "}"}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->83049836]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->246746483],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->306170077],

Cell["The variances of each dimension:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->472395019],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Variance", "[", 
  RowBox[{"MultivariateTDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", "\[Rho]"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"\[Rho]", ",", "1"}], "}"}]}], "}"}], ",", "10"}], "]"}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox["5", "4"], ",", 
   FractionBox["5", "4"]}], "}"}]], "Output",
 ImageSize->{52, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->529569837]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->675],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->139847556],

Cell["Probability density function:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->6303],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultivariateTDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "\[Rho]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Rho]", ",", "1"}], "}"}]}], "}"}], ",", "m"}], "]"}], ",", 
   
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30324],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox[
       RowBox[{
        RowBox[{"y", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["y", 
            RowBox[{"1", "-", 
             SuperscriptBox["\[Rho]", "2"]}]], "-", 
           FractionBox[
            RowBox[{"x", " ", "\[Rho]"}], 
            RowBox[{"1", "-", 
             SuperscriptBox["\[Rho]", "2"]}]]}], ")"}]}], "+", 
        RowBox[{"x", " ", 
         RowBox[{"(", 
          RowBox[{
           FractionBox["x", 
            RowBox[{"1", "-", 
             SuperscriptBox["\[Rho]", "2"]}]], "-", 
           FractionBox[
            RowBox[{"y", " ", "\[Rho]"}], 
            RowBox[{"1", "-", 
             SuperscriptBox["\[Rho]", "2"]}]]}], ")"}]}]}], "m"]}], ")"}], 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "2"}], "-", "m"}], ")"}]}]], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox[
     RowBox[{"2", "+", "m"}], "2"], "]"}]}], 
  RowBox[{"m", " ", "\[Pi]", " ", 
   SqrtBox[
    RowBox[{"1", "-", 
     SuperscriptBox["\[Rho]", "2"]}]], " ", 
   RowBox[{"Gamma", "[", 
    FractionBox["m", "2"], "]"}]}]]], "Output",
 ImageSize->{303, 85},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->61956831]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot3D", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"MultivariateTDistribution", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}], ",", "10"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "3"}], ",", "3"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20649],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 137},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->472721149]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->8098],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->333501359],

Cell[TextData[{
 "Generate a set of pseudorandom vectors that follow a trivariate ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->24449],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RandomReal", "[", 
  RowBox[{
   RowBox[{"MultivariateTDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "2"}], ",", 
         RowBox[{
          RowBox[{"-", "1"}], "/", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "1", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "1"}], "/", "3"}], ",", "0", ",", "1"}], "}"}]}], 
      "}"}], ",", "5"}], "]"}], ",", "10"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5765],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"0.9528597855973127`", ",", 
     RowBox[{"-", "1.0633247325737598`"}], ",", 
     RowBox[{"-", "1.6671848334800503`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.0490867327679005`"}], ",", 
     RowBox[{"-", "0.8382232966738582`"}], ",", "0.09383024412690155`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.28978705797772597`"}], ",", "0.002393323342303893`", ",",
      "0.7444807866441753`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.4211851001577727`"}], ",", 
     RowBox[{"-", "3.050477314884041`"}], ",", 
     RowBox[{"-", "1.8521946594395322`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.4175977785476963`", ",", "0.17536881707583224`", ",", 
     RowBox[{"-", "1.8779597117950777`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.5198639099351208`"}], ",", 
     RowBox[{"-", "1.280228457683036`"}], ",", "0.1225842808440997`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.8148833327046838`"}], ",", "1.0680399904268392`", ",", 
     "1.795415552638787`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.1941969686452821`"}], ",", 
     RowBox[{"-", "0.12899535649554364`"}], ",", "2.635178679443928`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
    "0.2824703004897917`", ",", "0.015523791875891398`", ",", 
     "2.1044662120130613`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0.17666737622065765`", ",", 
     RowBox[{"-", "0.8235977945917434`"}], ",", 
     RowBox[{"-", "0.672567724004931`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{462, 84},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->208342017]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3561],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->731715559],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Skewness", "[", 
  RowBox[{"MultivariateTDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "3"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "3"}], ",", "0", ",", "1"}], "}"}]}], "}"}],
     ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6096],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"0", ",", "0", ",", "0"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->860193105]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->2948],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->196293435],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Kurtosis", "[", 
  RowBox[{"MultivariateTDistribution", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"1", ",", 
        RowBox[{"1", "/", "2"}], ",", 
        RowBox[{
         RowBox[{"-", "1"}], "/", "3"}]}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"1", "/", "2"}], ",", "1", ",", "0"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{
         RowBox[{"-", "1"}], "/", "3"}], ",", "0", ",", "1"}], "}"}]}], "}"}],
     ",", "5"}], "]"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->6916],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"9", ",", "9", ",", "9"}], "}"}]], "Output",
 ImageSize->{62, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->392596043]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3719],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->926512319],

Cell[TextData[{
 "Equal probability contours for a bivariate ",
 Cell[BoxData[
  StyleBox["t", "TI"]], "InlineFormula"],
 " distribution:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->2750],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ContourPlot", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"MultivariateTDistribution", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}], ",", "10"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "2.5"}], ",", "2.5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19414],

Cell[BoxData[
 GraphicsBox[GraphicsComplexBox[CompressedData["
1:eJyVnQm4llP3/48mY5rQICoNhCSkUuyTElEiokQkUsYSSbyEpFJCaaAUrxJN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   "], {{{}, 
     {RGBColor[0.3378049005757136, 0.13458471021263835`, 0.5918059696180639], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxNmXmQlcUVxXvg9TfzBuKCqMjmEKMiomBWBUFjMMggFStRkMWqlLiCoqjI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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlVlsVlUUhU/be8//nx+iiXPigzEh2DhhjBNRQCpORUCJtKj1BRONUUp8
MYpDEE2jBaQkmGhRrGjgoUGjTUQhoqBiC7a1FRJFwig/FEIBBxDL4LdYPuzc
s+7ae9979tl7nctnzJraWBlCeBHLsNUxhPpSCA/nIayvCOFb8HRwA7gfvBV8
DzgHN4OXFELYwPopgleQaC/rtSmEl8Ed5OvC/yH8H+X9BPy38fwC/ln4t+A3
w98FH3j/PPxnPGvBw3g28XoO+afhfx7+zeRfxvt74Ys8n4Avw+3D2uEngWey
PoOtBU8k32781oBngz+C7wd/iNWAh8h3I7luwlaDe+E/xvcTrBE8QHwrvnfD
V/Gsh+/hfyeAh+CfhG/m/R3gE+CbFQ9fB57O+w74NvA0cB14GXg9uJU9Lefb
a/D/hW/9irURPwrcgO9l+FTj+xIxO+F2Ycvhx8J3wv0NXgX+EbwJXEPMMfAj
Oq/cZ6KzGMTOKYZwbtF7vRT+X7ihgrlh2AziJxN/MXEN5DtE7kHs0yr/w9es
x+DzOflfwQZZT8X/Svzb8T+cfGY6q47Me30fn3nBe74fvC+6FiNzxx6O7iXl
uBb8DTnmErsDmwLeFV2rEbl7TzVTrdSD14HLPLvBr2Xu1S+j/0U9uz95T9rL
SvgWcB/7bSNfrXqE9dXEbNe/sv9rWF+F7anwu2fgdxL/gmYCvpOcc7GRcMPB
v5Fva/JZ6MzUi9uiZ0E9WaFeLvksl8L/he+63LOgGqo3VuK/JLhHHgAfiJ61
avBt+HfxPEn9T1W5NjoD1V41ul71hO8hvgl8A3h/7t59XT0InogN510ZvIrY
6uiz0cxNLvgbyl3Hfk6xHsJq+f5X8Ft0/rn//V3sd3rnEvL1Ze6JsfAbyXcQ
/3riB/SvybELMs/WLL4xu9Iz9g/cieR/0z/vZZ1Fn41mtg78oGa2wjN+jPXx
5L3pjJ9mfTS6VzUz81mXiz4bnekbfG9Kwf9yBf4HwN8TM5/4N7GZBWuGtOK5
SmvXB//PsjRM2vOOZjxYgxaRe2HRWvU4+z3Iuz7yvU2uVmwM69E6g8w12CG9
TM6tPfzMuh+7MDimHD0D6n3NhLSypejc0kzVqj13b6pm95WsQdIeneFAdI+o
N9QzTTw3J//LReBe1j9hizN/swb/8fgfAZ8Bv4r/huRanA9uTNZIaaN6Wr0/
quTZ0wz0wHVjFwTn1NlLg6W96oEuuM7kXC2ZZ0Uzq1nVzGyE25TMKcf46BnS
7KjHvkvuUfVmc2bt7I7WLmnoUfgjyXeDNPtO+N5orT2dWYu3RN8V0mRp8cLc
2itN/pPYP5K1XneQ7h5pprRSd5C0Uj2jXpFm6q5ZGq21unNUO9VYtVUNpY2P
RWunNPKH3Boi7dAdcXv0nrQX3SHjwOuStUkafSj3TGmW3sNuZX2y4LPRjKtX
NUOaHfXsHvDu5LtMmn9LyTOrWVXPnU7OqVy641py1+hsbYj5D1OFHHo=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.4270286987348221, 0.28972079898608993`, 0.717220811602088], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJxFmXmQVcUVxt9w77vz7o2sgpKIUKCoIEgiKqCCCOISFWQG1GAABXdAzKIp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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwll3mQVdURxu97977z7n0BjQsuiUo0yqICUdYBBjQEtAJIBFyCsWJAxQqb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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.5162524968939305, 0.4448568877595416, 0.842635653586112], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1mGuwl1UVxt//5b39EQTBDOJysAwwgQPCQS56TurRpiQNuehkFAUK4gEq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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlneMVlUQxd/X3nvfA6SrwLICBikB3CW0ZREQXMFCkCYSEAXpPQpRCaB/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         "],
         VertexColors->None]}]}, 
     {RGBColor[0.594447243250973, 0.5767735005323857, 0.9101969283591728], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJw1V2lsVVUQvu/dd++554FUlpAILaGAKGgViqwmIsoiblCMiQoSaEgErCiE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         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlllsVVUUhs89t737nFssIogB2tKCgkAQLDL1AUUR5IXJaJwjhERARCFV
iAoOD4IgYCCkzGVGRKlEiSSCAQ2ziEGBGkUjKGEIyiiiCfH789+Hlax1/rXW
Xnuv6VSNenHEhDiKoo+gIuhaLoq+K46iR+AvZaLobIiic9AAlD5HHg8/E51N
2SiazLdy+H+TKNqJ3AF8APIKdD4EG8u3tvBjoEnI74BPB/85se0i5HVpFFXk
o+gHDj+I3BXdM+BbsK1Bpy1YFXQUvBH8EvYlyHuRm4LPQ3cg38aj/zzUCn/l
0K/wX6NfCz+D+/SIHNOP8DfQ/wxsNt/mgh8KjmUwPjcgz0euR3c0cpvUPuXr
F3wO4byAfUvkl6BO8LPRXxj7jTaBP8G3l3UX5BqwvsFn6f2ugF2GUvhRUCX8
JWy24bsf+uM46zzfktgxnAU7Da3O+E3W4msd1AA2hm859Nfn7Pt9vs3ifjnw
Svi7iX8H8nXlELkh8t1nIi+I/QZb8V2G3A15Dv4Pgz+YOnblvyz1HXU3veki
9BdDE7O+w39g07CfUcjna2Ad+NYVfju0mfN7gfcHH048ZeAVUHGhXtagG6WO
XfG8h/794LeDV6M/D3kj9p+C90d1LLr3kf/zRX6jBcgN6NSC/YR8pNgxKRZ9
u4Cv1ugfRn8d35LgM+S7Cv1vwQ9CE9Ddi/wP2DLVJ+eXoL8Wfg1UmnEM1cE1
r9g3Qd+ATUJ+F74XeEBOoDcyrpGEs9O8a1M12An7LsH51JnH4BuDc6/4noMv
wV917J6pRd4D7YOfBr3JfZcQ41Bst6mnOKsn+n2xPQK9AL+Hb+MK/TYFeVfw
3er1psplcG56QnPwdRty59g19Sh4E+T28FPRvznvnlOvHeDNKpF/x6Yidk/2
ApvOeUczjmEH8kPYDwW/gH0R/E7VfNY23Yj/JPZ/Iv8Ftc+7x9Xbx/DXDF/P
QDVg5XxrlfdM0CxQDuvho+Dcb4AW4/tkcO41g+7Ef8fUdzuFPCe4B9Uf6tG7
wLrjv0/GMfQG24iPxqxrNAu/lG8fxO6BhejXpa5N5aicePqgMzz2zCqFP5T4
bRXvZHSnpO69ZzWv8LUVnTPgp2Ln/m3VYOwa6AE2MDh3iqlJ3j5kqxm3FN9L
oDzy6Ix9ZVWDsX0+AHYjuFbVM5vBK7AfFHtmVSuW1L1/MetcdE/NKycHNLuD
63dp1rW2u1AvqrmV8EOweQVso/ojOMfKrWZKU+K9CRqJ/X7iXRa8QzQ79Iby
dRy5tMg+58KfS1zLur/O/graFTsG7ZYThXxqx6ygVjoG95Z0KoJ3impbO2oV
/DBsphTiu4Z+/8SzVW92EX5+zr2lGroOng9+S73Z1eCZr1l/Gvxx5FuDZ+tI
5InY7kvcj4qvsdgzTbNMM6xcvtCZlfUMvaJaU01m7W8htnWJZ5dmpny30D6N
fEYb3q4s71pdybcnsW1I3I/aIbM5a3Xw3WQzjFib5lxretPm2LaAXs96JqzA
dkTOvp9SzME7RrWrmf904pmvWa8e+w3/26FRRa6pELzDtbu1Q3S3LcGzRnfs
grw8uPdUY+tT73Dtbvm4A/zVxLNRO2Aqus1zzp92RD/k1ql3qexXwa8s7Fft
mN3Yjs85v3rzQcEzQ7NCM+Ue7RbtyKz7ZTB4b77VZDyD1Jvt8p4l6tFPEve0
enkGNu1S95xslaPliWtCtaAaKsFfad61rBnYCf3O0B+xz1Atbij2v4LupFqd
pZxlXbPtgmeC8qMdcDnxDlL9acdrtu9P3Gu639Cce0z51c4ZyFnfF/pHM1yz
uY7z+hS5JjJgjwXXpmT15sPBuVaPtsC+uf5hqIWj+l+A/6LYtaU7rEo84zXb
VTNf5twDqlW9qWbrcfSXR56xbyG3zLl3NLO2gV0OnmU642P4zYnfVvWqWXpL
6rM1U0/o/6KwL/VG9+ZdA8q9drhmR7O8d4tmyNTUPuVLd76K7d85/2tpB+tf
Lw3e3frnq0S/KnX8ivl/h9lXeA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.6600473805611087, 0.682174667757417, 0.9116924094386595], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlnmIV1UUx9+89/u9+96ENmkLmC0uM2pSpGYJFZSWqZkOaovKOFE5EFSa
Jk6Zigou0ELK5D7mVlbSGEgmghFlZWlFJtqqlJC0kqXRRn2+fO8fl3vuueee
9XvOez3umTbuoTRJks9ZGasLh/kQ02qSZDvres6L4H8GbzT0cuhueZIMCEly
HecJme/E78v5blYL7+7g/s7g8yDke5ZJMga6N2tqav0XwR8YbONK6KHQo6Dv
Z99QTZL70PkVe8K5G/yvoS9BzwZY38Jbk9vHduj+8gn6/RrrkD/S+1Zm/7tD
N1eS5APu60Wz7q3xuRH6OWQWo6cW/U9B/4mt9gK/uZuVeR8GfzL3J5D7MrXO
TaltjmDfyHoPug1fMuS2Qa9HzxTkJ/D2GPcHM/N3o7sX/Gb41yA/MtiPY8j3
Lu3PC/Dz0m/6sPdlfQc9teJcKg/nINPA28Gp66N7+dMG79lgn25NHad0HqrY
b8lcVXG9G8Vn36M44e/AhyNV5005quNuKPQc7HcOzt9v2P099530b4422lPX
SrXYR4y7kd8r33jbjHwr/BnsB7hbj72D7B+y2qFXwP+1sB+KR7ynkV8Erz+r
U+YctVQcyz50t+aWGR1jUt3fhF6VGT8noCdXXNMHkH2n8N2YWCvlcBL8V+Av
hl9TGgeSH1e4TqrRHvKxtTSGFMfbhWPZwr61cM80la696nsSHWnpmk/nrlfm
HO5KbUd4aORdzjqdeh8f6Y2821Ta74/gdUbnoNT90V4a34+gYzr3p2IvNcQ6
/oufZwef/yrcY+oD8V4szF/Lvq6wjsvQ1491EvowMj8VxoIwPqU0zuXTFZn1
r4S3inU7tpcjszN3zfdC31Y69++i40H4q3nTFf5/Vc+GFalnhnpWOPqnaix1
iTFI/844I3SuV45ZZWYM5RXnXD7J/jzkL8bmq9g6nhkXUzJjQz23quo8S9+M
zFiWT/JReoYhMyA3fkdhJymczwPwn0DvAegboC/P3d9N0BOhW6BXCkeF9SbI
boG/P3Odrq0YM5pzDTGWasUxyJ+jwhryzyPfho8jC8+WuogV4URzZVTE9M/c
P4P869z1wNalrG8yrxERxw3czyk8j4UL1VY66+Ock87hwbNY2O8Z57RklvDu
6ty507wcH2fmXcjXwO+C3LnQ57H6pe43xakYhc2ewWflRfeSfwl+J/z8JHMP
atdMWIOt1ayZmX2cFf1UjSfE78j21HiRf5ofS0rnbnbh2STfOqAnY2MJbzrg
tSEzlrgHw1vMXZPmbNXfEs2BQ/CHl8aQ4myNM0R41DthsjZ47is3HyM/DPms
4p7Vrrj0/VlYeG7cyP5H1b3dpzBeFcc29rGF8SwMac71qPH8kl96G1SHwn01
N/W8U14Vz66YQ9VbvaiZrPnXq7SOR/FzUmn815fGsTDcvTZJLqz1jK8LxpZy
+ze2DkNfgEx/1ZA1BHoHe0ewveOpZ5Xm3pnY86qvaj4x1v1knL+a882xT4Wt
H7j/PlhHpfTsk66l2J0PvSw11pUL5WFtpFUX+bEgxqg8norfmuMRN8LMG8Hz
RX2rGJZFPUfhHWF9yrkgP6Gw743Y3RSMH90ph8rVwuD4h8TvVfcYy2OqXW7c
P84+O9inM9Cnc8+nl+Etr3o+vcb+RdVYXSp8Bs+21ogt1WgmvBnBtZ0XXAP5
vh9bD+fOwfnsC4Jj1+wZEefPZnhPVt0Hwoe+08LSWeT2l+C8aMaciTXapW9x
8BzoCj03OD+aR5qV+h7pH2pD/I9qiv8QwuHN6tHc80nxl7H3b8GXFVXX4sfC
mFMO1bd1se43wRuY+9v7P+0hN44=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlmmIllUUx5953/d57n0mBFMzMIlm1HFpwSUrqGixTM0Nl0onx2jxU6Vp
5aCZSzBj0IKK47jMWKZm46BJloZURKupKZpltEkL7YulBqXY79///XDgnHvO
Pefcs96qO6ePu7+QJMlGoASkMUlCliSXFJPkBIzmNEleDEmyA3wC/O3wzgDd
oFuBA/BOQZ8Lvh/okydJDfBBRZJ8j46B8HrnxkfCH478ZuhpGBsr/eCDOHsU
3RM5ux38NDZr4N0D9IDuCTyNvqnIVIB/CX8t+PucbeD+Mc72iM/9buA3cpaW
7G879m8Itv0pPnSA14+zAcgfhC5AVwBPIfsVMmcj2xEYAj0NmY/BlyG/C9lD
8JuIzypgFvRd8IeB3wRcj/yf8MeAj42O3VjORqF7JFCP7Juc3RpsQ7rvgB6A
7mbo58BvBn4C/zHYl6PAGvhz0Dcee28Bk9FVC3xecMxmSh8yg6HnFayrAHQv
WOfF8JZDPws+DFgL3hr8fuXwDPhq9D9YtP9zke/H2RXgCyRPrN8I9v3uxLxH
kFlYsEyIrhm99yTwSXDMFKuPgCXIHi7TO7GxAdk26OnYnw+9B3wmMi3ge2U/
OmfK1QRgPfh3we/dDd2GP/2hryrXm3RtBrYXrHMJ+Bep39YCPAneibM+4O1A
DfprMuvOgebonCqXM6FHg88hvpeW3APrwK8Mro9azlaA9+f+CHStAyaBd+Ws
L/g0vR97pzlrR99j3HkJ/Nrg2MufD9H/TrmeW9F/OPWb9Bb10K/wf4nOrWL2
d+ocKTc9kC/iTyl3fWxCx2vw7lUNFZ2ja4Jj0FLO9zZkR0Tfn1Fyry4GHi/b
+zd1z6nXegKvSjdnz2C/HvmH4fUKri/Vw9vyH3i94JpuQNfe4NxtxId6eLOj
3674alYoBvJHOWlHtnM5Hy8D45EdF93bqqGl2O4Q7Ity2hTc8+p11bByvxWZ
MSXXwAl0r4+upU7QD2SuKfmzmrO+wW9YUK5X1dKK3LNGNTUwuMfUW1dDX4Su
wdBTNCuAz7DVO/otSxPXUlNq3/WGderd4NpST2tWzQruReW4Al1bud8o/5Rz
bL+SWpdqSLq6lOtHOtW7qjHVlnq4Dfmh0KM1D0uenY3oqyt6hjbC65Y5FsuA
5fC/Ca4/xWgvsp3hV1W4xwp6W3Ctyp8q8N3RsVJ/n8KfiZxNhd8LuCxzTBQL
2TyvkrmU2rdD6O+VuacUH82oLtBHomtBNp/An02pdSsnjdAtqWezaki2VIPK
t2zOhj4HHdUVnjHztBuCa1X61FuLg9+qN84PtimearoO/D3sryy6Piuxdxbw
bcE9LN2/Rc8i2VCvn8xcO+r5M/hyS/BsVn6PIdu17I92QIZ8U+be2wd9X+Ye
VO/J5h+atblnhWwqVrtS7ybFrBr+Qs0U6EHQ70bnQPFRD2t3dq90bLVDZSvJ
Pftkcxm65ubOjXZOHfiU3DzVs2bVz8G7Q++t5/7+aFuqR/XyvujZo57uy93L
M+/iHzhriK451Zp64ILcM0Wz5Ouid9Pzmd+uGVQTvDPUX9K3kvt/QXcseEeO
BL8uenbNKPrtMXpXKAZbuX8AmWLJf4zh0TNLs0o7+Hf4bZl3teI5CrySs2rw
hzg7CL0zuJa084Uf4iwr+axV+zhzb+qO/hpHgneTZuxC8EXlfacc62+wNPhv
ox25Cvqf6NmgehsQ/OfRvFbPXQj/fPw9WrT8mmgf5Zt2ak/lKvdu10x9Af6m
6L+B/jiadSuid496YAv0ZO43FB2P49BVuWOvGahdoxmqWaGZMTR3zavW9eZF
mr3lftUfaRKytwX3uuT1V+qXO9f6Mx3PnCPlRjmrzeyDbGtmbYn+U6lf5VOP
3DtCu0E2huSeKdKvHG7L3AP/1756DP6OzL5rhv0HeFhKKA==
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7256475178712443, 0.7875758349824483, 0.9131878905181462], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlV1sFlUQhvfb/Xb3bIuxTQUJJEZtEYVqraLGO7RERKsiRpRaMHojaIIB
jJiAUKUIFybE+lPEqBcgQqUBg6LAhQlKDP7EmlDB4E80GG8E4o03gp/Pm/dc
nMzse+bMzJl5z+wVjz+9YHmaJMlhVsaaWiTJlJAk02pJcqhMkmV8D6KPg/3A
2oHR9ipJBtC/BH87T5JNfM+uJ8ksHG1hfwB8I3KQ9Qz6r9gcxOY037vxdwa/
B8GvRx9Gn4V+S2rfw+gzU5/X2e84u7+yr13E3M16Af0m4l2NXIHNALIttZ7i
b2v0+Q3ypcI+/8gc/xh6A9s5nH8FvRd/D2OzCv2J1PfQfbsyx1lZcx6K34rc
g89JpTH5ks8bkVvxMYE8h/DRB/Zb5voswd+81LbfY3OAs3+j/4ncqW/0pYVr
rbg6/1VmfA34VaXzbKB/xDqK/iPyGPg/6G2lc1I+LcRvZY1njil5WLUlh+mp
7/gi+48G96iGnlaONxsf+6P/QfRt4Fs4MwVsU2k+9ILdw2quu8/dsddPpcaU
T1p3/3RH1fjW1Pmfxs8p/KR8j2Tu9zbwMbDu0rr68EFwnt+CbYy9exbsLfTR
mus6NXVtU7CeyvG0/2SwzWOcPRKc1yj8GcKml1wmYrO6dE6XoK8vnccFbPrR
L1YNka2l69WPzZzKvFgI1sjNgX+RD0b7I6pr6rv/jrwjNbdbObsSm8vQF+Nj
CWsyOawD70ffgN2blXmgXk8I7o3qOaN071W3azL3TzURx2+um5PqVSP26zXy
WVt5bywzh5SDYnzC93vor+PzWuxvqJm/iwpzZj5n7s9cN9VUtZXNp6nvrT4u
x/beyvf8hVi10nZ/kfOZ4Bg9mfuqPo6Ls4Xj9uN/YeY8j4MPRVxvtLvwO52B
vKhy7TQP0vh+1RPVWnWenDpX5anan4+46qJeqS9NxFlUN+eV69y6+XMA23cq
7ymGclI+64Nnme69ItZXPifVXTtxdRdnX67sS+9BPRSu93eycN9XoXeUnn8b
1MfgGaBcVdtOZF55Rqg36qnybmGdDOaieLgGm1dzz7aeWEu9u+HMXNZ8yLBP
Ct+3hv5fbj+ar+1xxl7HfkfwXBpBPxfn7ftgO4PnZYVsZl0a7y1O6e5Dpfuh
Ot3F/oeV830E2Ve5NtOQHZVnquJ0FY51O9htlWfAXPA7g2f058FvSXw6iv5F
8J2+zlxT8f95sHXBXGnGR1NlLnfFGaw8N5PbhcJcqLOfVfYhPr4ROXl35fev
ev1cepYpxlnkx7nfqM6Pxtp+Bv5u7ncsTii++H85uXTG97JP/5TcbyIUrp3y
0RzRXBGfTwS/E/FOs1ccFIeXgS8N7ueVyPbCfBBf2iNnNG8eijNnNTbPBfNG
nFT91N9zwbNDvGzEmarZMga2N/5TNF9/ijNWfgeizXTOnsr9PhaXnpsz475m
uO5yNng+6k4jwdxS3PnI+4L70FH4Dp3x36d76o4t4G3BsZriP0c2awvPMuU6
kf3juXM/X3jui98LwB8IzkP/+T3B/1rxbl4w9zYXPiP7vvhfFd92YHMo9z9W
vDiRu7f/AzyQBBg=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlUuIV2UYxr//mTnnfMdLziDpoJDKOI3hpI5a0iJQR7yXOoGh6QhtdBKS
VNLIcsxbi0CcGm+gbvI2JbrIsTEosCRSu4GTRqkoBi1ScdNKs9/DcxYvvM/3
Xs57P6NeX9P6ZhJC2AhVQ815CMOyEBoqIRyAhsUQ2qGWKr9NRz4B+WT4r6Ax
4D7knyKfgqOXihC+5u1fZP1x+BuyH8F7K9apgz/J23b4seg/Da7F31PId0Mf
YX+51J+FfZP00xDmw7+Q2Pc30PnE35gGX4NNH/7m8NaA70aoH7gJ+V34PnSO
wJ/lbSe6veBt4Kn4/Anfn0DPww/Gvhb5O9G5yWcn+EpprxgS8N/gHvBF5IcK
10T6S+QD2yehx4lzyuAXQuPRHQo+he5p6EvkD8BX+fZpaCG2dbxdoxbz8Lm6
zG8stluhpdhPAgf4udAz4Brw+/AjoYnwi3m7i+970G3se3mrx9/byE9WXI9N
+F4EXltxzvWFvyHfd7A/AT8ot3wL+EX4XuJbhu5MfLahf4e3BL6Ot8/Rr4Jq
0d+G/lpk66DJZf6PsR0MXl+xzmb4DzPPlublIfIneHsLPAh6A1/Dy/lTzNej
Z0y63fj/Alln7lguIO8CLy8cyy7ejoJTcGfiHrWDv8XHysQ9Vy7vRddKOe3B
V1fu+g1PXJuYuVeqwRxwFzZTql3zFeCacl47oB3YVgrPgr65Atn8wrOvHp5L
PaOazTbeDiDbXzg2xbsAf8eja60ZeRXdxblr1Yh8Brq/Zp4V5aDd+Tl1rbVD
++Dbcss0U1WFayLfl5B/hn539Kys007CD4iOXTku1bxjvxX9IcR3JnXPVV/N
0Hl0V2WunfLpBbdCzfjeBU0rvNPa5QT7FvAvZbx6GwA+kXkWVZ/d8Peid1k7
dZjvtWtmEu/0d9E11Lf24n8g9t2lvWI6Gr2z2tUO5C8j/z3zrsjHf8jmRc+T
ch6B/Ebq3t5CP6g/0bVQjXv49vTCsStm7XZ14dqpRy3gBvBf4B/A98H9lWOV
Y/oY37M0o+Dn8NEBPy7zPn1f8ezU5O6lZmh29A4rNtnoFl2IzlU1rs9dY9VW
O/Qn+HrufmrntujWFp4lxbNT+5T7dmhntJuvFe6l9FWLY9G1Uk2uEM8RaEa1
b9Qr0TdKs6Ceboy+oboVi8D9Cs+4eqecdRtHZ5br5ml2/om+rZqh5sw1U2z6
RzwLnpp7V7Vj28FXo3ulG/8HsfSkvp262ct0XzLHLn+ajeOp/wWyWRV9E3QL
9E9aov0v5083Rrfk3cK9UL6j4W+mvm3qoXblYOrbr53ZAN6U+d+jmdQt3hCd
u26yaqV/kGSqWSe696Nj0/x+ED1jmi3d6B3Ir0XfK+XXBN4cPQvKf3zmHqo+
mhHd2kepb5/uzf/T4t3c
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.7883306985958118, 0.855568164688984, 0.9025175580594148], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtlUtoV0cUxsfc/73/uTb4QIuvRSu6EJW2uFYkkoWSIuZvqykqPpHERYON
FgraaIK6EGMNPqiIq0Zbq+6q+MLW7nxEojFqrIIgrqpd1DauxN/HN4thvjlz
5tzvnPnO3Okb2mtf14UQehgZoy8PYZDRDn7ORj/Gg+DpMYQORpX1Cfa/ANew
/1xgK+13DBzBZ0aFsKH0WribvTmZ/adwbjOjjvU6fF5WQ3hW528NZPYfAX8G
bsb/R3yOM1ZUQqhw7ivGG/aH4TAW+w/4/MJ36kuf/5e9eensUebrrL8lZsSn
OTruInwv8N1r2sM2g71l2N+Ad2Dv5GyJz99V81qB/QpjXXC8I/huBLdy7kb0
eg38Vmbmswb779Hf/Yk4u8Wbva34dKU6jMa2MjrX0dhv1TnmYvAdcEewrZ71
PuL0ZbYLi+Pa0jw3gU/mPjsZ3IB9OXgADo3gCueHODeJuZezL7CvLr1W/toX
zzNw+TWa35e6n+hatjFPTff1EfMYzhbgDHw23cVNvru/NN/74OXge+A74KFo
3ofh2J/7Xv7B1guPS8Tpx+dJ8qln/oDxFtxEjEeFa9MMfgYeC36K/1+Mh/g8
wHdW1bU6R+y5Vev2XHQtVIdxnG0AHwJ/jP37aP6X8F9QtbZPY2tizMbeg/+B
0vcwzP5/0fXLsZ2Cw218tkszjAj+jnk8ezXwevBExjv8V0XrVfWR7naU1p70
vrG05rdG11R8rmK/UrW+Bpl7Uw0/ZH9CitnJPLewzj4Hh8J9Je7vcvOX1j4t
rDfFW1I65p/Y2wr3xGvsr5K2H2LfU1hf06L7U3et3FqSnmvE2FlYP9JHd9Kw
vq38hJWPelSa3BldX9V2JLqOqqHuWzkpzunc2pVuB6M1JP3MTj0sndzI3Jdd
wfmIk+7xMVyWlu4NaepUtL/0ofjSwDC29sL9ch6fodxx9nBuL2Mhvi3Rb5n4
K/a2iuO3pH5W7n/gczG9FYtL97b6RXfQkXykReWn3LtSnysH6Vj9rXdjfsVr
4W+iOYmPtHk593elx99S3fSGjaQ6dKS3RTqR3p9Ga158q6km0qXuQO+n3sVt
0dwaM9dR31I97kfXRHfcmOzjsK/FPj9L71x666Q52YSVv2qmnppZWPfSvPS+
KelzGvYt0XHv5u5D+SuG8lecT/DZFV1jca8l/sqpNeW1LO2Jm3q6L/2PpMH/
o/XzHl1/2Hs=
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtlElsjlEUhq//6//996OhIiJhg1ohiLVEiAUhokUHQ5QiaqFKWZlS00JM
DWJIbMzTxhhCUCsxBdVSQyKR2BgWxpV43rzf4ibnPdM995z33GFLmqtXFUII
DZwyTnsaQmcphBcobyYhNIFvge+CD4GzGEJENw75D7qrWQjz0f1EXkOClcjH
sHdgn8LZBN7I2UvuFBzxzzgf8T/fK4Ry5MOp5efYB+BbAZ6A/A+fy9jnovuB
3EL+PtE16O6/nGvFEL6VnE93bEN+z+kGbwbPic6h2GrwYPCQ1LUVOMvAe7BP
xb42uPb16GYlfsMCbJvQtVPfIHxmgleBd6p28BXwM2qYHfz+VmLXqUfE7kO3
BfkEPgux1aEbS+yI3F7P+UytR7DXYP9AzUczv0G1S7cDPC86/0RwJfHDwaXE
Na5Abop+i+rvQn4VLT8p2HcEMdWJY3qBz3PaEve0A3kx9zXif1Az474F6gHv
K+O+Lt42JM/fhs9q5JboWarfvzT76Hq7yPeOXG9LljWDi9E9Um/EkS/YzpL/
aeKZ1WKvieafZqq3Xs399eaX4E7Oo4J7/pX4c6m5onjN5ns0VzWja8T2FN37
tWWeVTf2U4nj27CXR3NnAvYN4AP4VwVzeja4OnMu7cAH4l/m+9AP/+P43s73
QT3rj28FZ39wj0+nnqlm+RjciG1JZn5Ld5q7z3BGJr6zHdslcjYH37Eb/LTk
2YmTt7CdzMwV3bEL+UzRd6snmt10dL3LrNPsHkTvqmYo7m0G1ybmYCNyVea3
6E7tXjFzrarxHvb7nDsFx0/CNjkz1jy24/8kr089fQ1+WHItquEtsT3RvZZP
KTNnxBXNvB65LnoXxYfr2IflfG7VDiKvieaadJXRPrJpZ5ZH76z4LU42iL/R
f4U4VND/QE3jc373zcwJcUGcXRrdA71dMeLqp9S7Lc4G5CT/z0Ylftub1Luu
N/4reoeUWzPsBA/M71fOafpLMvdOHPmtvyo6tzhVR64Z0bm3Jq61d/6fqeYb
3Lc9866r5/p7V6TeTeXT3zEm9V+ifizCtyEzt7SDF6LvUG7t+KJozovr+lOv
k+956t1W/tHIQ/N9Fkf+A+omyC8=
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.8472440742516545, 0.8752142056677225, 0.8761244185597954], 
      EdgeForm[None], GraphicsGroupBox[{PolygonBox[CompressedData["
1:eJwtVElrU1EYvcl9ee/egCKCtqELibrSpU1XFnXhCEasQ52gbRwqBW3VCm7b
2C4UhZIIisNGsAU3InUg1Fr/gLYmVKzgsHDn0jgsBM/h3MXH/d53v/Hc8718
abDrfNoYMwyxkKfemIPOmE34GIP+IjGmnDLmDWxzkCrskxljruNuR2TMCdj6
Y2NGUro7m5Z/J/QJyCj0bTifwPc29Bnke4D4OfgNQF9A/DB0C58ifB7D5xly
L4fUQxzj18M+ijrz8L8FfSX01dDXpNQr67dC/sA2grtx5JxlfZyTKeUt4nsj
zn+QLVaxJdQ5CWlDnYuIveTk12E1Rw6Sh+25V2wWuo9Vaxn0bCyfrWnVoM9b
zHXDa9487s/BbwP0Ppy9TthM4/6YUx3OzljOeBi2bkg7bPsgtZBze6RZ2HsO
OX/4gAlsKyLZiUNnJCzmI+HKHnbCdxExTejvkXsA+hDuJtKa2+K8A1u/Ux+5
SPjRfgWzVL3qTLEuvl/Cpwu2A16167B9jtXDXqt7zjuNd74Ln274tGTxXln1
tQD7VdhXIecgat7zmnMXzt0QB58ZJ3yJLeehLzEnv3jPWTjHHq9ZGlZ8YZ4K
bB8TvTu50Oc1D/lVDFifRu4zTtzi+6yN1fN+8sGJH0M4E6+ZyFfWaQZuk9fk
j2e/kHdWvEg79cl6r6x6YC/VWDrnGA1cfWj1RuTzd9x/SYT5EeQ4CilY2b4G
e80JO+ZoQK875biP+oVEHNwMjHsS4dQLe4/Xe970mpnzHnLac/LlG3zHEnHh
uBMvOwL3GgFP7lw5Vp8XnHAhJr9x/nLaM+5iS9hHxvAtiOdSRvvM75+4bzrh
QgzIceLAPRgPdWehv4ZUoF/mv8GpF85TCTtZhm/JKQf/Me0hH7lfCP+CWthJ
7g7fjf8q9s89Xudk5zufCm9N/P46xTCeecg94kL+ktN8qymrnVqC7yen7w+x
dozcaINtMaOd5o62xtrTa9AfZbTH5ArzMud/EDGmbA==
         "],
         VertexColors->None], PolygonBox[CompressedData["
1:eJwtk0tsjVEUhc/tf+/9z38HiKBtOmiKEUOPEcGAIGlFPUqQPjSIQa9nYsBA
qx0QkqZXEGUi0SYSMZCQtqqmBl5tKq1EGDBhqB4DiW9lGezkrLP22Y+192no
KDd3VYUQGrE89j0NIctCeJ2E8DQXws8YwoViCN04jXP3B3wL/ABuI3dvwd3g
6+Az4MjbG+D+KsdoB38BJ+A+7Cj+teDlOceYAB8CH4Or4F/D+RtvHuXtM5/z
bCGESbgp7Bn+Y4oB16Oc0T7idmDTvF9Xcrw5+Fa486lz1xJzO/h90dwJ1cN5
hBiLOV/kLoUfLrr3RtUDd5m7zbz9y90oeC+2Gq4fu09t51LrI5+vnNsy51LP
reBx/AcS13SacwO2klhNiXvfin/Mmy+DZ+GHE+t5Ca4H6865xiX0djw194Y3
t+G6outtAT+P1kjaKOcovmPYxH89pMUP+STWZBHndmw9uB7+iLSN1n4Td4cz
96Re6og/y/lX9C4M5TzrjsycZt4CV8JqctboJf5T4HuJd6SC70Dmt9LsCfyL
6Nmr5qXEK4NHOK/AHqLvqWitmsjRx9vezL5rE+9mM3hB3vGqo2emWamfzuge
dd6Afyf5hoi5Je/5fwJ/Tl27etyWWTNppZl84O0r8M2cZ9IWvQOavTSb4Vxd
8izko1k0FF27ZtIBXlh0fs1wkNz7uFuj97y5Sr5rmbXW+93RPuJWcTcZvROa
tzQcxPdO5r8njT7C7czcm3qugH9Hz1Ya94DfRfcq/efhWx9dn/6U/pp6UG79
OXEno3dfPr30/rjg3ZJGu/CfTJ1Lmi/D92z039NO5zkfiJ6N/qh2qQ5LEu9U
iXoORv818XcLnonq045eybwzqlUz2h8dU77SbC56B9WbdrgKvCdaK+3cdME7
o11Rzn+MEpds
         "],
         VertexColors->None]}]}, 
     {RGBColor[0.906157449907497, 0.8948602466464609, 0.849731279060176], 
      EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{832, 291, 114}, {768, 288, 112}, {725, 510, 404}, {1666, 
         2257, 929}, {2237, 2239, 914}, {2258, 1667, 930}, {2159, 1570, 
         844}, {1031, 403, 98}, {425, 291, 128}, {834, 960, 129}, {1294, 1337,
          98}, {2236, 2237, 914}, {403, 1031, 389}, {1031, 1033, 389}, {930, 
         928, 389}, {406, 928, 114}, {2296, 1684, 959}, {928, 929, 114}, {
         1663, 1785, 403}, {1257, 1031, 98}, {1838, 1668, 406}, {1751, 2378, 
         1033}, {912, 823, 97}, {2014, 1839, 425}, {729, 1050, 404}, {2140, 
         1546, 823}, {2442, 2072, 769}, {1201, 834, 832}, {1554, 2146, 830}, {
         1112, 844, 129}, {403, 1294, 98}, {768, 830, 97}, {761, 1294, 288}, {
         2539, 1560, 935}, {1765, 2401, 1050}, {2158, 2459, 843}, {1893, 1663,
          403}, {2234, 1639, 912}, {844, 842, 129}, {1668, 1894, 406}, {291, 
         832, 129}, {830, 1086, 97}, {2072, 2071, 769}, {425, 729, 404}, {928,
          406, 389}, {832, 834, 129}, {935, 832, 114}, {1561, 2151, 834}, {
         914, 1337, 761}, {842, 843, 128}, {1569, 2158, 843}, {2435, 2436, 
         1086}, {291, 842, 128}, {1460, 1925, 128}, {1337, 914, 98}, {729, 
         425, 128}, {2265, 2539, 935}, {2583, 2265, 935}, {1912, 1446, 112}, {
         2461, 2460, 1112}, {730, 729, 128}, {761, 288, 97}, {510, 725, 
         112}, {823, 761, 97}, {2238, 1887, 98}, {1914, 2014, 425}, {1337, 
         1294, 761}, {2017, 2016, 730}, {291, 406, 114}, {1786, 1992, 510}, {
         725, 1101, 112}, {1294, 403, 288}, {959, 725, 404}, {1992, 1915, 
         510}, {288, 768, 97}, {288, 510, 112}, {1898, 2582, 114}, {769, 768, 
         112}, {2451, 2452, 1101}, {842, 291, 129}, {935, 1201, 832}, {2620, 
         1750, 1257}, {1689, 2297, 960}},
         VertexColors->None], 
        PolygonBox[{{1560, 2540, 1201, 935}, {2401, 1665, 404, 1050}, {1664, 
         1914, 425, 404}, {2256, 1666, 929, 928}, {2378, 1642, 389, 1033}, {
         1639, 2140, 823, 912}, {2157, 1569, 843, 842}, {2146, 2435, 1086, 
         830}, {1684, 2009, 725, 959}, {2239, 2238, 98, 914}, {2151, 1689, 
         960, 834}, {2009, 2451, 1101, 725}, {1546, 2061, 761, 823}, {1887, 
         2620, 1257, 98}, {2540, 1561, 834, 1201}, {1839, 1559, 291, 425}, {
         2061, 2236, 914, 761}, {1489, 2234, 912, 97}, {2452, 1912, 112, 
         1101}, {1915, 1664, 404, 510}, {1570, 2157, 842, 844}, {1667, 2256, 
         928, 930}, {1750, 2375, 1031, 1257}, {1559, 1838, 406, 291}, {2460, 
         2159, 844, 1112}, {2459, 1460, 128, 843}, {2015, 1765, 1050, 729}, {
         1446, 2442, 769, 112}, {1845, 2461, 1112, 129}, {2070, 1554, 830, 
         768}, {1643, 1893, 403, 389}, {1785, 1784, 288, 403}, {1925, 2017, 
         730, 128}, {2582, 2583, 935, 114}, {2297, 1845, 129, 960}, {2016, 
         2015, 729, 730}, {1894, 1643, 389, 406}, {2071, 2070, 768, 769}, {
         2257, 1898, 114, 929}, {2436, 1489, 97, 1086}, {1665, 2296, 959, 
         404}, {1784, 1786, 510, 288}, {1642, 2258, 930, 389}, {2375, 1751, 
         1033, 1031}},
         VertexColors->None]}]}, 
     {RGBColor[0.941176, 0.906538, 0.834043], EdgeForm[None], 
      GraphicsGroupBox[{
        PolygonBox[{{645, 714, 113}, {1643, 1894, 625}, {728, 645, 113}, {
         1893, 1643, 625}, {534, 644, 113}, {714, 534, 113}, {571, 728, 
         113}, {647, 571, 113}, {1664, 1915, 645}, {644, 625, 113}, {1838, 
         1559, 571}, {1784, 1785, 534}, {625, 647, 113}, {1786, 1784, 534}, {
         1914, 1664, 645}, {1559, 1839, 571}},
         VertexColors->None], 
        PolygonBox[{{1915, 1992, 714, 645}, {1894, 1668, 647, 625}, {1663, 
         1893, 625, 644}, {1785, 1663, 644, 534}, {1668, 1838, 571, 647}, {
         1992, 1786, 534, 714}, {2014, 1914, 645, 728}, {1839, 2014, 728, 
         571}},
         VertexColors->None]}]}}, {{}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1914, 1664, 1915, 1992, 1786, 1784, 1785, 1663, 1893, 1643, 
         1894, 1668, 1838, 1559, 1839, 2014, 1914}],
        "0.18`"],
       Annotation[#, 0.18, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2070, 1554, 2146, 2435, 2436, 1489, 2234, 1639, 2140, 1546, 
         2061, 2236, 2237, 2239, 2238, 1887, 2620, 1750, 2375, 1751, 2378, 
         1642, 2258, 1667, 2256, 1666, 2257, 1898, 2582, 2583, 2265, 2539, 
         1560, 2540, 1561, 2151, 1689, 2297, 1845, 2461, 2460, 2159, 1570, 
         2157, 1569, 2158, 2459, 1460, 1925, 2017, 2016, 2015, 1765, 2401, 
         1665, 2296, 1684, 2009, 2451, 2452, 1912, 1446, 2442, 2072, 2071, 
         2070}],
        "0.16`"],
       Annotation[#, 0.16, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2150, 2073, 2075, 1494, 1454, 2162, 2163, 2081, 2486, 2083, 
         2165, 2164, 2319, 1498, 2485, 2318, 2079, 2161, 2160, 2311, 1704, 
         2028, 2313, 2312, 1687, 2402, 2403, 2022, 2400, 2399, 1916, 2292, 
         2293, 2010, 2295, 2294, 1661, 2386, 2387, 2003, 1758, 2385, 2147, 
         2148, 2068, 2145, 2144, 2235, 2134, 2135, 2058, 1545, 2050, 2133, 
         2482, 2132, 1436, 2136, 2137, 2052, 2139, 2484, 2138, 2438, 2437, 
         1975, 2241, 2240, 1629, 2376, 2377, 1979, 1980, 1438, 1892, 1447, 
         2443, 1994, 2260, 2259, 1647, 2266, 2267, 1998, 2445, 2446, 2149, 
         2150}],
        "0.14`"],
       Annotation[#, 0.14, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2057, 1544, 2129, 2428, 1428, 1486, 2214, 2215, 2123, 1534, 
         2049, 2218, 2219, 1624, 2124, 1536, 2051, 2220, 2483, 1487, 2221, 
         1816, 2369, 2370, 1974, 1745, 2372, 1628, 2243, 1641, 1978, 1640, 
         2242, 1889, 2379, 1752, 1993, 1753, 2382, 1646, 2263, 1669, 1997, 
         2262, 2261, 1832, 2269, 2152, 2153, 2074, 1563, 2154, 1691, 2166, 
         1571, 2082, 1572, 2169, 2321, 2320, 1857, 1466, 2468, 2177, 1583, 
         2084, 1582, 2176, 2467, 2175, 1580, 2080, 2174, 2173, 1465, 1853, 
         1461, 2030, 2029, 1705, 2316, 1688, 2309, 1702, 2023, 2457, 2458, 
         1924, 2013, 2012, 2011, 1764, 2396, 1662, 2287, 1682, 2004, 2450, 
         1453, 1836, 1445, 1492, 2069, 2067, 1552, 2143, 2434, 2060, 2059, 
         2057}],
        "0.12`"],
       Annotation[#, 0.12, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{1806, 1532, 1877, 1531, 1884, 1533, 1807, 2217, 2216, 2127, 
         2128, 2054, 2131, 2130, 2233, 1827, 1828, 1907, 1906, 1553, 1830, 
         1659, 1834, 1660, 1911, 1557, 2286, 1681, 2005, 2285, 2284, 1913, 
         2394, 2395, 2020, 2398, 2397, 1685, 2307, 2308, 2024, 2306, 2305, 
         1926, 2314, 2315, 2031, 1706, 2317, 1578, 1938, 1716, 1791, 1715, 
         1856, 1581, 1941, 1942, 1793, 1502, 2335, 2178, 2179, 2091, 2339, 
         2489, 1503, 2340, 2341, 1859, 1585, 1944, 1794, 1943, 1584, 1858, 
         2462, 1462, 1499, 2087, 2085, 2168, 2167, 1456, 1495, 1789, 1928, 
         1927, 1562, 1841, 2000, 1788, 1672, 1919, 1556, 2264, 1670, 1996, 
         2444, 1448, 1897, 1439, 1983, 1982, 2381, 2380, 1631, 2244, 2245, 
         1977, 2439, 1437, 1886, 1432, 1968, 1967, 1744, 2371, 1538, 1885, 
         1625, 1814, 1964, 1811, 1535, 1878, 1879, 1809, 1808, 1429, 2121, 
         2481, 2122, 2048, 2120, 2119, 1427, 2427, 1806}],
        "0.1`"],
       Annotation[#, 0.1, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2213, 1962, 1963, 1426, 1805, 2199, 2200, 2198, 2202, 2201, 
         1779, 1780, 1612, 2113, 1527, 2047, 2203, 2204, 1613, 1802, 1529, 
         2206, 1616, 1954, 1955, 1421, 1810, 1430, 1812, 1813, 1881, 1880, 
         1537, 2223, 1627, 1966, 1626, 2222, 1818, 2373, 1746, 1976, 1747, 
         2374, 1630, 2247, 1645, 1981, 1644, 2246, 1825, 2249, 1649, 1995, 
         1650, 2252, 1555, 1917, 1918, 1787, 1493, 1450, 1840, 1455, 2453, 
         2019, 1690, 2298, 1565, 1842, 1692, 2170, 1573, 2086, 1574, 2171, 
         1708, 1860, 1586, 2343, 2344, 2342, 2588, 2587, 1504, 1467, 2469, 
         2033, 2346, 2345, 1591, 1865, 2475, 2183, 1590, 2092, 1589, 2182, 
         2474, 1862, 1587, 2338, 1719, 2036, 2337, 2336, 1855, 1937, 1501, 
         1792, 1951, 1950, 1579, 2334, 1713, 2032, 2465, 2466, 1851, 2027, 
         2026, 2025, 1703, 2310, 1686, 2304, 1700, 2021, 2455, 2456, 1843, 
         2008, 2007, 2006, 1683, 2289, 1558, 1921, 1922, 1835, 1833, 1910, 
         1829, 2253, 2254, 1989, 1656, 2255, 1550, 1826, 2433, 2056, 2055, 
         2053, 1543, 2126, 2426, 1782, 1781, 2212, 2213}],
        "0.08`"],
       Annotation[#, 0.08, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2572, 2423, 2424, 1419, 1798, 1799, 1604, 1952, 2420, 1416, 
         1483, 1873, 1797, 2568, 2569, 2194, 1606, 1801, 1800, 1420, 2114, 
         2115, 2046, 1528, 2205, 1615, 1953, 1614, 1875, 1609, 2208, 1618, 
         1957, 1958, 1422, 1815, 1431, 2429, 1965, 2225, 2224, 1539, 1948, 
         1949, 1783, 1488, 1888, 1883, 1890, 1822, 1823, 1896, 1895, 1547, 
         2250, 2251, 1985, 1986, 1440, 1831, 1449, 2447, 1999, 1671, 2268, 
         1653, 1900, 1674, 2018, 1675, 2274, 1564, 2076, 2078, 1496, 1457, 
         1846, 1847, 1707, 2322, 2324, 2323, 1848, 1935, 1861, 1468, 2035, 
         2034, 1720, 1795, 1505, 1469, 2471, 2470, 2590, 2589, 1592, 2594, 
         2595, 2591, 2593, 2592, 1508, 1796, 1729, 2352, 2354, 2353, 1867, 
         1476, 1866, 1472, 2041, 2040, 1728, 1864, 1863, 2351, 1507, 2492, 
         2350, 2096, 1588, 2349, 1726, 2037, 2473, 1939, 1717, 2410, 1773, 
         2409, 2624, 2623, 1854, 2330, 2331, 2329, 2333, 2332, 1577, 1933, 
         1934, 1850, 1849, 1464, 1931, 1459, 1497, 1790, 1930, 1929, 1568, 
         2290, 2291, 2288, 2586, 2585, 1837, 2281, 2282, 2280, 1679, 2283, 
         1657, 1908, 1991, 1990, 1757, 2384, 1551, 2065, 2142, 2141, 2232, 
         1820, 1821, 1636, 1973, 2432, 1435, 1819, 1425, 1485, 2579, 2580, 
         2210, 1622, 1804, 1803, 2574, 2575, 2573, 2577, 2576, 1778, 2571, 
         2572}],
        "0.06`"],
       Annotation[#, 0.06, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2104, 1520, 2103, 1519, 2565, 2566, 2562, 2564, 2563, 1482, 
         1415, 2416, 2415, 2525, 2524, 1525, 2526, 1526, 2112, 1611, 2197, 
         2643, 1530, 2532, 2116, 2118, 2117, 2581, 1623, 2211, 2537, 1541, 
         2538, 1542, 2125, 1637, 2230, 1638, 2231, 1549, 2064, 2066, 1491, 
         1444, 1904, 1452, 2449, 2002, 1677, 2279, 1658, 1909, 1762, 2392, 
         1763, 2393, 1680, 2303, 1698, 2301, 1697, 2302, 1844, 2621, 1768, 
         2404, 2406, 2405, 1701, 2327, 2328, 2325, 1711, 2326, 1852, 2622, 
         1771, 2407, 1772, 2408, 1714, 2348, 1724, 2347, 1723, 1940, 1718, 
         2411, 1776, 2038, 2039, 1471, 1945, 1474, 2185, 2186, 2097, 1594, 
         2356, 1733, 2355, 1732, 2187, 1595, 2100, 2357, 2358, 1734, 2359, 
         2188, 2189, 2101, 2360, 2361, 1735, 2190, 1596, 2102, 2362, 2601, 
         2602, 2476, 2477, 1477, 1868, 2597, 2598, 2596, 2600, 2599, 2099, 
         2098, 1593, 2184, 2472, 2095, 2094, 2093, 2181, 2180, 2464, 2463, 
         2090, 2089, 2088, 1575, 2172, 2454, 2299, 1693, 2300, 1566, 2077, 
         2156, 2155, 2275, 1902, 2271, 2272, 2270, 1673, 2273, 1652, 1899, 
         1988, 1987, 1755, 2383, 1633, 2248, 1648, 1984, 2440, 2441, 1824, 
         1972, 1971, 1970, 2229, 2228, 1621, 2226, 2227, 1969, 2430, 2431, 
         1817, 1961, 1960, 1959, 1620, 2209, 1610, 2207, 1617, 1956, 2425, 
         1874, 1608, 2368, 1740, 2367, 2619, 2618, 1872, 2196, 1484, 2480, 
         2195, 2045, 1524, 2421, 2644, 1605, 2567, 2422, 2111, 1523, 2109, 
         1522, 2110, 2418, 2419, 2107, 2108, 2105, 1521, 2106, 2417, 2104}],
        "0.04`"],
       Annotation[#, 0.04, "Tooltip"]& ]}, 
     {GrayLevel[0], Opacity[0.4], 
      TagBox[
       TooltipBox[
        LineBox[{2502, 1514, 2501, 1513, 2556, 2557, 2555, 1601, 1480, 1410, 
         2414, 2413, 2559, 2558, 1517, 2517, 1518, 2518, 2561, 2560, 2520, 
         2521, 2519, 2523, 2522, 2570, 2528, 2529, 2527, 2531, 2530, 2578, 
         2534, 2535, 2533, 1540, 2536, 1634, 2638, 1635, 1548, 2062, 2063, 
         1490, 1443, 1903, 1451, 2448, 2001, 1676, 2278, 1655, 1905, 1760, 
         2639, 1761, 1678, 1696, 2645, 1695, 1923, 1766, 2640, 1767, 1699, 
         1710, 2646, 1709, 1932, 1769, 2641, 1770, 1712, 1722, 2647, 1721, 
         1936, 1774, 2642, 1775, 1725, 1731, 2648, 1730, 1946, 1727, 2412, 
         1777, 2042, 2043, 1475, 1947, 1478, 2192, 2193, 2191, 1598, 1737, 
         2649, 1736, 2549, 1599, 2497, 2608, 1510, 2609, 2550, 2551, 2498, 
         2610, 1511, 2611, 2552, 2553, 2499, 2612, 1512, 2613, 2614, 2554, 
         1600, 2500, 2615, 2635, 2636, 2478, 2479, 1479, 1869, 2604, 2605, 
         2603, 2607, 2606, 2496, 2495, 1597, 2548, 1473, 1509, 2494, 2493, 
         2547, 2546, 1470, 1506, 2491, 2490, 2545, 2544, 1463, 1500, 2488, 
         2487, 1576, 2543, 1458, 2634, 1694, 2651, 2650, 2652, 1567, 2541, 
         2542, 2277, 2276, 2584, 1920, 2389, 2390, 2388, 1759, 2391, 1654, 
         1901, 1442, 2633, 1756, 1651, 1754, 2632, 1441, 1891, 1434, 2631, 
         1749, 1632, 1748, 2630, 1433, 1882, 1424, 2629, 1743, 1619, 1742, 
         2628, 1423, 1876, 1418, 2627, 1741, 1607, 1739, 2626, 1417, 1871, 
         1603, 2366, 1738, 2365, 2617, 2616, 1870, 2364, 1481, 2637, 2363, 
         2044, 1516, 1602, 2625, 1414, 2516, 1515, 2513, 2515, 2514, 1413, 
         2511, 2512, 2508, 2510, 2509, 1412, 2506, 2507, 2503, 2505, 2504, 
         1411, 2502}],
        "0.02`"],
       Annotation[#, 0.02, "Tooltip"]& ]}, {}, {}, {}}}],
  AspectRatio->1,
  Frame->True,
  PlotRange->{{-2.5, 2.5}, {-2.5, 2.5}},
  PlotRangeClipping->True,
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 ImageSize->{184, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->877521465]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->30079],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->831182778],

Cell["The probability density function integrates to unity:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->4348],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NIntegrate", "[", 
  RowBox[{
   RowBox[{"PDF", "[", 
    RowBox[{
     RowBox[{"MultivariateTDistribution", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"1", ",", 
           RowBox[{"1", "/", "2"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{
           RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}], ",", "10"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "y"}], "}"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"y", ",", 
     RowBox[{"-", "\[Infinity]"}], ",", "\[Infinity]"}], "}"}]}], 
  "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16031],

Cell[BoxData["0.9999999865681821`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->390287198]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->2973],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->123967024],

Cell[TextData[{
 Cell[BoxData["MultivariateTDistribution"], "InlineFormula"],
 " is not defined when \[CapitalSigma] is not a valid correlation matrix:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->8964],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultivariateTDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"I", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}], ",", "10"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->95470147],

Cell[BoxData[
 RowBox[{
  RowBox[{"MultivariateTDistribution", "::", "\<\"cmsym\"\>"}], ":", 
  " ", "\<\"The correlation matrix must be symmetric. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:MultivariateStatistics/ref/MultivariateTDistribution\\\
\", ButtonNote -> \
\\\"MultivariateStatistics`.`MultivariateTDistribution::cmsym\\\"]\\)\"\>"}]],\
 "Message", "MSG",
 CellID->923013120],

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultivariateTDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         FractionBox["\[ImaginaryI]", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", "2"], ",", "1"}], "}"}]}], "}"}], ",", "10"}], 
    "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Output",
 ImageSize->{417, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->85769799]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData["MultivariateTDistribution"], "InlineFormula"],
 " is not defined when ",
 Cell[BoxData[
  StyleBox["m", "TI"]], "InlineFormula"],
 " is not positive:"
}], "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->97200626],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultivariateTDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         RowBox[{"1", "/", "2"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "2"}], ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->569941959],

Cell[BoxData[
 RowBox[{"PDF", "[", 
  RowBox[{
   RowBox[{"MultivariateTDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", 
         FractionBox["1", "2"]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         FractionBox["1", "2"], ",", "1"}], "}"}]}], "}"}], ",", 
     RowBox[{"-", "3"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "y"}], "}"}]}], "]"}]], "Output",
 ImageSize->{417, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->765686846]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->15418],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->114246152],

Cell["\<\
Substitution of invalid parameters into symbolic outputs gives results that \
are not meaningful:\
\>", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->16727],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Variance", "[", 
   RowBox[{"MultivariateTDistribution", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"1", ",", "\[Rho]"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"\[Rho]", ",", "1"}], "}"}]}], "}"}], ",", "m"}], "]"}], 
   "]"}], "/.", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"\[Rho]", "\[Rule]", "1"}], ",", 
    RowBox[{"m", "\[Rule]", "I"}]}], "}"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2647],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    FractionBox["1", "5"], "-", 
    FractionBox[
     RowBox[{"2", " ", "\[ImaginaryI]"}], "5"]}], ",", 
   RowBox[{
    FractionBox["1", "5"], "-", 
    FractionBox[
     RowBox[{"2", " ", "\[ImaginaryI]"}], "5"]}]}], "}"}]], "Output",
 ImageSize->{121, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->432580884]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->17975],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["StudentTDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/StudentTDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MultinormalDistribution",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/MultinormalDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["HotellingTSquareDistribution",
    BaseStyle->"Link",
    ButtonData->
     "paclet:MultivariateStatistics/ref/HotellingTSquareDistribution"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20440]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25223],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->2034]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MultivariateTDistribution - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 42.5096754}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {"multivariate t distribution"}, 
    "index" -> True, "label" -> "Multivariate Statistics Package Symbol", 
    "language" -> "en", "paclet" -> "MultivariateStatistics Package", 
    "status" -> "None", "summary" -> 
    "MultivariateTDistribution[r, m] represents the multivariate Student t \
distribution with correlation matrix r and degrees of freedom parameter m.", 
    "synonyms" -> {}, "title" -> "MultivariateTDistribution", "type" -> 
    "Symbol", "uri" -> 
    "MultivariateStatistics/ref/MultivariateTDistribution"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5629, 197, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->748265802]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 115342, 2499}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1657, 40, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2280, 67, 63, 1, 70, "ObjectName",
 CellID->29679],
Cell[2346, 70, 755, 23, 70, "Usage",
 CellID->14294]
}, Open  ]],
Cell[CellGroupData[{
Cell[3138, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3616, 115, 864, 33, 70, "Notes",
 CellID->8428],
Cell[4483, 150, 337, 12, 70, "Notes",
 CellID->12798],
Cell[4823, 164, 254, 7, 70, "Notes",
 CellID->16744],
Cell[5080, 173, 512, 19, 70, "Notes",
 CellID->1355]
}, Closed]],
Cell[CellGroupData[{
Cell[5629, 197, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->748265802],
Cell[CellGroupData[{
Cell[6014, 211, 147, 5, 70, "ExampleSection",
 CellID->20145572],
Cell[6164, 218, 147, 4, 70, "Input",
 CellID->163071191],
Cell[6314, 224, 317, 10, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[6656, 238, 347, 12, 28, "Input",
 CellID->24173],
Cell[7006, 252, 202, 7, 36, "Output",
 CellID->83049836]
}, Open  ]],
Cell[7223, 262, 125, 3, 70, "ExampleDelimiter",
 CellID->246746483],
Cell[7351, 267, 147, 4, 70, "Input",
 CellID->306170077],
Cell[7501, 273, 212, 5, 70, "ExampleText",
 CellID->472395019],
Cell[CellGroupData[{
Cell[7738, 282, 350, 12, 70, "Input",
 CellID->8902],
Cell[8091, 296, 247, 9, 51, "Output",
 CellID->529569837]
}, Open  ]],
Cell[8353, 308, 119, 3, 70, "ExampleDelimiter",
 CellID->675],
Cell[8475, 313, 147, 4, 70, "Input",
 CellID->139847556],
Cell[8625, 319, 204, 5, 70, "ExampleText",
 CellID->6303],
Cell[CellGroupData[{
Cell[8854, 328, 426, 15, 70, "Input",
 CellID->30324],
Cell[9283, 345, 1378, 46, 106, "Output",
 CellID->61956831]
}, Open  ]],
Cell[CellGroupData[{
Cell[10698, 396, 733, 25, 47, "Input",
 CellID->20649],
Cell[11434, 423, 19147, 318, 158, "Output",
 Evaluatable->False,
 CellID->472721149]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[30630, 747, 215, 7, 70, "ExampleSection",
 CellID->8098],
Cell[30848, 756, 147, 4, 70, "Input",
 CellID->333501359],
Cell[30998, 762, 331, 10, 70, "ExampleText",
 CellID->24449],
Cell[CellGroupData[{
Cell[31354, 776, 646, 21, 70, "Input",
 CellID->5765],
Cell[32003, 799, 1791, 50, 105, "Output",
 CellID->208342017]
}, Open  ]],
Cell[33809, 852, 120, 3, 70, "ExampleDelimiter",
 CellID->3561],
Cell[33932, 857, 147, 4, 70, "Input",
 CellID->731715559],
Cell[CellGroupData[{
Cell[34104, 865, 602, 20, 70, "Input",
 CellID->6096],
Cell[34709, 887, 213, 7, 36, "Output",
 CellID->860193105]
}, Open  ]],
Cell[34937, 897, 120, 3, 70, "ExampleDelimiter",
 CellID->2948],
Cell[35060, 902, 147, 4, 70, "Input",
 CellID->196293435],
Cell[CellGroupData[{
Cell[35232, 910, 602, 20, 70, "Input",
 CellID->6916],
Cell[35837, 932, 213, 7, 36, "Output",
 CellID->392596043]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36099, 945, 222, 7, 70, "ExampleSection",
 CellID->3719],
Cell[36324, 954, 147, 4, 70, "Input",
 CellID->926512319],
Cell[36474, 960, 309, 10, 70, "ExampleText",
 CellID->2750],
Cell[CellGroupData[{
Cell[36808, 974, 746, 25, 70, "Input",
 CellID->19414],
Cell[37557, 1001, 67838, 1137, 70, "Output",
 CellID->877521465]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[105444, 2144, 233, 7, 70, "ExampleSection",
 CellID->30079],
Cell[105680, 2153, 147, 4, 70, "Input",
 CellID->831182778],
Cell[105830, 2159, 228, 5, 70, "ExampleText",
 CellID->4348],
Cell[CellGroupData[{
Cell[106083, 2168, 780, 26, 70, "Input",
 CellID->16031],
Cell[106866, 2196, 176, 5, 36, "Output",
 CellID->390287198]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[107091, 2207, 225, 7, 70, "ExampleSection",
 CellID->2973],
Cell[107319, 2216, 147, 4, 70, "Input",
 CellID->123967024],
Cell[107469, 2222, 323, 8, 70, "ExampleText",
 CellID->8964],
Cell[CellGroupData[{
Cell[107817, 2234, 481, 17, 70, "Input",
 CellID->95470147],
Cell[108301, 2253, 460, 9, 70, "Message",
 CellID->923013120],
Cell[108764, 2264, 578, 20, 51, "Output",
 CellID->85769799]
}, Open  ]],
Cell[109357, 2287, 356, 11, 70, "ExampleText",
 CellID->97200626],
Cell[CellGroupData[{
Cell[109738, 2302, 497, 17, 70, "Input",
 CellID->569941959],
Cell[110238, 2321, 582, 20, 51, "Output",
 CellID->765686846]
}, Open  ]],
Cell[110835, 2344, 121, 3, 70, "ExampleDelimiter",
 CellID->15418],
Cell[110959, 2349, 147, 4, 70, "Input",
 CellID->114246152],
Cell[111109, 2355, 281, 8, 70, "ExampleText",
 CellID->16727],
Cell[CellGroupData[{
Cell[111415, 2367, 496, 17, 70, "Input",
 CellID->2647],
Cell[111914, 2386, 420, 15, 51, "Output",
 CellID->432580884]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[112395, 2408, 311, 9, 70, "SeeAlsoSection",
 CellID->17975],
Cell[112709, 2419, 842, 27, 70, "SeeAlso",
 CellID->20440]
}, Open  ]],
Cell[CellGroupData[{
Cell[113588, 2451, 314, 9, 70, "TutorialsSection",
 CellID->25223],
Cell[113905, 2462, 191, 5, 70, "Tutorials",
 CellID->2034]
}, Open  ]],
Cell[114111, 2470, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

