(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10760,        378]
NotebookOptionsPosition[      8130,        294]
NotebookOutlinePosition[      9516,        332]
CellTagsIndexPosition[      9432,        327]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolytopeQuantile" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/PolytopeQuantile"], 
          "PolytopeQuartiles" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/PolytopeQuartiles"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolytopeQuantile\"\>", 
       2->"\<\"PolytopeQuartiles\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Polytope", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"Polytope", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["v", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["connectivity", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]represents a ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "-dimensional polytope with ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     "-variate vertices ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["v", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ", where the connections between the vertices is specified by ",
     Cell[BoxData[
      StyleBox["connectivity", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Polytope"], "InlineFormula"],
 " objects are generated by ",
 Cell[BoxData[
  ButtonBox["PolytopeQuantile",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuantile"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["PolytopeQuartiles",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuartiles"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->28703],

Cell[TextData[{
 "Two-dimensional ",
 Cell[BoxData["Polytope"], "InlineFormula"],
 " objects can be visualized using ",
 Cell[BoxData[
  ButtonBox["Graphics",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Graphics"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->23811]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->324806941],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->227450720],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->699765764],

Cell["A polytope for bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PolytopeQuantile", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3", ",", "4"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"5", ",", "3"}], "}"}]}], "}"}], ",", ".5"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->270858289],

Cell[BoxData[
 RowBox[{"Polytope", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"3.875`", ",", "2.75`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.875`", ",", "3.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.875`", ",", "2.25`"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.375`", ",", "1.75`"}], "}"}]}], "}"}], 
   ",", "\<\"-Connectivity-\"\>"}], "]"}]], "Output",
 ImageSize->{584, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->514978104]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolytopeQuantile",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolytopeQuartiles",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuartiles"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Polytope - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 44.3378472}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {}, "index" -> True, "label" -> 
    "Multivariate Statistics Package Symbol", "language" -> "en", "paclet" -> 
    "MultivariateStatistics Package", "status" -> "None", "summary" -> 
    "Polytope[{v_1, v_2, ...}, connectivity] represents a p-dimensional \
polytope with p-variate vertices v_1, v_2, ..., where the connections between \
the vertices is specified by connectivity.", "synonyms" -> {}, "title" -> 
    "Polytope", "type" -> "Symbol", "uri" -> 
    "MultivariateStatistics/ref/Polytope"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[4725, 163, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->324806941]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 9289, 320}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1458, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2081, 64, 51, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2135, 67, 1304, 41, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3476, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3954, 130, 459, 16, 70, "Notes",
 CellID->28703],
Cell[4416, 148, 272, 10, 70, "Notes",
 CellID->23811]
}, Closed]],
Cell[CellGroupData[{
Cell[4725, 163, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->324806941],
Cell[CellGroupData[{
Cell[5110, 177, 148, 5, 70, "ExampleSection",
 CellID->227450720],
Cell[5261, 184, 147, 4, 70, "Input",
 CellID->699765764],
Cell[5411, 190, 205, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[5641, 199, 417, 14, 28, "Input",
 CellID->270858289],
Cell[6061, 215, 558, 18, 36, "Output",
 CellID->514978104]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6680, 240, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[6999, 251, 535, 17, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[7571, 273, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[7892, 284, 196, 5, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[8103, 292, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

