(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10225,        336]
NotebookOptionsPosition[      8193,        276]
NotebookOutlinePosition[      9461,        307]
CellTagsIndexPosition[      9418,        304]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolytopeQuartiles" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/PolytopeQuartiles"], 
          "EllipsoidQuartiles" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/EllipsoidQuartiles"], 
          "EllipsoidQuantile" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/EllipsoidQuantile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolytopeQuartiles\"\>", 
       2->"\<\"EllipsoidQuartiles\"\>", 
       3->"\<\"EllipsoidQuantile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolytopeQuantile", "ObjectName",
 CellID->28039],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PolytopeQuantile", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["11", "TR"]], ",", 
            SubscriptBox[
             StyleBox["x", "TI"], 
             StyleBox["12", "TR"]]}], "}"}], ",", 
          StyleBox["\[Ellipsis]", "TI"], ",", 
          RowBox[{"{", 
           RowBox[{
            SubscriptBox[
             StyleBox["x", "TI"], 
             RowBox[{
              StyleBox["n", "TI"], "\[InvisibleSpace]", 
              StyleBox["1", "TR"]}]], ",", 
            SubscriptBox[
             StyleBox["x", "TI"], 
             RowBox[{
              StyleBox["n", "TI"], "\[InvisibleSpace]", 
              StyleBox["2", "TR"]}]]}], "}"}]}], "}"}], ",", 
        StyleBox["q", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the locus of the ",
     Cell[BoxData[
      StyleBox["q", "TI"]], "InlineFormula"],
     Cell[BoxData[
      FormBox[
       SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
     " quantile of the bivariate data, where the data have been ordered using \
convex hulls centered on ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["ConvexHullMedian",
        BaseStyle->"Link",
        ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"], "[",
        
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["11", "TR"]], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            StyleBox["12", "TR"]]}], "}"}], ",", 
         StyleBox["\[Ellipsis]", "TI"], ",", 
         RowBox[{"{", 
          RowBox[{
           SubscriptBox[
            StyleBox["x", "TI"], 
            RowBox[{
             StyleBox["n", "TI"], "\[InvisibleSpace]", 
             StyleBox["1", "TR"]}]], ",", 
           SubscriptBox[
            StyleBox["x", "TI"], 
            RowBox[{
             StyleBox["n", "TI"], "\[InvisibleSpace]", 
             StyleBox["2", "TR"]}]]}], "}"}]}], "}"}], "]"}]], 
      "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28476]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PolytopeQuantile"], "InlineFormula"],
 " returns an ",
 Cell[BoxData[
  ButtonBox["Polytope",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/Polytope"]], 
  "InlineFormula"],
 " object, centered at ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConvexHullMedian",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->24389],

Cell[TextData[{
 "Outlying vectors are removed by repeatedly peeling off layers of convex \
hulls from the data until at most a fraction ",
 Cell[BoxData[
  StyleBox["q", "TI"]], "InlineFormula"],
 " are left. "
}], "Notes",
 CellID->273359575],

Cell[TextData[{
 Cell[BoxData["PolytopeQuantile"], "InlineFormula"],
 " interpolates between the convex hulls of the points remaining before and \
after the last layer is removed."
}], "Notes",
 CellID->447416070]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->19274],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolytopeQuartiles",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuartiles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipsoidQuartiles",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuartiles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipsoidQuantile",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuantile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30273]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->30090],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->12337]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolytopeQuantile - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 44.5409774}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {}, "index" -> True, "label" -> 
    "Multivariate Statistics Package Symbol", "language" -> "en", "paclet" -> 
    "MultivariateStatistics Package", "status" -> "None", "summary" -> 
    "PolytopeQuantile[{{x_11, x_12}, ..., {x n1, x n2}}, q] gives the locus \
of the q\\[Null]^th quantile of the bivariate data, where the data have been \
ordered using convex hulls centered on ConvexHullMedian[{{x_11, x_12}, ..., \
{x n1, x n2}}].", "synonyms" -> {}, "title" -> "PolytopeQuantile", "type" -> 
    "Symbol", "uri" -> "MultivariateStatistics/ref/PolytopeQuantile"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1642, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2265, 68, 54, 1, 70, "ObjectName",
 CellID->28039],
Cell[2322, 71, 2422, 74, 70, "Usage",
 CellID->28476]
}, Open  ]],
Cell[CellGroupData[{
Cell[4781, 150, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5259, 167, 711, 25, 70, "Notes",
 CellID->24389],
Cell[5973, 194, 244, 7, 70, "Notes",
 CellID->273359575],
Cell[6220, 203, 213, 5, 70, "Notes",
 CellID->447416070]
}, Closed]],
Cell[CellGroupData[{
Cell[6470, 213, 311, 9, 70, "SeeAlsoSection",
 CellID->19274],
Cell[6784, 224, 821, 26, 70, "SeeAlso",
 CellID->30273]
}, Open  ]],
Cell[CellGroupData[{
Cell[7642, 255, 314, 9, 70, "TutorialsSection",
 CellID->30090],
Cell[7959, 266, 192, 5, 70, "Tutorials",
 CellID->12337]
}, Open  ]],
Cell[8166, 274, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

