(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9042,        300]
NotebookOptionsPosition[      7150,        244]
NotebookOutlinePosition[      8397,        275]
CellTagsIndexPosition[      8354,        272]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PolytopeQuantile" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/PolytopeQuantile"], 
          "EllipsoidQuartiles" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/EllipsoidQuartiles"], 
          "EllipsoidQuantile" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/EllipsoidQuantile"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"PolytopeQuantile\"\>", 
       2->"\<\"EllipsoidQuartiles\"\>", 
       3->"\<\"EllipsoidQuantile\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PolytopeQuartiles", "ObjectName",
 CellID->1603],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PolytopeQuartiles", "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"], ",", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a list of the loci of the quartiles of the \
bivariate data ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ", where the data have been ordered using convex hulls centered on ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["ConvexHullMedian",
        BaseStyle->"Link",
        ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"], "[",
        
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["1", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"], ",", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5075]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PolytopeQuartiles"], "InlineFormula"],
 " returns a list of ",
 Cell[BoxData[
  ButtonBox["Polytope",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/Polytope"]], 
  "InlineFormula"],
 " objects, centered at ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["ConvexHullMedian",
    BaseStyle->"Link",
    ButtonData->"paclet:ComputationalGeometry/ref/ConvexHullMedian"], "[", 
   RowBox[{"{", 
    RowBox[{
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["1", "TR"]], ",", 
     StyleBox["\[Ellipsis]", "TR"], ",", 
     SubscriptBox[
      StyleBox["x", "TI"], 
      StyleBox["n", "TI"]]}], "}"}], "]"}]], "InlineFormula"],
 ". The fraction of the data lying inside the ",
 Cell[BoxData[
  ButtonBox["Polytope",
   BaseStyle->"Link",
   ButtonData->"paclet:MultivariateStatistics/ref/Polytope"]], 
  "InlineFormula"],
 " objects are ",
 Cell[BoxData[
  RowBox[{".25", ",", ".5", ","}]], "InlineFormula"],
 " and ",
 Cell[BoxData[".75"], "InlineFormula"],
 "."
}], "Notes",
 CellID->10712]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9563],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PolytopeQuantile",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/PolytopeQuantile"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipsoidQuartiles",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuartiles"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["EllipsoidQuantile",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/EllipsoidQuantile"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->30273]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21922],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->7487]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PolytopeQuartiles - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 44.7284822}", "context" -> 
    "MultivariateStatistics`", "keywords" -> {}, "index" -> True, "label" -> 
    "Multivariate Statistics Package Symbol", "language" -> "en", "paclet" -> 
    "MultivariateStatistics Package", "status" -> "None", "summary" -> 
    "PolytopeQuartiles[{x_1, ..., x_n}] gives a list of the loci of the \
quartiles of the bivariate data x_1, x_2, ..., where the data have been \
ordered using convex hulls centered on ConvexHullMedian[{x_1, ..., x_n}].", 
    "synonyms" -> {}, "title" -> "PolytopeQuartiles", "type" -> "Symbol", 
    "uri" -> "MultivariateStatistics/ref/PolytopeQuartiles"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1639, 41, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2262, 68, 54, 1, 70, "ObjectName",
 CellID->1603],
Cell[2319, 71, 1509, 47, 70, "Usage",
 CellID->5075]
}, Open  ]],
Cell[CellGroupData[{
Cell[3865, 123, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4343, 140, 1051, 36, 70, "Notes",
 CellID->10712]
}, Closed]],
Cell[CellGroupData[{
Cell[5431, 181, 310, 9, 70, "SeeAlsoSection",
 CellID->9563],
Cell[5744, 192, 819, 26, 70, "SeeAlso",
 CellID->30273]
}, Open  ]],
Cell[CellGroupData[{
Cell[6600, 223, 314, 9, 70, "TutorialsSection",
 CellID->21922],
Cell[6917, 234, 191, 5, 70, "Tutorials",
 CellID->7487]
}, Open  ]],
Cell[7123, 242, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

