(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     15251,        556]
NotebookOptionsPosition[     11571,        431]
NotebookOutlinePosition[     12957,        470]
CellTagsIndexPosition[     12872,        465]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Eigenvectors" :> 
          Documentation`HelpLookup["paclet:ref/Eigenvectors"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Eigenvectors\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PrincipalComponents", "ObjectName",
 CellID->13946],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"PrincipalComponents", "[", 
       StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]transforms elements of ",
     Cell[BoxData[
      StyleBox["matrix", "TI"]], "InlineFormula"],
     " into principal components."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->2600]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["PrincipalComponents"], "InlineFormula"],
 " gives the principal component transform of ",
 Cell[BoxData[
  StyleBox["matrix", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->626722793],

Cell[TextData[{
 "The principal components of ",
 Cell[BoxData[
  StyleBox["matrix", "TI"]], "InlineFormula"],
 " are linear transformations of the original columns into uncorrelated \
columns arranged in order of decreasing variance."
}], "Notes",
 CellID->2510],

Cell[TextData[{
 "The dimensions of ",
 Cell[BoxData[
  RowBox[{"PrincipalComponents", "[", 
   StyleBox["matrix", "TI"], "]"}]], "InlineFormula"],
 " are the same as the dimensions of ",
 Cell[BoxData[
  StyleBox["matrix", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->49093672],

Cell["The following options can be given:", "Notes",
 CellID->658053768],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Method",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Method"], 
    ButtonBox["Covariance",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Covariance"], Cell[
    "scaling method for decomposition", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->384108651],

Cell[TextData[{
 "Possible values of ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Covariance",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Covariance"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Correlation",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Correlation"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->14788678]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->84426158],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->465846670],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->220796889],

Cell["Principal components for bivariate data:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->9742],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrincipalComponents", "[", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"1", ",", "2"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"2", ",", "3"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"4", ",", "10"}], "}"}]}], "}"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2388852],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.2705329110195445`"}], ",", 
     RowBox[{"-", "0.2852932801798909`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.9996938973384737`"}], ",", "0.33516477747277823`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.270226808358018`", ",", 
     RowBox[{"-", "0.049871497292887784`"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{469, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->295601873]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->3950],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12999],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->271067592],

Cell["Principal components using correlation scaling:", "ExampleText",
 CellID->595116922],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrincipalComponents", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "10"}], "}"}]}], "}"}], ",", 
   RowBox[{"Method", "\[Rule]", "Correlation"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->634376418],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.1038776632406553`"}], ",", "0.13054913645608013`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.478746192223617`"}], ",", 
     RowBox[{"-", "0.17013949229943306`"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"1.5826238554642722`", ",", "0.039590355843353166`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{468, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->19419686]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->7478],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->246966337],

Cell["Precision 20 principal components:", "ExampleText",
 CellID->238475917],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrincipalComponents", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", "2"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4", ",", "10"}], "}"}]}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "\[Rule]", "20"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->99892941],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3.27053291101954454903787583182`19.026731345498956"}], ",",
      
     RowBox[{"-", "0.28529328017989080399472167737`18.12915966073228"}]}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "1.99969389733847366911461467428`18.937964350819115"}], ",",
      "0.33516477747277836705025031124`18.3947800269744"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"5.27022680835801821815249050612`18.994395264697847", ",", 
     RowBox[{"-", "0.04987149729288756305552863386`17.1736682866316"}]}], 
    "}"}]}], "}"}]], "Output",
 ImageSize->{339, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->581242663]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1341],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["Eigenvectors",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Eigenvectors"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->18261]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18481],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->16500]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PrincipalComponents - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 44.9159870}", "context" -> 
    "MultivariateStatistics`", 
    "keywords" -> {
     "principal components", "principal component analysis", "pca"}, "index" -> 
    True, "label" -> "Multivariate Statistics Package Symbol", "language" -> 
    "en", "paclet" -> "MultivariateStatistics Package", "status" -> "None", 
    "summary" -> 
    "PrincipalComponents[matrix] transforms elements of matrix into principal \
components.", "synonyms" -> {}, "title" -> "PrincipalComponents", "type" -> 
    "Symbol", "uri" -> "MultivariateStatistics/ref/PrincipalComponents"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[5155, 181, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->84426158]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 12730, 458}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1241, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1864, 60, 57, 1, 70, "ObjectName",
 CellID->13946],
Cell[1924, 63, 497, 15, 70, "Usage",
 CellID->2600]
}, Open  ]],
Cell[CellGroupData[{
Cell[2458, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2936, 100, 220, 7, 70, "Notes",
 CellID->626722793],
Cell[3159, 109, 263, 7, 70, "Notes",
 CellID->2510],
Cell[3425, 118, 286, 10, 70, "Notes",
 CellID->49093672],
Cell[3714, 130, 72, 1, 70, "Notes",
 CellID->658053768],
Cell[3789, 133, 867, 23, 70, "3ColumnTableMod",
 CellID->384108651],
Cell[4659, 158, 459, 18, 70, "Notes",
 CellID->14788678]
}, Closed]],
Cell[CellGroupData[{
Cell[5155, 181, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->84426158],
Cell[CellGroupData[{
Cell[5539, 195, 148, 5, 70, "ExampleSection",
 CellID->465846670],
Cell[5690, 202, 147, 4, 70, "Input",
 CellID->220796889],
Cell[5840, 208, 215, 5, 70, "ExampleText",
 CellID->9742],
Cell[CellGroupData[{
Cell[6080, 217, 324, 11, 28, "Input",
 CellID->2388852],
Cell[6407, 230, 560, 18, 36, "Output",
 CellID->295601873]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7016, 254, 217, 7, 70, "ExampleSection",
 CellID->3950],
Cell[CellGroupData[{
Cell[7258, 265, 223, 7, 70, "ExampleSubsection",
 CellID->12999],
Cell[7484, 274, 147, 4, 70, "Input",
 CellID->271067592],
Cell[7634, 280, 90, 1, 70, "ExampleText",
 CellID->595116922],
Cell[CellGroupData[{
Cell[7749, 285, 402, 13, 70, "Input",
 CellID->634376418],
Cell[8154, 300, 542, 18, 36, "Output",
 CellID->19419686]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[8745, 324, 232, 7, 70, "ExampleSubsection",
 CellID->7478],
Cell[8980, 333, 147, 4, 70, "Input",
 CellID->246966337],
Cell[9130, 339, 77, 1, 70, "ExampleText",
 CellID->238475917],
Cell[CellGroupData[{
Cell[9232, 344, 402, 13, 70, "Input",
 CellID->99892941],
Cell[9637, 359, 756, 21, 71, "Output",
 CellID->581242663]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10466, 388, 310, 9, 70, "SeeAlsoSection",
 CellID->1341],
Cell[10779, 399, 204, 6, 70, "SeeAlso",
 CellID->18261]
}, Open  ]],
Cell[CellGroupData[{
Cell[11020, 410, 314, 9, 70, "TutorialsSection",
 CellID->18481],
Cell[11337, 421, 192, 5, 70, "Tutorials",
 CellID->16500]
}, Open  ]],
Cell[11544, 429, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

