(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     11826,        428]
NotebookOptionsPosition[      9101,        340]
NotebookOutlinePosition[     10546,        380]
CellTagsIndexPosition[     10461,        375]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MULTIVARIATE STATISTICS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Multivariate Statistics Package" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"Multivariate Statistics Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Correlation" :> 
          Documentation`HelpLookup["paclet:ref/Correlation"], 
          "KendallRankCorrelation" :> 
          Documentation`HelpLookup[
           "paclet:MultivariateStatistics/ref/KendallRankCorrelation"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"Correlation\"\>", 
       2->"\<\"KendallRankCorrelation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["SpearmanRankCorrelation", "ObjectName",
 CellID->8963],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"SpearmanRankCorrelation", "[", 
       RowBox[{
        StyleBox["xlist", "TI"], ",", 
        StyleBox["ylist", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives Spearman's rank correlation coefficient ",
     Cell[BoxData[
      StyleBox["\[Rho]", "TR"]], "InlineFormula"],
     " for the real\[Hyphen]valued vectors ",
     Cell[BoxData[
      StyleBox["xlist", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["ylist", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13401]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
Spearman's rank correlation coefficient is a measure of association based on \
the rank differences between two lists.\
\>", "Notes",
 CellID->882969799],

Cell[TextData[{
 "Spearman's ",
 Cell[BoxData[
  StyleBox["\[Rho]", "TR"]], "InlineFormula"],
 " is given by ",
 Cell[BoxData[
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        SuperscriptBox[
         StyleBox["n", "TI"], "3"], "-", 
        StyleBox["n", "TI"]}], ")"}], "/", "6"}], "-", 
     SubscriptBox[
      StyleBox["T", "TI"], 
      StyleBox["x", "TI"]], "-", 
     SubscriptBox[
      StyleBox["T", "TI"], 
      StyleBox["y", "TI"]], "-", 
     RowBox[{"\[Sum]", 
      SuperscriptBox[
       SubscriptBox[
        StyleBox["r", "TI"], 
        StyleBox["i", "TI"]], "2"]}]}], ")"}], "/", 
   SqrtBox[
    RowBox[{
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           StyleBox["n", "TI"], "3"], "-", 
          StyleBox["n", "TI"]}], ")"}], "/", "6"}], "-", 
       RowBox[{"2", 
        SubscriptBox[
         StyleBox["T", "TI"], 
         StyleBox["x", "TI"]]}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          SuperscriptBox[
           StyleBox["n", "TI"], "3"], "-", 
          StyleBox["n", "TI"]}], ")"}], "/", "6"}], "-", 
       RowBox[{"2", 
        SubscriptBox[
         StyleBox["T", "TI"], 
         StyleBox["y", "TI"]]}]}], ")"}]}]]}]], "InlineFormula"],
 ", where ",
 Cell[BoxData[
  RowBox[{
   StyleBox["n", "TI"], "=", 
   RowBox[{
    ButtonBox["Length",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Length"], "[", 
    StyleBox["xlist", "TI"], "]"}]}]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["r", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " is the rank difference between ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["y", "TI"], 
   StyleBox["i", "TI"]]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["T", "TI"], 
   StyleBox["x", "TI"]]], "InlineFormula"],
 " is the correction term for ties in ",
 Cell[BoxData[
  StyleBox["xlist", "TI"]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["T", "TI"], 
   StyleBox["y", "TI"]]], "InlineFormula"],
 " is the correction term for ties in ",
 Cell[BoxData[
  StyleBox["ylist", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1091625],

Cell[TextData[{
 "The arguments ",
 Cell[BoxData[
  StyleBox["xlist", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["ylist", "TI"]], "InlineFormula"],
 " can be any real\[Hyphen]valued vectors of equal length."
}], "Notes",
 CellID->234751703]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81505291],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->112299018],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<MultivariateStatistics`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->220963621],

Cell["Spearman's rank correlation for two vectors:", "ExampleText",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0, 6},
 ScriptMinSize->9,
 CellID->176385558],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SpearmanRankCorrelation", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"1", ",", "2", ",", "3"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"3", ",", "1", ",", "6"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->338243318],

Cell[BoxData[
 FractionBox["1", "2"]], "Output",
 ImageSize->{16, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->26244371]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14781],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Correlation",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Correlation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["KendallRankCorrelation",
    BaseStyle->"Link",
    ButtonData->"paclet:MultivariateStatistics/ref/KendallRankCorrelation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->20334]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->13440],

Cell[TextData[ButtonBox["Multivariate Statistics Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:MultivariateStatistics/tutorial/MultivariateStatistics"]], \
"Tutorials",
 CellID->11711]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"SpearmanRankCorrelation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 0, 50.7755120}", "context" -> 
    "MultivariateStatistics`", 
    "keywords" -> {"Spearman's rho", "Spearman rho", "rank correlation"}, 
    "index" -> True, "label" -> "Multivariate Statistics Package Symbol", 
    "language" -> "en", "paclet" -> "MultivariateStatistics Package", 
    "status" -> "None", "summary" -> 
    "SpearmanRankCorrelation[xlist, ylist] gives Spearman's rank correlation \
coefficient \\[Rho] for the real-valued vectors xlist and ylist.", 
    "synonyms" -> {}, "title" -> "SpearmanRankCorrelation", "type" -> 
    "Symbol", "uri" -> 
    "MultivariateStatistics/ref/SpearmanRankCorrelation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[6256, 227, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->81505291]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 10319, 368}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1424, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2047, 63, 60, 1, 70, "ObjectName",
 CellID->8963],
Cell[2110, 66, 754, 23, 70, "Usage",
 CellID->13401]
}, Open  ]],
Cell[CellGroupData[{
Cell[2901, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3379, 111, 163, 4, 70, "Notes",
 CellID->882969799],
Cell[3545, 117, 2412, 94, 70, "Notes",
 CellID->1091625],
Cell[5960, 213, 259, 9, 70, "Notes",
 CellID->234751703]
}, Closed]],
Cell[CellGroupData[{
Cell[6256, 227, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->81505291],
Cell[CellGroupData[{
Cell[6640, 241, 148, 5, 70, "ExampleSection",
 CellID->112299018],
Cell[6791, 248, 147, 4, 70, "Input",
 CellID->220963621],
Cell[6941, 254, 224, 5, 70, "ExampleText",
 CellID->176385558],
Cell[CellGroupData[{
Cell[7190, 263, 260, 8, 28, "Input",
 CellID->338243318],
Cell[7453, 273, 177, 6, 51, "Output",
 CellID->26244371]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7691, 286, 311, 9, 70, "SeeAlsoSection",
 CellID->14781],
Cell[8005, 297, 508, 17, 70, "SeeAlso",
 CellID->20334]
}, Open  ]],
Cell[CellGroupData[{
Cell[8550, 319, 314, 9, 70, "TutorialsSection",
 CellID->13440],
Cell[8867, 330, 192, 5, 70, "Tutorials",
 CellID->11711]
}, Open  ]],
Cell[9074, 338, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

