(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9115,        312]
NotebookOptionsPosition[      7436,        257]
NotebookOutlinePosition[      8417,        285]
CellTagsIndexPosition[      8374,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Gsharp3" :> 
          Documentation`HelpLookup["paclet:Music/ref/Gsharp3"], "A3" :> 
          Documentation`HelpLookup["paclet:Music/ref/A3"], "Asharp3" :> 
          Documentation`HelpLookup["paclet:Music/ref/Asharp3"], "Aflat2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Aflat2"], "Aflat4" :> 
          Documentation`HelpLookup["paclet:Music/ref/Aflat4"], "C3" :> 
          Documentation`HelpLookup["paclet:Music/ref/C3"], "D3" :> 
          Documentation`HelpLookup["paclet:Music/ref/D3"], "E3" :> 
          Documentation`HelpLookup["paclet:Music/ref/E3"], "F3" :> 
          Documentation`HelpLookup["paclet:Music/ref/F3"], "G3" :> 
          Documentation`HelpLookup["paclet:Music/ref/G3"], "B3" :> 
          Documentation`HelpLookup["paclet:Music/ref/B3"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Gsharp3\"\>", 2->"\<\"A3\"\>", 
       3->"\<\"Asharp3\"\>", 4->"\<\"Aflat2\"\>", 5->"\<\"Aflat4\"\>", 
       6->"\<\"C3\"\>", 7->"\<\"D3\"\>", 8->"\<\"E3\"\>", 9->"\<\"F3\"\>", 
       10->"\<\"G3\"\>", 11->"\<\"B3\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Aflat3", "ObjectName",
 CellID->11480],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Aflat3"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note A-flat in octave 3."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->31989]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Aflat3"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->14117],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->19826]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->9622],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gsharp3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Gsharp3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Asharp3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Asharp3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Aflat2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Aflat2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Aflat4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Aflat4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B3"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23613]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11939],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->1716]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Aflat3 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 1, 6.4009120}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Aflat3 gives the frequency of the note A-flat in octave 3.",
     "synonyms" -> {}, "title" -> "Aflat3", "type" -> "Symbol", "uri" -> 
    "Music/ref/Aflat3"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 44, 1, 70, "ObjectName",
 CellID->11480],
Cell[2711, 73, 347, 10, 70, "Usage",
 CellID->31989]
}, Open  ]],
Cell[CellGroupData[{
Cell[3095, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3573, 105, 152, 4, 70, "Notes",
 CellID->14117],
Cell[3728, 111, 202, 8, 70, "Notes",
 CellID->19826]
}, Closed]],
Cell[CellGroupData[{
Cell[3967, 124, 310, 9, 70, "SeeAlsoSection",
 CellID->9622],
Cell[4280, 135, 2626, 98, 70, "SeeAlso",
 CellID->23613]
}, Open  ]],
Cell[CellGroupData[{
Cell[6943, 238, 314, 9, 70, "TutorialsSection",
 CellID->11939],
Cell[7260, 249, 134, 3, 70, "Tutorials",
 CellID->1716]
}, Open  ]],
Cell[7409, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

