(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9114,        312]
NotebookOptionsPosition[      7435,        257]
NotebookOutlinePosition[      8417,        285]
CellTagsIndexPosition[      8374,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Asharp1" :> 
          Documentation`HelpLookup["paclet:Music/ref/Asharp1"], "B1" :> 
          Documentation`HelpLookup["paclet:Music/ref/B1"], "Bsharp1" :> 
          Documentation`HelpLookup["paclet:Music/ref/Bsharp1"], "Bflat0" :> 
          Documentation`HelpLookup["paclet:Music/ref/Bflat0"], "Bflat2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Bflat2"], "C0" :> 
          Documentation`HelpLookup["paclet:Music/ref/C0"], "D0" :> 
          Documentation`HelpLookup["paclet:Music/ref/D0"], "E0" :> 
          Documentation`HelpLookup["paclet:Music/ref/E0"], "F0" :> 
          Documentation`HelpLookup["paclet:Music/ref/F0"], "G0" :> 
          Documentation`HelpLookup["paclet:Music/ref/G0"], "A0" :> 
          Documentation`HelpLookup["paclet:Music/ref/A0"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Asharp1\"\>", 2->"\<\"B1\"\>", 
       3->"\<\"Bsharp1\"\>", 4->"\<\"Bflat0\"\>", 5->"\<\"Bflat2\"\>", 
       6->"\<\"C0\"\>", 7->"\<\"D0\"\>", 8->"\<\"E0\"\>", 9->"\<\"F0\"\>", 
       10->"\<\"G0\"\>", 11->"\<\"A0\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bflat1", "ObjectName",
 CellID->4575],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Bflat1"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note B-flat in octave 1."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8762]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Bflat1"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->9567],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->22336]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13851],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Asharp1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Asharp1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bsharp1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Bsharp1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bflat0",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Bflat0"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bflat2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Bflat2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C0",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C0"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D0",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D0"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E0",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E0"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F0",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F0"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G0",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G0"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A0",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A0"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->26816]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->18397],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->31418]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bflat1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 1, 23.0732138}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Bflat1 gives the frequency of the note B-flat in octave 1.",
     "synonyms" -> {}, "title" -> "Bflat1", "type" -> "Symbol", "uri" -> 
    "Music/ref/Bflat1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 43, 1, 70, "ObjectName",
 CellID->4575],
Cell[2710, 73, 346, 10, 70, "Usage",
 CellID->8762]
}, Open  ]],
Cell[CellGroupData[{
Cell[3093, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3571, 105, 151, 4, 70, "Notes",
 CellID->9567],
Cell[3725, 111, 202, 8, 70, "Notes",
 CellID->22336]
}, Closed]],
Cell[CellGroupData[{
Cell[3964, 124, 311, 9, 70, "SeeAlsoSection",
 CellID->13851],
Cell[4278, 135, 2626, 98, 70, "SeeAlso",
 CellID->26816]
}, Open  ]],
Cell[CellGroupData[{
Cell[6941, 238, 314, 9, 70, "TutorialsSection",
 CellID->18397],
Cell[7258, 249, 135, 3, 70, "Tutorials",
 CellID->31418]
}, Open  ]],
Cell[7408, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

