(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9118,        312]
NotebookOptionsPosition[      7437,        257]
NotebookOutlinePosition[      8419,        285]
CellTagsIndexPosition[      8376,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Asharp2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Asharp2"], "B2" :> 
          Documentation`HelpLookup["paclet:Music/ref/B2"], "Bsharp2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Bsharp2"], "Bflat1" :> 
          Documentation`HelpLookup["paclet:Music/ref/Bflat1"], "Bflat3" :> 
          Documentation`HelpLookup["paclet:Music/ref/Bflat3"], "C2" :> 
          Documentation`HelpLookup["paclet:Music/ref/C2"], "D2" :> 
          Documentation`HelpLookup["paclet:Music/ref/D2"], "E2" :> 
          Documentation`HelpLookup["paclet:Music/ref/E2"], "F2" :> 
          Documentation`HelpLookup["paclet:Music/ref/F2"], "G2" :> 
          Documentation`HelpLookup["paclet:Music/ref/G2"], "A2" :> 
          Documentation`HelpLookup["paclet:Music/ref/A2"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Asharp2\"\>", 2->"\<\"B2\"\>", 
       3->"\<\"Bsharp2\"\>", 4->"\<\"Bflat1\"\>", 5->"\<\"Bflat3\"\>", 
       6->"\<\"C2\"\>", 7->"\<\"D2\"\>", 8->"\<\"E2\"\>", 9->"\<\"F2\"\>", 
       10->"\<\"G2\"\>", 11->"\<\"A2\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Bflat2", "ObjectName",
 CellID->28350],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Bflat2"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note B-flat in octave 2."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->14333]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Bflat2"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->22925],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->10910]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12393],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Asharp2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Asharp2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bsharp2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Bsharp2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bflat1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Bflat1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Bflat3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Bflat3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A2"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->7636]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19737],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->16336]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Bflat2 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 1, 23.2919694}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Bflat2 gives the frequency of the note B-flat in octave 2.",
     "synonyms" -> {}, "title" -> "Bflat2", "type" -> "Symbol", "uri" -> 
    "Music/ref/Bflat2"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 44, 1, 70, "ObjectName",
 CellID->28350],
Cell[2711, 73, 347, 10, 70, "Usage",
 CellID->14333]
}, Open  ]],
Cell[CellGroupData[{
Cell[3095, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3573, 105, 152, 4, 70, "Notes",
 CellID->22925],
Cell[3728, 111, 202, 8, 70, "Notes",
 CellID->10910]
}, Closed]],
Cell[CellGroupData[{
Cell[3967, 124, 311, 9, 70, "SeeAlsoSection",
 CellID->12393],
Cell[4281, 135, 2625, 98, 70, "SeeAlso",
 CellID->7636]
}, Open  ]],
Cell[CellGroupData[{
Cell[6943, 238, 314, 9, 70, "TutorialsSection",
 CellID->19737],
Cell[7260, 249, 135, 3, 70, "Tutorials",
 CellID->16336]
}, Open  ]],
Cell[7410, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

