(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7556,        258]
NotebookOptionsPosition[      5710,        202]
NotebookOutlinePosition[      6910,        233]
CellTagsIndexPosition[      6867,        230]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MusicScale" :> 
          Documentation`HelpLookup["paclet:Music/ref/MusicScale"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"MusicScale\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["CentsToHertz", "ObjectName",
 CellID->14398],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CentsToHertz", "[", 
       RowBox[{"{", 
        RowBox[{
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["1", "TR"]], ",", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["2", "TR"]], ",", 
         StyleBox["\[Ellipsis]", "TR"]}], "}"}], "]"}]], "InlineFormula"],
     " \[LineSeparator]converts a list of intervals ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ", measured in cents to a list of frequencies measured in ",
     Cell[BoxData[
      ButtonBox["Hertz",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
     ", beginning at ",
     Cell[BoxData["440"], "InlineFormula"],
     " ",
     Cell[BoxData[
      ButtonBox["Hertz",
       BaseStyle->"Link",
       ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"CentsToHertz", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["freq", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of frequencies beginning at frequency ",
     Cell[BoxData[
      StyleBox["freq", "TI"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->10498]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["HertzToCents",
   BaseStyle->"Link",
   ButtonData->"paclet:Music/ref/HertzToCents"]], "InlineFormula"],
 " performs the inverse conversion from ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 " to cents."
}], "Notes",
 CellID->7103]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14522],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["MusicScale",
   BaseStyle->"Link",
   ButtonData->"paclet:Music/ref/MusicScale"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->31088]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->27352],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->25679]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"CentsToHertz - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 1, 46.4019360}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "CentsToHertz[{i_1, i_2, ...}] converts a list of intervals i_1, i_2, \
..., measured in cents to a list of frequencies measured in Hertz, beginning \
at 440 Hertz. CentsToHertz[{i_1, i_2, ...}, freq] gives a list of frequencies \
beginning at frequency freq.", "synonyms" -> {}, "title" -> "CentsToHertz", 
    "type" -> "Symbol", "uri" -> "Music/ref/CentsToHertz"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1143, 31, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1766, 58, 50, 1, 70, "ObjectName",
 CellID->14398],
Cell[1819, 61, 1936, 61, 70, "Usage",
 CellID->10498]
}, Open  ]],
Cell[CellGroupData[{
Cell[3792, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4270, 144, 352, 12, 70, "Notes",
 CellID->7103]
}, Closed]],
Cell[CellGroupData[{
Cell[4659, 161, 311, 9, 70, "SeeAlsoSection",
 CellID->14522],
Cell[4973, 172, 206, 6, 70, "SeeAlso",
 CellID->31088]
}, Open  ]],
Cell[CellGroupData[{
Cell[5216, 183, 314, 9, 70, "TutorialsSection",
 CellID->27352],
Cell[5533, 194, 135, 3, 70, "Tutorials",
 CellID->25679]
}, Open  ]],
Cell[5683, 200, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

