(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9108,        312]
NotebookOptionsPosition[      7432,        257]
NotebookOutlinePosition[      8414,        285]
CellTagsIndexPosition[      8371,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dsharp1" :> 
          Documentation`HelpLookup["paclet:Music/ref/Dsharp1"], "E1" :> 
          Documentation`HelpLookup["paclet:Music/ref/E1"], "Esharp1" :> 
          Documentation`HelpLookup["paclet:Music/ref/Esharp1"], "Eflat0" :> 
          Documentation`HelpLookup["paclet:Music/ref/Eflat0"], "Eflat2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Eflat2"], "C1" :> 
          Documentation`HelpLookup["paclet:Music/ref/C1"], "D1" :> 
          Documentation`HelpLookup["paclet:Music/ref/D1"], "F1" :> 
          Documentation`HelpLookup["paclet:Music/ref/F1"], "G1" :> 
          Documentation`HelpLookup["paclet:Music/ref/G1"], "A1" :> 
          Documentation`HelpLookup["paclet:Music/ref/A1"], "B1" :> 
          Documentation`HelpLookup["paclet:Music/ref/B1"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dsharp1\"\>", 2->"\<\"E1\"\>", 
       3->"\<\"Esharp1\"\>", 4->"\<\"Eflat0\"\>", 5->"\<\"Eflat2\"\>", 
       6->"\<\"C1\"\>", 7->"\<\"D1\"\>", 8->"\<\"F1\"\>", 9->"\<\"G1\"\>", 
       10->"\<\"A1\"\>", 11->"\<\"B1\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eflat1", "ObjectName",
 CellID->23425],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Eflat1"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note E-flat in octave 1."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->23267]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Eflat1"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->19312],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->734]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->8211],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dsharp1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Dsharp1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Esharp1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Esharp1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eflat0",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Eflat0"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eflat2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Eflat2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A1"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B1",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B1"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29235]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->452],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->5169]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eflat1 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 2, 27.2779824}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Eflat1 gives the frequency of the note E-flat in octave 1.",
     "synonyms" -> {}, "title" -> "Eflat1", "type" -> "Symbol", "uri" -> 
    "Music/ref/Eflat1"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 44, 1, 70, "ObjectName",
 CellID->23425],
Cell[2711, 73, 347, 10, 70, "Usage",
 CellID->23267]
}, Open  ]],
Cell[CellGroupData[{
Cell[3095, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3573, 105, 152, 4, 70, "Notes",
 CellID->19312],
Cell[3728, 111, 200, 8, 70, "Notes",
 CellID->734]
}, Closed]],
Cell[CellGroupData[{
Cell[3965, 124, 310, 9, 70, "SeeAlsoSection",
 CellID->8211],
Cell[4278, 135, 2626, 98, 70, "SeeAlso",
 CellID->29235]
}, Open  ]],
Cell[CellGroupData[{
Cell[6941, 238, 312, 9, 70, "TutorialsSection",
 CellID->452],
Cell[7256, 249, 134, 3, 70, "Tutorials",
 CellID->5169]
}, Open  ]],
Cell[7405, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

