(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9116,        312]
NotebookOptionsPosition[      7436,        257]
NotebookOutlinePosition[      8418,        285]
CellTagsIndexPosition[      8375,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dsharp3" :> 
          Documentation`HelpLookup["paclet:Music/ref/Dsharp3"], "E3" :> 
          Documentation`HelpLookup["paclet:Music/ref/E3"], "Esharp3" :> 
          Documentation`HelpLookup["paclet:Music/ref/Esharp3"], "Eflat2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Eflat2"], "Eflat4" :> 
          Documentation`HelpLookup["paclet:Music/ref/Eflat4"], "C3" :> 
          Documentation`HelpLookup["paclet:Music/ref/C3"], "D3" :> 
          Documentation`HelpLookup["paclet:Music/ref/D3"], "F3" :> 
          Documentation`HelpLookup["paclet:Music/ref/F3"], "G3" :> 
          Documentation`HelpLookup["paclet:Music/ref/G3"], "A3" :> 
          Documentation`HelpLookup["paclet:Music/ref/A3"], "B3" :> 
          Documentation`HelpLookup["paclet:Music/ref/B3"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dsharp3\"\>", 2->"\<\"E3\"\>", 
       3->"\<\"Esharp3\"\>", 4->"\<\"Eflat2\"\>", 5->"\<\"Eflat4\"\>", 
       6->"\<\"C3\"\>", 7->"\<\"D3\"\>", 8->"\<\"F3\"\>", 9->"\<\"G3\"\>", 
       10->"\<\"A3\"\>", 11->"\<\"B3\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eflat3", "ObjectName",
 CellID->1135],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Eflat3"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note E-flat in octave 3."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->8357]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Eflat3"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->20070],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15271]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28295],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dsharp3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Dsharp3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Esharp3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Esharp3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eflat2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Eflat2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eflat4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Eflat4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B3"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17686]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->22342],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->17780]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eflat3 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 2, 27.6217412}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Eflat3 gives the frequency of the note E-flat in octave 3.",
     "synonyms" -> {}, "title" -> "Eflat3", "type" -> "Symbol", "uri" -> 
    "Music/ref/Eflat3"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 43, 1, 70, "ObjectName",
 CellID->1135],
Cell[2710, 73, 346, 10, 70, "Usage",
 CellID->8357]
}, Open  ]],
Cell[CellGroupData[{
Cell[3093, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3571, 105, 152, 4, 70, "Notes",
 CellID->20070],
Cell[3726, 111, 202, 8, 70, "Notes",
 CellID->15271]
}, Closed]],
Cell[CellGroupData[{
Cell[3965, 124, 311, 9, 70, "SeeAlsoSection",
 CellID->28295],
Cell[4279, 135, 2626, 98, 70, "SeeAlso",
 CellID->17686]
}, Open  ]],
Cell[CellGroupData[{
Cell[6942, 238, 314, 9, 70, "TutorialsSection",
 CellID->22342],
Cell[7259, 249, 135, 3, 70, "Tutorials",
 CellID->17780]
}, Open  ]],
Cell[7409, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

