(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9116,        312]
NotebookOptionsPosition[      7436,        257]
NotebookOutlinePosition[      8418,        285]
CellTagsIndexPosition[      8375,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dsharp4" :> 
          Documentation`HelpLookup["paclet:Music/ref/Dsharp4"], "E4" :> 
          Documentation`HelpLookup["paclet:Music/ref/E4"], "Esharp4" :> 
          Documentation`HelpLookup["paclet:Music/ref/Esharp4"], "Eflat3" :> 
          Documentation`HelpLookup["paclet:Music/ref/Eflat3"], "Eflat5" :> 
          Documentation`HelpLookup["paclet:Music/ref/Eflat5"], "C4" :> 
          Documentation`HelpLookup["paclet:Music/ref/C4"], "D4" :> 
          Documentation`HelpLookup["paclet:Music/ref/D4"], "F4" :> 
          Documentation`HelpLookup["paclet:Music/ref/F4"], "G4" :> 
          Documentation`HelpLookup["paclet:Music/ref/G4"], "A4" :> 
          Documentation`HelpLookup["paclet:Music/ref/A4"], "B4" :> 
          Documentation`HelpLookup["paclet:Music/ref/B4"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dsharp4\"\>", 2->"\<\"E4\"\>", 
       3->"\<\"Esharp4\"\>", 4->"\<\"Eflat3\"\>", 5->"\<\"Eflat5\"\>", 
       6->"\<\"C4\"\>", 7->"\<\"D4\"\>", 8->"\<\"F4\"\>", 9->"\<\"G4\"\>", 
       10->"\<\"A4\"\>", 11->"\<\"B4\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eflat4", "ObjectName",
 CellID->1588],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Eflat4"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note E-flat in octave 4."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->16467]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Eflat4"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->12083],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3400]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->20920],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dsharp4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Dsharp4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Esharp4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Esharp4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eflat3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Eflat3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eflat5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Eflat5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B4"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->18366]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->11158],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->15606]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eflat4 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 2, 27.8248714}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Eflat4 gives the frequency of the note E-flat in octave 4.",
     "synonyms" -> {}, "title" -> "Eflat4", "type" -> "Symbol", "uri" -> 
    "Music/ref/Eflat4"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 43, 1, 70, "ObjectName",
 CellID->1588],
Cell[2710, 73, 347, 10, 70, "Usage",
 CellID->16467]
}, Open  ]],
Cell[CellGroupData[{
Cell[3094, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3572, 105, 152, 4, 70, "Notes",
 CellID->12083],
Cell[3727, 111, 201, 8, 70, "Notes",
 CellID->3400]
}, Closed]],
Cell[CellGroupData[{
Cell[3965, 124, 311, 9, 70, "SeeAlsoSection",
 CellID->20920],
Cell[4279, 135, 2626, 98, 70, "SeeAlso",
 CellID->18366]
}, Open  ]],
Cell[CellGroupData[{
Cell[6942, 238, 314, 9, 70, "TutorialsSection",
 CellID->11158],
Cell[7259, 249, 135, 3, 70, "Tutorials",
 CellID->15606]
}, Open  ]],
Cell[7409, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

