(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9120,        312]
NotebookOptionsPosition[      7438,        257]
NotebookOutlinePosition[      8420,        285]
CellTagsIndexPosition[      8377,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Dsharp6" :> 
          Documentation`HelpLookup["paclet:Music/ref/Dsharp6"], "E6" :> 
          Documentation`HelpLookup["paclet:Music/ref/E6"], "Esharp6" :> 
          Documentation`HelpLookup["paclet:Music/ref/Esharp6"], "Eflat5" :> 
          Documentation`HelpLookup["paclet:Music/ref/Eflat5"], "Eflat7" :> 
          Documentation`HelpLookup["paclet:Music/ref/Eflat7"], "C6" :> 
          Documentation`HelpLookup["paclet:Music/ref/C6"], "D6" :> 
          Documentation`HelpLookup["paclet:Music/ref/D6"], "F6" :> 
          Documentation`HelpLookup["paclet:Music/ref/F6"], "G6" :> 
          Documentation`HelpLookup["paclet:Music/ref/G6"], "A6" :> 
          Documentation`HelpLookup["paclet:Music/ref/A6"], "B6" :> 
          Documentation`HelpLookup["paclet:Music/ref/B6"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Dsharp6\"\>", 2->"\<\"E6\"\>", 
       3->"\<\"Esharp6\"\>", 4->"\<\"Eflat5\"\>", 5->"\<\"Eflat7\"\>", 
       6->"\<\"C6\"\>", 7->"\<\"D6\"\>", 8->"\<\"F6\"\>", 9->"\<\"G6\"\>", 
       10->"\<\"A6\"\>", 11->"\<\"B6\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Eflat6", "ObjectName",
 CellID->28717],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Eflat6"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note E-flat in octave 6."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->28392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Eflat6"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->28752],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11324]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22070],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Dsharp6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Dsharp6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Esharp6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Esharp6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eflat5",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Eflat5"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Eflat7",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Eflat7"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A6"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B6",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B6"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->16843]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19773],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->27740]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Eflat6 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 2, 34.5750442}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Eflat6 gives the frequency of the note E-flat in octave 6.",
     "synonyms" -> {}, "title" -> "Eflat6", "type" -> "Symbol", "uri" -> 
    "Music/ref/Eflat6"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 44, 1, 70, "ObjectName",
 CellID->28717],
Cell[2711, 73, 347, 10, 70, "Usage",
 CellID->28392]
}, Open  ]],
Cell[CellGroupData[{
Cell[3095, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3573, 105, 152, 4, 70, "Notes",
 CellID->28752],
Cell[3728, 111, 202, 8, 70, "Notes",
 CellID->11324]
}, Closed]],
Cell[CellGroupData[{
Cell[3967, 124, 311, 9, 70, "SeeAlsoSection",
 CellID->22070],
Cell[4281, 135, 2626, 98, 70, "SeeAlso",
 CellID->16843]
}, Open  ]],
Cell[CellGroupData[{
Cell[6944, 238, 314, 9, 70, "TutorialsSection",
 CellID->19773],
Cell[7261, 249, 135, 3, 70, "Tutorials",
 CellID->27740]
}, Open  ]],
Cell[7411, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

