(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9120,        312]
NotebookOptionsPosition[      7438,        257]
NotebookOutlinePosition[      8420,        285]
CellTagsIndexPosition[      8377,        282]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Fsharp3" :> 
          Documentation`HelpLookup["paclet:Music/ref/Fsharp3"], "G3" :> 
          Documentation`HelpLookup["paclet:Music/ref/G3"], "Gsharp3" :> 
          Documentation`HelpLookup["paclet:Music/ref/Gsharp3"], "Gflat2" :> 
          Documentation`HelpLookup["paclet:Music/ref/Gflat2"], "Gflat4" :> 
          Documentation`HelpLookup["paclet:Music/ref/Gflat4"], "C3" :> 
          Documentation`HelpLookup["paclet:Music/ref/C3"], "D3" :> 
          Documentation`HelpLookup["paclet:Music/ref/D3"], "E3" :> 
          Documentation`HelpLookup["paclet:Music/ref/E3"], "F3" :> 
          Documentation`HelpLookup["paclet:Music/ref/F3"], "A3" :> 
          Documentation`HelpLookup["paclet:Music/ref/A3"], "B3" :> 
          Documentation`HelpLookup["paclet:Music/ref/B3"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"Fsharp3\"\>", 2->"\<\"G3\"\>", 
       3->"\<\"Gsharp3\"\>", 4->"\<\"Gflat2\"\>", 5->"\<\"Gflat4\"\>", 
       6->"\<\"C3\"\>", 7->"\<\"D3\"\>", 8->"\<\"E3\"\>", 9->"\<\"F3\"\>", 
       10->"\<\"A3\"\>", 11->"\<\"B3\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Gflat3", "ObjectName",
 CellID->30556],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Gflat3"], "InlineFormula"],
     " \[LineSeparator]gives the frequency of the note G-flat in octave 3."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17973]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["Gflat3"], "InlineFormula"],
 " is the name of a pitch in the standard equal-tempered scale."
}], "Notes",
 CellID->27116],

Cell[TextData[{
 "The frequency is measured in ",
 Cell[BoxData[
  ButtonBox["Hertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Units/ref/Hertz"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->11957]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->30672],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Fsharp3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Fsharp3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["G3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/G3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gsharp3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Gsharp3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gflat2",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Gflat2"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Gflat4",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/Gflat4"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["C3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/C3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["D3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/D3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["E3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/E3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["F3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/F3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["A3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/A3"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["B3",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/B3"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19814]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28286],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->27366]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Gflat3 - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 14.6698206}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> "Gflat3 gives the frequency of the note G-flat in octave 3.",
     "synonyms" -> {}, "title" -> "Gflat3", "type" -> "Symbol", "uri" -> 
    "Music/ref/Gflat3"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2041, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2664, 70, 44, 1, 70, "ObjectName",
 CellID->30556],
Cell[2711, 73, 347, 10, 70, "Usage",
 CellID->17973]
}, Open  ]],
Cell[CellGroupData[{
Cell[3095, 88, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3573, 105, 152, 4, 70, "Notes",
 CellID->27116],
Cell[3728, 111, 202, 8, 70, "Notes",
 CellID->11957]
}, Closed]],
Cell[CellGroupData[{
Cell[3967, 124, 311, 9, 70, "SeeAlsoSection",
 CellID->30672],
Cell[4281, 135, 2626, 98, 70, "SeeAlso",
 CellID->19814]
}, Open  ]],
Cell[CellGroupData[{
Cell[6944, 238, 314, 9, 70, "TutorialsSection",
 CellID->28286],
Cell[7261, 249, 135, 3, 70, "Tutorials",
 CellID->27366]
}, Open  ]],
Cell[7411, 255, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

