(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7836,        270]
NotebookOptionsPosition[      6017,        210]
NotebookOutlinePosition[      7030,        239]
CellTagsIndexPosition[      6987,        236]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MeanMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/MeanMajor"], "MeanMinor" :> 
          Documentation`HelpLookup["paclet:Music/ref/MeanMinor"], 
          "PythagoreanChromatic" :> 
          Documentation`HelpLookup["paclet:Music/ref/PythagoreanChromatic"], 
          "TemperedChromatic" :> 
          Documentation`HelpLookup["paclet:Music/ref/TemperedChromatic"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MeanMajor\"\>", 
       2->"\<\"MeanMinor\"\>", 3->"\<\"PythagoreanChromatic\"\>", 
       4->"\<\"TemperedChromatic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MeanChromatic", "ObjectName",
 CellID->27928],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["MeanChromatic"], "InlineFormula"],
     " \[LineSeparator]is an interval list for the Mean Chromatic scale."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Intervals are measured in cents.", "Notes",
 CellID->24332],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MusicScale",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MusicScale"], "[", 
   RowBox[{"MeanChromatic", ",", 
    StyleBox["freq", "TI"], ",", 
    StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object that is a sequence of pitches corresponding to the Mean Chromatic \
scale."
}], "Notes",
 CellID->21866],

Cell["\<\
The Mean Chromatic scale uses 696.6 cents as the definition of a fifth, \
instead of 702 cents as in the Pythagorean and Just Intonation systems.\
\>", "Notes",
 CellID->26458],

Cell[TextData[{
 "This scale was invented in the 18",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["\[Null]", "th"], TraditionalForm]]],
 " century by Gottfried Silbermann to correct for intonation problems due to \
enharmonic change."
}], "Notes",
 CellID->15266]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13360],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MeanMajor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanMinor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MeanMinor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PythagoreanChromatic",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/PythagoreanChromatic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TemperedChromatic",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/TemperedChromatic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->23166]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9463],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->26913]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MeanChromatic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 23.8888066}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "MeanChromatic is an interval list for the Mean Chromatic scale.", 
    "synonyms" -> {}, "title" -> "MeanChromatic", "type" -> "Symbol", "uri" -> 
    "Music/ref/MeanChromatic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1546, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2169, 64, 51, 1, 70, "ObjectName",
 CellID->27928],
Cell[2223, 67, 352, 10, 70, "Usage",
 CellID->15094]
}, Open  ]],
Cell[CellGroupData[{
Cell[2612, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3090, 99, 65, 1, 70, "Notes",
 CellID->24332],
Cell[3158, 102, 512, 17, 70, "Notes",
 CellID->21866],
Cell[3673, 121, 186, 4, 70, "Notes",
 CellID->26458],
Cell[3862, 127, 263, 8, 70, "Notes",
 CellID->15266]
}, Closed]],
Cell[CellGroupData[{
Cell[4162, 140, 311, 9, 70, "SeeAlsoSection",
 CellID->13360],
Cell[4476, 151, 1011, 35, 70, "SeeAlso",
 CellID->23166]
}, Open  ]],
Cell[CellGroupData[{
Cell[5524, 191, 313, 9, 70, "TutorialsSection",
 CellID->9463],
Cell[5840, 202, 135, 3, 70, "Tutorials",
 CellID->26913]
}, Open  ]],
Cell[5990, 208, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

