(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9278,        291]
NotebookOptionsPosition[      7395,        233]
NotebookOutlinePosition[      8558,        264]
CellTagsIndexPosition[      8515,        261]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"Music Package" :> 
         Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
       Evaluator -> Automatic], {
      1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
      StyleBox["\<\"tutorials\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["MusicScale", "ObjectName",
 CellID->23630],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"MusicScale", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["1", "TR"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["2", "TR"]], ",", 
          StyleBox["\[Ellipsis]", "TR"]}], "}"}], ",", 
        StyleBox["freq", "TI"], ",", 
        StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]creates a ",
     Cell[BoxData[
      ButtonBox["Sound",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
     " object that is a sequence of pitches corresponding to numbers ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["1", "TR"]], ",", 
       SubscriptBox[
        StyleBox["i", "TI"], 
        StyleBox["2", "TR"]], ",", 
       StyleBox["\[Ellipsis]", "TR"]}]], "InlineFormula"],
     ", a list of intervals measured in cents, starting at ",
     Cell[BoxData[
      StyleBox["freq", "TI"]], "InlineFormula"],
     " Hertz and lasting ",
     Cell[BoxData[
      StyleBox["dur", "TI"]], "InlineFormula"],
     " seconds."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->5094]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["MusicScale"], "InlineFormula"],
 " creates a pitch sequence from a predefined interval list or an arbitrary \
list of numbers interpreted as intervals."
}], "Notes",
 CellID->10400],

Cell["\<\
The list of intervals does not have to be in ascending or descending order.\
\>", "Notes",
 CellID->8993],

Cell["The following predefined interval lists may be given:", "Notes",
 CellID->2054],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["JustMajor",
     BaseStyle->"Link",
     ButtonData->"paclet:Music/ref/JustMajor"], Cell[
    "interval list for the Just Major scale", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["JustMinor",
     BaseStyle->"Link",
     ButtonData->"paclet:Music/ref/JustMinor"], Cell[
    "interval list for the minor version of the Just Major scale", 
     "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeanChromatic",
     BaseStyle->"Link",
     ButtonData->"paclet:Music/ref/MeanChromatic"], Cell[
    "interval list for the Mean Chromatic scale", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["MeanMajor",
     BaseStyle->"Link",
     ButtonData->"paclet:Music/ref/MeanMajor"], Cell[
    "interval list derived from the Mean Chromatic scale", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PythagoreanChromatic",
     BaseStyle->"Link",
     ButtonData->"paclet:Music/ref/PythagoreanChromatic"], Cell[
    "interval list for the Pythagorean Chromatic scale", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["PythagoreanMajor",
     BaseStyle->"Link",
     ButtonData->"paclet:Music/ref/PythagoreanMajor"], Cell[
    "interval list for the Pythagorean Major scale", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["QuarterTone",
     BaseStyle->"Link",
     ButtonData->"paclet:Music/ref/QuarterTone"], Cell[
    "interval list in which each semitone is split in two", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["SixthTone",
     BaseStyle->"Link",
     ButtonData->"paclet:Music/ref/SixthTone"], Cell[
    "interval list in which each semitone is split in three", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TemperedChromatic",
     BaseStyle->"Link",
     ButtonData->"paclet:Music/ref/TemperedChromatic"], Cell[
    "interval list corresponding to an equal-tempered scale", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TemperedMajor",
     BaseStyle->"Link",
     ButtonData->"paclet:Music/ref/TemperedMajor"], Cell[
    "interval list derived from the Tempered Chromatic scale", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["TemperedMinor",
     BaseStyle->"Link",
     ButtonData->"paclet:Music/ref/TemperedMinor"], Cell[
    "interval list derived from the Tempered Chromatic scale", "TableText"]}
  }]], "2ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {
    None, None, None, None, None, None, None, None, None, None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{
  "Rows" -> {{
     True, True, True, True, True, True, True, True, True, True, True, 
      True}}}},
 CellID->160919329],

Cell[TextData[{
 "The two functions ",
 Cell[BoxData[
  ButtonBox["HertzToCents",
   BaseStyle->"Link",
   ButtonData->"paclet:Music/ref/HertzToCents"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["CentsToHertz",
   BaseStyle->"Link",
   ButtonData->"paclet:Music/ref/CentsToHertz"]], "InlineFormula"],
 " convert a list of one type to its complementary type."
}], "Notes",
 CellID->29204]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->5542],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->26124]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"MusicScale - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 30.8264842}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "MusicScale[{i_1, i_2, ...}, freq, dur] creates a Sound object that is a \
sequence of pitches corresponding to numbers i_1, i_2, ..., a list of \
intervals measured in cents, starting at freq Hertz and lasting dur seconds.",
     "synonyms" -> {}, "title" -> "MusicScale", "type" -> "Symbol", "uri" -> 
    "Music/ref/MusicScale"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 578, 15, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1201, 42, 48, 1, 70, "ObjectName",
 CellID->23630],
Cell[1252, 45, 1423, 44, 70, "Usage",
 CellID->5094]
}, Open  ]],
Cell[CellGroupData[{
Cell[2712, 94, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3190, 111, 212, 5, 70, "Notes",
 CellID->10400],
Cell[3405, 118, 115, 3, 70, "Notes",
 CellID->8993],
Cell[3523, 123, 85, 1, 70, "Notes",
 CellID->2054],
Cell[3611, 126, 2850, 68, 70, "2ColumnTableMod",
 CellID->160919329],
Cell[6464, 196, 401, 13, 70, "Notes",
 CellID->29204]
}, Closed]],
Cell[CellGroupData[{
Cell[6902, 214, 313, 9, 70, "TutorialsSection",
 CellID->5542],
Cell[7218, 225, 135, 3, 70, "Tutorials",
 CellID->26124]
}, Open  ]],
Cell[7368, 231, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

