(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7128,        250]
NotebookOptionsPosition[      5282,        190]
NotebookOutlinePosition[      6327,        219]
CellTagsIndexPosition[      6284,        216]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"MeanChromatic" :> 
          Documentation`HelpLookup["paclet:Music/ref/MeanChromatic"], 
          "TemperedChromatic" :> 
          Documentation`HelpLookup["paclet:Music/ref/TemperedChromatic"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"MeanChromatic\"\>", 
       2->"\<\"TemperedChromatic\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PythagoreanChromatic", "ObjectName",
 CellID->7639],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PythagoreanChromatic"], "InlineFormula"],
     " \[LineSeparator]is an interval list for the Pythagorean Chromatic \
scale."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->17508]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The Pythagorean Chromatic scale is an extension of the Pythagorean Major \
scale defined by ",
 Cell[BoxData[
  ButtonBox["PythagoreanMajor",
   BaseStyle->"Link",
   ButtonData->"paclet:Music/ref/PythagoreanMajor"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->17460],

Cell["Intervals are measured in cents.", "Notes",
 CellID->25682],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MusicScale",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MusicScale"], "[", 
   RowBox[{"PythagoreanChromatic", ",", 
    StyleBox["freq", "TI"], ",", 
    StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object that is a sequence of pitches corresponding to ",
 "the Pythagorean Chromatic scale."
}], "Notes",
 CellID->30586],

Cell["\<\
This scale has 21 notes, since the complete scale requires 7 \"natural\" \
notes, 7 \"flat\" notes, and 7 \"sharp\" notes.\
\>", "Notes",
 CellID->11495]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->5119],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanChromatic",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MeanChromatic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TemperedChromatic",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/TemperedChromatic"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5138]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9122],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->3935]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PythagoreanChromatic - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 31.2952462}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "PythagoreanChromatic is an interval list for the Pythagorean Chromatic \
scale.", "synonyms" -> {}, "title" -> "PythagoreanChromatic", "type" -> 
    "Symbol", "uri" -> "Music/ref/PythagoreanChromatic"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1294, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1917, 60, 57, 1, 70, "ObjectName",
 CellID->7639],
Cell[1977, 63, 368, 11, 70, "Usage",
 CellID->17508]
}, Open  ]],
Cell[CellGroupData[{
Cell[2382, 79, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2860, 96, 287, 9, 70, "Notes",
 CellID->17460],
Cell[3150, 107, 65, 1, 70, "Notes",
 CellID->25682],
Cell[3218, 110, 529, 17, 70, "Notes",
 CellID->30586],
Cell[3750, 129, 163, 4, 70, "Notes",
 CellID->11495]
}, Closed]],
Cell[CellGroupData[{
Cell[3950, 138, 310, 9, 70, "SeeAlsoSection",
 CellID->5119],
Cell[4263, 149, 490, 17, 70, "SeeAlso",
 CellID->5138]
}, Open  ]],
Cell[CellGroupData[{
Cell[4790, 171, 313, 9, 70, "TutorialsSection",
 CellID->9122],
Cell[5106, 182, 134, 3, 70, "Tutorials",
 CellID->3935]
}, Open  ]],
Cell[5255, 188, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

