(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7810,        267]
NotebookOptionsPosition[      5978,        207]
NotebookOutlinePosition[      7006,        236]
CellTagsIndexPosition[      6963,        233]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"PythagoreanChromatic" :> 
          Documentation`HelpLookup["paclet:Music/ref/PythagoreanChromatic"], 
          "JustMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/JustMajor"], "MeanMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/MeanMajor"], 
          "TemperedMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/TemperedMajor"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"PythagoreanChromatic\"\>", 
       2->"\<\"JustMajor\"\>", 3->"\<\"MeanMajor\"\>", 
       4->"\<\"TemperedMajor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["PythagoreanMajor", "ObjectName",
 CellID->29063],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["PythagoreanMajor"], "InlineFormula"],
     " \[LineSeparator]is an interval list for the Pythagorean Major scale."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->25544]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Intervals are measured in cents.", "Notes",
 CellID->12249],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MusicScale",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MusicScale"], "[", 
   RowBox[{"PythagoreanMajor", ",", 
    StyleBox["freq", "TI"], ",", 
    StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object that is a sequence of pitches corresponding to the Pythagorean \
Major scale."
}], "Notes",
 CellID->14426],

Cell[TextData[{
 Cell[BoxData["PythagoreanMajor"], "InlineFormula"],
 " has an interval list in which the members of the scale are derived from a \
sequence of octaves and fifths, where a fifth is the ratio of 3/2 (702 cents) \
and an octave is the ratio of 2/1 (1200 cents)."
}], "Notes",
 CellID->6440],

Cell["\<\
The scale is built by successive fifth addition and octave subtraction.\
\>", "Notes",
 CellID->1662]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->14978],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["PythagoreanChromatic",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/PythagoreanChromatic"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JustMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/JustMajor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MeanMajor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["TemperedMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/TemperedMajor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->13727]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21291],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->9029]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"PythagoreanMajor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 31.4515002}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "PythagoreanMajor is an interval list for the Pythagorean Major scale.", 
    "synonyms" -> {}, "title" -> "PythagoreanMajor", "type" -> "Symbol", 
    "uri" -> "Music/ref/PythagoreanMajor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1534, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2157, 64, 54, 1, 70, "ObjectName",
 CellID->29063],
Cell[2214, 67, 358, 10, 70, "Usage",
 CellID->25544]
}, Open  ]],
Cell[CellGroupData[{
Cell[2609, 82, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3087, 99, 65, 1, 70, "Notes",
 CellID->12249],
Cell[3155, 102, 518, 17, 70, "Notes",
 CellID->14426],
Cell[3676, 121, 304, 6, 70, "Notes",
 CellID->6440],
Cell[3983, 129, 111, 3, 70, "Notes",
 CellID->1662]
}, Closed]],
Cell[CellGroupData[{
Cell[4131, 137, 311, 9, 70, "SeeAlsoSection",
 CellID->14978],
Cell[4445, 148, 1003, 35, 70, "SeeAlso",
 CellID->13727]
}, Open  ]],
Cell[CellGroupData[{
Cell[5485, 188, 314, 9, 70, "TutorialsSection",
 CellID->21291],
Cell[5802, 199, 134, 3, 70, "Tutorials",
 CellID->9029]
}, Open  ]],
Cell[5951, 205, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

