(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7557,        262]
NotebookOptionsPosition[      5785,        204]
NotebookOutlinePosition[      6808,        233]
CellTagsIndexPosition[      6765,        230]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["MUSIC PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Music Package" :> 
          Documentation`HelpLookup["paclet:Music/tutorial/Music"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Music Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"TemperedMinor" :> 
          Documentation`HelpLookup["paclet:Music/ref/TemperedMinor"], 
          "JustMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/JustMajor"], "MeanMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/MeanMajor"], 
          "PythagoreanMajor" :> 
          Documentation`HelpLookup["paclet:Music/ref/PythagoreanMajor"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"TemperedMinor\"\>", 
       2->"\<\"JustMajor\"\>", 3->"\<\"MeanMajor\"\>", 
       4->"\<\"PythagoreanMajor\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["TemperedMajor", "ObjectName",
 CellID->18321],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["TemperedMajor"], "InlineFormula"],
     " \[LineSeparator]is an interval list derived from the Tempered \
Chromatic scale."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->636]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Intervals are measured in cents.", "Notes",
 CellID->18677],

Cell[TextData[{
 Cell[BoxData[
  RowBox[{
   ButtonBox["MusicScale",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MusicScale"], "[", 
   RowBox[{"TemperedMajor", ",", 
    StyleBox["freq", "TI"], ",", 
    StyleBox["dur", "TI"]}], "]"}]], "InlineFormula"],
 " creates a ",
 Cell[BoxData[
  ButtonBox["Sound",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Sound"]], "InlineFormula"],
 " object that is a sequence of pitches corresponding to the Tempered Major \
scale."
}], "Notes",
 CellID->17995],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["TemperedChromatic",
   BaseStyle->"Link",
   ButtonData->"paclet:Music/ref/TemperedChromatic"]], "InlineFormula"],
 " gives the interval list of the Tempered Chromatic scale."
}], "Notes",
 CellID->30906]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6133],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["TemperedMinor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/TemperedMinor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["JustMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/JustMajor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["MeanMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/MeanMajor"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["PythagoreanMajor",
    BaseStyle->"Link",
    ButtonData->"paclet:Music/ref/PythagoreanMajor"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->29566]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19463],

Cell[TextData[ButtonBox["Music Package",
 BaseStyle->"Link",
 ButtonData->"paclet:Music/tutorial/Music"]], "Tutorials",
 CellID->5249]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"TemperedMajor - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 32.1233924}", "context" -> "Music`", 
    "keywords" -> {}, "index" -> True, "label" -> "Music Package Symbol", 
    "language" -> "en", "paclet" -> "Music Package", "status" -> "None", 
    "summary" -> 
    "TemperedMajor is an interval list derived from the Tempered Chromatic \
scale.", "synonyms" -> {}, "title" -> "TemperedMajor", "type" -> "Symbol", 
    "uri" -> "Music/ref/TemperedMajor"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1522, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2145, 64, 51, 1, 70, "ObjectName",
 CellID->18321],
Cell[2199, 67, 365, 11, 70, "Usage",
 CellID->636]
}, Open  ]],
Cell[CellGroupData[{
Cell[2601, 83, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3079, 100, 65, 1, 70, "Notes",
 CellID->18677],
Cell[3147, 103, 512, 17, 70, "Notes",
 CellID->17995],
Cell[3662, 122, 248, 7, 70, "Notes",
 CellID->30906]
}, Closed]],
Cell[CellGroupData[{
Cell[3947, 134, 310, 9, 70, "SeeAlsoSection",
 CellID->6133],
Cell[4260, 145, 995, 35, 70, "SeeAlso",
 CellID->29566]
}, Open  ]],
Cell[CellGroupData[{
Cell[5292, 185, 314, 9, 70, "TutorialsSection",
 CellID->19463],
Cell[5609, 196, 134, 3, 70, "Tutorials",
 CellID->5249]
}, Open  ]],
Cell[5758, 202, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

