(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6171,        204]
NotebookOptionsPosition[      4588,        156]
NotebookOutlinePosition[      5690,        186]
CellTagsIndexPosition[      5647,        183]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NOTATION PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notation, Symbolize and InfixNotation" :> 
          Documentation`HelpLookup[
           "paclet:Notation/tutorial/NotationSymbolizeAndInfixNotation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Notation, Symbolize and InfixNotation\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notation" :> 
          Documentation`HelpLookup["paclet:Notation/ref/Notation"], 
          "Symbolize" :> 
          Documentation`HelpLookup["paclet:Notation/ref/Symbolize"], 
          "RemoveInfixNotation" :> 
          Documentation`HelpLookup[
           "paclet:Notation/ref/RemoveInfixNotation"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"Notation\"\>", 2->"\<\"Symbolize\"\>", 
       3->"\<\"RemoveInfixNotation\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["InfixNotation", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"InfixNotation", "[", 
       RowBox[{
        StyleBox["op", "TI"], ",", 
        StyleBox["func", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]forces the box structure ",
     Cell[BoxData[
      StyleBox["op", "TI"]], "InlineFormula"],
     " to be treated as an infix operator representing the function ",
     Cell[BoxData[
      StyleBox["func", "TI"]], "InlineFormula"],
     " in input and output."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Notation",
    BaseStyle->"Link",
    ButtonData->"paclet:Notation/ref/Notation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Symbolize",
    BaseStyle->"Link",
    ButtonData->"paclet:Notation/ref/Symbolize"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RemoveInfixNotation",
    BaseStyle->"Link",
    ButtonData->"paclet:Notation/ref/RemoveInfixNotation"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Notation, Symbolize and InfixNotation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Notation/tutorial/NotationSymbolizeAndInfixNotation"]], "Tutorials",\

 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"InfixNotation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 46.9050208}", "context" -> "Notation`", 
    "keywords" -> {}, "index" -> True, "label" -> "Notation Package Symbol", 
    "language" -> "en", "paclet" -> "Notation Package", "status" -> "None", 
    "summary" -> 
    "InfixNotation[op, func] forces the box structure op to be treated as an \
infix operator representing the function func in input and output.", 
    "synonyms" -> {}, "title" -> "InfixNotation", "type" -> "Symbol", "uri" -> 
    "Notation/ref/InfixNotation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1519, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2142, 65, 56, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2201, 68, 681, 20, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[2919, 93, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[3238, 104, 751, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[4026, 135, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[4347, 146, 199, 5, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[4561, 154, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

