(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6892,        222]
NotebookOptionsPosition[      5170,        172]
NotebookOutlinePosition[      6409,        204]
CellTagsIndexPosition[      6366,        201]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NOTATION PACKAGE SYMBOL", "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notation, Symbolize and InfixNotation" :> 
          Documentation`HelpLookup[
           "paclet:Notation/tutorial/NotationSymbolizeAndInfixNotation"]}, #, 
         2]& , Evaluator -> Automatic], {
       1->"\<\"Notation, Symbolize and InfixNotation\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Notation" :> 
          Documentation`HelpLookup["paclet:Notation/ref/Notation"], 
          "RemoveInfixNotation" :> 
          Documentation`HelpLookup["paclet:Notation/ref/RemoveInfixNotation"],
           "RemoveSymbolize" :> 
          Documentation`HelpLookup["paclet:Notation/ref/RemoveSymbolize"]}, #,
          2]& , Evaluator -> Automatic], {1->"\<\"Notation\"\>", 
       2->"\<\"RemoveInfixNotation\"\>", 
       3->"\<\"RemoveSymbolize\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["RemoveNotation", "ObjectName",
 CellID->1224892054],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RemoveNotation", "[", 
       RowBox[{
        StyleBox["boxes", "TI"], " ", "\[DoubleLongLeftRightArrow]", " ", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]removes the notation ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " \[DoubleLongLeftRightArrow] ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     "."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RemoveNotation", "[", 
       RowBox[{
        StyleBox["boxes", "TI"], "\[DoubleLongRightArrow]", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]removes only the parsing."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"RemoveNotation", "[", 
       RowBox[{
        StyleBox["boxes", "TI"], "\[DoubleLongLeftArrow]", 
        StyleBox["expr", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]removes only the formatting."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, {None}}, "RowsIndexed" -> {}}},
 CellID->982511436]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1255426704],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Notation",
    BaseStyle->"Link",
    ButtonData->"paclet:Notation/ref/Notation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RemoveInfixNotation",
    BaseStyle->"Link",
    ButtonData->"paclet:Notation/ref/RemoveInfixNotation"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RemoveSymbolize",
    BaseStyle->"Link",
    ButtonData->"paclet:Notation/ref/RemoveSymbolize"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->929782353]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->250839057],

Cell[TextData[ButtonBox["Notation, Symbolize and InfixNotation",
 BaseStyle->"Link",
 ButtonData->
  "paclet:Notation/tutorial/NotationSymbolizeAndInfixNotation"]], "Tutorials",\

 CellID->341631938]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"RemoveNotation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 3, 55.5771178}", "context" -> "Notation`", 
    "keywords" -> {}, "index" -> True, "label" -> "Notation Package Symbol", 
    "language" -> "en", "paclet" -> "Notation Package", "status" -> "None", 
    "summary" -> 
    "RemoveNotation[boxes \\[DoubleLongLeftRightArrow] expr] removes the \
notation boxes \\[DoubleLongLeftRightArrow] expr. \
RemoveNotation[boxes\\[DoubleLongRightArrow]expr] removes only the parsing. \
RemoveNotation[boxes\\[DoubleLongLeftArrow]expr] removes only the \
formatting.", "synonyms" -> {}, "title" -> "RemoveNotation", "type" -> 
    "Symbol", "uri" -> "Notation/ref/RemoveNotation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1534, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2157, 65, 57, 1, 70, "ObjectName",
 CellID->1224892054],
Cell[2217, 68, 1235, 36, 70, "Usage",
 CellID->982511436]
}, Open  ]],
Cell[CellGroupData[{
Cell[3489, 109, 316, 9, 70, "SeeAlsoSection",
 CellID->1255426704],
Cell[3808, 120, 763, 26, 70, "SeeAlso",
 CellID->929782353]
}, Open  ]],
Cell[CellGroupData[{
Cell[4608, 151, 318, 9, 70, "TutorialsSection",
 CellID->250839057],
Cell[4929, 162, 199, 5, 70, "Tutorials",
 CellID->341631938]
}, Open  ]],
Cell[5143, 170, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

