(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     94015,       2633]
NotebookOptionsPosition[     44426,       1491]
NotebookOutlinePosition[     81951,       2331]
CellTagsIndexPosition[     81606,       2319]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NOTATION PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"InfixNotation" :> 
         Documentation`HelpLookup["paclet:Notation/ref/InfixNotation"], 
         "Notation" :> 
         Documentation`HelpLookup["paclet:Notation/ref/Notation"], 
         "RemoveInfixNotation" :> 
         Documentation`HelpLookup["paclet:Notation/ref/RemoveInfixNotation"], 
         "RemoveNotation" :> 
         Documentation`HelpLookup["paclet:Notation/ref/RemoveNotation"], 
         "RemoveSymbolize" :> 
         Documentation`HelpLookup["paclet:Notation/ref/RemoveSymbolize"], 
         "Symbolize" :> 
         Documentation`HelpLookup["paclet:Notation/ref/Symbolize"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"InfixNotation\"\>", 
      2->"\<\"Notation\"\>", 3->"\<\"RemoveInfixNotation\"\>", 
      4->"\<\"RemoveNotation\"\>", 5->"\<\"RemoveSymbolize\"\>", 
      6->"\<\"Symbolize\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Notation, Symbolize and InfixNotation", "Title",
 CellTags->"NotationDocumentation",
 CellID->58446231],

Cell[CellGroupData[{

Cell["Notation", "Section",
 CellTags->{"Notation:S1", "NotationDocumentation"},
 CellID->184195116],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Notation",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/Notation"], "[", 
     RowBox[{
      StyleBox["boxes", "TI"], " ", "\[DoubleLongLeftRightArrow]", " ", 
      StyleBox["expr", "TI"]}], "]"}], Cell[TextData[{
     "set ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " to be parsed to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " and ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to be formatted as ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Notation",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/Notation"], "[", 
     RowBox[{
      StyleBox["boxes", "TI"], " ", "\[DoubleLongRightArrow]", " ", 
      StyleBox["expr", "TI"]}], "]"}], Cell[TextData[{
     "set ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " to be parsed to ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Notation",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/Notation"], "[", 
     RowBox[{
      StyleBox["boxes", "TI"], " ", "\[DoubleLongLeftArrow]", " ", 
      StyleBox["expr", "TI"]}], "]"}], Cell[TextData[{
     "set ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " to be formatted as ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Notation",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/Notation"], "[", 
     StyleBox["notation", "TI"], ",", " ", 
     StyleBox["opts", "TI"], "]"}], Cell[TextData[{
     "define a notation ",
     Cell[BoxData[
      StyleBox["notation", "TI"]], "InlineFormula"],
     " with the options ",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RemoveNotation",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/RemoveNotation"], "[", 
     StyleBox["notation", "TI"], "]"}], Cell[TextData[{
     "remove the notation ",
     Cell[BoxData[
      StyleBox["notation", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->125841609],

Cell["Syntax of notation declarations.", "Caption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->83264530],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Notation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Notation"]], "InlineFormula"],
 " takes both an external representation and an internal representation as \
arguments. ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " translates any input matching the external representation into the \
corresponding internal representation and, reciprocally, formats any \
expression matching the internal representation into the corresponding \
external representation.",
 " ",
 "In this context, representation means a composite structure made up of \
boxes representing some \"notation\"."
}], "Text",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->220031767],

Cell["This loads the package. ", "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->152819323],

Cell[BoxData[
 RowBox[{"<<", "Notation`"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[1]:=",
 CellID->25990533],

Cell[TextData[{
 "The following declares a new notation for ",
 StyleBox["gplus", "MR"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->131976459],

Cell[BoxData[
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox[
    RowBox[{
     RowBox[{"x_", " ", 
      SubscriptBox["\[CirclePlus]", "n_"], " ", "y_"}], " "}],
    "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
   TagBox[
    RowBox[{" ", 
     RowBox[{"gplus", "[", 
      RowBox[{"x_", ",", "y_", ",", "n_"}], "]"}]}],
    "NotationTemplateTag"]}], "]"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[2]:=",
 CellID->82520988],

Cell[TextData[{
 "Any input matching",
 " ",
 Cell[BoxData[
  FormBox[
   RowBox[{"x_", " ", 
    RowBox[{
     SubscriptBox["\[CirclePlus]", "n_"], " ", "y_"}]}], TraditionalForm]]],
 " is now interpreted as ",
 StyleBox["gplus[x,y,n]", "MR"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->200441114],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", 
   SubscriptBox["\[CirclePlus]", 
    RowBox[{"n", "+", "m"}]], " ", "b"}], " ", "//", " ", 
  "FullForm"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[3]:=",
 CellID->356568269],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"gplus", "[", 
    RowBox[{"a", ",", "b", ",", 
     RowBox[{"Plus", "[", 
      RowBox[{"m", ",", "n"}], "]"}]}], "]"}],
   ShowStringCharacters->True],
  FullForm]], "Output",
 ImageSize->{157, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"Out[3]//FullForm=",
 CellID->158530954]
}, Open  ]],

Cell[TextData[{
 "Any ",
 StyleBox["gplus", "MR"],
 " expression is now formatted in the new notation."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->145061192],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"gplus", "[", 
  RowBox[{"\[Alpha]", ",", " ", "\[Beta]", ",", " ", "\[CapitalGamma]"}], 
  "]"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[4]:=",
 CellID->532090564],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Alpha]", " ", 
   SubscriptBox["\[CirclePlus]", "\[CapitalGamma]"], " ", "\[Beta]"}], 
  " "}]], "Output",
 ImageSize->{44, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"Out[4]=",
 CellID->179622149]
}, Open  ]],

Cell[TextData[{
 "Notations defined using ",
 Cell[BoxData[
  FormBox["\[DoubleLongLeftRightArrow]", TraditionalForm]]],
 " in their definition both parse and format expressions according to the \
given notation. However, you can restrict the notation to only parsing or \
only formatting by using ",
 Cell[BoxData[
  FormBox["\[DoubleLongRightArrow]", TraditionalForm]]],
 " or ",
 Cell[BoxData[
  FormBox["\[DoubleLongLeftArrow]", TraditionalForm]]],
 " respectively, instead of ",
 Cell[BoxData[
  FormBox["\[DoubleLongLeftRightArrow]", TraditionalForm]]],
 " in your notation statements."
}], "Text",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->230147683],

Cell[TextData[{
 "This defines a notation for the parsing of a hypothetical ",
 StyleBox["DomainIntegral", "MR"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->386295218],

Cell[BoxData[
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox[
    RowBox[{
     SubscriptBox["\[Integral]", "\[ScriptCapitalD]"], 
     RowBox[{"f_", " ", 
      RowBox[{"\[CapitalDifferentialD]", "x_"}]}]}],
    "NotationTemplateTag"], " ", "\[DoubleLongRightArrow]", " ", 
   TagBox[
    RowBox[{"DomainIntegral", "[", 
     RowBox[{"f_", ",", "x_"}], "]"}],
    "NotationTemplateTag"]}], "]"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[5]:=",
 CellID->164104568],

Cell[TextData[{
 StyleBox["DomainIntegrals", "MR"],
 " are now parsable."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->461060774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Integral]", "\[ScriptCapitalD]"], 
  RowBox[{
   RowBox[{
    RowBox[{"\[Delta]", "'"}], "[", "x", "]"}], 
   RowBox[{"\[CapitalDifferentialD]", "x"}]}]}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[6]:=",
 CellID->435999959],

Cell[BoxData[
 RowBox[{"DomainIntegral", "[", 
  RowBox[{
   RowBox[{
    SuperscriptBox["\[Delta]", "\[Prime]",
     MultilineFunction->None], "[", "x", "]"}], ",", "x"}], "]"}]], "Output",
 ImageSize->{166, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"Out[6]=",
 CellID->552718978]
}, Open  ]],

Cell[TextData[{
 "The following defines an output format for ",
 Cell[BoxData[
  ButtonBox["Derivative",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Derivative"]], "InlineFormula"],
 " objects that looks more like that of traditional mathematics."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->42010050],

Cell[BoxData[{
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox[
    FractionBox[
     RowBox[{"\[PartialD]", 
      RowBox[{"f_", "[", "x_", "]"}]}], 
     RowBox[{"\[PartialD]", "x_"}]],
    "NotationTemplateTag"], " ", "\[DoubleLongLeftArrow]", " ", 
   TagBox[
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", "1", "]"}], "[", "f_", "]"}], "[", "x_", 
     "]"}],
    "NotationTemplateTag"]}], "]"}], "\n", 
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox[
    FractionBox[
     RowBox[{
      SuperscriptBox["\[PartialD]", "n_"], 
      RowBox[{"f_", "[", "x_", "]"}]}], 
     RowBox[{"\[PartialD]", 
      SuperscriptBox["x_", "n_"]}]],
    "NotationTemplateTag"], " ", "\[DoubleLongLeftArrow]", " ", 
   TagBox[
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", "n_", "]"}], "[", "f_", "]"}], "[", "x_", 
     "]"}],
    "NotationTemplateTag"]}], "]"}]}], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[7]:=",
 CellID->15411296],

Cell["\<\
Derivatives are now formatted according to the new derivative notation.\
\>", "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->94100752],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox["\[CapitalGamma]", "\[Alpha]"], "'"}], "[", "t", "]"}], ",",
    " ", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"(", 
       RowBox[{"z", "+", "r"}], ")"}], "'"}], "'"}], "[", "q", "]"}]}], 
  "}"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[9]:=",
 CellID->19509129],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   FractionBox[
    RowBox[{"\[PartialD]", 
     RowBox[{
      SubscriptBox["\[CapitalGamma]", "\[Alpha]"], "[", "t", "]"}]}], 
    RowBox[{"\[PartialD]", "t"}]], ",", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[PartialD]", "2"], 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"r", "+", "z"}], ")"}], "[", "q", "]"}]}], 
    RowBox[{"\[PartialD]", 
     SuperscriptBox["q", "2"]}]]}], "}"}]], "Output",
 ImageSize->{155, 36},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"Out[9]=",
 CellID->518501910]
}, Open  ]],

Cell["\<\
To allow the previous output to be used as input you can define an \
interpretation of partial derivatives.\
\>", "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->80727247],

Cell[BoxData[{
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox[
    RowBox[{
     FractionBox[
      RowBox[{"\[PartialD]", "f_"}], 
      RowBox[{"\[PartialD]", "x_"}]], " "}],
    "NotationTemplateTag"], " ", "\[DoubleLongRightArrow]", " ", 
   TagBox[
    RowBox[{"D", "[", 
     RowBox[{"f_", ",", "x_"}], "]"}],
    "NotationTemplateTag"]}], "]"}], "\n", 
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox[
    RowBox[{
     FractionBox[
      RowBox[{
       SuperscriptBox["\[PartialD]", "n_"], "f_"}], 
      RowBox[{"\[PartialD]", 
       SuperscriptBox["x_", "n_"]}]], " "}],
    "NotationTemplateTag"], " ", "\[DoubleLongRightArrow]", " ", 
   TagBox[
    RowBox[{"D", "[", 
     RowBox[{"f_", ",", 
      RowBox[{"{", 
       RowBox[{"x_", ",", "n_"}], "}"}]}], "]"}],
    "NotationTemplateTag"]}], "]"}]}], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[10]:=",
 CellID->59190948],

Cell["You can now use these new notations for derivatives.", "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->382026760],

Cell[CellGroupData[{

Cell[BoxData[
 FractionBox[
  RowBox[{"\[PartialD]", 
   RowBox[{"(", 
    RowBox[{
     SuperscriptBox["y", "2"], "+", 
     RowBox[{"2", "y"}], "+", " ", 
     RowBox[{"Sin", "[", "y", "]"}], "+", 
     RowBox[{"f", "[", "y", "]"}]}], ")"}]}], 
  RowBox[{"\[PartialD]", "y"}]]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[12]:=",
 CellID->267671246],

Cell[BoxData[
 RowBox[{"2", "+", 
  RowBox[{"2", " ", "y"}], "+", 
  RowBox[{"Cos", "[", "y", "]"}], "+", 
  FractionBox[
   RowBox[{"\[PartialD]", 
    RowBox[{"f", "[", "y", "]"}]}], 
   RowBox[{"\[PartialD]", "y"}]]}]], "Output",
 ImageSize->{149, 32},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"Out[12]=",
 CellID->9933526]
}, Open  ]],

Cell["\<\
You should define your notations in such a way that they both parse and \
format, since users will generally expect this functionality.\
\>", "Text",
 Background->GrayLevel[1],
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->798039053],

Cell[TextData[{
 "The following notation both formats and parses arrows overscripted by ",
 Cell[BoxData[
  ButtonBox["Apply",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Apply"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->615157417],

Cell[BoxData[
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox[
    RowBox[{"a_", " ", 
     OverscriptBox["\[LongRightArrow]", 
      RowBox[{" ", "Apply", " "}]], " ", "b_", " "}],
    "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
   TagBox[
    RowBox[{"MyApply", "[", 
     RowBox[{"a_", ",", "b_"}], "]"}],
    "NotationTemplateTag"]}], "]"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[13]:=",
 CellID->312997119],

Cell["\<\
Simple rules like linearity can now be entered in a visually intuitive way.\
\>", "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->231589850],

Cell[BoxData[
 RowBox[{
  RowBox[{"a_", " ", 
   OverscriptBox["\[LongRightArrow]", 
    RowBox[{" ", "Apply", " "}]], " ", 
   RowBox[{"(", 
    RowBox[{"b_", " ", "+", " ", "c_"}], ")"}]}], " ", ":=", " ", 
  RowBox[{
   RowBox[{"a", " ", 
    OverscriptBox["\[LongRightArrow]", 
     RowBox[{" ", "Apply", " "}]], " ", "b"}], " ", "+", " ", 
   RowBox[{"a", " ", 
    OverscriptBox["\[LongRightArrow]", 
     RowBox[{" ", "Apply", " "}]], " ", "c"}]}]}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[14]:=",
 CellID->391444115],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", 
  OverscriptBox["\[LongRightArrow]", 
   RowBox[{" ", "Apply", " "}]], 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Sin", "[", "x", "]"}], "+", " ", 
    FractionBox[
     RowBox[{
      SuperscriptBox["\[PartialD]", "2"], 
      RowBox[{"f", "[", "x", "]"}]}], 
     RowBox[{"\[PartialD]", 
      SuperscriptBox["x", "2"]}]]}], ")"}]}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"In[15]:=",
 CellID->385849498],

Cell[BoxData[
 RowBox[{
  RowBox[{"a", " ", 
   OverscriptBox["\[LongRightArrow]", 
    RowBox[{" ", "Apply", " "}]], " ", 
   RowBox[{"Sin", "[", "x", "]"}]}], " ", "+", 
  RowBox[{"a", " ", 
   OverscriptBox["\[LongRightArrow]", 
    RowBox[{" ", "Apply", " "}]], " ", 
   FractionBox[
    RowBox[{
     SuperscriptBox["\[PartialD]", "2"], 
     RowBox[{"f", "[", "x", "]"}]}], 
    RowBox[{"\[PartialD]", 
     SuperscriptBox["x", "2"]}]], " "}]}]], "Output",
 ImageSize->{201, 34},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellLabel->"Out[15]=",
 CellID->767188241]
}, Open  ]],

Cell[TextData[{
 "You may at first feel that having underscores on both sides of a ",
 Cell[BoxData[
  ButtonBox["Notation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Notation"]], "InlineFormula"],
 " statement is somewhat unsettling.",
 " ",
 "However, notational transformations usually work in both directions, \
therefore having underscores on both sides of a notation statement is \
natural, and soon becomes intuitive."
}], "Text",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->9011352]
}, Open  ]],

Cell[CellGroupData[{

Cell["Symbolize", "Section",
 CellTags->{"Notation:S1", "NotationDocumentation"},
 CellID->378720807],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["Symbolize",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/Symbolize"], "[", 
     StyleBox["boxes", "TI"], "]"}], Cell[TextData[{
     "treat ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " as a symbol"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["Symbolize",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/Symbolize"], "[", 
     RowBox[{
      StyleBox["boxes", "TI"], ",", " ", 
      StyleBox["opts", "TI"]}], "]"}], Cell[TextData[{
     "treat ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " as a symbol with the options ",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RemoveSymbolize",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/RemoveSymbolize"], "[", 
     StyleBox["boxes", "TI"], "]"}], Cell[TextData[{
     "remove the treatment of ",
     Cell[BoxData[
      StyleBox["boxes", "TI"]], "InlineFormula"],
     " as a symbol"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->673993761],

Cell["Syntax of symbolization declarations.", "Caption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->88940945],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Symbolize",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Symbolize"]], "InlineFormula"],
 " is used to treat a class of composite boxes internally as symbols. It is \
sometimes necessary and desirable to be able to symbolize composite objects; \
for example, to be able to attach rules to a composite object, it must be \
treated as a symbol."
}], "Text",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->247395798],

Cell["\<\
This declares that the composite object \[ScriptCapitalD]\[ScriptO]\[ScriptM]\
\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD] should be treated as a symbol.\
\>", "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->645338536],

Cell[BoxData[
 RowBox[{"Symbolize", "[", 
  TagBox[
   TagBox[
    StyleBox[
     RowBox[{
     "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]", 
      "\[PartialD]"}],
     ZeroWidthTimes->True],
    DomainD],
   "NotationTemplateTag"], "]"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellLabel->"In[16]:=",
 CellID->3645052],

Cell[TextData[{
 "The package has created a ",
 Cell[BoxData[
  ButtonBox["FullForm",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/FullForm"]], "InlineFormula"],
 " name for the composite symbol \[ScriptCapitalD]\[ScriptO]\[ScriptM]\
\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD]."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->266849732],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  TagBox[
   StyleBox[
    RowBox[{
    "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]", 
     "\[PartialD]"}],
    ZeroWidthTimes->True],
   DomainD], 
  StyleBox[
   RowBox[{
    StyleBox["/",
     ZeroWidthTimes->True], "/"}]], "FullForm"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellLabel->"In[17]:=",
 CellID->607331955],

Cell[BoxData[
 TagBox[
  StyleBox[
   "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\
PartialD",
   ShowStringCharacters->True],
  FullForm]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellLabel->"Out[17]//FullForm=",
 CellID->167262648]
}, Open  ]],

Cell["\<\
You can now attach rules to the composite symbol \[ScriptCapitalD]\[ScriptO]\
\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD].\
\>", "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->38332301],

Cell[BoxData[
 RowBox[{
  TagBox[
   StyleBox[
    RowBox[{
    "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]", 
     "\[PartialD]"}],
    ZeroWidthTimes->True],
   DomainD], "/:", 
  RowBox[{
   SubscriptBox["\[Integral]", "\[ScriptCapitalD]"], 
   RowBox[{
    RowBox[{
     TagBox[
      StyleBox[
       RowBox[{
       "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]", 
        "\[PartialD]"}],
       ZeroWidthTimes->True],
      DomainD], "[", 
     RowBox[{"f_", ",", "x_"}], "]"}], 
    RowBox[{"\[CapitalDifferentialD]", "x_"}]}]}], " ", ":=", " ", 
  "f"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellLabel->"In[18]:=",
 CellID->482028630],

Cell[TextData[{
 "The above rule for \
\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD]\
 is now tried before the rules of ",
 StyleBox["DomainIntegrals", "MR"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->104484113],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Integral]", "\[ScriptCapitalD]"], 
  RowBox[{
   RowBox[{
    TagBox[
     StyleBox[
      RowBox[{
      "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]", 
       "\[PartialD]"}],
      ZeroWidthTimes->True],
     DomainD], " ", "[", 
    RowBox[{
     RowBox[{"\[Delta]", "[", "x", "]"}], ",", "x"}], "]"}], 
   RowBox[{"\[CapitalDifferentialD]", "x"}]}]}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellLabel->"In[19]:=",
 CellID->371152859],

Cell[BoxData[
 RowBox[{"\[Delta]", "[", "x", "]"}]], "Output",
 ImageSize->{32, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellLabel->"Out[19]=",
 CellID->56115270]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Symbolize",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Symbolize"]], "InlineFormula"],
 " also symbolizes classes of expressions, for example, to symbolize all \
objects subscripted by ",
 Cell[BoxData[
  ButtonBox["Rule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->167574325],

Cell[BoxData[
 RowBox[{"Symbolize", "[", 
  TagBox[
   SubscriptBox["expr_", "Rule"],
   "NotationTemplateTag"], "]"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellLabel->"In[20]:=",
 CellID->40916124],

Cell[TextData[{
 "Anything subscripted by ",
 Cell[BoxData[
  ButtonBox["Rule",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Rule"]], "InlineFormula"],
 " is now treated as a symbol."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->126263315],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["MyDistribute", "Rule"], " ", "//", "FullForm"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellLabel->"In[21]:=",
 CellID->17630334],

Cell[BoxData[
 TagBox[
  StyleBox["MyDistribute\[UnderBracket]Subscript\[UnderBracket]Rule",
   ShowStringCharacters->True],
  FullForm]], "Output",
 ImageSize->{199, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellLabel->"Out[21]//FullForm=",
 CellID->107978219]
}, Open  ]],

Cell[TextData[{
 "You can use symbolized box structures as pattern variables in definitions. \
This lets you create formulas in a more familiar notation. However, you must \
use pattern expressions of the form ",
 StyleBox["CompositePatternVariable",
  FontSlant->"Italic"],
 " : ",
 StyleBox["PatternContent",
  FontSlant->"Italic"],
 " otherwise ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " may interpret the pattern expression as ",
 StyleBox["CompositePatternVariable",
  FontSlant->"Italic"],
 " ",
 Cell[BoxData[
  FormBox["\[Star]", TraditionalForm]]],
 " ",
 StyleBox["PatternContent",
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->743866641],

Cell["\<\
This defines the transmission coefficient for an incident wave packet on a \
potential step under certain conditions.\
\>", "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->43749443],

Cell[BoxData[
 RowBox[{"Symbolize", "[", 
  TagBox[
   SubscriptBox["k", "_"],
   "NotationTemplateTag"], "]"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellLabel->"In[22]:=",
 CellID->440660673],

Cell[BoxData[
 RowBox[{
  RowBox[{"transmissionCoefficient", "[", 
   RowBox[{
    RowBox[{
     SubscriptBox["k", "1"], ":", "_"}], ",", 
    RowBox[{
     SubscriptBox["k", "2"], " ", ":", "_"}]}], "]"}], ":=", " ", 
  RowBox[{"1", "-", 
   FractionBox[
    RowBox[{"4", " ", 
     SubscriptBox["k", "1"], 
     SubscriptBox["k", "2"]}], 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["k", "1"], "+", 
       SubscriptBox["k", "2"]}], ")"}], "2"]]}]}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellLabel->"In[23]:=",
 CellID->502893767]
}, Open  ]],

Cell[CellGroupData[{

Cell["InfixNotation", "Section",
 CellTags->{"Notation:S1", "NotationDocumentation"},
 CellID->225724573],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["InfixNotation",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/InfixNotation"], "[", 
     RowBox[{
      StyleBox["op", "TI"], ",", " ", 
      StyleBox["func", "TI"]}], "]"}], Cell[TextData[{
     "treat ",
     Cell[BoxData[
      StyleBox["op", "TI"]], "InlineFormula"],
     " as an infix operator representing the function ",
     Cell[BoxData[
      StyleBox["func", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["InfixNotation",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/InfixNotation"], "[", 
     RowBox[{
      StyleBox["op", "TI"], ",", " ", 
      StyleBox["func", "TI"], ",", " ", 
      StyleBox["opts", "TI"]}], "]"}], Cell[TextData[{
     "treat ",
     Cell[BoxData[
      StyleBox["op", "TI"]], "InlineFormula"],
     " as an infix operator representing the function ",
     Cell[BoxData[
      StyleBox["func", "TI"]], "InlineFormula"],
     " with the options ",
     Cell[BoxData[
      StyleBox["opts", "TI"]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["RemoveInfixNotation",
      BaseStyle->"Link",
      ButtonData->"paclet:Notation/ref/RemoveInfixNotation"], "[", 
     RowBox[{
      StyleBox["op", "TI"], ",", " ", 
      StyleBox["func", "TI"]}], "]"}], Cell[TextData[{
     "remove the composite infix operator ",
     Cell[BoxData[
      StyleBox["op", "TI"]], "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->135229471],

Cell["Syntax of infix notation declarations.", "Caption",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->454053977],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFormula"],
 " is used to treat a composite box structure as an infix operator. ",
 Cell[BoxData[
  ButtonBox["InfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFormula"],
 " requires both a composite box object which will represent the infix \
operator and a symbol which will be the full form head of the expression. A \
simple parallel of this duality in ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " is that the infix notation ",
 StyleBox["+", "MR"],
 " has the full form head ",
 Cell[BoxData[
  ButtonBox["Plus",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Plus"]], "InlineFormula"],
 "."
}], "Text",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->838872990],

Cell[TextData[{
 "This declares that the composite object ",
 Cell[BoxData[
  SubscriptBox["+", 
   RowBox[{"{", "}"}]]]],
 " should act as the infix form of ",
 Cell[BoxData[
  ButtonBox["Join",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Join"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->2621059],

Cell[BoxData[
 RowBox[{"InfixNotation", "[", 
  RowBox[{
   TagBox[
    SubscriptBox["+", 
     RowBox[{"{", "}"}]],
    "NotationTemplateTag"], ",", 
   TagBox["Join",
    Identity]}], "]"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellLabel->"In[23]:=",
 CellID->205047253],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"{", 
   RowBox[{"a", ",", "b"}], "}"}], " ", 
  SubscriptBox["+", 
   RowBox[{"{", "}"}]], " ", 
  RowBox[{"{", 
   RowBox[{"c", ",", "d"}], "}"}], " ", 
  SubscriptBox["+", 
   RowBox[{"{", "}"}]], " ", 
  RowBox[{"{", 
   RowBox[{"e", ",", "f"}], "}"}]}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellLabel->"In[24]:=",
 CellID->147574555],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"a", ",", "b", ",", "c", ",", "d", ",", "e", ",", "f"}], 
  "}"}]], "Output",
 ImageSize->{116, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellLabel->"Out[24]=",
 CellID->500552507]
}, Open  ]],

Cell[TextData[{
 "The infix notation ",
 Cell[BoxData[
  SubscriptBox["+", 
   RowBox[{"{", "}"}]]]],
 " both parses input and formats output."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->2690609],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HoldForm", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], " ", 
   SubscriptBox["+", 
    RowBox[{"{", "}"}]], " ", 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], " ", 
   SubscriptBox["+", 
    RowBox[{"{", "}"}]], " ", 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}]}], "]"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellLabel->"In[25]:=",
 CellID->625506335],

Cell[BoxData[
 TagBox[
  RowBox[{
   RowBox[{"{", 
    RowBox[{"a", ",", "b"}], "}"}], 
   SubscriptBox["+", 
    RowBox[{"{", "}"}]], 
   RowBox[{"{", 
    RowBox[{"c", ",", "d"}], "}"}], 
   SubscriptBox["+", 
    RowBox[{"{", "}"}]], 
   RowBox[{"{", 
    RowBox[{"e", ",", "f"}], "}"}]}],
  HoldForm]], "Output",
 ImageSize->{168, 17},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellLabel->"Out[25]=",
 CellID->158893191]
}, Open  ]],

Cell[TextData[{
 "An advantage of using ",
 Cell[BoxData[
  ButtonBox["InfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFormula"],
 " over that of using ",
 Cell[BoxData[
  ButtonBox["Notation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Notation"]], "InlineFormula"],
 " to define an infix operator is that ",
 Cell[BoxData[
  ButtonBox["InfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFormula"],
 " parses an expression into a flat internal form without evaluation. \
Although this is a subtle difference, it is an important one (see ",
 ButtonBox["ring operations",
  BaseStyle->"Link",
  ButtonData->
   "paclet:Notation/tutorial/PrecedenceOfOperatorsInNotations#511142072"],
 " and ",
 ButtonBox["parsing without evaluation",
  BaseStyle->"Link",
  ButtonData->
   "paclet:Notation/tutorial/AdviceAndSuggestedGuidelines#234012466"],
 ".)"
}], "Text",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->158492311],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["InfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFormula"],
 " parses input to a flat expression."
}], "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->239428714],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", " ", "[", 
  RowBox[{"Hold", "[", 
   RowBox[{"a", " ", 
    SubscriptBox["+", 
     RowBox[{"{", "}"}]], " ", "b", " ", 
    SubscriptBox["+", 
     RowBox[{"{", "}"}]], " ", "c", " ", 
    SubscriptBox["+", 
     RowBox[{"{", "}"}]], " ", "d"}], "]"}], "]"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellLabel->"In[26]:=",
 CellID->771793936],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Hold", "[", 
    RowBox[{"Join", "[", 
     RowBox[{"a", ",", "b", ",", "c", ",", "d"}], "]"}], "]"}],
   ShowStringCharacters->True],
  FullForm]], "Output",
 ImageSize->{150, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellLabel->"Out[26]//FullForm=",
 CellID->101143201]
}, Open  ]],

Cell[TextData[{
 "The function ",
 StyleBox["InfixNotation",
  FontFamily->"Courier"],
 " can be compared to using the infix form of functions ~",
 Cell[BoxData[
  FormBox["\[ScriptF]", TraditionalForm]]],
 "~ (cf. ",
 ButtonBox["Special Ways to Input Expressions",
  BaseStyle->"Link",
  ButtonData->"paclet:tutorial/SpecialWaysToInputExpressions"],
 ")"
}], "Text",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->20213903]
}, Open  ]],

Cell[CellGroupData[{

Cell["Entering Notations", "Section",
 CellTags->{"Notation:S1", "NotationDocumentation"},
 CellID->20750902],

Cell[TextData[{
 "When defining your own notations it is ",
 StyleBox["critically",
  FontSlant->"Italic"],
 " important to use the ",
 ButtonBox["notation templates",
  BaseStyle->"Hyperlink",
  ButtonData:>{
    FrontEnd`ToFileName[{$InstallationDirectory, "AddOns", "Packages", 
      "Notation", "LocalPalettes", "English", "NotationPalette.nb"}], None},
  ButtonNote->"Show Palette"],
 ". The notation templates are contained in the notation palette shown \
below."
}], "Text",
 CellTags->{
  "Must use palette", "Notation:Documentation:Entering Notations", 
   "Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->18489875],

Cell[BoxData[GridBox[{
   {
    ButtonBox[
     RowBox[{"Notation", "[", 
      RowBox[{
       TagBox["\[SelectionPlaceholder]",
        "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
       TagBox["\[Placeholder]",
        "NotationTemplateTag"]}], "]"}],
     Active->False,
     ButtonNote->"\[EscapeKey]note\[EscapeKey]"]},
   {
    ButtonBox[
     RowBox[{"Notation", "[", 
      RowBox[{
       TagBox["\[SelectionPlaceholder]",
        "NotationTemplateTag"], " ", "\[DoubleLongRightArrow]", " ", 
       TagBox["\[Placeholder]",
        "NotationTemplateTag"]}], "]"}],
     Active->False,
     ButtonNote->"\[EscapeKey]note>\[EscapeKey]"]},
   {
    ButtonBox[
     RowBox[{"Notation", "[", 
      RowBox[{
       TagBox["\[SelectionPlaceholder]",
        "NotationTemplateTag"], " ", "\[DoubleLongLeftArrow]", " ", 
       TagBox["\[Placeholder]",
        "NotationTemplateTag"]}], "]"}],
     Active->False,
     ButtonNote->"\[EscapeKey]note<\[EscapeKey]"]},
   {
    ButtonBox[
     RowBox[{"Symbolize", "[", 
      TagBox["\[SelectionPlaceholder]",
       "NotationTemplateTag"], "]"}],
     Active->False,
     ButtonNote->"\[EscapeKey]symb\[EscapeKey]"]},
   {
    ButtonBox[
     RowBox[{"InfixNotation", "[", 
      RowBox[{
       TagBox["\[SelectionPlaceholder]",
        "NotationTemplateTag"], ",", "\[Placeholder]"}], "]"}],
     Active->False,
     BaseStyle->"Paste",
     ButtonNote->"\[EscapeKey]infixnote\[EscapeKey]"]},
   {
    ButtonBox[
     RowBox[{"AddInputAlias", "[", 
      RowBox[{
       TagBox["\[SelectionPlaceholder]",
        "NotationTemplateTag"], ",", "\[Placeholder]"}], "]"}],
     Active->False,
     BaseStyle->"Paste",
     ButtonNote->"\[EscapeKey]addia\[EscapeKey]"]},
   {
    ButtonBox[
     StyleBox[
      RowBox[{"Full", " ", "Notation", " ", "Palette"}],
      FontFamily->"Helvetica",
      FontColor->GrayLevel[1]],
     Active->False,
     Background->RGBColor[0.100008, 0.100008, 0.4],
     BaseStyle->None,
     ButtonFunction:>(FrontEndExecute[{
        FrontEnd`NotebookClose[
         FrontEnd`ButtonNotebook[]], 
        FrontEnd`NotebookOpen[
         FrontEnd`ToFileName[{$TopDirectory, "AddOns", "ExtraPackages", 
           "Utilities", "Palettes", "English", 
           "FullNotationPalette.nb"}]]}]& ),
     ButtonNote->"Switch to FullNotationPalette"]}
  },
  GridBoxSpacings->{"Columns" -> {
      Offset[0.28], {
       Offset[0.]}, 
      Offset[0.28]}, "ColumnsIndexed" -> {}, "Rows" -> {
      Offset[0.2], {
       Offset[0.]}, 
      Offset[0.2]}, "RowsIndexed" -> {}},
  GridDefaultElement:>ButtonBox[
   "\[Placeholder]", ButtonData -> "paclet:ref/\[Placeholder]"]]], "Picture",
 Editable->False,
 Active->True,
 Evaluatable->False,
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->164416936],

Cell[TextData[{
 "The reason for this restriction is that the templates pasted into a \
notebook contain essential tag boxes embedded in the correct way. These \
embedded tag boxes allow ",
 Cell[BoxData[
  ButtonBox["Notation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Notation"]], "InlineFormula"],
 " , ",
 Cell[BoxData[
  ButtonBox["Symbolize",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Symbolize"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["InfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFormula"],
 " to properly group and parse the new notation being defined. Further, they \
allow these functions to get the styling information of the new notation so \
that the output is formatted with the same spacing, sizes, adjustments, etc. \
as the input."
}], "Text",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->82082205],

Cell["A blank notation template looks like the following.", "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->261571783],

Cell[BoxData[
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox["\[Placeholder]",
    "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
   TagBox["\[Placeholder]",
    "NotationTemplateTag"]}], "]"}]], "Input",
 Evaluatable->False,
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->145527335],

Cell[TextData[{
 "Advanced note: You can circumvent using the notation palette by wrapping \
the corresponding literal box structures in a ",
 Cell[BoxData[
  ButtonBox["ParsedBoxWrapper",
   BaseStyle->"Link",
   ButtonData->
    "paclet:Notation/tutorial/ComplexPatternsAndAdvancedFeatures#281647541"]],
   "InlineFormula"],
 "."
}], "Caption",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->377846837],

Cell[TextData[{
 "In ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " it is possible to create input aliases for any notation or expression you \
want. The normal interface to these input aliases is rather cumbersome and so \
the notation package contains the function ",
 Cell[BoxData[
  ButtonBox["AddInputAlias",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/AddInputAlias"]], "InlineFormula"],
 " to facilitate adding input aliases to the current notebook.",
 " ",
 "Each of the common templates has an alias associated with it for easy \
entry. For instance typing \[EscapeKey]",
 StyleBox["notation", "SR"],
 "\[EscapeKey] in an input cell will enter the notation template ",
 Cell[BoxData[
  StyleBox[
   RowBox[{"Notation", "[", 
    RowBox[{
     TagBox["\[Placeholder]",
      "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
     TagBox["\[Placeholder]",
      "NotationTemplateTag"]}], "]"}], "Input"]]],
 StyleBox[".", "Input"]
}], "Text",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->123448571],

Cell["\<\
Add an input alias for apply statements to the current notebook.\
\>", "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->744634285],

Cell[BoxData[
 RowBox[{"AddInputAlias", "[", 
  RowBox[{
   TagBox[
    RowBox[{"\[Placeholder]", " ", 
     OverscriptBox["\[LongRightArrow]", 
      RowBox[{" ", "Apply", " "}]], " ", "\[Placeholder]", " "}],
    "NotationTemplateTag"], ",", "\"\<apply\>\""}], "]"}]], "Input",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellLabel->"In[27]:=",
 CellID->45477138],

Cell[TextData[{
 "Now that we have created this alias we can enter \"apply\" templates by \
simply typing \[EscapeKey]",
 StyleBox["apply", "SR"],
 "\[EscapeKey]."
}], "Text",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->110098405]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Notation, Symbolize and InfixNotation - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 3.7492020}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Notation Package Tutorial",
     "language" -> "en", "paclet" -> "Notation Package", "status" -> "None", 
    "summary" -> 
    "Syntax of notation declarations. Notation takes both an external \
representation and an internal representation as arguments. Mathematica \
translates any input matching the external representation into the \
corresponding internal representation and, reciprocally, formats any \
expression matching the internal representation into the corresponding \
external representation. In this context, representation means a composite \
structure made up of boxes representing some \"notation\". This loads the \
package. ", "synonyms" -> {}, "title" -> 
    "Notation, Symbolize and InfixNotation", "type" -> "Tutorial", "uri" -> 
    "Notation/tutorial/NotationSymbolizeAndInfixNotation"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "NotationDocumentation"->{
  Cell[1878, 54, 109, 2, 70, "Title",
   CellTags->"NotationDocumentation",
   CellID->58446231],
  Cell[2012, 60, 100, 2, 70, "Section",
   CellTags->{"Notation:S1", "NotationDocumentation"},
   CellID->184195116],
  Cell[4515, 143, 140, 2, 70, "Caption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->83264530],
  Cell[4658, 147, 748, 18, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->220031767],
  Cell[5409, 167, 137, 2, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->152819323],
  Cell[5549, 171, 165, 4, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->25990533],
  Cell[5717, 177, 202, 6, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->131976459],
  Cell[5922, 185, 502, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->82520988],
  Cell[6427, 202, 358, 13, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->200441114],
  Cell[6810, 219, 276, 8, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->356568269],
  Cell[7089, 229, 434, 14, 50, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->158530954],
  Cell[7538, 246, 212, 6, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->145061192],
  Cell[7775, 256, 244, 6, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->532090564],
  Cell[8022, 264, 343, 10, 36, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->179622149],
  Cell[8380, 277, 694, 18, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->230147683],
  Cell[9077, 297, 227, 6, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->386295218],
  Cell[9307, 305, 521, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->164104568],
  Cell[9831, 322, 182, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->461060774],
  Cell[10038, 331, 320, 9, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->435999959],
  Cell[10361, 342, 391, 11, 36, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->552718978],
  Cell[10767, 356, 360, 9, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->42010050],
  Cell[11130, 367, 1003, 33, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->15411296],
  Cell[12136, 402, 191, 4, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->94100752],
  Cell[12352, 410, 416, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->19509129],
  Cell[12771, 427, 656, 21, 57, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->518501910],
  Cell[13442, 451, 227, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->80727247],
  Cell[13672, 458, 939, 31, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->59190948],
  Cell[14614, 491, 165, 2, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->382026760],
  Cell[14804, 497, 403, 12, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->267671246],
  Cell[15210, 511, 432, 13, 53, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->9933526],
  Cell[15657, 527, 276, 6, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->798039053],
  Cell[15936, 535, 317, 9, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->615157417],
  Cell[16256, 546, 491, 14, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->312997119],
  Cell[16750, 562, 196, 4, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->231589850],
  Cell[16949, 568, 581, 16, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->391444115],
  Cell[17555, 588, 487, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->385849498],
  Cell[18045, 605, 664, 20, 55, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->767188241],
  Cell[18724, 628, 541, 13, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->9011352],
  Cell[19302, 646, 101, 2, 70, "Section",
   CellTags->{"Notation:S1", "NotationDocumentation"},
   CellID->378720807],
  Cell[20575, 691, 145, 2, 70, "Caption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->88940945],
  Cell[20723, 695, 502, 11, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->247395798],
  Cell[21228, 708, 272, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->645338536],
  Cell[21503, 715, 388, 13, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->3645052],
  Cell[21894, 730, 390, 10, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->266849732],
  Cell[22309, 744, 414, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->607331955],
  Cell[22726, 761, 385, 12, 50, "Output",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->167262648],
  Cell[23126, 776, 250, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->38332301],
  Cell[23379, 783, 736, 25, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->482028630],
  Cell[24118, 810, 305, 8, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->104484113],
  Cell[24448, 822, 546, 17, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->371152859],
  Cell[24997, 841, 262, 7, 36, "Output",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->56115270],
  Cell[25274, 851, 471, 14, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->167574325],
  Cell[25748, 867, 242, 7, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->40916124],
  Cell[25993, 876, 296, 9, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->126263315],
  Cell[26314, 889, 211, 5, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->17630334],
  Cell[26528, 896, 360, 10, 50, "Output",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->107978219],
  Cell[26903, 909, 734, 24, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->743866641],
  Cell[27640, 935, 237, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->43749443],
  Cell[27880, 942, 236, 7, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->440660673],
  Cell[28119, 951, 606, 20, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->502893767],
  Cell[28762, 976, 105, 2, 70, "Section",
   CellTags->{"Notation:S1", "NotationDocumentation"},
   CellID->225724573],
  Cell[30410, 1030, 147, 2, 70, "Caption",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->454053977],
  Cell[30560, 1034, 902, 25, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->838872990],
  Cell[31465, 1061, 383, 13, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->2621059],
  Cell[31851, 1076, 316, 11, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->205047253],
  Cell[32192, 1091, 416, 14, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->147574555],
  Cell[32611, 1107, 318, 9, 36, "Output",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->500552507],
  Cell[32944, 1119, 250, 8, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->2690609],
  Cell[33219, 1131, 461, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->625506335],
  Cell[33683, 1148, 518, 19, 38, "Output",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->158893191],
  Cell[34216, 1170, 1061, 30, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->158492311],
  Cell[35280, 1202, 301, 8, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->239428714],
  Cell[35606, 1214, 420, 12, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->771793936],
  Cell[36029, 1228, 417, 13, 50, "Output",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->101143201],
  Cell[36461, 1244, 456, 14, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->20213903],
  Cell[36954, 1263, 109, 2, 70, "Section",
   CellTags->{"Notation:S1", "NotationDocumentation"},
   CellID->20750902],
  Cell[37066, 1267, 643, 17, 70, "Text",
   CellTags->{
    "Must use palette", "Notation:Documentation:Entering Notations", 
     "Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->18489875],
  Cell[37712, 1286, 2827, 87, 70, "Picture",
   Evaluatable->False,
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->164416936],
  Cell[40542, 1375, 955, 24, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->82082205],
  Cell[41500, 1401, 164, 2, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->261571783],
  Cell[41667, 1405, 335, 9, 70, "Input",
   Evaluatable->False,
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->145527335],
  Cell[42005, 1416, 436, 12, 70, "Caption",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->377846837],
  Cell[42444, 1430, 1077, 28, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->123448571],
  Cell[43524, 1460, 185, 4, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->744634285],
  Cell[43712, 1466, 392, 10, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->45477138],
  Cell[44107, 1478, 265, 7, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->110098405]},
 "Notation:S1"->{
  Cell[2012, 60, 100, 2, 70, "Section",
   CellTags->{"Notation:S1", "NotationDocumentation"},
   CellID->184195116],
  Cell[4515, 143, 140, 2, 70, "Caption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->83264530],
  Cell[4658, 147, 748, 18, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->220031767],
  Cell[5409, 167, 137, 2, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->152819323],
  Cell[5549, 171, 165, 4, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->25990533],
  Cell[5717, 177, 202, 6, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->131976459],
  Cell[5922, 185, 502, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->82520988],
  Cell[6427, 202, 358, 13, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->200441114],
  Cell[6810, 219, 276, 8, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->356568269],
  Cell[7089, 229, 434, 14, 50, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->158530954],
  Cell[7538, 246, 212, 6, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->145061192],
  Cell[7775, 256, 244, 6, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->532090564],
  Cell[8022, 264, 343, 10, 36, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->179622149],
  Cell[8380, 277, 694, 18, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->230147683],
  Cell[9077, 297, 227, 6, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->386295218],
  Cell[9307, 305, 521, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->164104568],
  Cell[9831, 322, 182, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->461060774],
  Cell[10038, 331, 320, 9, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->435999959],
  Cell[10361, 342, 391, 11, 36, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->552718978],
  Cell[10767, 356, 360, 9, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->42010050],
  Cell[11130, 367, 1003, 33, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->15411296],
  Cell[12136, 402, 191, 4, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->94100752],
  Cell[12352, 410, 416, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->19509129],
  Cell[12771, 427, 656, 21, 57, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->518501910],
  Cell[13442, 451, 227, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->80727247],
  Cell[13672, 458, 939, 31, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->59190948],
  Cell[14614, 491, 165, 2, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->382026760],
  Cell[14804, 497, 403, 12, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->267671246],
  Cell[15210, 511, 432, 13, 53, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->9933526],
  Cell[15657, 527, 276, 6, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->798039053],
  Cell[15936, 535, 317, 9, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->615157417],
  Cell[16256, 546, 491, 14, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->312997119],
  Cell[16750, 562, 196, 4, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->231589850],
  Cell[16949, 568, 581, 16, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->391444115],
  Cell[17555, 588, 487, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->385849498],
  Cell[18045, 605, 664, 20, 55, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->767188241],
  Cell[18724, 628, 541, 13, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->9011352],
  Cell[19302, 646, 101, 2, 70, "Section",
   CellTags->{"Notation:S1", "NotationDocumentation"},
   CellID->378720807],
  Cell[20575, 691, 145, 2, 70, "Caption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->88940945],
  Cell[20723, 695, 502, 11, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->247395798],
  Cell[21228, 708, 272, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->645338536],
  Cell[21503, 715, 388, 13, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->3645052],
  Cell[21894, 730, 390, 10, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->266849732],
  Cell[22309, 744, 414, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->607331955],
  Cell[22726, 761, 385, 12, 50, "Output",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->167262648],
  Cell[23126, 776, 250, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->38332301],
  Cell[23379, 783, 736, 25, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->482028630],
  Cell[24118, 810, 305, 8, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->104484113],
  Cell[24448, 822, 546, 17, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->371152859],
  Cell[24997, 841, 262, 7, 36, "Output",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->56115270],
  Cell[25274, 851, 471, 14, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->167574325],
  Cell[25748, 867, 242, 7, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->40916124],
  Cell[25993, 876, 296, 9, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->126263315],
  Cell[26314, 889, 211, 5, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->17630334],
  Cell[26528, 896, 360, 10, 50, "Output",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->107978219],
  Cell[26903, 909, 734, 24, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->743866641],
  Cell[27640, 935, 237, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->43749443],
  Cell[27880, 942, 236, 7, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->440660673],
  Cell[28119, 951, 606, 20, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->502893767],
  Cell[28762, 976, 105, 2, 70, "Section",
   CellTags->{"Notation:S1", "NotationDocumentation"},
   CellID->225724573],
  Cell[30410, 1030, 147, 2, 70, "Caption",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->454053977],
  Cell[30560, 1034, 902, 25, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->838872990],
  Cell[31465, 1061, 383, 13, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->2621059],
  Cell[31851, 1076, 316, 11, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->205047253],
  Cell[32192, 1091, 416, 14, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->147574555],
  Cell[32611, 1107, 318, 9, 36, "Output",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->500552507],
  Cell[32944, 1119, 250, 8, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->2690609],
  Cell[33219, 1131, 461, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->625506335],
  Cell[33683, 1148, 518, 19, 38, "Output",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->158893191],
  Cell[34216, 1170, 1061, 30, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->158492311],
  Cell[35280, 1202, 301, 8, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->239428714],
  Cell[35606, 1214, 420, 12, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->771793936],
  Cell[36029, 1228, 417, 13, 50, "Output",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->101143201],
  Cell[36461, 1244, 456, 14, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->20213903],
  Cell[36954, 1263, 109, 2, 70, "Section",
   CellTags->{"Notation:S1", "NotationDocumentation"},
   CellID->20750902],
  Cell[37066, 1267, 643, 17, 70, "Text",
   CellTags->{
    "Must use palette", "Notation:Documentation:Entering Notations", 
     "Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->18489875],
  Cell[37712, 1286, 2827, 87, 70, "Picture",
   Evaluatable->False,
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->164416936],
  Cell[40542, 1375, 955, 24, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->82082205],
  Cell[41500, 1401, 164, 2, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->261571783],
  Cell[41667, 1405, 335, 9, 70, "Input",
   Evaluatable->False,
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->145527335],
  Cell[42005, 1416, 436, 12, 70, "Caption",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->377846837],
  Cell[42444, 1430, 1077, 28, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->123448571],
  Cell[43524, 1460, 185, 4, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->744634285],
  Cell[43712, 1466, 392, 10, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->45477138],
  Cell[44107, 1478, 265, 7, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->110098405]},
 "Notation:S1.1"->{
  Cell[4515, 143, 140, 2, 70, "Caption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->83264530],
  Cell[4658, 147, 748, 18, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->220031767],
  Cell[5409, 167, 137, 2, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->152819323],
  Cell[5549, 171, 165, 4, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->25990533],
  Cell[5717, 177, 202, 6, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->131976459],
  Cell[5922, 185, 502, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->82520988],
  Cell[6427, 202, 358, 13, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->200441114],
  Cell[6810, 219, 276, 8, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->356568269],
  Cell[7089, 229, 434, 14, 50, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->158530954],
  Cell[7538, 246, 212, 6, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->145061192],
  Cell[7775, 256, 244, 6, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->532090564],
  Cell[8022, 264, 343, 10, 36, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->179622149],
  Cell[8380, 277, 694, 18, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->230147683],
  Cell[9077, 297, 227, 6, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->386295218],
  Cell[9307, 305, 521, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->164104568],
  Cell[9831, 322, 182, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->461060774],
  Cell[10038, 331, 320, 9, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->435999959],
  Cell[10361, 342, 391, 11, 36, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->552718978],
  Cell[10767, 356, 360, 9, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->42010050],
  Cell[11130, 367, 1003, 33, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->15411296],
  Cell[12136, 402, 191, 4, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->94100752],
  Cell[12352, 410, 416, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->19509129],
  Cell[12771, 427, 656, 21, 57, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->518501910],
  Cell[13442, 451, 227, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->80727247],
  Cell[13672, 458, 939, 31, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->59190948],
  Cell[14614, 491, 165, 2, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->382026760],
  Cell[14804, 497, 403, 12, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->267671246],
  Cell[15210, 511, 432, 13, 53, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->9933526],
  Cell[15657, 527, 276, 6, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->798039053],
  Cell[15936, 535, 317, 9, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->615157417],
  Cell[16256, 546, 491, 14, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->312997119],
  Cell[16750, 562, 196, 4, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->231589850],
  Cell[16949, 568, 581, 16, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->391444115],
  Cell[17555, 588, 487, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->385849498],
  Cell[18045, 605, 664, 20, 55, "Output",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->767188241],
  Cell[18724, 628, 541, 13, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
   CellID->9011352]},
 "Notation:S1.2"->{
  Cell[20575, 691, 145, 2, 70, "Caption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->88940945],
  Cell[20723, 695, 502, 11, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->247395798],
  Cell[21228, 708, 272, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->645338536],
  Cell[21503, 715, 388, 13, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->3645052],
  Cell[21894, 730, 390, 10, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->266849732],
  Cell[22309, 744, 414, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->607331955],
  Cell[22726, 761, 385, 12, 50, "Output",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->167262648],
  Cell[23126, 776, 250, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->38332301],
  Cell[23379, 783, 736, 25, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->482028630],
  Cell[24118, 810, 305, 8, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->104484113],
  Cell[24448, 822, 546, 17, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->371152859],
  Cell[24997, 841, 262, 7, 36, "Output",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->56115270],
  Cell[25274, 851, 471, 14, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->167574325],
  Cell[25748, 867, 242, 7, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->40916124],
  Cell[25993, 876, 296, 9, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->126263315],
  Cell[26314, 889, 211, 5, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->17630334],
  Cell[26528, 896, 360, 10, 50, "Output",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->107978219],
  Cell[26903, 909, 734, 24, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->743866641],
  Cell[27640, 935, 237, 5, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->43749443],
  Cell[27880, 942, 236, 7, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->440660673],
  Cell[28119, 951, 606, 20, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
   CellID->502893767]},
 "Notation:S1.3"->{
  Cell[30410, 1030, 147, 2, 70, "Caption",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->454053977],
  Cell[30560, 1034, 902, 25, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->838872990],
  Cell[31465, 1061, 383, 13, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->2621059],
  Cell[31851, 1076, 316, 11, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->205047253],
  Cell[32192, 1091, 416, 14, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->147574555],
  Cell[32611, 1107, 318, 9, 36, "Output",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->500552507],
  Cell[32944, 1119, 250, 8, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->2690609],
  Cell[33219, 1131, 461, 15, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->625506335],
  Cell[33683, 1148, 518, 19, 38, "Output",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->158893191],
  Cell[34216, 1170, 1061, 30, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->158492311],
  Cell[35280, 1202, 301, 8, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->239428714],
  Cell[35606, 1214, 420, 12, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->771793936],
  Cell[36029, 1228, 417, 13, 50, "Output",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->101143201],
  Cell[36461, 1244, 456, 14, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
   CellID->20213903]},
 "Must use palette"->{
  Cell[37066, 1267, 643, 17, 70, "Text",
   CellTags->{
    "Must use palette", "Notation:Documentation:Entering Notations", 
     "Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->18489875]},
 "Notation:Documentation:Entering Notations"->{
  Cell[37066, 1267, 643, 17, 70, "Text",
   CellTags->{
    "Must use palette", "Notation:Documentation:Entering Notations", 
     "Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->18489875]},
 "Notation:S1.4"->{
  Cell[37066, 1267, 643, 17, 70, "Text",
   CellTags->{
    "Must use palette", "Notation:Documentation:Entering Notations", 
     "Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->18489875],
  Cell[37712, 1286, 2827, 87, 70, "Picture",
   Evaluatable->False,
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->164416936],
  Cell[40542, 1375, 955, 24, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->82082205],
  Cell[41500, 1401, 164, 2, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->261571783],
  Cell[41667, 1405, 335, 9, 70, "Input",
   Evaluatable->False,
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->145527335],
  Cell[42005, 1416, 436, 12, 70, "Caption",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->377846837],
  Cell[42444, 1430, 1077, 28, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->123448571],
  Cell[43524, 1460, 185, 4, 70, "MathCaption",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->744634285],
  Cell[43712, 1466, 392, 10, 70, "Input",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->45477138],
  Cell[44107, 1478, 265, 7, 70, "Text",
   CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
   CellID->110098405]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"NotationDocumentation", 46213, 1530},
 {"Notation:S1", 58047, 1793},
 {"Notation:S1.1", 69785, 2053},
 {"Notation:S1.2", 74733, 2162},
 {"Notation:S1.3", 77637, 2226},
 {"Must use palette", 79591, 2269},
 {"Notation:Documentation:Entering Notations", 79851, 2275},
 {"Notation:S1.4", 80083, 2281}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 1253, 27, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1878, 54, 109, 2, 70, "Title",
 CellTags->"NotationDocumentation",
 CellID->58446231],
Cell[CellGroupData[{
Cell[2012, 60, 100, 2, 70, "Section",
 CellTags->{"Notation:S1", "NotationDocumentation"},
 CellID->184195116],
Cell[2115, 64, 2397, 77, 70, "DefinitionBox",
 CellID->125841609],
Cell[4515, 143, 140, 2, 70, "Caption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->83264530],
Cell[4658, 147, 748, 18, 70, "Text",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->220031767],
Cell[5409, 167, 137, 2, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->152819323],
Cell[5549, 171, 165, 4, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->25990533],
Cell[5717, 177, 202, 6, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->131976459],
Cell[5922, 185, 502, 15, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->82520988],
Cell[6427, 202, 358, 13, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->200441114],
Cell[CellGroupData[{
Cell[6810, 219, 276, 8, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->356568269],
Cell[7089, 229, 434, 14, 50, "Output",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->158530954]
}, Open  ]],
Cell[7538, 246, 212, 6, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->145061192],
Cell[CellGroupData[{
Cell[7775, 256, 244, 6, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->532090564],
Cell[8022, 264, 343, 10, 36, "Output",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->179622149]
}, Open  ]],
Cell[8380, 277, 694, 18, 70, "Text",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->230147683],
Cell[9077, 297, 227, 6, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->386295218],
Cell[9307, 305, 521, 15, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->164104568],
Cell[9831, 322, 182, 5, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->461060774],
Cell[CellGroupData[{
Cell[10038, 331, 320, 9, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->435999959],
Cell[10361, 342, 391, 11, 36, "Output",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->552718978]
}, Open  ]],
Cell[10767, 356, 360, 9, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->42010050],
Cell[11130, 367, 1003, 33, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->15411296],
Cell[12136, 402, 191, 4, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->94100752],
Cell[CellGroupData[{
Cell[12352, 410, 416, 15, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->19509129],
Cell[12771, 427, 656, 21, 57, "Output",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->518501910]
}, Open  ]],
Cell[13442, 451, 227, 5, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->80727247],
Cell[13672, 458, 939, 31, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->59190948],
Cell[14614, 491, 165, 2, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->382026760],
Cell[CellGroupData[{
Cell[14804, 497, 403, 12, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->267671246],
Cell[15210, 511, 432, 13, 53, "Output",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->9933526]
}, Open  ]],
Cell[15657, 527, 276, 6, 70, "Text",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->798039053],
Cell[15936, 535, 317, 9, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->615157417],
Cell[16256, 546, 491, 14, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->312997119],
Cell[16750, 562, 196, 4, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->231589850],
Cell[16949, 568, 581, 16, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->391444115],
Cell[CellGroupData[{
Cell[17555, 588, 487, 15, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->385849498],
Cell[18045, 605, 664, 20, 55, "Output",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->767188241]
}, Open  ]],
Cell[18724, 628, 541, 13, 70, "Text",
 CellTags->{"Notation:S1", "Notation:S1.1", "NotationDocumentation"},
 CellID->9011352]
}, Open  ]],
Cell[CellGroupData[{
Cell[19302, 646, 101, 2, 70, "Section",
 CellTags->{"Notation:S1", "NotationDocumentation"},
 CellID->378720807],
Cell[19406, 650, 1166, 39, 70, "DefinitionBox",
 CellID->673993761],
Cell[20575, 691, 145, 2, 70, "Caption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->88940945],
Cell[20723, 695, 502, 11, 70, "Text",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->247395798],
Cell[21228, 708, 272, 5, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->645338536],
Cell[21503, 715, 388, 13, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->3645052],
Cell[21894, 730, 390, 10, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->266849732],
Cell[CellGroupData[{
Cell[22309, 744, 414, 15, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->607331955],
Cell[22726, 761, 385, 12, 50, "Output",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->167262648]
}, Open  ]],
Cell[23126, 776, 250, 5, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->38332301],
Cell[23379, 783, 736, 25, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->482028630],
Cell[24118, 810, 305, 8, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->104484113],
Cell[CellGroupData[{
Cell[24448, 822, 546, 17, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->371152859],
Cell[24997, 841, 262, 7, 36, "Output",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->56115270]
}, Open  ]],
Cell[25274, 851, 471, 14, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->167574325],
Cell[25748, 867, 242, 7, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->40916124],
Cell[25993, 876, 296, 9, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->126263315],
Cell[CellGroupData[{
Cell[26314, 889, 211, 5, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->17630334],
Cell[26528, 896, 360, 10, 50, "Output",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->107978219]
}, Open  ]],
Cell[26903, 909, 734, 24, 70, "Text",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->743866641],
Cell[27640, 935, 237, 5, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->43749443],
Cell[27880, 942, 236, 7, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->440660673],
Cell[28119, 951, 606, 20, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.2", "NotationDocumentation"},
 CellID->502893767]
}, Open  ]],
Cell[CellGroupData[{
Cell[28762, 976, 105, 2, 70, "Section",
 CellTags->{"Notation:S1", "NotationDocumentation"},
 CellID->225724573],
Cell[28870, 980, 1537, 48, 70, "DefinitionBox",
 CellID->135229471],
Cell[30410, 1030, 147, 2, 70, "Caption",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->454053977],
Cell[30560, 1034, 902, 25, 70, "Text",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->838872990],
Cell[31465, 1061, 383, 13, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->2621059],
Cell[31851, 1076, 316, 11, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->205047253],
Cell[CellGroupData[{
Cell[32192, 1091, 416, 14, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->147574555],
Cell[32611, 1107, 318, 9, 36, "Output",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->500552507]
}, Open  ]],
Cell[32944, 1119, 250, 8, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->2690609],
Cell[CellGroupData[{
Cell[33219, 1131, 461, 15, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->625506335],
Cell[33683, 1148, 518, 19, 38, "Output",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->158893191]
}, Open  ]],
Cell[34216, 1170, 1061, 30, 70, "Text",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->158492311],
Cell[35280, 1202, 301, 8, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->239428714],
Cell[CellGroupData[{
Cell[35606, 1214, 420, 12, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->771793936],
Cell[36029, 1228, 417, 13, 50, "Output",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->101143201]
}, Open  ]],
Cell[36461, 1244, 456, 14, 70, "Text",
 CellTags->{"Notation:S1", "Notation:S1.3", "NotationDocumentation"},
 CellID->20213903]
}, Open  ]],
Cell[CellGroupData[{
Cell[36954, 1263, 109, 2, 70, "Section",
 CellTags->{"Notation:S1", "NotationDocumentation"},
 CellID->20750902],
Cell[37066, 1267, 643, 17, 70, "Text",
 CellTags->{
  "Must use palette", "Notation:Documentation:Entering Notations", 
   "Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->18489875],
Cell[37712, 1286, 2827, 87, 70, "Picture",
 Evaluatable->False,
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->164416936],
Cell[40542, 1375, 955, 24, 70, "Text",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->82082205],
Cell[41500, 1401, 164, 2, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->261571783],
Cell[41667, 1405, 335, 9, 70, "Input",
 Evaluatable->False,
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->145527335],
Cell[42005, 1416, 436, 12, 70, "Caption",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->377846837],
Cell[42444, 1430, 1077, 28, 70, "Text",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->123448571],
Cell[43524, 1460, 185, 4, 70, "MathCaption",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->744634285],
Cell[43712, 1466, 392, 10, 70, "Input",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->45477138],
Cell[44107, 1478, 265, 7, 70, "Text",
 CellTags->{"Notation:S1", "Notation:S1.4", "NotationDocumentation"},
 CellID->110098405]
}, Open  ]]
}, Open  ]],
Cell[44399, 1489, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

