(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     48416,       1337]
NotebookOptionsPosition[     23186,        733]
NotebookOutlinePosition[     42774,       1186]
CellTagsIndexPosition[     42356,       1173]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NOTATION PACKAGE TUTORIAL", "PacletNameCell"], Cell[TextData[Cell[
    BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"AdjustmentBox" :> 
         Documentation`HelpLookup["paclet:ref/AdjustmentBox"], "ButtonBox" :> 
         Documentation`HelpLookup["paclet:ref/ButtonBox"], "ErrorBox" :> 
         Documentation`HelpLookup["paclet:ref/ErrorBox"], "FormBox" :> 
         Documentation`HelpLookup["paclet:ref/FormBox"], "FractionBox" :> 
         Documentation`HelpLookup["paclet:ref/FractionBox"], "FrameBox" :> 
         Documentation`HelpLookup["paclet:ref/FrameBox"], "GridBox" :> 
         Documentation`HelpLookup["paclet:ref/GridBox"], "InterpretationBox" :> 
         Documentation`HelpLookup["paclet:ref/InterpretationBox"], 
         "OverscriptBox" :> 
         Documentation`HelpLookup["paclet:ref/OverscriptBox"], "RadicalBox" :> 
         Documentation`HelpLookup["paclet:ref/RadicalBox"], "RowBox" :> 
         Documentation`HelpLookup["paclet:ref/RowBox"], "SqrtBox" :> 
         Documentation`HelpLookup["paclet:ref/SqrtBox"], "StyleBox" :> 
         Documentation`HelpLookup["paclet:ref/StyleBox"], "SubscriptBox" :> 
         Documentation`HelpLookup["paclet:ref/SubscriptBox"], 
         "SubsuperscriptBox" :> 
         Documentation`HelpLookup["paclet:ref/SubsuperscriptBox"], 
         "SuperscriptBox" :> 
         Documentation`HelpLookup["paclet:ref/SuperscriptBox"], "TagBox" :> 
         Documentation`HelpLookup["paclet:ref/TagBox"], "UnderoverscriptBox" :> 
         Documentation`HelpLookup["paclet:ref/UnderoverscriptBox"], 
         "UnderscriptBox" :> 
         Documentation`HelpLookup["paclet:ref/UnderscriptBox"]}, #, 2]& , 
       Evaluator -> Automatic], {1->"\<\"AdjustmentBox\"\>", 
      2->"\<\"ButtonBox\"\>", 3->"\<\"ErrorBox\"\>", 4->"\<\"FormBox\"\>", 
      5->"\<\"FractionBox\"\>", 6->"\<\"FrameBox\"\>", 7->"\<\"GridBox\"\>", 
      8->"\<\"InterpretationBox\"\>", 9->"\<\"OverscriptBox\"\>", 
      10->"\<\"RadicalBox\"\>", 11->"\<\"RowBox\"\>", 12->"\<\"SqrtBox\"\>", 
      13->"\<\"StyleBox\"\>", 14->"\<\"SubscriptBox\"\>", 
      15->"\<\"SubsuperscriptBox\"\>", 16->"\<\"SuperscriptBox\"\>", 
      17->"\<\"TagBox\"\>", 18->"\<\"UnderoverscriptBox\"\>", 
      19->"\<\"UnderscriptBox\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Precedence of Operators in Notations", "Title",
 CellTags->"NotationDocumentation",
 CellID->44994921],

Cell[CellGroupData[{

Cell["How Precedence is determined", "Section",
 CellTags->{"Notation:S2", "NotationDocumentation"},
 CellID->323651810],

Cell[TextData[{
 "The precedence of any new notation or operator is determined by examining \
the components from which it is constructed. For instance, ",
 Cell[BoxData[
  SubscriptBox["+", "\[ScriptCapitalR]"]]],
 " ",
 "is grouped according to the precedence of +, the operator ",
 Cell[BoxData[
  SubscriptBox["\[CirclePlus]", "n"]]],
 " is grouped according to the precedence of ",
 Cell[BoxData[
  FormBox[
   SubscriptBox["\[CirclePlus]", "\[Null]"], TraditionalForm]]],
 ", and the mapping ",
 Cell[BoxData[
  OverscriptBox["\[LongRightArrow]", 
   RowBox[{"  ", "myApply", "  "}]]]],
 " is grouped according to the precedence of \[LongRightArrow]. Generally the \
grouping behavior of positioning boxes is determined by the \"base element\". \
For instance, the expression ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["SubscriptBox",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/SubscriptBox"], "MR"]], "InlineFormula"],
 StyleBox["[", "MR"],
 StyleBox["symb",
  FontSlant->"Italic"],
 StyleBox[",", "Input"],
 " ",
 StyleBox["sub",
  FontSlant->"Italic"],
 StyleBox["]", "MR"],
 " is grouped according to ",
 StyleBox["symb",
  FontSlant->"Italic"],
 ". But for some other structural boxes the grouping behavior of surrounding \
elements is not affected by the behavior of the contents of the box. The \
precedence of compound objects is determined according to the following \
table:"
}], "Text",
 CellTags->{
  "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1", 
   "NotationDocumentation"},
 CellID->898728618],

Cell[BoxData[GridBox[{
   {Cell["type of box", "TableHeader"], Cell["behavior", "TableHeader"]},
   {
    RowBox[{
     ButtonBox["AdjustmentBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/AdjustmentBox"], ",", " ", 
     ButtonBox["ErrorBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ErrorBox"], ",", " ", 
     ButtonBox["StyleBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/StyleBox"], ",", " ", 
     ButtonBox["SubscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubscriptBox"], ",", " ", 
     ButtonBox["SuperscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SuperscriptBox"], ",", " ", 
     ButtonBox["SubsuperscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SubsuperscriptBox"], ",", " ", 
     ButtonBox["UnderscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnderscriptBox"], ",", " ", 
     ButtonBox["OverscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/OverscriptBox"], ",", " ", 
     ButtonBox["UnderoverscriptBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/UnderoverscriptBox"], ",", " ", 
     ButtonBox["TagBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/TagBox"]}], Cell["\<\
These box structures do not isolate their contents from the outside; the \
contents of these boxes can affect the grouping of surrounding elements\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ButtonBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/ButtonBox"], ",", " ", 
     ButtonBox["FormBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FormBox"], ",", " ", 
     ButtonBox["FractionBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FractionBox"], ",", " ", 
     ButtonBox["FrameBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/FrameBox"], ",", " ", 
     ButtonBox["GridBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GridBox"], ",", " ", 
     ButtonBox["InterpretationBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/InterpretationBox"], ",", " ", 
     ButtonBox["RowBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RowBox"], ",", " ", 
     ButtonBox["RadicalBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/RadicalBox"], ",", " ", 
     ButtonBox["SqrtBox",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/SqrtBox"]}], Cell["\<\
These box structures isolate their contents from the outside; the contents of \
these boxes do not affect the grouping of surrounding elements\
\>", "TableText"]}
  }]], "DefinitionBox", "TableHeaderLine",
 CellID->112725058],

Cell["The standard boxes and their relationship to precedence.", "Caption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->724306124],

Cell[TextData[{
 "The design decision of making the precedence of new compound operators \
correspond to their constituents makes intuitive sense and generally leads to \
notations that are consistent. For instance, consider a possible notation for \
addition and multiplication over a ring ",
 Cell[BoxData[
  RowBox[{"\[LeftAngleBracket]", 
   RowBox[{"\[ScriptCapitalR]", ",", 
    RowBox[{
     SubscriptBox["+", "\[ScriptCapitalR]"], 
     RowBox[{",", 
      SubscriptBox["*", "\[ScriptCapitalR]"]}]}]}], 
   "\[RightAngleBracket]"}]]],
 "."
}], "Text",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->17207873],

Cell["\<\
This defines a notation for ring addition and ring multiplication.\
\>", "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->175855967],

Cell[BoxData[{
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox[
    RowBox[{"a_", " ", 
     SubscriptBox["+", "\[ScriptCapitalR]"], " ", "b_"}],
    "NotationTemplateTag"], "  ", "\[DoubleLongLeftRightArrow]", " ", 
   TagBox[
    RowBox[{" ", 
     RowBox[{"RingPlus", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}]}],
    "NotationTemplateTag"]}], "]"}], "\n", 
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox[
    RowBox[{
     RowBox[{"a_", " ", 
      SubscriptBox["*", "\[ScriptCapitalR]"], " ", "b_"}], " "}],
    "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
   TagBox[
    RowBox[{" ", 
     RowBox[{"RingTimes", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}]}],
    "NotationTemplateTag"]}], "]"}]}], "Input",
 CellTags->{
  "Ring Operations", "Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 
 CellLabel->"In[28]:=",
 CellID->511142072],

Cell[TextData[{
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " now can parse and format expressions containing ring additions and \
multiplications."
}], "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->66193563],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"x", " ", 
  SubscriptBox["+", "\[ScriptCapitalR]"], " ", 
  RowBox[{"y", " ", 
   SubscriptBox["*", "\[ScriptCapitalR]"], " ", "z"}]}]], "Input",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellLabel->"In[30]:=",
 CellID->690623672],

Cell[BoxData[
 RowBox[{"x", " ", 
  SubscriptBox["+", "\[ScriptCapitalR]"], " ", 
  RowBox[{"y", " ", 
   SubscriptBox["*", "\[ScriptCapitalR]"], " ", "z"}], " "}]], "Output",
 ImageSize->{75, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellLabel->"Out[30]=",
 CellID->171028537]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", " ", "@", " ", "%"}]], "Input",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellLabel->"In[31]:=",
 CellID->92309166],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"RingPlus", "[", 
    RowBox[{"x", ",", 
     RowBox[{"RingTimes", "[", 
      RowBox[{"y", ",", "z"}], "]"}]}], "]"}],
   ShowStringCharacters->True],
  FullForm]], "Output",
 ImageSize->{195, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellLabel->"Out[31]//FullForm=",
 CellID->191034785]
}, Open  ]],

Cell[TextData[{
 "The ring multiplication operator ",
 Cell[BoxData[
  SubscriptBox["*", "\[ScriptCapitalR]"]]],
 " has a higher precedence than the ring addition operator ",
 Cell[BoxData[
  SubscriptBox["+", "\[ScriptCapitalR]"]]],
 " because ",
 StyleBox["*", "Input"],
 " has a higher precedence than ",
 StyleBox["+", "Input"],
 " . Moreover, the notation is automatically set up to parenthesize the \
expression appropriately to maintain the correct structure."
}], "Text",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->67347689],

Cell["\<\
The output has the correct formatting, styling, spacing, and \
parenthesization.\
\>", "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->599839807],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"RingTimes", "[", 
    RowBox[{
     RowBox[{"RingPlus", "[", 
      RowBox[{"x", ",", "y"}], "]"}], ",", "z"}], "]"}],
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Input",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellLabel->"In[32]:=",
 CellID->103606775],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{"x", " ", 
     SubscriptBox["+", "\[ScriptCapitalR]"], " ", "y"}], ")"}], " ", 
   SubscriptBox["*", "\[ScriptCapitalR]"], " ", "z"}], " "}]], "Output",
 ImageSize->{89, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellLabel->"Out[32]=",
 CellID->377715943]
}, Open  ]],

Cell["\<\
However the above notation for ring addition and ring multiplication is still \
somewhat limited.\
\>", "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->79628061],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RingPlus", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Input",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellLabel->"In[33]:=",
 CellID->505577540],

Cell[BoxData[
 RowBox[{"RingPlus", "[", 
  RowBox[{"a", ",", "b", ",", "c"}], "]"}]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellLabel->"Out[33]=",
 CellID->4010008]
}, Open  ]],

Cell[TextData[{
 "The above ",
 Cell[BoxData[
  ButtonBox["Notation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/Notation"]], "InlineFormula"],
 " statement can be removed and an ",
 Cell[BoxData[
  ButtonBox["InfixNotation",
   BaseStyle->"Link",
   ButtonData->"paclet:Notation/ref/InfixNotation"]], "InlineFormula"],
 " can be used instead."
}], "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->760575024],

Cell[BoxData[{
 RowBox[{"RemoveNotation", "[", 
  RowBox[{
   TagBox[
    RowBox[{"a_", " ", 
     SubscriptBox["+", "\[ScriptCapitalR]"], " ", "b_"}],
    "NotationTemplateTag"], "  ", "\[DoubleLongLeftRightArrow]", " ", 
   TagBox[
    RowBox[{" ", 
     RowBox[{"RingPlus", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}]}],
    "NotationTemplateTag"]}], "]"}], "\n", 
 RowBox[{"RemoveNotation", "[", 
  RowBox[{
   TagBox[
    RowBox[{
     RowBox[{"a_", " ", 
      SubscriptBox["*", "\[ScriptCapitalR]"], " ", "b_"}], " "}],
    "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
   TagBox[
    RowBox[{" ", 
     RowBox[{"RingTimes", "[", 
      RowBox[{"a_", ",", "b_"}], "]"}]}],
    "NotationTemplateTag"]}], "]"}], "\n", 
 RowBox[{"InfixNotation", "[", 
  RowBox[{
   TagBox[
    SubscriptBox["+", "\[ScriptCapitalR]"],
    "NotationTemplateTag"], ",", 
   TagBox["RingPlus",
    Identity]}], "]"}], "\n", 
 RowBox[{"InfixNotation", "[", 
  RowBox[{
   TagBox[
    SubscriptBox["*", "\[ScriptCapitalR]"],
    "NotationTemplateTag"], ",", 
   TagBox["RingTimes",
    Identity]}], "]"}]}], "Input",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellLabel->"In[34]:=",
 CellID->312730836],

Cell[TextData[{
 "Now ",
 Cell[BoxData[
  SubscriptBox["+", "\[ScriptCapitalR]"]]],
 " and ",
 Cell[BoxData[
  SubscriptBox["*", "\[ScriptCapitalR]"]]],
 " act as true infix operators for ",
 StyleBox["RingPlus", "MR"],
 " and ",
 StyleBox["RingTimes", "MR"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->163094619],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"a", 
  SubscriptBox["+", "\[ScriptCapitalR]"], " ", "b", 
  SubscriptBox["+", "\[ScriptCapitalR]"], " ", "c", 
  SubscriptBox["+", "\[ScriptCapitalR]"], " ", 
  RowBox[{"d", " ", 
   SubscriptBox["*", "\[ScriptCapitalR]"], " ", "e"}]}]], "Input",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellLabel->"In[38]:=",
 CellID->311003923],

Cell[BoxData[
 RowBox[{"a", 
  SubscriptBox["+", "\[ScriptCapitalR]"], "b", 
  SubscriptBox["+", "\[ScriptCapitalR]"], "c", 
  SubscriptBox["+", "\[ScriptCapitalR]"], 
  RowBox[{"d", 
   SubscriptBox["*", "\[ScriptCapitalR]"], "e"}]}]], "Output",
 ImageSize->{111, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellLabel->"Out[38]=",
 CellID->79402875]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parentheses in Notations", "Section",
 CellTags->{"Notation:S2", "NotationDocumentation"},
 CellID->855898],

Cell[TextData[{
 "It is important to point out that bracketing expressions by using ",
 StyleBox["{}", "MR"],
 ",",
 StyleBox["()", "MR"],
 ",",
 StyleBox["\[LeftAngleBracket]\[RightAngleBracket]", "MR"],
 ",",
 StyleBox["[]", "MR"],
 ",",
 StyleBox["|", "MR"],
 " or other braces in a notation not only changes the grouping of the \
notation but requires the brackets to be literally present in the input \
expression."
}], "Text",
 CellTags->{
  "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses", 
   "NotationDocumentation"},
 CellID->26769111],

Cell["The following defines a notation that uses parentheses.", "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellID->925122041],

Cell[BoxData[
 RowBox[{"Notation", "[", 
  RowBox[{
   TagBox[
    SubscriptBox[
     RowBox[{"(", "expr___", ")"}], "\[DoubleStruckCapitalS]"],
    "NotationTemplateTag"], " ", "\[DoubleLongLeftRightArrow]", " ", 
   TagBox[
    RowBox[{"Semantic", "[", "expr___", "]"}],
    "NotationTemplateTag"]}], "]"}]], "Input",
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellLabel->"In[39]:=",
 CellID->88112840],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox[
   RowBox[{"(", 
    RowBox[{"a", ",", "b", ",", "c"}], ")"}], "\[DoubleStruckCapitalS]"], "//",
   "FullForm"}]], "Input",
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellLabel->"In[40]:=",
 CellID->279559934],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Semantic", "[", 
    RowBox[{"a", ",", "b", ",", "c"}], "]"}],
   ShowStringCharacters->True],
  FullForm]], "Output",
 ImageSize->{118, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellLabel->"Out[40]//FullForm=",
 CellID->523473392]
}, Open  ]],

Cell[TextData[{
 "Without parentheses input is not recognized as a ",
 StyleBox["Semantic", "MR"],
 " wrapper."
}], "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellID->27808374],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SubscriptBox["H", "\[DoubleStruckCapitalS]"], " ", "//", 
  "FullForm"}]], "Input",
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellLabel->"In[41]:=",
 CellID->370302637],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{"Subscript", "[", 
    RowBox[{"H", ",", "\[DoubleStruckCapitalS]"}], "]"}],
   ShowStringCharacters->True],
  FullForm]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellLabel->"Out[41]//FullForm=",
 CellID->274378028]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Changing Precedences in Notations", "Section",
 CellTags->{"Notation:S2", "NotationDocumentation"},
 CellID->167645012],

Cell[TextData[{
 "You can isolate the elements around an operator or expression by \
surrounding the operator or expression with a box structure that isolates its \
contents (cf. the ",
 ButtonBox["table above",
  BaseStyle->"Link",
  ButtonData->
   "paclet:Notation/tutorial/PrecedenceOfOperatorsInNotations#112725058"],
 "). The box structure typically used to do this encapsulation / isolation is \
the ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 ". Furthermore it is possible to change the precedence of an operator \
through the use of the ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " option ",
 Cell[BoxData[
  ButtonBox["SyntaxForm",
   BaseStyle->"Link",
   ButtonData->
    "paclet:Notation/tutorial/ComplexPatternsAndAdvancedFeatures#4576917"]], 
  "InlineFormula"],
 ". More will be said on this later in ",
 StyleBox[ButtonBox["Complex Patterns and Advanced Features",
  BaseStyle->"Link",
  ButtonData->"paclet:Notation/tutorial/ComplexPatternsAndAdvancedFeatures"],
  FontSlant->"Italic"],
 "."
}], "Text",
 CellTags->{
  "Notation:S2", "Notation:S2.3", 
   "Notation:Documentation:Changing Precedences", "NotationDocumentation"},
 CellID->683683627],

Cell[TextData[{
 "The underlying box structure of \[ScriptCapitalD]\[ScriptO]\[ScriptM]\
\[ScriptA]\[ScriptI]\[ScriptN]\[PartialD] has an embedded ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 "."
}], "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
 CellID->206671737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ToBoxes", " ", "@", " ", 
  TagBox[
   StyleBox[
    RowBox[{
    "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]", 
     "\[PartialD]"}],
    ZeroWidthTimes->True],
   DomainD]}]], "Input",
 CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
 CellLabel->"In[42]:=",
 CellID->21667896],

Cell[BoxData[
 RowBox[{"TagBox", "[", 
  RowBox[{
   RowBox[{"StyleBox", "[", 
    RowBox[{
     RowBox[{"RowBox", "[", 
      RowBox[{"{", 
       RowBox[{"\<\"\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\
\[ScriptN]\"\>", ",", "\<\"\[PartialD]\"\>"}], "}"}], "]"}], ",", 
     RowBox[{"ZeroWidthTimes", "\[Rule]", "True"}]}], "]"}], ",", "DomainD"}],
   "]"}]], "Output",
 ImageSize->{465, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
 CellLabel->"Out[42]=",
 CellID->176817880]
}, Open  ]],

Cell[TextData[{
 "The embedded ",
 Cell[BoxData[
  ButtonBox["TagBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/TagBox"]], "InlineFormula"],
 " in ",
 Cell[BoxData[
  FormBox[
   StyleBox[
    RowBox[{
    "\[ScriptCapitalD]\[ScriptO]\[ScriptM]\[ScriptA]\[ScriptI]\[ScriptN]", 
     "\[PartialD]"}],
    ZeroWidthTimes->True], TraditionalForm]]],
 " is necessary for several reasons: to contain the ",
 Cell[BoxData[
  ButtonBox["StyleBox",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/StyleBox"]], "InlineFormula"],
 " asserting ",
 Cell[BoxData[
  ButtonBox["ZeroWidthTimes",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/ZeroWidthTimes"]], "InlineFormula"],
 ", to suppress the natural prefix operator grouping of ",
 Cell[BoxData[
  FormBox["\[PartialD]", TraditionalForm]]],
 ", and to allow the parsing and formatting rules to act on an encapsulated \
unit."
}], "Text",
 CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
 CellID->60432642]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Precedence of Operators in Notations - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 4.3429672}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> "Notation Package Tutorial",
     "language" -> "en", "paclet" -> "Notation Package", "status" -> "None", 
    "summary" -> 
    "The precedence of any new notation or operator is determined by \
examining the components from which it is constructed. For instance, \
+_\\[ScriptCapitalR] is grouped according to the precedence of +, the \
operator (+)_n is grouped according to the precedence of (+)_, and the \
mapping OverscriptBox[-->, RowBox[{ , myApply, }]] is grouped according to \
the precedence of -->. Generally the grouping behavior of positioning boxes \
is determined by the \"base element\". For instance, the expression \
SubscriptBox[symb, sub] is grouped according to symb. But for some other \
structural boxes the grouping behavior of surrounding elements is not \
affected by the behavior of the contents of the box. The precedence of \
compound objects is determined according to the following table: The standard \
boxes and their relationship to precedence. The design decision of making the \
precedence of new compound operators correspond to their constituents makes \
intuitive sense and generally leads to notations that are consistent. For \
instance, consider a possible notation for addition and multiplication over a \
ring <\\[ScriptCapitalR],+_\\[ScriptCapitalR],*_\\[ScriptCapitalR]>.", 
    "synonyms" -> {}, "title" -> "Precedence of Operators in Notations", 
    "type" -> "Tutorial", "uri" -> 
    "Notation/tutorial/PrecedenceOfOperatorsInNotations"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "NotationDocumentation"->{
  Cell[3176, 71, 108, 2, 70, "Title",
   CellTags->"NotationDocumentation",
   CellID->44994921],
  Cell[3309, 77, 120, 2, 70, "Section",
   CellTags->{"Notation:S2", "NotationDocumentation"},
   CellID->323651810],
  Cell[3432, 81, 1545, 44, 70, "Text",
   CellTags->{
    "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1", 
     "NotationDocumentation"},
   CellID->898728618],
  Cell[7612, 199, 165, 2, 70, "Caption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->724306124],
  Cell[7780, 203, 648, 16, 70, "Text",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->17207873],
  Cell[8431, 221, 187, 4, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->175855967],
  Cell[8621, 227, 874, 28, 70, "Input",
   CellTags->{
    "Ring Operations", "Notation:S2", "Notation:S2.1", 
     "NotationDocumentation"},
   CellID->511142072],
  Cell[9498, 257, 262, 7, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->66193563],
  Cell[9785, 268, 283, 7, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->690623672],
  Cell[10071, 277, 376, 10, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->171028537],
  Cell[10484, 292, 179, 4, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->92309166],
  Cell[10666, 298, 433, 14, 50, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->191034785],
  Cell[11114, 315, 568, 15, 70, "Text",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->67347689],
  Cell[11685, 332, 201, 5, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->599839807],
  Cell[11911, 341, 356, 12, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->103606775],
  Cell[12270, 355, 418, 12, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->377715943],
  Cell[12703, 370, 217, 5, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->79628061],
  Cell[12945, 379, 208, 5, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->505577540],
  Cell[13156, 386, 295, 8, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->4010008],
  Cell[13466, 397, 468, 14, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->760575024],
  Cell[13937, 413, 1233, 40, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->312730836],
  Cell[15173, 455, 373, 14, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->163094619],
  Cell[15571, 473, 384, 9, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->311003923],
  Cell[15958, 484, 447, 12, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->79402875],
  Cell[16454, 502, 113, 2, 70, "Section",
   CellTags->{"Notation:S2", "NotationDocumentation"},
   CellID->855898],
  Cell[16570, 506, 566, 18, 70, "Text",
   CellTags->{
    "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses", 
     "NotationDocumentation"},
   CellID->26769111],
  Cell[17139, 526, 168, 2, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->925122041],
  Cell[17310, 530, 432, 12, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->88112840],
  Cell[17767, 546, 277, 8, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->279559934],
  Cell[18047, 556, 377, 12, 50, "Output",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->523473392],
  Cell[18439, 571, 219, 6, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->27808374],
  Cell[18683, 581, 223, 6, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->370302637],
  Cell[18909, 589, 390, 12, 50, "Output",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->274378028],
  Cell[19348, 607, 125, 2, 70, "Section",
   CellTags->{"Notation:S2", "NotationDocumentation"},
   CellID->167645012],
  Cell[19476, 611, 1316, 37, 70, "Text",
   CellTags->{
    "Notation:S2", "Notation:S2.3", 
     "Notation:Documentation:Changing Precedences", "NotationDocumentation"},
   CellID->683683627],
  Cell[20795, 650, 378, 10, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
   CellID->206671737],
  Cell[21198, 664, 348, 11, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
   CellID->21667896],
  Cell[21549, 677, 588, 16, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
   CellID->176817880],
  Cell[22152, 696, 980, 31, 70, "Text",
   CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
   CellID->60432642]},
 "Notation:S2"->{
  Cell[3309, 77, 120, 2, 70, "Section",
   CellTags->{"Notation:S2", "NotationDocumentation"},
   CellID->323651810],
  Cell[3432, 81, 1545, 44, 70, "Text",
   CellTags->{
    "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1", 
     "NotationDocumentation"},
   CellID->898728618],
  Cell[7612, 199, 165, 2, 70, "Caption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->724306124],
  Cell[7780, 203, 648, 16, 70, "Text",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->17207873],
  Cell[8431, 221, 187, 4, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->175855967],
  Cell[8621, 227, 874, 28, 70, "Input",
   CellTags->{
    "Ring Operations", "Notation:S2", "Notation:S2.1", 
     "NotationDocumentation"},
   CellID->511142072],
  Cell[9498, 257, 262, 7, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->66193563],
  Cell[9785, 268, 283, 7, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->690623672],
  Cell[10071, 277, 376, 10, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->171028537],
  Cell[10484, 292, 179, 4, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->92309166],
  Cell[10666, 298, 433, 14, 50, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->191034785],
  Cell[11114, 315, 568, 15, 70, "Text",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->67347689],
  Cell[11685, 332, 201, 5, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->599839807],
  Cell[11911, 341, 356, 12, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->103606775],
  Cell[12270, 355, 418, 12, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->377715943],
  Cell[12703, 370, 217, 5, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->79628061],
  Cell[12945, 379, 208, 5, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->505577540],
  Cell[13156, 386, 295, 8, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->4010008],
  Cell[13466, 397, 468, 14, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->760575024],
  Cell[13937, 413, 1233, 40, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->312730836],
  Cell[15173, 455, 373, 14, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->163094619],
  Cell[15571, 473, 384, 9, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->311003923],
  Cell[15958, 484, 447, 12, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->79402875],
  Cell[16454, 502, 113, 2, 70, "Section",
   CellTags->{"Notation:S2", "NotationDocumentation"},
   CellID->855898],
  Cell[16570, 506, 566, 18, 70, "Text",
   CellTags->{
    "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses", 
     "NotationDocumentation"},
   CellID->26769111],
  Cell[17139, 526, 168, 2, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->925122041],
  Cell[17310, 530, 432, 12, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->88112840],
  Cell[17767, 546, 277, 8, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->279559934],
  Cell[18047, 556, 377, 12, 50, "Output",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->523473392],
  Cell[18439, 571, 219, 6, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->27808374],
  Cell[18683, 581, 223, 6, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->370302637],
  Cell[18909, 589, 390, 12, 50, "Output",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->274378028],
  Cell[19348, 607, 125, 2, 70, "Section",
   CellTags->{"Notation:S2", "NotationDocumentation"},
   CellID->167645012],
  Cell[19476, 611, 1316, 37, 70, "Text",
   CellTags->{
    "Notation:S2", "Notation:S2.3", 
     "Notation:Documentation:Changing Precedences", "NotationDocumentation"},
   CellID->683683627],
  Cell[20795, 650, 378, 10, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
   CellID->206671737],
  Cell[21198, 664, 348, 11, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
   CellID->21667896],
  Cell[21549, 677, 588, 16, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
   CellID->176817880],
  Cell[22152, 696, 980, 31, 70, "Text",
   CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
   CellID->60432642]},
 "Notation:Documentation:Precedence"->{
  Cell[3432, 81, 1545, 44, 70, "Text",
   CellTags->{
    "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1", 
     "NotationDocumentation"},
   CellID->898728618]},
 "Notation:S2.1"->{
  Cell[3432, 81, 1545, 44, 70, "Text",
   CellTags->{
    "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1", 
     "NotationDocumentation"},
   CellID->898728618],
  Cell[7612, 199, 165, 2, 70, "Caption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->724306124],
  Cell[7780, 203, 648, 16, 70, "Text",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->17207873],
  Cell[8431, 221, 187, 4, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->175855967],
  Cell[8621, 227, 874, 28, 70, "Input",
   CellTags->{
    "Ring Operations", "Notation:S2", "Notation:S2.1", 
     "NotationDocumentation"},
   CellID->511142072],
  Cell[9498, 257, 262, 7, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->66193563],
  Cell[9785, 268, 283, 7, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->690623672],
  Cell[10071, 277, 376, 10, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->171028537],
  Cell[10484, 292, 179, 4, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->92309166],
  Cell[10666, 298, 433, 14, 50, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->191034785],
  Cell[11114, 315, 568, 15, 70, "Text",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->67347689],
  Cell[11685, 332, 201, 5, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->599839807],
  Cell[11911, 341, 356, 12, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->103606775],
  Cell[12270, 355, 418, 12, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->377715943],
  Cell[12703, 370, 217, 5, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->79628061],
  Cell[12945, 379, 208, 5, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->505577540],
  Cell[13156, 386, 295, 8, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->4010008],
  Cell[13466, 397, 468, 14, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->760575024],
  Cell[13937, 413, 1233, 40, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->312730836],
  Cell[15173, 455, 373, 14, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->163094619],
  Cell[15571, 473, 384, 9, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->311003923],
  Cell[15958, 484, 447, 12, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
   CellID->79402875]},
 "Ring Operations"->{
  Cell[8621, 227, 874, 28, 70, "Input",
   CellTags->{
    "Ring Operations", "Notation:S2", "Notation:S2.1", 
     "NotationDocumentation"},
   CellID->511142072]},
 "Notation:S2.2"->{
  Cell[16570, 506, 566, 18, 70, "Text",
   CellTags->{
    "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses", 
     "NotationDocumentation"},
   CellID->26769111],
  Cell[17139, 526, 168, 2, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->925122041],
  Cell[17310, 530, 432, 12, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->88112840],
  Cell[17767, 546, 277, 8, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->279559934],
  Cell[18047, 556, 377, 12, 50, "Output",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->523473392],
  Cell[18439, 571, 219, 6, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->27808374],
  Cell[18683, 581, 223, 6, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->370302637],
  Cell[18909, 589, 390, 12, 50, "Output",
   CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
   CellID->274378028]},
 "Notation:Documentation:Parentheses"->{
  Cell[16570, 506, 566, 18, 70, "Text",
   CellTags->{
    "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses", 
     "NotationDocumentation"},
   CellID->26769111]},
 "Notation:S2.3"->{
  Cell[19476, 611, 1316, 37, 70, "Text",
   CellTags->{
    "Notation:S2", "Notation:S2.3", 
     "Notation:Documentation:Changing Precedences", "NotationDocumentation"},
   CellID->683683627],
  Cell[20795, 650, 378, 10, 70, "MathCaption",
   CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
   CellID->206671737],
  Cell[21198, 664, 348, 11, 70, "Input",
   CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
   CellID->21667896],
  Cell[21549, 677, 588, 16, 36, "Output",
   CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
   CellID->176817880],
  Cell[22152, 696, 980, 31, 70, "Text",
   CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
   CellID->60432642]},
 "Notation:Documentation:Changing Precedences"->{
  Cell[19476, 611, 1316, 37, 70, "Text",
   CellTags->{
    "Notation:S2", "Notation:S2.3", 
     "Notation:Documentation:Changing Precedences", "NotationDocumentation"},
   CellID->683683627]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"NotationDocumentation", 25648, 781},
 {"Notation:S2", 31091, 907},
 {"Notation:Documentation:Precedence", 36458, 1030},
 {"Notation:S2.1", 36661, 1036},
 {"Ring Operations", 39770, 1107},
 {"Notation:S2.2", 39956, 1113},
 {"Notation:Documentation:Parentheses", 41141, 1140},
 {"Notation:S2.3", 41345, 1146},
 {"Notation:Documentation:Changing Precedences", 42138, 1164}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 2551, 44, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3176, 71, 108, 2, 70, "Title",
 CellTags->"NotationDocumentation",
 CellID->44994921],
Cell[CellGroupData[{
Cell[3309, 77, 120, 2, 70, "Section",
 CellTags->{"Notation:S2", "NotationDocumentation"},
 CellID->323651810],
Cell[3432, 81, 1545, 44, 70, "Text",
 CellTags->{
  "Notation:S2", "Notation:Documentation:Precedence", "Notation:S2.1", 
   "NotationDocumentation"},
 CellID->898728618],
Cell[4980, 127, 2629, 70, 70, "DefinitionBox",
 CellID->112725058],
Cell[7612, 199, 165, 2, 70, "Caption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->724306124],
Cell[7780, 203, 648, 16, 70, "Text",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->17207873],
Cell[8431, 221, 187, 4, 70, "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->175855967],
Cell[8621, 227, 874, 28, 70, "Input",
 CellTags->{
  "Ring Operations", "Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 
 CellID->511142072],
Cell[9498, 257, 262, 7, 70, "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->66193563],
Cell[CellGroupData[{
Cell[9785, 268, 283, 7, 70, "Input",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->690623672],
Cell[10071, 277, 376, 10, 36, "Output",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->171028537]
}, Open  ]],
Cell[CellGroupData[{
Cell[10484, 292, 179, 4, 70, "Input",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->92309166],
Cell[10666, 298, 433, 14, 50, "Output",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->191034785]
}, Open  ]],
Cell[11114, 315, 568, 15, 70, "Text",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->67347689],
Cell[11685, 332, 201, 5, 70, "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->599839807],
Cell[CellGroupData[{
Cell[11911, 341, 356, 12, 70, "Input",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->103606775],
Cell[12270, 355, 418, 12, 36, "Output",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->377715943]
}, Open  ]],
Cell[12703, 370, 217, 5, 70, "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->79628061],
Cell[CellGroupData[{
Cell[12945, 379, 208, 5, 70, "Input",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->505577540],
Cell[13156, 386, 295, 8, 36, "Output",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->4010008]
}, Open  ]],
Cell[13466, 397, 468, 14, 70, "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->760575024],
Cell[13937, 413, 1233, 40, 70, "Input",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->312730836],
Cell[15173, 455, 373, 14, 70, "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->163094619],
Cell[CellGroupData[{
Cell[15571, 473, 384, 9, 70, "Input",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->311003923],
Cell[15958, 484, 447, 12, 36, "Output",
 CellTags->{"Notation:S2", "Notation:S2.1", "NotationDocumentation"},
 CellID->79402875]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16454, 502, 113, 2, 70, "Section",
 CellTags->{"Notation:S2", "NotationDocumentation"},
 CellID->855898],
Cell[16570, 506, 566, 18, 70, "Text",
 CellTags->{
  "Notation:S2", "Notation:S2.2", "Notation:Documentation:Parentheses", 
   "NotationDocumentation"},
 CellID->26769111],
Cell[17139, 526, 168, 2, 70, "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellID->925122041],
Cell[17310, 530, 432, 12, 70, "Input",
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellID->88112840],
Cell[CellGroupData[{
Cell[17767, 546, 277, 8, 70, "Input",
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellID->279559934],
Cell[18047, 556, 377, 12, 50, "Output",
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellID->523473392]
}, Open  ]],
Cell[18439, 571, 219, 6, 70, "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellID->27808374],
Cell[CellGroupData[{
Cell[18683, 581, 223, 6, 70, "Input",
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellID->370302637],
Cell[18909, 589, 390, 12, 50, "Output",
 CellTags->{"Notation:S2", "Notation:S2.2", "NotationDocumentation"},
 CellID->274378028]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19348, 607, 125, 2, 70, "Section",
 CellTags->{"Notation:S2", "NotationDocumentation"},
 CellID->167645012],
Cell[19476, 611, 1316, 37, 70, "Text",
 CellTags->{
  "Notation:S2", "Notation:S2.3", 
   "Notation:Documentation:Changing Precedences", "NotationDocumentation"},
 CellID->683683627],
Cell[20795, 650, 378, 10, 70, "MathCaption",
 CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
 CellID->206671737],
Cell[CellGroupData[{
Cell[21198, 664, 348, 11, 70, "Input",
 CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
 CellID->21667896],
Cell[21549, 677, 588, 16, 36, "Output",
 CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
 CellID->176817880]
}, Open  ]],
Cell[22152, 696, 980, 31, 70, "Text",
 CellTags->{"Notation:S2", "Notation:S2.3", "NotationDocumentation"},
 CellID->60432642]
}, Open  ]]
}, Open  ]],
Cell[23159, 731, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

