(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      6822,        236]
NotebookOptionsPosition[      5019,        179]
NotebookOutlinePosition[      6125,        209]
CellTagsIndexPosition[      6082,        206]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL CALCULUS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculus Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/tutorial/NumericalCalculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculus Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EulerSum" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/ref/EulerSum"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EulerSum\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EulerRatio", "ObjectName",
 CellID->24537],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["EulerRatio"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["EulerSum",
       BaseStyle->"Link",
       ButtonData->"paclet:NumericalCalculus/ref/EulerSum"]], 
      "InlineFormula"],
     ", which specifies the parameter to use in the generalized Euler \
transformation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->13629]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["EulerRatio"], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", a single ratio, or a list of ratios or ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["ratio", "TI"], ",", 
    RowBox[{
     StyleBox["degree", "TI"], "+", "1"}]}], "}"}]], "InlineFormula"],
 " pairs. In the case of a list, the various ratios are used successively in \
iterated Euler transformations."
}], "Notes",
 CellID->18389],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", the value used for ",
 Cell[BoxData["EulerRatio"], "InlineFormula"],
 " is based on the ratio of successive terms in the series."
}], "Notes",
 CellID->9843]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->31987],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["EulerSum",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/EulerSum"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->5136]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->7004],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/tutorial/NumericalCalculus"]], "Tutorials",
 CellID->20101]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EulerRatio - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 10.4212478}", "context" -> 
    "NumericalCalculus`", "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Calculus Package Symbol", "language" -> "en", "paclet" -> 
    "NumericalCalculus Package", "status" -> "None", "summary" -> 
    "EulerRatio is an option to EulerSum, which specifies the parameter to \
use in the generalized Euler transformation.", "synonyms" -> {}, "title" -> 
    "EulerRatio", "type" -> "Symbol", "uri" -> 
    "NumericalCalculus/ref/EulerRatio"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1233, 33, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1856, 60, 48, 1, 70, "ObjectName",
 CellID->24537],
Cell[1907, 63, 566, 17, 70, "Usage",
 CellID->13629]
}, Open  ]],
Cell[CellGroupData[{
Cell[2510, 85, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[2988, 102, 566, 18, 70, "Notes",
 CellID->18389],
Cell[3557, 122, 328, 10, 70, "Notes",
 CellID->9843]
}, Closed]],
Cell[CellGroupData[{
Cell[3922, 137, 311, 9, 70, "SeeAlsoSection",
 CellID->31987],
Cell[4236, 148, 213, 6, 70, "SeeAlso",
 CellID->5136]
}, Open  ]],
Cell[CellGroupData[{
Cell[4486, 159, 313, 9, 70, "TutorialsSection",
 CellID->7004],
Cell[4802, 170, 175, 4, 70, "Tutorials",
 CellID->20101]
}, Open  ]],
Cell[4992, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

