(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12890,        430]
NotebookOptionsPosition[     10583,        358]
NotebookOutlinePosition[     11798,        389]
CellTagsIndexPosition[     11755,        386]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL CALCULUS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculus Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/tutorial/NumericalCalculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculus Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NSeries" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/NSeries"], 
          "NResidue" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/NResidue"], 
          "ND" :> Documentation`HelpLookup["paclet:NumericalCalculus/ref/ND"],
           "NSum" :> Documentation`HelpLookup["paclet:ref/NSum"]}, #, 2]& , 
        Evaluator -> Automatic], {1->"\<\"NSeries\"\>", 2->"\<\"NResidue\"\>",
        3->"\<\"ND\"\>", 4->"\<\"NSum\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["EulerSum", "ObjectName",
 CellID->3240],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EulerSum", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]]}], "}"}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives a numerical approximation to the sum ",
     Cell[BoxData[
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{
         StyleBox["i", "TI"], "=", 
         SubscriptBox[
          StyleBox["i", "TI"], 
          StyleBox["min", "TI"]]}], 
        SubscriptBox[
         StyleBox["i", "TI"], 
         StyleBox["max", "TI"]]], 
       StyleBox["f", "TI"]}]], "InlineFormula"],
     " using Euler\[CloseCurlyQuote]s transformation."
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"EulerSum", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["i", "TI"], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["min", "TI"]], ",", 
          SubscriptBox[
           StyleBox["i", "TI"], 
           StyleBox["max", "TI"]], ",", 
          StyleBox["di", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]uses a step ",
     Cell[BoxData[
      StyleBox["di", "TI"]], "InlineFormula"],
     " in the sum."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->21027]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 Cell[BoxData["EulerSum"], "InlineFormula"],
 " is particularly good for working with alternating series and series whose \
terms have the form ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{"p", "(", "n", ")"}], " ", 
    SuperscriptBox["r", "n"]}], TraditionalForm]], "InlineMath"],
 ", where ",
 Cell[BoxData[
  FormBox[
   RowBox[{"p", "(", "n", ")"}], TraditionalForm]], "InlineMath"],
 " is a polynomial in ",
 Cell[BoxData[
  StyleBox["n", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->15610],

Cell[TextData[{
 Cell[BoxData["EulerSum"], "InlineFormula"],
 " can be used for sums with both finite and infinite limits."
}], "Notes",
 CellID->527],

Cell["The following options can be given:", "Notes",
 CellID->15282],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["EulerRatio",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalCalculus/ref/EulerRatio"], 
    ButtonBox["Automatic",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "parameter used in generalized Euler transformations", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["ExtraTerms",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalCalculus/ref/ExtraTerms"], "7", Cell[
    "number of terms to use during extrapolation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Terms",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalCalculus/ref/Terms"], "5", Cell[
    "number of terms to use before extrapolation", "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "the precision used in internal computations", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {None, None, None, {None}}, "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True, True, True}}}},
 CellID->26393],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["EulerRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/EulerRatio"]], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", a single ratio, or a list of ratios or ",
 Cell[BoxData[
  RowBox[{"{", 
   RowBox[{
    StyleBox["ratio", "TI"], ",", 
    RowBox[{
     StyleBox["degree", "TI"], "+", "1"}]}], "}"}]], "InlineFormula"],
 " pairs. In the case of a list, the various ratios are used successively in \
iterated Euler transformations."
}], "Notes",
 CellID->17187],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  ButtonBox["Automatic",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Automatic"]], "InlineFormula"],
 ", the value used for ",
 Cell[BoxData[
  ButtonBox["EulerRatio",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/EulerRatio"]], "InlineFormula"],
 " is based on the ratio of successive terms in the series."
}], "Notes",
 CellID->7863],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["ExtraTerms",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/ExtraTerms"]], "InlineFormula"],
 " are integers greater than 1. The default setting is ",
 Cell[BoxData["7"], "InlineFormula"],
 "."
}], "Notes",
 CellID->23961],

Cell[TextData[{
 "The setting for ",
 Cell[BoxData[
  ButtonBox["ExtraTerms",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/ExtraTerms"]], "InlineFormula"],
 " gives the number of terms to be used in the extrapolation process after \
the number of terms specified by the option ",
 Cell[BoxData[
  ButtonBox["Terms",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/Terms"]], "InlineFormula"],
 " have been explicitly summed."
}], "Notes",
 CellID->2565],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["Terms",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/Terms"]], "InlineFormula"],
 " are positive integers."
}], "Notes",
 CellID->28599]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->28103],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/NSeries"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NResidue",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/NResidue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ND",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/ND"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSum"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->6358]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->19251],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/tutorial/NumericalCalculus"]], "Tutorials",
 CellID->27318]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"EulerSum - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 10.6087526}", "context" -> 
    "NumericalCalculus`", "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Calculus Package Symbol", "language" -> "en", "paclet" -> 
    "NumericalCalculus Package", "status" -> "None", "summary" -> 
    "EulerSum[f, {i, i_min, i_max}] gives a numerical approximation to the \
sum UnderoverscriptBox[\\[Sum], i = i_min, i_max]f using \
Euler\\[CloseCurlyQuote]s transformation. EulerSum[f, {i, i_min, i_max, di}] \
uses a step di in the sum.", "synonyms" -> {}, "title" -> "EulerSum", "type" -> 
    "Symbol", "uri" -> "NumericalCalculus/ref/EulerSum"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1534, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2157, 64, 45, 1, 70, "ObjectName",
 CellID->3240],
Cell[2205, 67, 1714, 55, 70, "Usage",
 CellID->21027]
}, Open  ]],
Cell[CellGroupData[{
Cell[3956, 127, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4434, 144, 528, 18, 70, "Notes",
 CellID->15610],
Cell[4965, 164, 150, 4, 70, "Notes",
 CellID->527],
Cell[5118, 170, 68, 1, 70, "Notes",
 CellID->15282],
Cell[5189, 173, 1374, 33, 70, "3ColumnTableMod",
 CellID->26393],
Cell[6566, 208, 660, 21, 70, "Notes",
 CellID->17187],
Cell[7229, 231, 422, 13, 70, "Notes",
 CellID->7863],
Cell[7654, 246, 310, 10, 70, "Notes",
 CellID->23961],
Cell[7967, 258, 493, 14, 70, "Notes",
 CellID->2565],
Cell[8463, 274, 226, 8, 70, "Notes",
 CellID->28599]
}, Closed]],
Cell[CellGroupData[{
Cell[8726, 287, 311, 9, 70, "SeeAlsoSection",
 CellID->28103],
Cell[9040, 298, 972, 35, 70, "SeeAlso",
 CellID->6358]
}, Open  ]],
Cell[CellGroupData[{
Cell[10049, 338, 314, 9, 70, "TutorialsSection",
 CellID->19251],
Cell[10366, 349, 175, 4, 70, "Tutorials",
 CellID->27318]
}, Open  ]],
Cell[10556, 356, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

