(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     55306,       2159]
NotebookOptionsPosition[     42854,       1703]
NotebookOutlinePosition[     44110,       1739]
CellTagsIndexPosition[     44024,       1734]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL CALCULUS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculus Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/tutorial/NumericalCalculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculus Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ND" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/ND"], 
          "Limit" :> Documentation`HelpLookup["paclet:ref/Limit"], "NSeries" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/ref/NSeries"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"ND\"\>", 2->"\<\"Limit\"\>", 
       3->"\<\"NSeries\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NLimit", "ObjectName",
 CellID->8243],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NLimit", "[", 
       RowBox[{
        StyleBox["expr", "TI"], ",", 
        RowBox[{
         StyleBox["z", "TI"], "->", 
         SubscriptBox[
          StyleBox["z", "TI"], 
          StyleBox["0", "TR"]]}]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]numerically finds the limiting value of ",
     Cell[BoxData[
      StyleBox["expr", "TI"]], "InlineFormula"],
     " as ",
     Cell[BoxData[
      StyleBox["z", "TI"]], "InlineFormula"],
     " approaches ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["z", "TI"], 
       StyleBox["0", "TR"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->12365]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The expression ",
 Cell[BoxData[
  StyleBox["expr", "TI"]], "InlineFormula"],
 " must be numeric when its argument ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " is numeric."
}], "Notes",
 CellBracketOptions->{"Color"->RGBColor[0.269993, 0.308507, 0.6]},
 ShowAutoStyles->False,
 ParagraphSpacing->{0.7, 0},
 ScriptMinSize->9,
 CellID->4718],

Cell[TextData[{
 Cell[BoxData["NLimit"], "InlineFormula"],
 " constructs a sequence of values that approach the point ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["z", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " and uses extrapolation to find the limit."
}], "Notes",
 CellID->17135],

Cell[TextData[{
 Cell[BoxData["NLimit"], "InlineFormula"],
 " is unable to recognize small numbers that should in fact be zero. ",
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 " may be needed to eliminate these spurious residuals."
}], "Notes",
 CellID->16937],

Cell[TextData[{
 Cell[BoxData["NLimit"], "InlineFormula"],
 " often fails when the limit has a power law approach to infinity."
}], "Notes",
 CellID->4599],

Cell["The following options can be given: ", "Notes",
 CellID->31499],

Cell[BoxData[GridBox[{
   {
    ButtonBox["WorkingPrecision",
     BaseStyle->"FunctionLink",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"FunctionLink",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "precision to use in internal computations", "TableText"]},
   {
    ButtonBox["Direction",
     BaseStyle->"FunctionLink",
     ButtonData->"paclet:ref/Direction"], 
    ButtonBox["Automatic",
     BaseStyle->"FunctionLink",
     ButtonData->"paclet:ref/Automatic"], Cell[
    "vector giving the direction of approach", "TableText"]},
   {
    ButtonBox["Scale",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalCalculus/ref/Scale"], "1", Cell[
    "initial stepsize in the sequence of steps", "TableText"]},
   {
    ButtonBox["Terms",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalCalculus/ref/Terms"], "7", Cell[
    "number of terms used to evaluate the limit", "TableText"]},
   {
    ButtonBox["Method",
     BaseStyle->"FunctionLink",
     ButtonData->"paclet:ref/Method"], "EulerSum", Cell[
    "the method used to evaluate the result", "TableText"]},
   {"WynnDegree", "1", Cell[
    "degree used in Wynn's epsilon algorithm", "TableText"]}
  }]], "3ColumnTable",
 CellID->13192],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Direction",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Direction"], "->", 
   StyleBox["d", "TI"]}]], "InlineFormula"],
 " specifies that the approach vector to a finite limit point ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["z", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " is given by the complex number ",
 Cell[BoxData[
  StyleBox["d", "TI"]], "InlineFormula"],
 ". The default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Direction",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Direction"], "->", 
   ButtonBox["Automatic",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Automatic"]}]], "InlineFormula"],
 " is equivalent to ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Direction",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Direction"], "->", 
   RowBox[{"-", "1"}]}]], "InlineFormula"],
 ", and computes the limit as ",
 Cell[BoxData[
  StyleBox["z", "TI"]], "InlineFormula"],
 " approaches ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["z", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " from larger values."
}], "Notes",
 CellID->30554],

Cell[TextData[{
 Cell[BoxData["NLimit"], "InlineFormula"],
 " approaches infinite limit points on a ray from the origin."
}], "Notes",
 CellID->19124],

Cell[TextData[{
 "The option ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/Scale"]], "InlineFormula"],
 " specifies the initial step in the constructed sequence. "
}], "Notes",
 CellID->31],

Cell[TextData[{
 "For finite limit points ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 ", the initial step is a distance ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/Scale"]], "InlineFormula"],
 " away from ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 ". For infinite limit points, the initial step is a distance ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/Scale"]], "InlineFormula"],
 " away from the origin."
}], "Notes",
 CellID->28066],

Cell[TextData[{
 "The accuracy of the result is generally improved by increasing the number \
of terms, although increased ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " will also usually be necessary."
}], "Notes",
 CellID->26429],

Cell[TextData[{
 "Possible settings for ",
 Cell[BoxData[
  ButtonBox["Method",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Method"]], "InlineFormula"],
 " include:"
}], "Notes",
 CellID->12722],

Cell[BoxData[GridBox[{
   {"EulerSum", 
    RowBox[{
    "converts", " ", "sequence", " ", "to", " ", "a", " ", "sum", " ", "and", 
     " ", "uses", " ", "EulerSum"}]},
   {"SequenceLimit", Cell[TextData[{
     "uses ",
     Cell[BoxData["SequenceLimit"], "InlineFormula"],
     " on constructed sequence"
    }], "TableText"]}
  }]], "2ColumnTable",
 CellID->29556],

Cell[TextData[{
 "The option ",
 Cell[BoxData["WynnDegree"], "InlineFormula"],
 " specifies the number of iterations of Wynn's epsilon algorithm to be used \
by ",
 Cell[BoxData["SequenceLimit"], "InlineFormula"],
 ". In general, there must be at least ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", " ", 
    RowBox[{"(", 
     RowBox[{"n", "+", "1"}], ")"}]}], TraditionalForm]], "InlineMath"],
 " terms for ",
 Cell[BoxData[
  FormBox["n", TraditionalForm]], "InlineMath"],
 " iterations."
}], "Notes",
 CellID->13818]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->467841964],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(2)", "ExampleCount"]
}], "ExampleSection",
 CellID->200913172],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->74143902],

Cell["Find the limit at zero:", "ExampleText",
 CellID->1141961669],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], "x"], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->31826],

Cell[BoxData["1.0000000000000082`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1744298338]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->1278],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->418325075],

Cell["Find the limit at infinity:", "ExampleText",
 CellID->17777],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      RowBox[{"1", "/", "n"}]}], ")"}], "n"], ",", 
   RowBox[{"n", "->", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->22338],

Cell[BoxData["2.7182820547148787`"], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1122901569]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->6125],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->266011606],

Cell["The expression can be manifestly complex:", "ExampleText",
 CellID->139],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   SuperscriptBox[
    RowBox[{"(", 
     RowBox[{"1", "+", 
      FractionBox["I", "x"]}], ")"}], "x"], ",", 
   RowBox[{"x", "->", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->19821],

Cell[BoxData[
 RowBox[{"0.5403023567085921`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.8414705892303841`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{140, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->520380347]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->3640],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->62499341],

Cell["The limit point can be complex:", "ExampleText",
 CellID->7966],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Tanh", "[", 
     RowBox[{"\[Pi]", " ", "x"}], "]"}], 
    RowBox[{"1", "+", 
     SuperscriptBox["x", "2"]}]], ",", 
   RowBox[{"x", "->", "I"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->29081],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "8.176170046836351`*^-7"}], "-", 
  RowBox[{"1.5707987833968036`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{163, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1479081445]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(3)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->9951],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Terms",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->12907],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->3171289],

Cell["\<\
Expressions which approach their limiting value exponentially need fewer \
terms:\
\>", "ExampleText",
 CellID->19551],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", "x", "]"}], ",", 
   RowBox[{"x", "->", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3110],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/0.`\\) encountered. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/infy\\\", \
ButtonNote -> \\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->35648047],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(0.`\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->1769722],

Cell[BoxData[
 RowBox[{
  RowBox[{"EulerSum", "::", "\<\"ernum\"\>"}], ":", 
  " ", "\<\"Encountered the nonnumerical EulerRatio of \
\\!\\(Indeterminate\\).\"\>"}]], "Message", "MSG",
 CellID->105003815],

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", "x", "]"}], ",", 
   RowBox[{"x", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Output",
 ImageSize->{152, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->34158231]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{"Tanh", "[", "x", "]"}], ",", 
   RowBox[{"x", "->", "\[Infinity]"}], ",", 
   RowBox[{"Terms", "->", "3"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21576],

Cell[BoxData["1.`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->683644442]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->26023],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->371882471],

Cell["Increasing the number of terms can improve accuracy:", "ExampleText",
 CellID->22574],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lim", "=", 
  RowBox[{"Limit", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["10", "x"], "-", "1"}], "x"], ",", 
    RowBox[{"x", "->", "0"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->15454],

Cell[BoxData[
 RowBox[{"Log", "[", "10", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->1525091597]
}, Open  ]],

Cell["Error in numerical approximation:", "ExampleText",
 CellID->11906],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NLimit", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["10", "x"], "-", "1"}], "x"], ",", 
    RowBox[{"x", "->", "0"}], ",", 
    RowBox[{"Method", "->", "SequenceLimit"}]}], "]"}], "-", "lim"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->32485],

Cell[BoxData[
 RowBox[{"-", "4.940622710947196`*^-7"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1997143834]
}, Open  ]],

Cell["Use more terms to reduce error:", "ExampleText",
 CellID->28048],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NLimit", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["10", "x"], "-", "1"}], "x"], ",", 
    RowBox[{"x", "->", "0"}], ",", 
    RowBox[{"Terms", "->", "10"}], ",", 
    RowBox[{"Method", "->", "SequenceLimit"}]}], "]"}], "-", "lim"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->23930],

Cell[BoxData[
 RowBox[{"-", "4.203970505045618`*^-11"}]], "Output",
 ImageSize->{102, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->827015428]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scale",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->26658],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->70063539],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Scale",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/Scale"]], "InlineFormula"],
 " to avoid regions where the expression is undefined:"
}], "ExampleText",
 CellID->25816],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"NIntegrate", "[", 
    RowBox[{
     RowBox[{"Zeta", "[", 
      RowBox[{"a", " ", "z"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"z", ",", 
       RowBox[{"2", "/", "a"}], ",", "1"}], "}"}]}], "]"}], "/;", 
   RowBox[{"a", ">", "1"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->8884],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"a", "->", "Infinity"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->20373],

Cell[BoxData[
 RowBox[{
  RowBox[{"NLimit", "::", "\<\"notnum\"\>"}], ":", 
  " ", "\<\"The expression \\!\\(f[1.`]\\) is not numerical at the point \
\\!\\(a\\) == \\!\\(1.`\\).\"\>"}]], "Message", "MSG",
 CellID->488822137],

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"a", "\[Rule]", "\[Infinity]"}]}], "]"}]], "Output",
 ImageSize->{131, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->99913114]
}, Open  ]],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "x", ")"}], TraditionalForm]], "InlineMath"],
 " diverges for ",
 Cell[BoxData[
  FormBox[
   RowBox[{"f", "(", "1", ")"}], TraditionalForm]], "InlineMath"],
 ", so choose the initial step to avoid this divergence:"
}], "ExampleText",
 CellID->9783],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{"f", "[", "a", "]"}], ",", 
   RowBox[{"a", "->", "\[Infinity]"}], ",", 
   RowBox[{"Scale", "->", "10"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->15791],

Cell[BoxData["1.0000011391279244`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->99542984]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Direction",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->8010],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->12539305],

Cell[TextData[{
 "Approach 0 along the negative real axis (",
 Cell[BoxData[
  RowBox[{"z", "\[Conjugate]"}]], "InlineFormula"],
 " can be input using ",
 Cell[BoxData["z\[EscapeKey]co\[EscapeKey]"], "InlineFormula"],
 "):"
}], "ExampleText",
 CellID->20987],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{"z", "+", 
    FractionBox[
     RowBox[{"z", "\[Conjugate]"}], "z"]}], ",", 
   RowBox[{"z", "->", "0"}], ",", 
   RowBox[{"Direction", "->", "1"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32364],

Cell[BoxData["0.9999999999999999`"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->568]
}, Open  ]],

Cell["Approach 0 along the positive imaginary axis:", "ExampleText",
 CellID->5994],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NLimit", "[", 
   RowBox[{
    RowBox[{"z", "+", 
     FractionBox[
      RowBox[{"z", "\[Conjugate]"}], "z"]}], ",", 
    RowBox[{"z", "->", "0"}], ",", 
    RowBox[{"Direction", "->", 
     RowBox[{"-", "I"}]}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->579],

Cell[BoxData[
 RowBox[{"-", "1.0000000000000002`"}]], "Output",
 ImageSize->{26, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->24023]
}, Open  ]],

Cell[TextData[{
 "Approach 0 from the ",
 Cell[BoxData[
  FormBox[
   SuperscriptBox["3", "rd"], TraditionalForm]]],
 " quadrant, 225\[Degree]:"
}], "ExampleText",
 CellID->25709],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NLimit", "[", 
   RowBox[{
    RowBox[{"z", "+", 
     FractionBox[
      RowBox[{"z", "\[Conjugate]"}], "z"]}], ",", 
    RowBox[{"z", "->", "0"}], ",", 
    RowBox[{"Direction", "->", 
     RowBox[{"-", 
      RowBox[{"Exp", "[", 
       RowBox[{"225", "\[Degree]", " ", "I"}], "]"}]}]}]}], "]"}], "//", 
  "Chop"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->31657],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.9999999999999999`"}], " ", "\[ImaginaryI]"}]], "Output",
 ImageSize->{37, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->4141]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Method",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->29285],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->687419632],

Cell["An example where the default method works fairly well:", "ExampleText",
 CellID->8477],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], "x"], ",", 
   RowBox[{"x", "->", "\[Infinity]"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->14023],

Cell[BoxData[
 RowBox[{"-", "3.191531412483073`*^-7"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->45604064]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData["SequenceLimit"], "InlineFormula"],
 " produces poorer results:"
}], "ExampleText",
 CellID->8828],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], "x"], ",", 
   RowBox[{"x", "->", "\[Infinity]"}], ",", 
   RowBox[{"Method", "->", "SequenceLimit"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->11435],

Cell[BoxData[
 RowBox[{
  RowBox[{"SequenceLimit", "::", "\<\"seqlim\"\>"}], ":", 
  " ", "\<\"The general form of the sequence could not be determined, and the \
result may be incorrect. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/SequenceLimit/seqlim\\\", ButtonNote -> \\\
\"SequenceLimit::seqlim\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->205054247],

Cell[BoxData["0.0002997765608389689`"], "Output",
 ImageSize->{81, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->564933186]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9009],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->186382135],

Cell["An example where the default method works poorly:", "ExampleText",
 CellID->27743],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "z", "]"}], ",", 
   RowBox[{"z", "->", 
    RowBox[{"\[Infinity]", " ", "I"}]}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->30867],

Cell[BoxData[
 RowBox[{
  RowBox[{"Power", "::", "\<\"infy\"\>"}], ":", 
  " ", "\<\"Infinite expression \\!\\(1\\/\\(\\(\\(0.` \
\[InvisibleSpace]\\)\\) + \\(\\(0.`\\\\ \[ImaginaryI]\\)\\)\\)\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/infy\\\", ButtonNote -> \
\\\"Power::infy\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->300852860],

Cell[BoxData[
 RowBox[{
  RowBox[{"\[Infinity]", "::", "\<\"indet\"\>"}], ":", 
  " ", "\<\"Indeterminate expression \\!\\(\\(\\((\\(\\(0.` \[InvisibleSpace]\
\\)\\) + \\(\\(0.`\\\\ \[ImaginaryI]\\)\\))\\)\\)\\\\ ComplexInfinity\\) \
encountered. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/indet\\\", ButtonNote -> \
\\\"Infinity::indet\\\"]\\)\"\>"}]], "Message", "MSG",
 CellID->291086890],

Cell[BoxData[
 RowBox[{
  RowBox[{"EulerSum", "::", "\<\"ernum\"\>"}], ":", 
  " ", "\<\"Encountered the nonnumerical EulerRatio of \
\\!\\(Indeterminate\\).\"\>"}]], "Message", "MSG",
 CellID->474066422],

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "z", "]"}], ",", 
   RowBox[{"z", "\[Rule]", 
    TagBox[
     RowBox[{
      TagBox["\[ImaginaryI]",
       "DirectedInfinityCoefficient",
       Editable->True], " ", "\[Infinity]"}],
     DirectedInfinity,
     Editable->False]}]}], "]"}]], "Output",
 ImageSize->{156, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->399121566]
}, Open  ]],

Cell[TextData[{
 "Here, ",
 Cell[BoxData["SequenceLimit"], "InlineFormula"],
 " produces the correct result:"
}], "ExampleText",
 CellID->1538],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{"Tan", "[", "z", "]"}], ",", 
   RowBox[{"z", "->", 
    RowBox[{"\[Infinity]", " ", "I"}]}], ",", 
   RowBox[{"Method", "->", "SequenceLimit"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->7604],

Cell[BoxData[
 RowBox[{"0.`", "\[InvisibleSpace]", "+", 
  RowBox[{"1.`", " ", "\[ImaginaryI]"}]}]], "Output",
 ImageSize->{56, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->806749586]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WynnDegree",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->32212],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->314154812],

Cell[TextData[{
 "When using ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"FunctionLink",
    ButtonData->"paclet:ref/Method"], "->", "SequenceLimit"}]], 
  "InlineFormula"],
 ", increasing ",
 Cell[BoxData["WynnDegree"], "InlineFormula"],
 " may improve the accuracy of the limit:"
}], "ExampleText",
 CellID->10991],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lim", "=", 
  RowBox[{"SinIntegral", "[", "\[Infinity]", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12693],

Cell[BoxData[
 FractionBox["\[Pi]", "2"]], "Output",
 ImageSize->{17, 28},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23409]
}, Open  ]],

Cell[TextData[{
 "Error with ",
 Cell[BoxData[
  RowBox[{"WynnDegree", "->", "1"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->11620],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NLimit", "[", 
   RowBox[{
    RowBox[{"SinIntegral", "[", "z", "]"}], ",", 
    RowBox[{"z", "->", "\[Infinity]"}], ",", 
    RowBox[{"Terms", "->", "10"}], ",", 
    RowBox[{"Method", "->", "SequenceLimit"}], ",", 
    RowBox[{"WynnDegree", "->", "1"}]}], "]"}], "-", "lim"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->28197],

Cell[BoxData[
 RowBox[{"-", "9.309709980698244`*^-7"}]], "Output",
 ImageSize->{97, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->22662]
}, Open  ]],

Cell[TextData[{
 "Error with ",
 Cell[BoxData[
  RowBox[{"WynnDegree", "->", "3"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->327805596],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NLimit", "[", 
   RowBox[{
    RowBox[{"SinIntegral", "[", "z", "]"}], ",", 
    RowBox[{"z", "->", "\[Infinity]"}], ",", 
    RowBox[{"Terms", "->", "10"}], ",", 
    RowBox[{"Method", "->", "SequenceLimit"}], ",", 
    RowBox[{"WynnDegree", "->", "3"}]}], "]"}], "-", "lim"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->16100],

Cell[BoxData["8.221225922255826`*^-10"], "Output",
 ImageSize->{94, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->32759]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "WorkingPrecision",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->10842],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->530757375],

Cell[TextData[{
 "Increasing ",
 Cell[BoxData[
  ButtonBox["WorkingPrecision",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/WorkingPrecision"]], "InlineFormula"],
 " alone does not produce a more accurate result:"
}], "ExampleText",
 CellID->18440],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lim", "=", 
  RowBox[{"Limit", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["10", "x"], "-", "1"}], "x"], ",", 
    RowBox[{"x", "->", "0"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->10089],

Cell[BoxData[
 RowBox[{"Log", "[", "10", "]"}]], "Output",
 ImageSize->{53, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->29494]
}, Open  ]],

Cell[TextData[{
 "Error with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"], "->", "20"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22642],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NLimit", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["10", "x"], "-", "1"}], "x"], ",", 
    RowBox[{"x", "->", "0"}], ",", 
    RowBox[{"WorkingPrecision", "->", "20"}]}], "]"}], "-", "lim"}]], "Input",\

 CellLabel->"In[3]:=",
 CellID->31620],

Cell[BoxData["5.68192981025673672981937`8.843721807265538*^-6"], "Output",
 ImageSize->{110, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21486]
}, Open  ]],

Cell[TextData[{
 "Error with ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["WorkingPrecision",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/WorkingPrecision"], "->", "30"}]], 
  "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->6146],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NLimit", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["10", "x"], "-", "1"}], "x"], ",", 
    RowBox[{"x", "->", "0"}], ",", 
    RowBox[{"WorkingPrecision", "->", "30"}]}], "]"}], "-", "lim"}]], "Input",\

 CellLabel->"In[4]:=",
 CellID->27964],

Cell[BoxData["5.68192981025673672942228253417773`18.84372180726554*^-6"], \
"Output",
 ImageSize->{180, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->11486]
}, Open  ]],

Cell["\<\
To improve accuracy, the number of terms needs to be increased:\
\>", "ExampleText",
 CellID->1271],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NLimit", "[", 
   RowBox[{
    FractionBox[
     RowBox[{
      SuperscriptBox["10", "x"], "-", "1"}], "x"], ",", 
    RowBox[{"x", "->", "0"}], ",", 
    RowBox[{"WorkingPrecision", "->", "20"}], ",", 
    RowBox[{"Terms", "->", "10"}]}], "]"}], "-", "lim"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->30943],

Cell[BoxData[
 RowBox[{"-", "6.95301467803534002846`2.931150962010071*^-9"}]], "Output",
 ImageSize->{76, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->9466]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21474],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->610245231],

Cell["Find limit of a numerically defined function:", "ExampleText",
 CellID->3445],

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", 
   RowBox[{"a_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{
   FractionBox["1", "a"], 
   RowBox[{"Log", "[", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       SuperscriptBox["z", "a"], " ", 
       RowBox[{"Cot", "[", "z", "]"}]}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "0", ",", 
        RowBox[{"Pi", "/", "2"}]}], "}"}], ",", 
      RowBox[{"MaxRecursion", "->", "10"}]}], "]"}], "]"}]}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->11788],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   RowBox[{"g", "[", "a", "]"}], ",", 
   RowBox[{"a", "->", "Infinity"}], ",", 
   RowBox[{"Terms", "->", "10"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17349],

Cell[BoxData["0.4515827050548315`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->377803647]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->30954],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->445158059],

Cell["\<\
Limits where parts of the expression have essential singularities:\
\>", "ExampleText",
 CellID->31504],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{
     SqrtBox["z"], 
     RowBox[{"BesselJ", "[", 
      RowBox[{"0", ",", "z"}], "]"}]}], 
    RowBox[{"Cos", "[", 
     RowBox[{"z", "-", 
      FractionBox["\[Pi]", "4"]}], "]"}]], ",", 
   RowBox[{"z", "->", "\[Infinity]"}], ",", 
   RowBox[{"Terms", "->", "10"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->3281],

Cell[BoxData["0.7978845496585617`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->120880905]
}, Open  ]],

Cell["In this case, the exact limit can be found:", "ExampleText",
 CellID->23757],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"lim", "=", 
  RowBox[{
   RowBox[{
    FractionBox[
     SqrtBox["z"], 
     RowBox[{"Cos", "[", 
      RowBox[{"z", "-", 
       FractionBox["\[Pi]", "4"]}], "]"}]], 
    RowBox[{"Series", "[", 
     RowBox[{
      RowBox[{"BesselJ", "[", 
       RowBox[{"0", ",", "z"}], "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"z", ",", "\[Infinity]", ",", "0"}], "}"}]}], "]"}]}], "//", 
   "Normal"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27285],

Cell[BoxData[
 SqrtBox[
  FractionBox["2", "\[Pi]"]]], "Output",
 ImageSize->{36, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->285542210]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->12312],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"N", "[", "lim", "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->3232],

Cell[BoxData["0.7978845608028654`"], "Output",
 ImageSize->{60, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->93551376]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->13239],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->158685931],

Cell[TextData[{
 Cell[BoxData["SequenceLimit"], "InlineFormula"],
 " can be used directly to compute limits:"
}], "ExampleText",
 CellID->7768],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   FractionBox[
    RowBox[{"Sin", "[", "x", "]"}], "x"], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->32589],

Cell[BoxData[
 FormBox["1.0000000000000082`", TraditionalForm]], "Output",
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->17683]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SequenceLimit", "[", 
  RowBox[{"N", "@", 
   RowBox[{"Table", "[", 
    RowBox[{
     FractionBox[
      RowBox[{"Sin", "[", 
       SuperscriptBox["2", 
        RowBox[{"-", "x"}]], "]"}], 
      SuperscriptBox["2", 
       RowBox[{"-", "x"}]]], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->6209],

Cell[BoxData[
 FormBox["1.`", TraditionalForm]], "Output",
 ImageSize->{13, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21987]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->18795],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->350323645],

Cell["\<\
Limits whose value approaches infinity are sometimes unable to be computed:\
\>", "ExampleText",
 CellID->13245],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   FractionBox["1", "x"], ",", 
   RowBox[{"x", "->", "0"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1912],

Cell[BoxData[
 RowBox[{
  RowBox[{"NLimit", "::", "\<\"noise\"\>"}], ":", 
  " ", "\<\"Cannot recognize a limiting value.  This may be due to  noise \
resulting from roundoff errors in which case higher WorkingPrecision,  fewer \
Terms, or a different Scale might help.\"\>"}]], "Message", "MSG",
 CellID->1134135012],

Cell[BoxData[
 RowBox[{"NLimit", "[", 
  RowBox[{
   FractionBox["1", "x"], ",", 
   RowBox[{"x", "\[Rule]", "0"}]}], "]"}]], "Output",
 ImageSize->{113, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->342295912]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->13132],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ND",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/ND"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Limit",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Limit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSeries",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/NSeries"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->19728]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21875],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/tutorial/NumericalCalculus"]], "Tutorials",
 CellID->1692]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NLimit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 11.7181560}", "context" -> 
    "NumericalCalculus`", "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Calculus Package Symbol", "language" -> "en", "paclet" -> 
    "NumericalCalculus Package", "status" -> "None", "summary" -> 
    "NLimit[expr, z -> z_0] numerically finds the limiting value of expr as z \
approaches z_0.", "synonyms" -> {}, "title" -> "NLimit", "type" -> "Symbol", 
    "uri" -> "NumericalCalculus/ref/NLimit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[9736, 341, 360, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->467841964]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 43881, 1727}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1423, 36, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2046, 63, 43, 1, 70, "ObjectName",
 CellID->8243],
Cell[2092, 66, 855, 29, 70, "Usage",
 CellID->12365]
}, Open  ]],
Cell[CellGroupData[{
Cell[2984, 100, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3462, 117, 375, 13, 70, "Notes",
 CellID->4718],
Cell[3840, 132, 295, 9, 70, "Notes",
 CellID->17135],
Cell[4138, 143, 335, 9, 70, "Notes",
 CellID->16937],
Cell[4476, 154, 155, 4, 70, "Notes",
 CellID->4599],
Cell[4634, 160, 69, 1, 70, "Notes",
 CellID->31499],
Cell[4706, 163, 1279, 35, 70, "3ColumnTable",
 CellID->13192],
Cell[5988, 200, 1201, 42, 70, "Notes",
 CellID->30554],
Cell[7192, 244, 150, 4, 70, "Notes",
 CellID->19124],
Cell[7345, 250, 249, 8, 70, "Notes",
 CellID->31],
Cell[7597, 260, 680, 23, 70, "Notes",
 CellID->28066],
Cell[8280, 285, 325, 9, 70, "Notes",
 CellID->26429],
Cell[8608, 296, 199, 8, 70, "Notes",
 CellID->12722],
Cell[8810, 306, 367, 11, 70, "2ColumnTable",
 CellID->29556],
Cell[9180, 319, 519, 17, 70, "Notes",
 CellID->13818]
}, Closed]],
Cell[CellGroupData[{
Cell[9736, 341, 360, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->467841964],
Cell[CellGroupData[{
Cell[10121, 355, 148, 5, 70, "ExampleSection",
 CellID->200913172],
Cell[10272, 362, 141, 4, 70, "Input",
 CellID->74143902],
Cell[10416, 368, 67, 1, 70, "ExampleText",
 CellID->1141961669],
Cell[CellGroupData[{
Cell[10508, 373, 200, 7, 42, "Input",
 CellID->31826],
Cell[10711, 382, 177, 5, 36, "Output",
 CellID->1744298338]
}, Open  ]],
Cell[10903, 390, 120, 3, 70, "ExampleDelimiter",
 CellID->1278],
Cell[11026, 395, 142, 4, 70, "Input",
 CellID->418325075],
Cell[11171, 401, 66, 1, 70, "ExampleText",
 CellID->17777],
Cell[CellGroupData[{
Cell[11262, 406, 259, 9, 70, "Input",
 CellID->22338],
Cell[11524, 417, 177, 5, 36, "Output",
 CellID->1122901569]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11750, 428, 215, 7, 70, "ExampleSection",
 CellID->6125],
Cell[11968, 437, 142, 4, 70, "Input",
 CellID->266011606],
Cell[12113, 443, 78, 1, 70, "ExampleText",
 CellID->139],
Cell[CellGroupData[{
Cell[12216, 448, 257, 9, 70, "Input",
 CellID->19821],
Cell[12476, 459, 273, 7, 36, "Output",
 CellID->520380347]
}, Open  ]],
Cell[12764, 469, 120, 3, 70, "ExampleDelimiter",
 CellID->3640],
Cell[12887, 474, 141, 4, 70, "Input",
 CellID->62499341],
Cell[13031, 480, 69, 1, 70, "ExampleText",
 CellID->7966],
Cell[CellGroupData[{
Cell[13125, 485, 283, 10, 70, "Input",
 CellID->29081],
Cell[13411, 497, 274, 8, 36, "Output",
 CellID->1479081445]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[13734, 511, 217, 7, 70, "ExampleSection",
 CellID->9951],
Cell[CellGroupData[{
Cell[13976, 522, 222, 7, 70, "ExampleSubsection",
 CellID->12907],
Cell[14201, 531, 140, 4, 70, "Input",
 CellID->3171289],
Cell[14344, 537, 128, 4, 70, "ExampleText",
 CellID->19551],
Cell[CellGroupData[{
Cell[14497, 545, 187, 6, 70, "Input",
 CellID->3110],
Cell[14687, 553, 368, 7, 70, "Message",
 CellID->35648047],
Cell[15058, 562, 402, 8, 70, "Message",
 CellID->1769722],
Cell[15463, 572, 204, 5, 70, "Message",
 CellID->105003815],
Cell[15670, 579, 285, 9, 36, "Output",
 CellID->34158231]
}, Open  ]],
Cell[CellGroupData[{
Cell[15992, 593, 227, 7, 70, "Input",
 CellID->21576],
Cell[16222, 602, 160, 5, 36, "Output",
 CellID->683644442]
}, Open  ]],
Cell[16397, 610, 121, 3, 70, "ExampleDelimiter",
 CellID->26023],
Cell[16521, 615, 142, 4, 70, "Input",
 CellID->371882471],
Cell[16666, 621, 91, 1, 70, "ExampleText",
 CellID->22574],
Cell[CellGroupData[{
Cell[16782, 626, 250, 9, 70, "Input",
 CellID->15454],
Cell[17035, 637, 189, 6, 36, "Output",
 CellID->1525091597]
}, Open  ]],
Cell[17239, 646, 72, 1, 70, "ExampleText",
 CellID->11906],
Cell[CellGroupData[{
Cell[17336, 651, 306, 11, 70, "Input",
 CellID->32485],
Cell[17645, 664, 197, 6, 36, "Output",
 CellID->1997143834]
}, Open  ]],
Cell[17857, 673, 70, 1, 70, "ExampleText",
 CellID->28048],
Cell[CellGroupData[{
Cell[17952, 678, 347, 12, 70, "Input",
 CellID->23930],
Cell[18302, 692, 198, 6, 36, "Output",
 CellID->827015428]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[18549, 704, 222, 7, 70, "ExampleSubsection",
 CellID->26658],
Cell[18774, 713, 141, 4, 70, "Input",
 CellID->70063539],
Cell[18918, 719, 246, 8, 70, "ExampleText",
 CellID->25816],
Cell[19167, 729, 411, 14, 70, "Input",
 CellID->8884],
Cell[CellGroupData[{
Cell[19603, 747, 182, 6, 70, "Input",
 CellID->20373],
Cell[19788, 755, 225, 5, 70, "Message",
 CellID->488822137],
Cell[20016, 762, 282, 9, 36, "Output",
 CellID->99913114]
}, Open  ]],
Cell[20313, 774, 330, 11, 70, "ExampleText",
 CellID->9783],
Cell[CellGroupData[{
Cell[20668, 789, 225, 7, 70, "Input",
 CellID->15791],
Cell[20896, 798, 175, 5, 36, "Output",
 CellID->99542984]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21120, 809, 225, 7, 70, "ExampleSubsection",
 CellID->8010],
Cell[21348, 818, 141, 4, 70, "Input",
 CellID->12539305],
Cell[21492, 824, 258, 8, 70, "ExampleText",
 CellID->20987],
Cell[CellGroupData[{
Cell[21775, 836, 268, 9, 70, "Input",
 CellID->32364],
Cell[22046, 847, 170, 5, 36, "Output",
 CellID->568]
}, Open  ]],
Cell[22231, 855, 83, 1, 70, "ExampleText",
 CellID->5994],
Cell[CellGroupData[{
Cell[22339, 860, 320, 11, 70, "Input",
 CellID->579],
Cell[22662, 873, 189, 6, 36, "Output",
 CellID->24023]
}, Open  ]],
Cell[22866, 882, 179, 7, 70, "ExampleText",
 CellID->25709],
Cell[CellGroupData[{
Cell[23070, 893, 402, 14, 70, "Input",
 CellID->31657],
Cell[23475, 909, 223, 7, 36, "Output",
 CellID->4141]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[23747, 922, 223, 7, 70, "ExampleSubsection",
 CellID->29285],
Cell[23973, 931, 142, 4, 70, "Input",
 CellID->687419632],
Cell[24118, 937, 92, 1, 70, "ExampleText",
 CellID->8477],
Cell[CellGroupData[{
Cell[24235, 942, 210, 7, 70, "Input",
 CellID->14023],
Cell[24448, 951, 195, 6, 36, "Output",
 CellID->45604064]
}, Open  ]],
Cell[24658, 960, 139, 5, 70, "ExampleText",
 CellID->8828],
Cell[CellGroupData[{
Cell[24822, 969, 262, 8, 70, "Input",
 CellID->11435],
Cell[25087, 979, 440, 8, 70, "Message",
 CellID->205054247],
Cell[25530, 989, 179, 5, 36, "Output",
 CellID->564933186]
}, Open  ]],
Cell[25724, 997, 120, 3, 70, "ExampleDelimiter",
 CellID->9009],
Cell[25847, 1002, 142, 4, 70, "Input",
 CellID->186382135],
Cell[25992, 1008, 88, 1, 70, "ExampleText",
 CellID->27743],
Cell[CellGroupData[{
Cell[26105, 1013, 212, 7, 70, "Input",
 CellID->30867],
Cell[26320, 1022, 445, 9, 70, "Message",
 CellID->300852860],
Cell[26768, 1033, 486, 9, 70, "Message",
 CellID->291086890],
Cell[27257, 1044, 204, 5, 70, "Message",
 CellID->474066422],
Cell[27464, 1051, 457, 16, 36, "Output",
 CellID->399121566]
}, Open  ]],
Cell[27936, 1070, 143, 5, 70, "ExampleText",
 CellID->1538],
Cell[CellGroupData[{
Cell[28104, 1079, 263, 8, 70, "Input",
 CellID->7604],
Cell[28370, 1089, 240, 7, 36, "Output",
 CellID->806749586]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[28659, 1102, 227, 7, 70, "ExampleSubsection",
 CellID->32212],
Cell[28889, 1111, 142, 4, 70, "Input",
 CellID->314154812],
Cell[29034, 1117, 339, 12, 70, "ExampleText",
 CellID->10991],
Cell[CellGroupData[{
Cell[29398, 1133, 138, 4, 70, "Input",
 CellID->12693],
Cell[29539, 1139, 178, 6, 49, "Output",
 CellID->23409]
}, Open  ]],
Cell[29732, 1148, 142, 6, 70, "ExampleText",
 CellID->11620],
Cell[CellGroupData[{
Cell[29899, 1158, 362, 10, 70, "Input",
 CellID->28197],
Cell[30264, 1170, 192, 6, 36, "Output",
 CellID->22662]
}, Open  ]],
Cell[30471, 1179, 146, 6, 70, "ExampleText",
 CellID->327805596],
Cell[CellGroupData[{
Cell[30642, 1189, 362, 10, 70, "Input",
 CellID->16100],
Cell[31007, 1201, 176, 5, 36, "Output",
 CellID->32759]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[31232, 1212, 233, 7, 70, "ExampleSubsection",
 CellID->10842],
Cell[31468, 1221, 142, 4, 70, "Input",
 CellID->530757375],
Cell[31613, 1227, 252, 8, 70, "ExampleText",
 CellID->18440],
Cell[CellGroupData[{
Cell[31890, 1239, 250, 9, 70, "Input",
 CellID->10089],
Cell[32143, 1250, 184, 6, 36, "Output",
 CellID->29494]
}, Open  ]],
Cell[32342, 1259, 237, 10, 70, "ExampleText",
 CellID->22642],
Cell[CellGroupData[{
Cell[32604, 1273, 305, 11, 70, "Input",
 CellID->31620],
Cell[32912, 1286, 201, 5, 36, "Output",
 CellID->21486]
}, Open  ]],
Cell[33128, 1294, 236, 10, 70, "ExampleText",
 CellID->6146],
Cell[CellGroupData[{
Cell[33389, 1308, 305, 11, 70, "Input",
 CellID->27964],
Cell[33697, 1321, 212, 6, 36, "Output",
 CellID->11486]
}, Open  ]],
Cell[33924, 1330, 109, 3, 70, "ExampleText",
 CellID->1271],
Cell[CellGroupData[{
Cell[34058, 1337, 344, 11, 70, "Input",
 CellID->30943],
Cell[34405, 1350, 213, 6, 36, "Output",
 CellID->9466]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[34679, 1363, 223, 7, 70, "ExampleSection",
 CellID->21474],
Cell[34905, 1372, 142, 4, 70, "Input",
 CellID->610245231],
Cell[35050, 1378, 83, 1, 70, "ExampleText",
 CellID->3445],
Cell[35136, 1381, 521, 17, 70, "Input",
 CellID->11788],
Cell[CellGroupData[{
Cell[35682, 1402, 222, 7, 70, "Input",
 CellID->17349],
Cell[35907, 1411, 176, 5, 36, "Output",
 CellID->377803647]
}, Open  ]],
Cell[36098, 1419, 121, 3, 70, "ExampleDelimiter",
 CellID->30954],
Cell[36222, 1424, 142, 4, 70, "Input",
 CellID->445158059],
Cell[36367, 1430, 113, 3, 70, "ExampleText",
 CellID->31504],
Cell[CellGroupData[{
Cell[36505, 1437, 403, 14, 70, "Input",
 CellID->3281],
Cell[36911, 1453, 176, 5, 36, "Output",
 CellID->120880905]
}, Open  ]],
Cell[37102, 1461, 82, 1, 70, "ExampleText",
 CellID->23757],
Cell[CellGroupData[{
Cell[37209, 1466, 472, 17, 70, "Input",
 CellID->27285],
Cell[37684, 1485, 194, 7, 60, "Output",
 CellID->285542210]
}, Open  ]],
Cell[37893, 1495, 45, 1, 70, "ExampleText",
 CellID->12312],
Cell[CellGroupData[{
Cell[37963, 1500, 94, 3, 70, "Input",
 CellID->3232],
Cell[38060, 1505, 175, 5, 36, "Output",
 CellID->93551376]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[38284, 1516, 233, 7, 70, "ExampleSection",
 CellID->13239],
Cell[38520, 1525, 142, 4, 70, "Input",
 CellID->158685931],
Cell[38665, 1531, 143, 4, 70, "ExampleText",
 CellID->7768],
Cell[CellGroupData[{
Cell[38833, 1539, 200, 7, 70, "Input",
 CellID->32589],
Cell[39036, 1548, 200, 6, 36, "Output",
 CellID->17683]
}, Open  ]],
Cell[CellGroupData[{
Cell[39273, 1559, 411, 14, 70, "Input",
 CellID->6209],
Cell[39687, 1575, 184, 6, 36, "Output",
 CellID->21987]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39920, 1587, 226, 7, 70, "ExampleSection",
 CellID->18795],
Cell[40149, 1596, 142, 4, 70, "Input",
 CellID->350323645],
Cell[40294, 1602, 122, 3, 70, "ExampleText",
 CellID->13245],
Cell[CellGroupData[{
Cell[40441, 1609, 167, 6, 70, "Input",
 CellID->1912],
Cell[40611, 1617, 317, 6, 70, "Message",
 CellID->1134135012],
Cell[40931, 1625, 266, 9, 51, "Output",
 CellID->342295912]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[41258, 1641, 311, 9, 70, "SeeAlsoSection",
 CellID->13132],
Cell[41572, 1652, 712, 26, 70, "SeeAlso",
 CellID->19728]
}, Open  ]],
Cell[CellGroupData[{
Cell[42321, 1683, 314, 9, 70, "TutorialsSection",
 CellID->21875],
Cell[42638, 1694, 174, 4, 70, "Tutorials",
 CellID->1692]
}, Open  ]],
Cell[42827, 1701, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

