(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     64021,       2121]
NotebookOptionsPosition[     55283,       1804]
NotebookOutlinePosition[     56617,       1841]
CellTagsIndexPosition[     56531,       1836]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL CALCULUS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculus Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/tutorial/NumericalCalculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculus Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NLimit" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/NLimit"], 
          "NResidue" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/NResidue"], 
          "Series" :> Documentation`HelpLookup["paclet:ref/Series"], "NSum" :> 
          Documentation`HelpLookup["paclet:ref/NSum"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"NLimit\"\>", 2->"\<\"NResidue\"\>", 
       3->"\<\"Series\"\>", 4->"\<\"NSum\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NSeries", "ObjectName",
 CellID->18563],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NSeries", "[", 
       RowBox[{
        StyleBox["f", "TI"], ",", 
        RowBox[{"{", 
         RowBox[{
          StyleBox["x", "TI"], ",", 
          SubscriptBox[
           StyleBox["x", "TI"], 
           StyleBox["0", "TR"]], ",", 
          StyleBox["n", "TI"]}], "}"}]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]",
     "gives a numerical approximation to the series expansion of ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " about the point ",
     Cell[BoxData[
      RowBox[{
       StyleBox["x", "TI"], "=", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["0", "TR"]]}]], "InlineFormula"],
     " including the terms ",
     Cell[BoxData[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         StyleBox["x", "TI"], "-", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["0", "TR"]]}], ")"}], 
       RowBox[{"-", 
        StyleBox["n", "TI"]}]]], "InlineFormula"],
     " through ",
     Cell[BoxData[
      SuperscriptBox[
       RowBox[{"(", 
        RowBox[{
         StyleBox["x", "TI"], "-", 
         SubscriptBox[
          StyleBox["x", "TI"], 
          StyleBox["0", "TR"]]}], ")"}], 
       StyleBox["n", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->9125]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The function ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " must be numeric when its argument ",
 Cell[BoxData[
  StyleBox["x", "TI"]], "InlineFormula"],
 " is numeric."
}], "Notes",
 CellID->7007],

Cell[TextData[{
 Cell[BoxData["NSeries"], "InlineFormula"],
 " will construct standard univariate Taylor or Laurent series."
}], "Notes",
 CellID->18370],

Cell[TextData[{
 Cell[BoxData["NSeries"], "InlineFormula"],
 " samples ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " at points on a circle in the complex plane centered at ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " and uses ",
 Cell[BoxData[
  ButtonBox["InverseFourier",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/InverseFourier"]], "InlineFormula"],
 ". The option ",
 Cell[BoxData[
  ButtonBox["Radius",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/Radius"]], "InlineFormula"],
 " specifies the radius of the circle."
}], "Notes",
 CellID->15121],

Cell[TextData[{
 "The region of convergence will be the annulus (containing the sampled \
points) where ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 " is analytic."
}], "Notes",
 CellID->7727],

Cell[TextData[{
 Cell[BoxData["NSeries"], "InlineFormula"],
 " will not return a correct result if the disk centered at ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["x", "TI"], 
   StyleBox["0", "TR"]]], "InlineFormula"],
 " contains a branch cut of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->2658],

Cell[TextData[{
 "The result of ",
 Cell[BoxData["NSeries"], "InlineFormula"],
 " is a ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " object."
}], "Notes",
 CellID->24336],

Cell[TextData[{
 "If the result of ",
 Cell[BoxData["NSeries"], "InlineFormula"],
 " is a Laurent series, than the ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " object is not a correct representation of the series, as higher order \
poles are neglected."
}], "Notes",
 CellID->18275],

Cell["\<\
No effort is made to justify the precision in each of the coefficients of the \
series.\
\>", "Notes",
 CellID->1221],

Cell[TextData[{
 Cell[BoxData["NSeries"], "InlineFormula"],
 " is unable to recognize small numbers that should in fact be zero. ",
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"FunctionLink",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 " is often needed to eliminate these spurious residuals."
}], "Notes",
 CellID->11576],

Cell[TextData[{
 "The number of sample points chosen is ",
 Cell[BoxData[
  SuperscriptBox["2", 
   RowBox[{"2", "+", 
    RowBox[{"\[LeftCeiling]", 
     RowBox[{
      SubscriptBox[
       StyleBox["log", "TI"], 
       StyleBox["2", "TR"]], "[", 
      StyleBox["n", "TI"], "]"}], "\[RightCeiling]"}]}]]], "InlineFormula"],
 "."
}], "Notes",
 CellID->1799],

Cell["The following options can be given: ", "Notes",
 CellID->24919],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["Radius",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalCalculus/ref/Radius"], "1", Cell[TextData[{
     "radius of circle on which ",
     Cell[BoxData[
      StyleBox["f", "TI"]], "InlineFormula"],
     " is sampled"
    }], "TableText"]},
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["WorkingPrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/WorkingPrecision"], 
    ButtonBox["MachinePrecision",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/MachinePrecision"], Cell[
    "precision used in internal computations", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True, True}}}},
 CellID->14241]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["EXAMPLES",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19559893],

Cell[CellGroupData[{

Cell[TextData[{
 "Basic Examples",
 "\[NonBreakingSpace]\[NonBreakingSpace]",
 Cell["(1)", "ExampleCount"]
}], "ExampleSection",
 CellID->219040393],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->286133229],

Cell[TextData[{
 "This is a power series for the exponential function around ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "=", "0"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31032],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSeries", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->24988],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox[
     RowBox[{"3.895589227717253`*^-17", "+", 
      RowBox[{"9.143364331734818`*^-18", " ", "\[ImaginaryI]"}]}], 
     SuperscriptBox["x", "5"]]}], "-", 
   FractionBox[
    RowBox[{"4.689936725652336`*^-17", "-", 
     RowBox[{"3.049494734964759`*^-17", " ", "\[ImaginaryI]"}]}], 
    SuperscriptBox["x", "4"]], "-", 
   FractionBox[
    RowBox[{"8.404679125174876`*^-17", "-", 
     RowBox[{"2.1870747031981394`*^-17", " ", "\[ImaginaryI]"}]}], 
    SuperscriptBox["x", "3"]], "-", 
   FractionBox[
    RowBox[{"9.287598476124176`*^-17", "+", 
     RowBox[{"2.8984341481259825`*^-17", " ", "\[ImaginaryI]"}]}], 
    SuperscriptBox["x", "2"]], "-", 
   FractionBox[
    RowBox[{"1.603056588383373`*^-17", "+", 
     RowBox[{"1.4086417001339398`*^-17", " ", "\[ImaginaryI]"}]}], "x"], "+", 
   
   RowBox[{"(", 
    RowBox[{"1.0000000000000002`", "\[InvisibleSpace]", "-", 
     RowBox[{"2.2878292722740384`*^-17", " ", "\[ImaginaryI]"}]}], ")"}], "+",
    
   RowBox[{
    RowBox[{"(", 
     RowBox[{"1.`", "\[InvisibleSpace]", "-", 
      RowBox[{"6.242639539524022`*^-17", " ", "\[ImaginaryI]"}]}], ")"}], " ",
     "x"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.5000000000000001`", "\[InvisibleSpace]", "-", 
      RowBox[{"1.4915227043351699`*^-16", " ", "\[ImaginaryI]"}]}], ")"}], 
    " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.1666666666666667`", "\[InvisibleSpace]", "-", 
      RowBox[{"6.577768125105186`*^-17", " ", "\[ImaginaryI]"}]}], ")"}], " ",
     
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.041666666666666706`", "\[InvisibleSpace]", "-", 
      RowBox[{"7.680210421084366`*^-17", " ", "\[ImaginaryI]"}]}], ")"}], " ",
     
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.008333333333333363`", "\[InvisibleSpace]", "-", 
      RowBox[{"5.913254896116427`*^-17", " ", "\[ImaginaryI]"}]}], ")"}], " ",
     
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, -5, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
    Complex[-3.89558922771725*^-17, -9.14336433173482*^-18], 
    Complex[-4.68993672565234*^-17, 3.04949473496476*^-17], 
    Complex[-8.40467912517488*^-17, 2.18707470319814*^-17], 
    Complex[-9.28759847612418*^-17, -2.89843414812598*^-17], 
    Complex[-1.60305658838337*^-17, -1.40864170013394*^-17], 
    Complex[1., -2.28782927227404*^-17], 
    Complex[1., -6.24263953952402*^-17], 
    Complex[0.5, -1.49152270433517*^-16], 
    Complex[0.166666666666667, -6.57776812510519*^-17], 
    Complex[0.0416666666666667, -7.68021042108437*^-17], 
    Complex[0.00833333333333336, -5.91325489611643*^-17]}, -5, 6, 1],
  Editable->False]], "Output",
 ImageSize->{547, 139},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->3339]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Chop",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Chop"]], "InlineFormula"],
 " is needed to eliminate spurious residuals:"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->23705],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "//", "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->14670],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"1.0000000000000002`", "+", "x", "+", 
   RowBox[{"0.5000000000000001`", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"0.1666666666666667`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.041666666666666706`", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"0.008333333333333363`", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {1., 1., 0.5, 0.166666666666667, 
   0.0416666666666667, 0.00833333333333336}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{407, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->15940]
}, Open  ]],

Cell["\<\
Using extended precision may also eliminate spurious imaginaries:\
\>", "ExampleText",
 CellID->9868],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NSeries", "[", 
  RowBox[{
   RowBox[{"Exp", "[", "x", "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "5"}], "}"}], ",", 
   RowBox[{"WorkingPrecision", "->", "17"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->28391],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "0.99999999999999999999935928217`15.452768537099372", "+", "x", "+", 
   RowBox[{"0.49999999999999999999935928175`15.114508190255322", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"0.1666666666666666666660259483`14.68364265610348", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.0416666666666666666660259483`14.14049932173805", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"0.00833333333333333333269261501`13.437614611914059", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   1.`15.452768537099372, 1.`15.476614271643278, 0.5`15.114508190255322, 
    0.1666666666666667`14.68364265610348, 
    0.0416666666666667`14.14049932173805, 
    0.0083333333333333`13.437614611914059}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{486, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->7728]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Scope",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5537],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->51004330],

Cell["Find expansions in the complex plane:", "ExampleText",
 CellID->26320],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    RowBox[{"Exp", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "I", ",", "5"}], "}"}]}], "]"}], "//", 
  "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13124],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"(", 
    RowBox[{"0.5403023058681399`", "\[InvisibleSpace]", "+", 
     RowBox[{"0.8414709848078967`", " ", "\[ImaginaryI]"}]}], ")"}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.5403023058681399`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.8414709848078965`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
    RowBox[{"(", 
     RowBox[{"x", "-", "\[ImaginaryI]"}], ")"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.27015115293407005`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.4207354924039482`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "\[ImaginaryI]"}], ")"}], "2"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.09005038431135672`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.14024516413464944`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "\[ImaginaryI]"}], ")"}], "3"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.02251259607783922`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.03506129103366234`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "\[ImaginaryI]"}], ")"}], "4"]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"0.004502519215567969`", "\[InvisibleSpace]", "+", 
      RowBox[{"0.0070122582067324675`", " ", "\[ImaginaryI]"}]}], ")"}], " ", 
    
    SuperscriptBox[
     RowBox[{"(", 
      RowBox[{"x", "-", "\[ImaginaryI]"}], ")"}], "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", 
      RowBox[{"x", "-", "\[ImaginaryI]"}], "]"}], "6"],
    SeriesData[$CellContext`x, 
     Complex[0, 1], {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 
   Complex[0, 1], {
    Complex[0.54030230586814, 0.841470984807897], 
    Complex[0.54030230586814, 0.841470984807897], 
    Complex[0.27015115293407, 0.420735492403948], 
    Complex[0.0900503843113567, 0.140245164134649], 
    Complex[0.0225125960778392, 0.0350612910336623], 
    Complex[0.00450251921556797, 0.00701225820673247]}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{532, 50},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->30997]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->9354],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->121312570],

Cell["Find Laurent expansions about essential singularities:", "ExampleText",
 CellID->28703],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{"x", "+", 
      RowBox[{"1", "/", "x"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}], "//", 
  "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5494],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["2.4923434351224606`*^-6", 
    SuperscriptBox["x", "9"]], "-", 
   FractionBox["0.00017494407486828685`", 
    SuperscriptBox["x", "7"]], "+", 
   FractionBox["0.007039629755871699`", 
    SuperscriptBox["x", "5"]], "-", 
   FractionBox["0.12894324947440206`", 
    SuperscriptBox["x", "3"]], "+", 
   FractionBox["0.5767248077568734`", "x"], "+", 
   RowBox[{"0.5767248077568734`", " ", "x"}], "-", 
   RowBox[{"0.12894324947440206`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.0070396297558717015`", " ", 
    SuperscriptBox["x", "5"]}], "-", 
   RowBox[{"0.00017494407486828983`", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"2.4923434351324247`*^-6", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, -9, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {
   2.4923434351224606`*^-6, 0, -0.00017494407486828685`, 0, 
    0.007039629755871699, 0, -0.12894324947440206`, 0, 0.5767248077568734, 0, 
    0.5767248077568734, 0, -0.12894324947440206`, 0, 0.0070396297558717015`, 
    0, -0.00017494407486828983`, 0, 2.4923434351324247`*^-6}, -9, 11, 1],
  Editable->False]], "Output",
 ImageSize->{508, 51},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->235995271]
}, Open  ]],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["Series",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Series"]], "InlineFormula"],
 " will not find Laurent expansions about essential singularities:"
}], "ExampleText",
 CellID->23865],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"x", "+", 
     RowBox[{"1", "/", "x"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "10"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->17554],

Cell[BoxData[
 RowBox[{"Sin", "[", 
  RowBox[{
   FractionBox["1", "x"], "+", "x"}], "]"}]], "Output",
 ImageSize->{70, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->210377578]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Options",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->31629],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Radius",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSubsection"],
  $Line = 0; Null]], "ExampleSubsection",
 CellID->16794],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->82582490],

Cell[TextData[{
 "Use ",
 Cell[BoxData[
  ButtonBox["Radius",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/Radius"]], "InlineFormula"],
 " to pick the annulus within which the Laurent series will converge:"
}], "ExampleText",
 CellID->21026],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}]}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"Radius", "->", "2"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->20463],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["0.5000000528713976`", 
     SuperscriptBox["x", "10"]]}], "+", 
   FractionBox["0.5000000176238019`", 
    SuperscriptBox["x", "9"]], "-", 
   FractionBox["0.500000005874598`", 
    SuperscriptBox["x", "8"]], "+", 
   FractionBox["0.5000000019581992`", 
    SuperscriptBox["x", "7"]], "-", 
   FractionBox["0.500000000652733`", 
    SuperscriptBox["x", "6"]], "+", 
   FractionBox["0.500000000217578`", 
    SuperscriptBox["x", "5"]], "-", 
   FractionBox["0.5000000000725257`", 
    SuperscriptBox["x", "4"]], "+", 
   FractionBox["0.5000000000241752`", 
    SuperscriptBox["x", "3"]], "-", 
   FractionBox["0.5000000000080583`", 
    SuperscriptBox["x", "2"]], "+", 
   FractionBox["0.5000000000026861`", "x"], "-", "0.16666666666756208`", "+", 
   
   RowBox[{"0.05555555555585402`", " ", "x"}], "-", 
   RowBox[{"0.018518518518618`", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"0.006172839506206`", " ", 
    SuperscriptBox["x", "3"]}], "-", 
   RowBox[{"0.0020576131687353332`", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"0.000685871056245111`", " ", 
    SuperscriptBox["x", "5"]}], "-", 
   RowBox[{"0.00022862368541503686`", " ", 
    SuperscriptBox["x", "6"]}], "+", 
   RowBox[{"0.00007620789513834563`", " ", 
    SuperscriptBox["x", "7"]}], "-", 
   RowBox[{"0.000025402631712781882`", " ", 
    SuperscriptBox["x", "8"]}], "+", 
   RowBox[{"8.467543904260654`*^-6", " ", 
    SuperscriptBox["x", "9"]}], "-", 
   RowBox[{"2.822514634753572`*^-6", " ", 
    SuperscriptBox["x", "10"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, -10, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {-0.500000052871398, 
   0.500000017623802, -0.500000005874598, 
   0.500000001958199, -0.500000000652733, 
   0.500000000217578, -0.500000000072526, 
   0.500000000024175, -0.500000000008058, 
   0.500000000002686, -0.166666666667562, 
   0.055555555555854, -0.018518518518618, 
   0.006172839506206, -0.00205761316873533, 
   0.000685871056245111, -0.000228623685415037, 
   0.0000762078951383456, -0.0000254026317127819, 
   8.46754390426065*^-6, -2.82251463475357*^-6}, -10, 11, 1],
  Editable->False]], "Output",
 ImageSize->{541, 65},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->528]
}, Open  ]],

Cell[TextData[{
 "Laurent series for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["x", "TI"], "\[GreaterEqual]", "3"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->31748],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{"1", "+", "x"}], ")"}], 
      RowBox[{"(", 
       RowBox[{"3", "+", "x"}], ")"}]}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"Radius", "->", "5"}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->25679],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["9841.000000000093`", 
    SuperscriptBox["x", "10"]], "-", 
   FractionBox["3280.0000000000264`", 
    SuperscriptBox["x", "9"]], "+", 
   FractionBox["1093.0000000000075`", 
    SuperscriptBox["x", "8"]], "-", 
   FractionBox["364.0000000000024`", 
    SuperscriptBox["x", "7"]], "+", 
   FractionBox["121.00000000000078`", 
    SuperscriptBox["x", "6"]], "-", 
   FractionBox["40.00000000000025`", 
    SuperscriptBox["x", "5"]], "+", 
   FractionBox["13.000000000000085`", 
    SuperscriptBox["x", "4"]], "-", 
   FractionBox["4.0000000000000275`", 
    SuperscriptBox["x", "3"]], "+", 
   FractionBox["1", 
    SuperscriptBox["x", "2"]], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "11"],
    SeriesData[$CellContext`x, 0, {}, -10, 11, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {9841.00000000009, -3280.00000000003, 
   1093.00000000001, -364.000000000002, 121.000000000001, -40.0000000000002, 
   13.0000000000001, -4.00000000000003, 1.00000000000001}, -10, 11, 1],
  Editable->False]], "Output",
 ImageSize->{423, 31},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->21351]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->20199],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->423035367],

Cell[TextData[{
 "Changing ",
 Cell[BoxData[
  ButtonBox["Radius",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/Radius"]], "InlineFormula"],
 " can improve accuracy:"
}], "ExampleText",
 CellID->3],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "-", "x"}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"Radius", "->", 
     FractionBox["7", "8"]}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->18442],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztW1tPE0EUXrptocgdYjTEiA8KXh4Eog/qm8ZLDYmAqFBQCTGBB6NB/oW+
+Oa/4VV/gv6ZunNrZ7+dvZTuzu7SQ9LO7cyZ7+zMmZk9X1nbPzn89Hn/5Ohg
f+HZ8f7Xw6ODbwtPvxx7Ve6Q4wz9dRzn4yXHy7e9HP+wv3/eR2S7uV/ep+IJ
XJDpqq/FcVXfNpfQy8tccsT7rnmVruxf81ImVIXUlXIVWa5L+YpMx0B7jfSm
qnca9NalHNPnVDv10KtqnPNRqHV16Zquy5G6ktbieDUoV/1ovcw4SAwTNsKW
IbYZU49YvZWAHhzJ7FmN1C2sGyxU+w7rjM+aEAwWgmmJINm6Vp6I2mytZjZ+
1emedhPQnv1zJARFRDAL7eVYzWYpuKE58ecjISNkaSAr+10nXEp/x7lIOAhH
BI7L4br6fG+2ZdGYRIX+bGt83OGmBhxH3vPBInkqVqRLTyTSyeOAvpU/6hVu
cOlGu/seY4pSKd9SUSx9RthYUz32x5vmpOXxJw1PsGf8w/DENSwqQqdHaPE0
xVkUM/EYLHsJUi8M7RUlF4LoTuKRmaa1iBHDEPQ/sl7bhBHiyv0jeCJtb8q5
w6fe1NpN58QtWa/eRJa4VtZkit2H584alR8BPGlFn/FOW/Roedn1XuGrIL84
PZaLFMHFNV4kbEWOfBO2dLCZfTP7CC/rlW9seTh3BPnH1wlBF4EtT9Cjw/nG
pRu5I8g/Nk8IgghseYJZyr5fJI1Ax93VKGpPyLJAlq8/5hWXxMg3/mZs0JkA
wuHHwWNiA+cl8zmNq2LKeXll3qzFuLS/KOzR2RiPXhmG+R7lTRyXTUaj3/7I
yCzy9A9obUKZcQnsQMd4+3Vjb5R6DmOq6LyIvv82tCJrUIF6lk2G3ITF7djN
qsKj/Dfb/v34HZTfxrT/5FoY5+C/De0EarYTyOyC9ru8+rYsqdYWlN8H9Cwn
6vdBpishNqBPbxolmMBGoEVFC7eMLa72JFeM86BzQ2yFbEI7YnsV074eoZ9l
34Y8w1WQY7NYVXOn1begvGWcyWVtBnTrdqE3av/e6a3XqnncAW0tKP/o9GaV
ewaLoiwRY7Os8Bjsj/JxZbStkqFWESs6PT11xF+TfbGyJsUOqXqMnJuTnMKX
5TPKRivLJmFZGSNvOsPi2LthmVZADrmE2Yz1z5H+SP38LiLebwK3QctcauAU
MtTgOtbKM+fAhlmygWxIyYYoz86eB6sb9hoTY6CXp0uE1bzbENZBwsp/kWTN
wxS/lozfKoqvpYva1uog1GVFbdcnzVLBs1rd3tUtHK2y5Y1p4bW1NghvOfAW
wet0qc7OYUaj6ZoqIeZ8dwvCXGTM/D+XCuaJEbsMnuQBqXx3wjQtMccUyBKy
JA1LRLRHRev1qD2mehRZ/VbT1drVXbwmn0+a+uYGTJ+YFTZH4QzL1bafiWxB
OY7hxvIDrnWBffvucHuBmiSMd7DmIU+utf0cNXLXKn10Bukgdh/PpvnCekBS
xWhfB1qSseXREkr7fePMcc8M+d9K5Lfj+PE4fh13hY2Y/vd4uhSBcKdtZquj
uO9kmrehBzKUOMK27yn3ojmOaceRBfbFkDlROEyMqqutWqGFNQmPfgPy/TK2
jQy1inVSfgY+y2eUjVaWTcLAh509xMCfH/1OyK2uXIwjMfBkA9mQzLOLyWgS
A09Yy4SV7xLWPIwY+LKywoTaHmq7PkkMPOElvMXwOmLgCTNh5jtHwTyRGHgm
dX7YXrKkeJaIaI86n4mBL44+MVGCTXGG/gOdxgy3\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{473, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->156551063]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "-", "x"}]], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "10"}], "}"}], ",", 
    RowBox[{"Radius", "->", 
     FractionBox["1", "5"]}]}], "]"}], "//", "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10016],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzVV8FSwjAQDS21KqWAIOCNi6KMB8eD/oGe/IgO4wwcHB3ED9Efrkmb6PLY
kLYgMzJTkt19u9192YTwlCxnzy/Jcj5NRo+L5G02n76PHl4XUuXXhKh9CiFa
QyHnqZxlj/p8ySeffsjHk+qGHuMVi/CNR5ohqBxlSOHng/r4WlRxDgFd13pP
j6HDHu3ZHsivgOR/APgmE68M3hW/bD5l8R3AK7sSg6yYHz141dk190FrW3OI
XQjB8fb3COxGU1G45hkzPFbzLP7O6tlW9zzhOAxonwimP7y1OAEg+A5SZ0tA
ujYEOaooY73N9Hd3Gvwmu83fFd9l72h7MVbpnnZziWtuODmy6LmO3oXeVnuL
8S+Cs8Ur+t6iuC7o97FG//ekjNY8XCek28P9jvJZlffY7wnYS1d/eWOQuyXl
PsRvlLQPtvR32c/sbG55G7lJ85tNX3sNiUxxbZANg7juPZDxJoX2onGVHOjq
qD62M4O38RWmjqVQy9CGr1vwGYKMjNBK1DvbOs6pRc8xugmPPRXTOCFUTHzN
PZX+T8FdhSzmTNw7KlaZ1pnMzqGCS7CPGbtncJZKritljJnhGpkuNxlMNmSq
phdcZVtlfMdkROVByncLZsZxSmXWvlOuMUOOe59wPdbyFVOJsXPn1kTrfTKq
zfsNoWzgHg==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{401, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->327230290]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Applications",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->15098],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->278312198],

Cell["A function defined only for numerical input:", "ExampleText",
 CellID->9858],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"a_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"NIntegrate", "[", 
   RowBox[{
    RowBox[{"Sin", "[", 
     RowBox[{
      RowBox[{"a", " ", 
       RowBox[{"Sin", "[", "x", "]"}]}], "+", 
      RowBox[{"Cos", "[", "x", "]"}]}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "a"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1730],

Cell[TextData[{
 "Find series expansion of ",
 Cell[BoxData[
  StyleBox["f", "TI"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->8553],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"g", "[", "a_", "]"}], "=", 
  RowBox[{
   RowBox[{"Normal", "@", 
    RowBox[{"NSeries", "[", 
     RowBox[{
      RowBox[{"f", "[", "a", "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"a", ",", "0", ",", "10"}], "}"}]}], "]"}]}], "//", 
   "Chop"}]}]], "Input",
 CellLabel->"In[3]:=",
 CellID->29551],

Cell[BoxData[
 RowBox[{
  RowBox[{"0.8414709848078975`", " ", "a"}], "+", 
  RowBox[{"0.1801007686227134`", " ", 
   SuperscriptBox["a", "3"]}], "-", 
  RowBox[{"0.07410814251613115`", " ", 
   SuperscriptBox["a", "5"]}], "+", 
  RowBox[{"0.008520246025506804`", " ", 
   SuperscriptBox["a", "7"]}], "+", 
  RowBox[{"0.0013412926733623425`", " ", 
   SuperscriptBox["a", "9"]}]}]], "Output",
 ImageSize->{442, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->23262]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->444],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", "a", "]"}], ",", 
     RowBox[{"g", "[", "a", "]"}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"a", ",", "0", ",", "2"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->21649],

Cell[GraphicsData["CompressedBitmap", "\<\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\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 114},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->207275588]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Properties & Relations",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->7055],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->171439789],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["NResidue",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/NResidue"]], "InlineFormula"],
 " can also be used to construct a series of a numerical function:"
}], "ExampleText",
 CellID->12572],

Cell[BoxData[
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"Exp", "[", "x", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->12889],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    RowBox[{"f", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], "//", 
  "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->2858],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"0.9999999999999997`", "+", "x", "+", 
   RowBox[{"0.4999999999999999`", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"0.16666666666666677`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.04166666666666673`", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"0.00833333333333343`", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, 0, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {0.9999999999999997, 0.9999999999999997, 
   0.4999999999999999, 0.16666666666666677`, 0.04166666666666673, 
   0.00833333333333343}, 0, 6, 1],
  Editable->False]], "Output",
 ImageSize->{407, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->1667917383]
}, Open  ]],

Cell[TextData[{
 "Using ",
 Cell[BoxData[
  ButtonBox["NResidue",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/NResidue"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->129],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"NResidue", "[", 
    RowBox[{
     RowBox[{
      RowBox[{"f", "[", "x", "]"}], 
      SuperscriptBox["x", 
       RowBox[{"Range", "[", 
        RowBox[{
         RowBox[{"-", "1"}], ",", 
         RowBox[{"-", "6"}], ",", 
         RowBox[{"-", "1"}]}], "]"}]]}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0"}], "}"}], ",", 
     RowBox[{"Radius", "->", "1"}]}], "]"}], ".", 
   SuperscriptBox["x", 
    RowBox[{"Range", "[", 
     RowBox[{"0", ",", "5"}], "]"}]]}], "//", "Chop"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->8046],

Cell[BoxData[
 RowBox[{"1.`", "\[InvisibleSpace]", "+", 
  RowBox[{"0.9999999999595869`", " ", "x"}], "+", 
  RowBox[{"0.499999999968951`", " ", 
   SuperscriptBox["x", "2"]}], "+", 
  RowBox[{"0.1666666666450069`", " ", 
   SuperscriptBox["x", "3"]}], "+", 
  RowBox[{"0.04166666665428306`", " ", 
   SuperscriptBox["x", "4"]}], "+", 
  RowBox[{"0.008333333333297301`", " ", 
   SuperscriptBox["x", "5"]}]}]], "Output",
 ImageSize->{378, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->1583411790]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Possible Issues",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(2)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->5044],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->587094157],

Cell[TextData[{
 Cell[BoxData["NSeries"], "InlineFormula"],
 " can have aliasing problems due to ",
 Cell[BoxData[
  ButtonBox["InverseFourier",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/InverseFourier"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->41],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    RowBox[{"ArcSin", "[", "x", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}], "//", 
  "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25936],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["0.0016365425943661435`", 
    SuperscriptBox["x", "19"]], "+", 
   FractionBox["0.0016125476359476574`", 
    SuperscriptBox["x", "17"]], "+", 
   FractionBox["0.0015894669489645138`", 
    SuperscriptBox["x", "15"]], "+", 
   FractionBox["0.0015672478563764226`", 
    SuperscriptBox["x", "13"]], "+", 
   FractionBox["0.0015458416369524212`", 
    SuperscriptBox["x", "11"]], "+", 
   FractionBox["0.0015252031640026278`", 
    SuperscriptBox["x", "9"]], "+", 
   FractionBox["0.0015052905826522522`", 
    SuperscriptBox["x", "7"]], "+", 
   FractionBox["0.001486065020979708`", 
    SuperscriptBox["x", "5"]], "+", 
   FractionBox["0.0014674903309734835`", 
    SuperscriptBox["x", "3"]], "+", 
   FractionBox["0.0014495328558062081`", "x"], "+", 
   RowBox[{"1.0014321612203776`", " ", "x"}], "+", 
   RowBox[{"0.1680820128091452`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.07639906026226014`", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"0.046026135130843825`", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"0.03174991980074236`", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   RowBox[{"0.023725288996333645`", " ", 
    SuperscriptBox["x", "11"]}], "+", 
   RowBox[{"0.01869148498306281`", " ", 
    SuperscriptBox["x", "13"]}], "+", 
   RowBox[{"0.015289571276162168`", " ", 
    SuperscriptBox["x", "15"]}], "+", 
   RowBox[{"0.012862933092314361`", " ", 
    SuperscriptBox["x", "17"]}], "+", 
   RowBox[{"0.011059526590323636`", " ", 
    SuperscriptBox["x", "19"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "21"],
    SeriesData[FrontEndOwned`Cell1003`x, 0, {}, -19, 21, 1],
    Editable->False]}],
  SeriesData[
  FrontEndOwned`Cell1003`x, 0, {
   0.00163654259436614, 0, 0.00161254763594766, 0, 0.00158946694896451, 0, 
    0.00156724785637642, 0, 0.00154584163695242, 0, 0.00152520316400263, 0, 
    0.00150529058265225, 0, 0.00148606502097971, 0, 0.00146749033097348, 0, 
    0.00144953285580621, 0, 1.00143216122038, 0, 0.168082012809145, 0, 
    0.0763990602622601, 0, 0.0460261351308438, 0, 0.0317499198007424, 0, 
    0.0237252889963336, 0, 0.0186914849830628, 0, 0.0152895712761622, 0, 
    0.0128629330923144, 0, 0.0110595265903236}, -19, 21, 1],
  Editable->False]], "Output",
 ImageSize->{507, 96},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->7473]
}, Open  ]],

Cell["The correct expansion is analytic at the origin:", "ExampleText",
 CellID->19154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Series", "[", 
  RowBox[{
   RowBox[{"ArcSin", "[", 
    RowBox[{"1.", "x"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"x", ",", "0", ",", "20"}], "}"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->333],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"x", "+", 
   RowBox[{"0.16666666666666666`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"0.075`", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   RowBox[{"0.044642857142857144`", " ", 
    SuperscriptBox["x", "7"]}], "+", 
   RowBox[{"0.030381944444444444`", " ", 
    SuperscriptBox["x", "9"]}], "+", 
   RowBox[{"0.022372159090909092`", " ", 
    SuperscriptBox["x", "11"]}], "+", 
   RowBox[{"0.017352764423076924`", " ", 
    SuperscriptBox["x", "13"]}], "+", 
   RowBox[{"0.01396484375`", " ", 
    SuperscriptBox["x", "15"]}], "+", 
   RowBox[{"0.011551800896139705`", " ", 
    SuperscriptBox["x", "17"]}], "+", 
   RowBox[{"0.009761609529194078`", " ", 
    SuperscriptBox["x", "19"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "21"],
    SeriesData[FrontEndOwned`Cell1003`x, 0, {}, 1, 21, 1],
    Editable->False]}],
  SeriesData[
  FrontEndOwned`Cell1003`x, 0, {
   1., 0, 0.166666666666667, 0, 0.075, 0, 0.0446428571428571, 0, 
    0.0303819444444444, 0, 0.0223721590909091, 0, 0.0173527644230769, 0, 
    0.01396484375, 0, 0.0115518008961397, 0, 0.00976160952919408}, 1, 21, 1],
  Editable->False]], "Output",
 ImageSize->{447, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8756]
}, Open  ]],

Cell[BoxData[
 InterpretationBox[Cell["\t", "ExampleDelimiter"],
  $Line = 0; Null]], "ExampleDelimiter",
 CellID->11051],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->278664265],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " cannot correctly represent Laurent series. Here is the square of the \
series of ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Exp",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Exp"], "[", 
   RowBox[{
    FractionBox["1", 
     StyleBox["x", "TI"]], "+", 
    StyleBox["x", "TI"]}], "]"}]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellFrameLabels->{{None, None}, {None, None}},
 CellID->25391],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  SuperscriptBox[
   RowBox[{"NSeries", "[", 
    RowBox[{
     RowBox[{"Exp", "[", 
      RowBox[{
       FractionBox["1", "x"], "+", "x"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], "2"], "//", 
  "Chop"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->16534],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["0.00009654397416102179`", 
    SuperscriptBox["x", "10"]], "+", 
   FractionBox["0.0009968853222729638`", 
    SuperscriptBox["x", "9"]], "+", 
   FractionBox["0.006754017049546484`", 
    SuperscriptBox["x", "8"]], "+", 
   FractionBox["0.0351227608538483`", 
    SuperscriptBox["x", "7"]], "+", 
   FractionBox["0.14641520464608354`", 
    SuperscriptBox["x", "6"]], "+", 
   FractionBox["0.4993121436884026`", 
    SuperscriptBox["x", "5"]], "+", 
   FractionBox["1.4139723832009823`", 
    SuperscriptBox["x", "4"]], "+", 
   FractionBox["3.336571591333448`", 
    SuperscriptBox["x", "3"]], "+", 
   FractionBox["6.422022521774707`", 
    SuperscriptBox["x", "2"]], "+", 
   FractionBox["9.759432976585424`", "x"], "+", "11.30191672854803`", "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "1"],
    SeriesData[$CellContext`x, 0, {}, -10, 1, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {0.0000965439741610218, 0.000996885322272964, 
   0.00675401704954648, 0.0351227608538483, 0.146415204646084, 
   0.499312143688403, 1.41397238320098, 3.33657159133345, 6.42202252177471, 
   9.75943297658542, 11.301916728548}, -10, 1, 1],
  Editable->False]], "Output",
 ImageSize->{442, 62},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->23931]
}, Open  ]],

Cell[TextData[{
 "Here is the ",
 Cell[BoxData[
  ButtonBox["SeriesData",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/SeriesData"]], "InlineFormula"],
 " representation of the Laurent series of ",
 Cell[BoxData[
  SuperscriptBox[
   RowBox[{
    ButtonBox["Exp",
     BaseStyle->"Link",
     ButtonData->"paclet:ref/Exp"], "[", 
    RowBox[{
     FractionBox["1", 
      StyleBox["x", "TI"]], "+", 
     StyleBox["x", "TI"]}], "]"}], "2"]], "InlineFormula"],
 ":"
}], "ExampleText",
 CellID->22322],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    SuperscriptBox[
     RowBox[{"Exp", "[", 
      RowBox[{
       FractionBox["1", "x"], "+", "x"}], "]"}], "2"], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "0", ",", "5"}], "}"}]}], "]"}], "//", 
  "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->27079],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   FractionBox["0.5047243631131674`", 
    SuperscriptBox["x", "5"]], "+", 
   FractionBox["1.4162757076535895`", 
    SuperscriptBox["x", "4"]], "+", 
   FractionBox["3.3372757784203446`", 
    SuperscriptBox["x", "3"]], "+", 
   FractionBox["6.422189375284105`", 
    SuperscriptBox["x", "2"]], "+", 
   FractionBox["9.759465153704449`", "x"], "+", "11.30192195213633`", "+", 
   RowBox[{"9.759465153704449`", " ", "x"}], "+", 
   RowBox[{"6.422189375284105`", " ", 
    SuperscriptBox["x", "2"]}], "+", 
   RowBox[{"3.337275778420344`", " ", 
    SuperscriptBox["x", "3"]}], "+", 
   RowBox[{"1.4162757076535895`", " ", 
    SuperscriptBox["x", "4"]}], "+", 
   RowBox[{"0.504724363113167`", " ", 
    SuperscriptBox["x", "5"]}], "+", 
   InterpretationBox[
    SuperscriptBox[
     RowBox[{"O", "[", "x", "]"}], "6"],
    SeriesData[$CellContext`x, 0, {}, -5, 6, 1],
    Editable->False]}],
  SeriesData[$CellContext`x, 0, {0.504724363113167, 1.41627570765359, 
   3.33727577842034, 6.4221893752841, 9.75946515370445, 11.3019219521363, 
   9.75946515370445, 6.4221893752841, 3.33727577842034, 1.41627570765359, 
   0.504724363113167}, -5, 6, 1],
  Editable->False]], "Output",
 ImageSize->{432, 48},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->8202]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[Cell[TextData[{
   "Neat Examples",
   "\[NonBreakingSpace]\[NonBreakingSpace]",
   Cell["(1)", "ExampleCount"]
  }], "ExampleSection"],
  $Line = 0; Null]], "ExampleSection",
 CellID->21580],

Cell[BoxData[
 RowBox[{"Needs", "[", "\"\<NumericalCalculus`\>\"", "]"}]], "Input", \
"Deemphasis",
 CellLabel->"In[1]:=",
 CellID->204529898],

Cell["\<\
Find the series expansion of the generating function for unrestricted \
partitions:\
\>", "ExampleText",
 CellID->13269],

Cell[BoxData[
 RowBox[{
  RowBox[{"q", "[", 
   RowBox[{"z_", "?", "NumericQ"}], "]"}], ":=", 
  RowBox[{"NProduct", "[", 
   RowBox[{
    FractionBox["1", 
     RowBox[{"1", "-", 
      SuperscriptBox["z", "n"]}]], ",", 
    RowBox[{"{", 
     RowBox[{"n", ",", "\[Infinity]"}], "}"}]}], "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->5388],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"NSeries", "[", 
   RowBox[{
    RowBox[{"q", "[", "z", "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", "20"}], "}"}], ",", 
    RowBox[{"Radius", "->", 
     FractionBox["1", "2"]}], ",", 
    RowBox[{"WorkingPrecision", "->", "17"}]}], "]"}], "//", 
  "Chop"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->3429],

Cell[GraphicsData["CompressedBitmap", "\<\
eJzNWk1v1DAQdZPstpSWLqVFBYQEB2iR2vJZQEJcgQs/okJIcEAg6L/nYOJs
pus8P3vszVZipW1qx/M9njhv9vP5xbevP84vvn85f/Dx9/mvb9+//Hnw4efv
dqpeM6Z6Z4x5eGDa/237X/eVz/v2uxguRn/bb9UuvN5fXwzumPqSR7fCHz/r
Vm60fyftZN1e6/4qY8dvvR/fBOoJ0DXeNYeugfm6kH5Zfauebkrkp+inxM4c
fTf6dXOD5TOJUO8SrX0rmddS9KL1BOarCL95TmyS1WbiZ6NRdAlXo1/Ws2Tw
2XGSUO9VyJgUaD/Ob1wSxre+AhlXF6FrTHvK0zT+bFwC7oOmQPey+LAdq/PM
kzxmN27DeGbnOx53A9ZB5INPjRgfbjfmYYwbakGrQ4Z1Gh/UZyvCp8vIRa4R
S3L95PwylR2a5IgcblqvRqueRcvRMuGWl5/IHevLmMy8QTRLxUzLUGZpil9e
ppZyRS0xY0utdvo0JqzsmPm0lhZlrmZp3F9NtIaitXn1GDXTbF+u9mrjMbm9
FXgfdWSnkcoszpPbxRygsvRx0flswFiec+h13aYN6ht2BgnqnWqp75t8H02D
FSWnl9DiWyRqbkHW0zPJqeC8MOCzyors7HWL7jEvBtQ7qdUDHeUZeF/xEtbK
LZ+uqJZtpimzbInnRTxb3OQd0AX3V0zXu1kxuoo3tt2e59w58w/upPj53l91
yw7frmejuQTPziVP78zGWQE/Pitcx2iaa73vy2X19K3H5zvfGZyf07Emuu9k
xQJPuJItvnZu/KgbupOMPI+k+rvxbaY/xADpXCnYy6Rr7GKn1UK3Drb1Cs8s
R4NuF9AItoP6YR7sEFmNot9urw+idPuKL0QWomz49PJ1lNyqe9/7qKT2fjGP
+FPFA2fWkpPOmcL7VcI/r3MkFtBWMh+hOVHkcT8UWxSgJG/is5qcMd4Z74Vl
fB/Uobfx2SW0T93zc9GNcX8cw5jvg1PLd80ry0/oL+1wl5959JU3ZvcZf6HT
dkdnTZBVh50NMhPrW+SN8Mkg7yh4thJ0n70bse4AvvP66P4q1rG3+dR6vzvB
9MU338Zbx/TB9Rr/lJ059l52OSLxKumqpNZrWL4mr8vgKDrOsiqsG/l4Uhw1
ZvH/H3ik8racugxJx5yliFqhfWwfrKaHkef9VXCOIHqZnZAxvZ3V9tnKuPGd
6s6TDOefRuYRhxR67Djhm0npOqwcGENZp/kI81WwBWZvSq8YnYbFD+wu6lYI
pfQ7NPw7v9MS66xo+Eqst8MzCz2PkdLGaB/dxYn7Y9ejN1gmlexWtEerzlr/
SfOvJj+zKhZ4LA951fo25XqwX4iU1IS8SkmffAM9US6OQ+yaxbAyDI9n2VJn
rVxOC7UODDhgTNlvgbi2SKnFLt+HHIULdaf7MNkZ0PssEh3p6ZX3jnS7Ka4c
ZK3DpRjOJFj5QWQe8axtZT1iiLGOiIY1ihzE/mNY/0HgF+TINHSZgDk66B4k
NLxh83owA7kBlyeWZaegwRz9dXddZmO92u+pOFaOKCh2ElBvkYL5xTLLH3Od
+TkYdSpB+Zl+8dWxvsJOhhc2oz5VegODXyZ2FecSTzu2HgYOUanJ/nDym8R+
9Pe1kzazC0SrAjq8zzB8xNL3CL1/H/UV/lLxO/kJ3L6JyLKW/+LDx1z2aBS6
iJlPQHsI48e97COYRzwRkeNTcr8yaWxVQ+FPlfvXqUWo+SPQ7NDTzF2fK1JP
LLH8Si36SDT2x0fWwz8T3FlM/DG9P8ayCO0WjRNqz+JWe3E67cfPiGS5z7Dm
E7vYeX7c6UnCmLV/4jGFcw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{571, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->310251905]
}, Open  ]],

Cell["Check:", "ExampleText",
 CellID->22002],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PartitionsP", "[", 
  RowBox[{"Range", "[", 
   RowBox[{"0", ",", "20"}], "]"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->27610],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "3", ",", "5", ",", "7", ",", "11", ",", "15",
    ",", "22", ",", "30", ",", "42", ",", "56", ",", "77", ",", "101", ",", 
   "135", ",", "176", ",", "231", ",", "297", ",", "385", ",", "490", ",", 
   "627"}], "}"}]], "Output",
 ImageSize->{550, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->16327]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->23263],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/NLimit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NResidue",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/NResidue"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Series",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Series"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NSum",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/NSum"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->17830]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->28611],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/tutorial/NumericalCalculus"]], "Tutorials",
 CellID->5712]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NSeries - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 12.4994260}", "context" -> 
    "NumericalCalculus`", "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Calculus Package Symbol", "language" -> "en", "paclet" -> 
    "NumericalCalculus Package", "status" -> "None", "summary" -> 
    "NSeries[f, {x, x_0, n}] gives a numerical approximation to the series \
expansion of f about the point x = x_0 including the terms (x - x_0) -n \
through (x - x_0) n.", "synonyms" -> {}, "title" -> "NSeries", "type" -> 
    "Symbol", "uri" -> "NumericalCalculus/ref/NSeries"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{
 "PrimaryExamplesSection"->{
  Cell[8313, 294, 359, 10, 70, "PrimaryExamplesSection",
   CellTags->"PrimaryExamplesSection",
   CellID->19559893]}
 }
*)
(*CellTagsIndex
CellTagsIndex->{
 {"PrimaryExamplesSection", 56389, 1829}
 }
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1525, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2148, 64, 45, 1, 70, "ObjectName",
 CellID->18563],
Cell[2196, 67, 1521, 52, 70, "Usage",
 CellID->9125]
}, Open  ]],
Cell[CellGroupData[{
Cell[3754, 124, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4232, 141, 231, 9, 70, "Notes",
 CellID->7007],
Cell[4466, 152, 153, 4, 70, "Notes",
 CellID->18370],
Cell[4622, 158, 665, 22, 70, "Notes",
 CellID->15121],
Cell[5290, 182, 208, 7, 70, "Notes",
 CellID->7727],
Cell[5501, 191, 343, 12, 70, "Notes",
 CellID->2658],
Cell[5847, 205, 261, 10, 70, "Notes",
 CellID->24336],
Cell[6111, 217, 374, 11, 70, "Notes",
 CellID->18275],
Cell[6488, 230, 127, 4, 70, "Notes",
 CellID->1221],
Cell[6618, 236, 338, 9, 70, "Notes",
 CellID->11576],
Cell[6959, 247, 359, 13, 70, "Notes",
 CellID->1799],
Cell[7321, 262, 69, 1, 70, "Notes",
 CellID->24919],
Cell[7393, 265, 883, 24, 70, "3ColumnTableMod",
 CellID->14241]
}, Closed]],
Cell[CellGroupData[{
Cell[8313, 294, 359, 10, 70, "PrimaryExamplesSection",
 CellTags->"PrimaryExamplesSection",
 CellID->19559893],
Cell[CellGroupData[{
Cell[8697, 308, 148, 5, 70, "ExampleSection",
 CellID->219040393],
Cell[8848, 315, 142, 4, 70, "Input",
 CellID->286133229],
Cell[8993, 321, 200, 7, 70, "ExampleText",
 CellID->31032],
Cell[CellGroupData[{
Cell[9218, 332, 212, 7, 28, "Input",
 CellID->24988],
Cell[9433, 341, 3047, 79, 160, "Output",
 CellID->3339]
}, Open  ]],
Cell[12495, 423, 256, 8, 70, "ExampleText",
 CellID->23705],
Cell[CellGroupData[{
Cell[12776, 435, 92, 3, 70, "Input",
 CellID->14670],
Cell[12871, 440, 832, 23, 36, "Output",
 CellID->15940]
}, Open  ]],
Cell[13718, 466, 111, 3, 70, "ExampleText",
 CellID->9868],
Cell[CellGroupData[{
Cell[13854, 473, 263, 8, 70, "Input",
 CellID->28391],
Cell[14120, 483, 1108, 27, 54, "Output",
 CellID->7728]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15277, 516, 215, 7, 70, "ExampleSection",
 CellID->5537],
Cell[15495, 525, 141, 4, 70, "Input",
 CellID->51004330],
Cell[15639, 531, 76, 1, 70, "ExampleText",
 CellID->26320],
Cell[CellGroupData[{
Cell[15740, 536, 246, 9, 70, "Input",
 CellID->13124],
Cell[15989, 547, 2291, 61, 71, "Output",
 CellID->30997]
}, Open  ]],
Cell[18295, 611, 120, 3, 70, "ExampleDelimiter",
 CellID->9354],
Cell[18418, 616, 142, 4, 70, "Input",
 CellID->121312570],
Cell[18563, 622, 93, 1, 70, "ExampleText",
 CellID->28703],
Cell[CellGroupData[{
Cell[18681, 627, 299, 11, 70, "Input",
 CellID->5494],
Cell[18983, 640, 1431, 36, 72, "Output",
 CellID->235995271]
}, Open  ]],
Cell[20429, 679, 233, 7, 70, "ExampleText",
 CellID->23865],
Cell[CellGroupData[{
Cell[20687, 690, 263, 9, 70, "Input",
 CellID->17554],
Cell[20953, 701, 232, 8, 51, "Output",
 CellID->210377578]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[21234, 715, 218, 7, 70, "ExampleSection",
 CellID->31629],
Cell[CellGroupData[{
Cell[21477, 726, 223, 7, 70, "ExampleSubsection",
 CellID->16794],
Cell[21703, 735, 141, 4, 70, "Input",
 CellID->82582490],
Cell[21847, 741, 263, 8, 70, "ExampleText",
 CellID->21026],
Cell[CellGroupData[{
Cell[22135, 753, 407, 14, 70, "Input",
 CellID->20463],
Cell[22545, 769, 2442, 64, 86, "Output",
 CellID->528]
}, Open  ]],
Cell[25002, 836, 174, 7, 70, "ExampleText",
 CellID->31748],
Cell[CellGroupData[{
Cell[25201, 847, 407, 14, 70, "Input",
 CellID->25679],
Cell[25611, 863, 1246, 34, 52, "Output",
 CellID->21351]
}, Open  ]],
Cell[26872, 900, 121, 3, 70, "ExampleDelimiter",
 CellID->20199],
Cell[26996, 905, 142, 4, 70, "Input",
 CellID->423035367],
Cell[27141, 911, 219, 8, 70, "ExampleText",
 CellID->3],
Cell[CellGroupData[{
Cell[27385, 923, 326, 11, 70, "Input",
 CellID->18442],
Cell[27714, 936, 2021, 37, 70, "Output",
 Evaluatable->False,
 CellID->156551063]
}, Open  ]],
Cell[CellGroupData[{
Cell[29772, 978, 326, 11, 70, "Input",
 CellID->10016],
Cell[30101, 991, 895, 19, 70, "Output",
 Evaluatable->False,
 CellID->327230290]
}, Open  ]]
}, Closed]]
}, Closed]],
Cell[CellGroupData[{
Cell[31057, 1017, 223, 7, 70, "ExampleSection",
 CellID->15098],
Cell[31283, 1026, 142, 4, 70, "Input",
 CellID->278312198],
Cell[31428, 1032, 82, 1, 70, "ExampleText",
 CellID->9858],
Cell[31513, 1035, 424, 14, 70, "Input",
 CellID->1730],
Cell[31940, 1051, 141, 6, 70, "ExampleText",
 CellID->8553],
Cell[CellGroupData[{
Cell[32106, 1061, 337, 12, 70, "Input",
 CellID->29551],
Cell[32446, 1075, 518, 15, 36, "Output",
 CellID->23262]
}, Open  ]],
Cell[32979, 1093, 43, 1, 70, "ExampleText",
 CellID->444],
Cell[CellGroupData[{
Cell[33047, 1098, 289, 10, 70, "Input",
 CellID->21649],
Cell[33339, 1110, 2648, 47, 70, "Output",
 Evaluatable->False,
 CellID->207275588]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[36036, 1163, 232, 7, 70, "ExampleSection",
 CellID->7055],
Cell[36271, 1172, 142, 4, 70, "Input",
 CellID->171439789],
Cell[36416, 1178, 255, 7, 70, "ExampleText",
 CellID->12572],
Cell[36674, 1187, 179, 6, 70, "Input",
 CellID->12889],
Cell[CellGroupData[{
Cell[36878, 1197, 243, 9, 70, "Input",
 CellID->2858],
Cell[37124, 1208, 891, 24, 36, "Output",
 CellID->1667917383]
}, Open  ]],
Cell[38030, 1235, 201, 8, 70, "ExampleText",
 CellID->129],
Cell[CellGroupData[{
Cell[38256, 1247, 587, 20, 70, "Input",
 CellID->8046],
Cell[38846, 1269, 552, 15, 36, "Output",
 CellID->1583411790]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[39447, 1290, 225, 7, 70, "ExampleSection",
 CellID->5044],
Cell[39675, 1299, 142, 4, 70, "Input",
 CellID->587094157],
Cell[39820, 1305, 267, 9, 70, "ExampleText",
 CellID->41],
Cell[CellGroupData[{
Cell[40112, 1318, 250, 9, 70, "Input",
 CellID->25936],
Cell[40365, 1329, 2468, 60, 117, "Output",
 CellID->7473]
}, Open  ]],
Cell[42848, 1392, 87, 1, 70, "ExampleText",
 CellID->19154],
Cell[CellGroupData[{
Cell[42960, 1397, 234, 8, 70, "Input",
 CellID->333],
Cell[43197, 1407, 1345, 36, 54, "Output",
 CellID->8756]
}, Open  ]],
Cell[44557, 1446, 121, 3, 70, "ExampleDelimiter",
 CellID->11051],
Cell[44681, 1451, 142, 4, 70, "Input",
 CellID->278664265],
Cell[44826, 1457, 543, 19, 70, "ExampleText",
 CellID->25391],
Cell[CellGroupData[{
Cell[45394, 1480, 328, 12, 70, "Input",
 CellID->16534],
Cell[45725, 1494, 1399, 36, 83, "Output",
 CellID->23931]
}, Open  ]],
Cell[47139, 1533, 503, 19, 70, "ExampleText",
 CellID->22322],
Cell[CellGroupData[{
Cell[47667, 1556, 326, 12, 70, "Input",
 CellID->27079],
Cell[47996, 1570, 1351, 35, 69, "Output",
 CellID->8202]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[49396, 1611, 224, 7, 70, "ExampleSection",
 CellID->21580],
Cell[49623, 1620, 142, 4, 70, "Input",
 CellID->204529898],
Cell[49768, 1626, 130, 4, 70, "ExampleText",
 CellID->13269],
Cell[49901, 1632, 345, 12, 70, "Input",
 CellID->5388],
Cell[CellGroupData[{
Cell[50271, 1648, 361, 12, 70, "Input",
 CellID->3429],
Cell[50635, 1662, 2066, 38, 70, "Output",
 Evaluatable->False,
 CellID->310251905]
}, Open  ]],
Cell[52716, 1703, 45, 1, 70, "ExampleText",
 CellID->22002],
Cell[CellGroupData[{
Cell[52786, 1708, 160, 5, 70, "Input",
 CellID->27610],
Cell[52949, 1715, 428, 11, 36, "Output",
 CellID->16327]
}, Open  ]]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[53438, 1733, 311, 9, 70, "SeeAlsoSection",
 CellID->23263],
Cell[53752, 1744, 961, 35, 70, "SeeAlso",
 CellID->17830]
}, Open  ]],
Cell[CellGroupData[{
Cell[54750, 1784, 314, 9, 70, "TutorialsSection",
 CellID->28611],
Cell[55067, 1795, 174, 4, 70, "Tutorials",
 CellID->5712]
}, Open  ]],
Cell[55256, 1802, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

