(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7918,        272]
NotebookOptionsPosition[      6149,        216]
NotebookOutlinePosition[      7220,        245]
CellTagsIndexPosition[      7177,        242]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL CALCULUS PACKAGE SYMBOL", "PacletNameCell"], Cell[
    TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Calculus Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalCalculus/tutorial/NumericalCalculus"]}, #, 2]& , 
        Evaluator -> Automatic], {
       1->"\<\"Numerical Calculus Package\"\>"}, "\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"EulerSum" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/EulerSum"], 
          "NLimit" :> 
          Documentation`HelpLookup["paclet:NumericalCalculus/ref/NLimit"], 
          "ND" :> Documentation`HelpLookup[
           "paclet:NumericalCalculus/ref/ND"]}, #, 2]& , Evaluator -> 
        Automatic], {1->"\<\"EulerSum\"\>", 2->"\<\"NLimit\"\>", 
       3->"\<\"ND\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Terms", "ObjectName",
 CellID->8732],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Terms"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["EulerSum",
       BaseStyle->"Link",
       ButtonData->"paclet:NumericalCalculus/ref/EulerSum"]], 
      "InlineFormula"],
     ", ",
     Cell[BoxData[
      ButtonBox["NLimit",
       BaseStyle->"Link",
       ButtonData->"paclet:NumericalCalculus/ref/NLimit"]], "InlineFormula"],
     ", and ",
     Cell[BoxData[
      ButtonBox["ND",
       BaseStyle->"Link",
       ButtonData->"paclet:NumericalCalculus/ref/ND"]], "InlineFormula"],
     " that specifies the total number of terms to be used."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->20392]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["Valid settings are positive integers.", "Notes",
 CellID->26843],

Cell[TextData[{
 "For ",
 Cell[BoxData[
  ButtonBox["NLimit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/NLimit"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["ND",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/ND"]], "InlineFormula"],
 " with the option ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["Method",
    BaseStyle->"Link",
    ButtonData->"paclet:ref/Method"], "->", 
   ButtonBox["EulerSum",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/EulerSum"]}]], 
  "InlineFormula"],
 ", the setting for ",
 Cell[BoxData["Terms"], "InlineFormula"],
 " specifies the number of terms to be used. For ",
 Cell[BoxData[
  ButtonBox["EulerSum",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalCalculus/ref/EulerSum"]], "InlineFormula"],
 ", the setting specifies the number of terms to be included before \
extrapolation."
}], "Notes",
 CellID->14063]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->22443],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["EulerSum",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/EulerSum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["NLimit",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/NLimit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ND",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalCalculus/ref/ND"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->22270]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->16923],

Cell[TextData[ButtonBox["Numerical Calculus Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalCalculus/tutorial/NumericalCalculus"]], "Tutorials",
 CellID->14611]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Terms - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 18.3902018}", "context" -> 
    "NumericalCalculus`", "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Calculus Package Symbol", "language" -> "en", "paclet" -> 
    "NumericalCalculus Package", "status" -> "None", "summary" -> 
    "Terms is an option to EulerSum, NLimit, and ND that specifies the total \
number of terms to be used.", "synonyms" -> {}, "title" -> "Terms", "type" -> 
    "Symbol", "uri" -> "NumericalCalculus/ref/Terms"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1458, 37, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2081, 64, 42, 1, 70, "ObjectName",
 CellID->8732],
Cell[2126, 67, 849, 26, 70, "Usage",
 CellID->20392]
}, Open  ]],
Cell[CellGroupData[{
Cell[3012, 98, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3490, 115, 70, 1, 70, "Notes",
 CellID->26843],
Cell[3563, 118, 930, 31, 70, "Notes",
 CellID->14063]
}, Closed]],
Cell[CellGroupData[{
Cell[4530, 154, 311, 9, 70, "SeeAlsoSection",
 CellID->22443],
Cell[4844, 165, 734, 26, 70, "SeeAlso",
 CellID->22270]
}, Open  ]],
Cell[CellGroupData[{
Cell[5615, 196, 314, 9, 70, "TutorialsSection",
 CellID->16923],
Cell[5932, 207, 175, 4, 70, "Tutorials",
 CellID->14611]
}, Open  ]],
Cell[6122, 214, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

