(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7453,        251]
NotebookOptionsPosition[      5576,        194]
NotebookOutlinePosition[      6805,        226]
CellTagsIndexPosition[      6762,        223]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"RungeKuttaMethod" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaMethod"], "$ContinuousExtension" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/$\
ContinuousExtension"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"RungeKuttaMethod\"\>", 
       2->"\<\"$ContinuousExtension\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["$RungeKuttaMethod", "ObjectName",
 CellID->26946],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["$RungeKuttaMethod"], "InlineFormula"],
     "\[LineSeparator]is a global environment setting, specifying the type of \
method to be generated by ",
     Cell[BoxData[
      RowBox[{
       ButtonBox["ButcherPhi",
        BaseStyle->"Link",
        ButtonData->
         "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPhi"], 
       " "}]], "InlineFormula"],
     "and related functions."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->29909]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Valid settings are ",
 Cell[BoxData[
  ButtonBox["Explicit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Explicit"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["DiagonallyImplicit",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/DiagonallyImplicit"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Implicit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Implicit"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->1048]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->4235],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["RungeKuttaMethod",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["$ContinuousExtension",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/$ContinuousExtension"],
   
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->140833224]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21768],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->26624]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"$RungeKuttaMethod - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 51.2972942}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "$RungeKuttaMethod is a global environment setting, specifying the type \
of method to be generated by ButcherPhi and related functions.", 
    "synonyms" -> {}, "title" -> "$RungeKuttaMethod", "type" -> "Symbol", 
    "uri" -> "NumericalDifferentialEquationAnalysis/ref/$RungeKuttaMethod"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1573, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2196, 66, 55, 1, 70, "ObjectName",
 CellID->26946],
Cell[2254, 69, 641, 19, 70, "Usage",
 CellID->29909]
}, Open  ]],
Cell[CellGroupData[{
Cell[2932, 93, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3410, 110, 594, 22, 70, "Notes",
 CellID->1048]
}, Closed]],
Cell[CellGroupData[{
Cell[4041, 137, 310, 9, 70, "SeeAlsoSection",
 CellID->4235],
Cell[4354, 148, 587, 20, 70, "SeeAlso",
 CellID->140833224]
}, Open  ]],
Cell[CellGroupData[{
Cell[4978, 173, 314, 9, 70, "TutorialsSection",
 CellID->21768],
Cell[5295, 184, 239, 5, 70, "Tutorials",
 CellID->26624]
}, Open  ]],
Cell[5549, 192, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

