(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10435,        347]
NotebookOptionsPosition[      8377,        283]
NotebookOutlinePosition[      9619,        316]
CellTagsIndexPosition[      9576,        313]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ButcherGamma" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherGamma"], 
          "ButcherHeight" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherHeight"], 
          "ButcherOrder" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherOrder"], 
          "ButcherSigma" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherSigma"], 
          "ButcherWidth" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherWidth"]}, \
#, 2]& , Evaluator -> Automatic], {1->"\<\"ButcherGamma\"\>", 
       2->"\<\"ButcherHeight\"\>", 3->"\<\"ButcherOrder\"\>", 
       4->"\<\"ButcherSigma\"\>", 
       5->"\<\"ButcherWidth\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButcherPhi", "ObjectName",
 CellID->32372],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButcherPhi", "[", 
       RowBox[{
        StyleBox["tree", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the weight of ",
     Cell[BoxData[
      StyleBox["tree", "TI"]], "InlineFormula"],
     " in an ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     "-stage Runge\[Dash]Kutta method. "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButcherPhi", "[", 
       StyleBox["tree", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the weight of ",
     Cell[BoxData[
      StyleBox["tree", "TI"]], "InlineFormula"],
     " in stage independent tensor notation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->30032]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "The weight of ",
 Cell[BoxData[
  StyleBox["tree", "TI"]], "InlineFormula"],
 " is the left hand side of the order conditions imposed by ",
 Cell[BoxData[
  StyleBox["tree", "TI"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->3989],

Cell["The following option can be given:", "Notes",
 CellID->9320],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RungeKuttaMethod",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"], 
    ButtonBox["$RungeKuttaMethod",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/$RungeKuttaMethod"], 
    Cell["type of Runge-Kutta method", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->23165],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["RungeKuttaMethod",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"]], 
  "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["DiagonallyImplicit",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/DiagonallyImplicit"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Explicit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Explicit"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Implicit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Implicit"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->15431]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16948],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherGamma",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherGamma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherHeight",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherHeight"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherOrder",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherOrder"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherSigma",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherSigma"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherWidth",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherWidth"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->2206]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->9658],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->11293]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButcherPhi - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 26.6091622}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "ButcherPhi[tree, s] gives the weight of tree in an s-stage \
Runge\\[Dash]Kutta method. ButcherPhi[tree] gives the weight of tree in stage \
independent tensor notation.", "synonyms" -> {}, "title" -> "ButcherPhi", 
    "type" -> "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/ButcherPhi"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2067, 49, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2690, 76, 48, 1, 70, "ObjectName",
 CellID->32372],
Cell[2741, 79, 933, 29, 70, "Usage",
 CellID->30032]
}, Open  ]],
Cell[CellGroupData[{
Cell[3711, 113, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[4189, 130, 250, 9, 70, "Notes",
 CellID->3989],
Cell[4442, 141, 66, 1, 70, "Notes",
 CellID->9320],
Cell[4511, 144, 645, 17, 70, "3ColumnTableMod",
 CellID->23165],
Cell[5159, 163, 786, 29, 70, "Notes",
 CellID->15431]
}, Closed]],
Cell[CellGroupData[{
Cell[5982, 197, 311, 9, 70, "SeeAlsoSection",
 CellID->16948],
Cell[6296, 208, 1447, 49, 70, "SeeAlso",
 CellID->2206]
}, Open  ]],
Cell[CellGroupData[{
Cell[7780, 262, 313, 9, 70, "TutorialsSection",
 CellID->9658],
Cell[8096, 273, 239, 5, 70, "Tutorials",
 CellID->11293]
}, Open  ]],
Cell[8350, 281, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

