(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      9439,        312]
NotebookOptionsPosition[      7331,        248]
NotebookOutlinePosition[      8674,        283]
CellTagsIndexPosition[      8631,        280]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ButcherColumnConditions" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherColumnConditions"], "ButcherRowConditions" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherRowConditions"], "RungeKuttaOrderConditions" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"ButcherColumnConditions\"\>", 
       2->"\<\"ButcherRowConditions\"\>", 
       3->"\<\"RungeKuttaOrderConditions\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButcherQuadratureConditions", "ObjectName",
 CellID->24118],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButcherQuadratureConditions", "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["s", "TI"]}], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives the quadrature conditions up to and including \
order ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " for ",
     Cell[BoxData[
      StyleBox["s", "TI"]], "InlineFormula"],
     " stages.  "
    }]]},
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButcherQuadratureConditions", "[", 
       StyleBox["p", "TI"], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the quadrature conditions in stage independent \
tensor notation."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {None, {None}}, 
   "RowsIndexed" -> {}}},
 CellID->12737]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["The following option can be given:", "Notes",
 CellID->18028],

Cell[BoxData[GridBox[{
   {Cell["      ", "TableRowIcon"], 
    ButtonBox["RungeKuttaMethod",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"], 
    ButtonBox["$RungeKuttaMethod",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/$RungeKuttaMethod"], 
    Cell["type of Runge-Kutta method", "TableText"]}
  }]], "3ColumnTableMod",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}},
 GridBoxDividers->{"Rows" -> {{True, True}}}},
 CellID->32119],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData[
  ButtonBox["RungeKuttaMethod",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"]], 
  "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["DiagonallyImplicit",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/DiagonallyImplicit"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["Explicit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Explicit"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["Implicit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Implicit"]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->20577]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->16060],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherColumnConditions",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherColumnConditions"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherRowConditions",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherRowConditions"],
   
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RungeKuttaOrderConditions",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->21901]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->10737],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->14091]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButcherQuadratureConditions - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 34.4218622}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "ButcherQuadratureConditions[p, s] gives the quadrature conditions up to \
and including order p for s stages. ButcherQuadratureConditions[p] gives the \
quadrature conditions in stage independent tensor notation.", 
    "synonyms" -> {}, "title" -> "ButcherQuadratureConditions", "type" -> 
    "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/ButcherQuadratureConditions"}},\

FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1802, 43, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2425, 70, 65, 1, 70, "ObjectName",
 CellID->24118],
Cell[2493, 73, 909, 28, 70, "Usage",
 CellID->12737]
}, Open  ]],
Cell[CellGroupData[{
Cell[3439, 106, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3917, 123, 67, 1, 70, "Notes",
 CellID->18028],
Cell[3987, 126, 645, 17, 70, "3ColumnTableMod",
 CellID->32119],
Cell[4635, 145, 786, 29, 70, "Notes",
 CellID->20577]
}, Closed]],
Cell[CellGroupData[{
Cell[5458, 179, 311, 9, 70, "SeeAlsoSection",
 CellID->16060],
Cell[5772, 190, 924, 32, 70, "SeeAlso",
 CellID->21901]
}, Open  ]],
Cell[CellGroupData[{
Cell[6733, 227, 314, 9, 70, "TutorialsSection",
 CellID->10737],
Cell[7050, 238, 239, 5, 70, "Tutorials",
 CellID->14091]
}, Open  ]],
Cell[7304, 246, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

