(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      8807,        299]
NotebookOptionsPosition[      6752,        235]
NotebookOutlinePosition[      8000,        268]
CellTagsIndexPosition[      7957,        265]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ButcherRowSum" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherRowSum"], 
          "ContinuousExtension" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
ContinuousExtension"], "RungeKuttaMethod" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaMethod"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"ButcherRowSum\"\>", 2->"\<\"ContinuousExtension\"\>", 
       3->"\<\"RungeKuttaMethod\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButcherSimplify", "ObjectName",
 CellID->28773],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["ButcherSimplify"], "InlineFormula"],
     " \[LineSeparator]is an option to ",
     Cell[BoxData[
      ButtonBox["RungeKuttaOrderConditions",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"]], "InlineFormula"],
     " that specifies whether to apply Butcher\[CloseCurlyQuote]s row and \
column simplifying conditions."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->18470]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Butcher's row and column simplifying assumptions reduce the set of \
necessary and sufficient trees for an order ",
 Cell[BoxData[
  StyleBox["p", "TI"]], "InlineFormula"],
 " method with ",
 Cell[BoxData[
  StyleBox["s", "TI"]], "InlineFormula"],
 " stages."
}], "Notes",
 CellID->29731],

Cell["\<\
For implicit methods, all trees are reduced to quadrature type together with \
subsidiary row and column simplifying conditions.\
\>", "Notes",
 CellID->6747],

Cell[TextData[{
 "For explicit methods, the restriction ",
 Cell[BoxData[
  RowBox[{
   RowBox[{
    StyleBox["b", "TI"], "[", "2", "]"}], "==", "0"}]], "InlineFormula"],
 " for ",
 Cell[BoxData[
  RowBox[{
   StyleBox["p", "TI"], "\[GreaterEqual]", "5"}]], "InlineFormula"],
 " implies positivity of the weights ",
 Cell[BoxData[
  RowBox[{
   StyleBox["b", "TI"], "[", 
   StyleBox["i", "TI"], "]"}]], "InlineFormula"],
 "."
}], "Notes",
 CellID->7511],

Cell[TextData[{
 "Valid settings for ",
 Cell[BoxData["ButcherSimplify"], "InlineFormula"],
 " are ",
 Cell[BoxData[
  ButtonBox["True",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/True"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["False",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/False"]], "InlineFormula"],
 "."
}], "Notes",
 CellID->5869]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->25679],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherRowSum",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherRowSum"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ContinuousExtension",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ContinuousExtension"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["RungeKuttaMethod",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->28053]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->14398],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->10498]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButcherSimplify - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 35.1406306}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "ButcherSimplify is an option to RungeKuttaOrderConditions that specifies \
whether to apply Butcher\\[CloseCurlyQuote]s row and column simplifying \
conditions.", "synonyms" -> {}, "title" -> "ButcherSimplify", "type" -> 
    "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/ButcherSimplify"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1743, 42, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2366, 69, 53, 1, 70, "ObjectName",
 CellID->28773],
Cell[2422, 72, 648, 18, 70, "Usage",
 CellID->18470]
}, Open  ]],
Cell[CellGroupData[{
Cell[3107, 95, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3585, 112, 306, 10, 70, "Notes",
 CellID->29731],
Cell[3894, 124, 168, 4, 70, "Notes",
 CellID->6747],
Cell[4065, 130, 454, 17, 70, "Notes",
 CellID->7511],
Cell[4522, 149, 368, 15, 70, "Notes",
 CellID->5869]
}, Closed]],
Cell[CellGroupData[{
Cell[4927, 169, 311, 9, 70, "SeeAlsoSection",
 CellID->25679],
Cell[5241, 180, 876, 29, 70, "SeeAlso",
 CellID->28053]
}, Open  ]],
Cell[CellGroupData[{
Cell[6154, 214, 314, 9, 70, "TutorialsSection",
 CellID->14398],
Cell[6471, 225, 239, 5, 70, "Tutorials",
 CellID->10498]
}, Open  ]],
Cell[6725, 233, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

