(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      5650,        188]
NotebookOptionsPosition[      4038,        139]
NotebookOutlinePosition[      5197,        170]
CellTagsIndexPosition[      5154,        167]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ButcherTrees" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTrees"]}, \
#, 2]& , Evaluator -> Automatic], {
       1->"\<\"ButcherTrees\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButcherTreeQ", "ObjectName",
 CellID->20386],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButcherTreeQ", "[", 
       StyleBox["tree", "TI"], "]"}]], "InlineFormula"],
     "\[LineSeparator]gives ",
     Cell[BoxData[
      ButtonBox["True",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/True"]], "InlineFormula"],
     " if ",
     Cell[BoxData[
      StyleBox["tree", "TI"]], "InlineFormula"],
     " is a valid Butcher tree, and ",
     Cell[BoxData[
      ButtonBox["False",
       BaseStyle->"Link",
       ButtonData->"paclet:ref/False"]], "InlineFormula"],
     " otherwise."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->32651]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->1497],

Cell[TextData[Cell[BoxData[
 StyleBox[
  ButtonBox["ButcherTrees",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTrees"],
  FontFamily->"Verdana"]], "InlineFormula"]], "SeeAlso",
 CellID->27283]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->32765],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->19601]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButcherTreeQ - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 35.4843894}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "ButcherTreeQ[tree] gives True if tree is a valid Butcher tree, and False \
otherwise.", "synonyms" -> {}, "title" -> "ButcherTreeQ", "type" -> "Symbol", 
    "uri" -> "NumericalDifferentialEquationAnalysis/ref/ButcherTreeQ"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1368, 35, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[1991, 62, 50, 1, 70, "ObjectName",
 CellID->20386],
Cell[2044, 65, 762, 25, 70, "Usage",
 CellID->32651]
}, Open  ]],
Cell[CellGroupData[{
Cell[2843, 95, 310, 9, 70, "SeeAlsoSection",
 CellID->1497],
Cell[3156, 106, 247, 7, 70, "SeeAlso",
 CellID->27283]
}, Open  ]],
Cell[CellGroupData[{
Cell[3440, 118, 314, 9, 70, "TutorialsSection",
 CellID->32765],
Cell[3757, 129, 239, 5, 70, "Tutorials",
 CellID->19601]
}, Open  ]],
Cell[4011, 137, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

