(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7413,        241]
NotebookOptionsPosition[      5389,        182]
NotebookOutlinePosition[      6769,        216]
CellTagsIndexPosition[      6726,        213]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"ButcherTreeCount" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherTreeCount"], "ButcherTrees" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTrees"]}, \
#, 2]& , Evaluator -> Automatic], {1->"\<\"ButcherTreeCount\"\>", 
       2->"\<\"ButcherTrees\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["ButcherTreeSimplify", "ObjectName",
 CellID->13758],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"ButcherTreeSimplify", "[", 
       RowBox[{
        StyleBox["p", "TI"], ",", 
        StyleBox["\[Eta]", "TR"], ",", 
        StyleBox["\[Xi]", "TR"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives the set of trees through order ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     " that are not reduced by Butcher\[CloseCurlyQuote]s quadrature \
conditions through order ",
     Cell[BoxData[
      StyleBox["p", "TI"]], "InlineFormula"],
     ", row simplifying conditions through order ",
     Cell[BoxData[
      StyleBox["\[Eta]", "TR"]], "InlineFormula"],
     " and column simplifying conditions through order ",
     Cell[BoxData[
      StyleBox["\[Xi]", "TR"]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->15433]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell["\<\
The result is grouped by order, starting with the first nonvanishing tree.\
\>", "Notes",
 CellID->32255]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->12759],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherTreeCount",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeCount"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["ButcherTrees",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTrees"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->10393]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->29065],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->726]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"ButcherTreeSimplify - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 35.6562688}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "ButcherTreeSimplify[p, \\[Eta], \\[Xi]] gives the set of trees through \
order p that are not reduced by Butcher\\[CloseCurlyQuote]s quadrature \
conditions through order p, row simplifying conditions through order \\[Eta] \
and column simplifying conditions through order \\[Xi].", "synonyms" -> {}, 
    "title" -> "ButcherTreeSimplify", "type" -> "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/ButcherTreeSimplify"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1541, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2164, 65, 57, 1, 70, "ObjectName",
 CellID->13758],
Cell[2224, 68, 988, 28, 70, "Usage",
 CellID->15433]
}, Open  ]],
Cell[CellGroupData[{
Cell[3249, 101, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3727, 118, 115, 3, 70, "Notes",
 CellID->32255]
}, Closed]],
Cell[CellGroupData[{
Cell[3879, 126, 311, 9, 70, "SeeAlsoSection",
 CellID->12759],
Cell[4193, 137, 563, 19, 70, "SeeAlso",
 CellID->10393]
}, Open  ]],
Cell[CellGroupData[{
Cell[4793, 161, 314, 9, 70, "TutorialsSection",
 CellID->29065],
Cell[5110, 172, 237, 5, 70, "Tutorials",
 CellID->726]
}, Open  ]],
Cell[5362, 180, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

