(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7051,        236]
NotebookOptionsPosition[      5220,        179]
NotebookOutlinePosition[      6408,        211]
CellTagsIndexPosition[      6365,        208]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Implicit" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/Implicit"], 
          "DiagonallyImplicit" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
DiagonallyImplicit"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Implicit\"\>", 
       2->"\<\"DiagonallyImplicit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Explicit", "ObjectName",
 CellID->6266],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Explicit"], "InlineFormula"],
     "\[LineSeparator]is a setting for the option ",
     Cell[BoxData[
      ButtonBox["RungeKuttaMethod",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"]],
       "InlineFormula"],
     " specifying the type of Runge\[Dash]Kutta method to be generated."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->27651]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An explicit method is one where the the matrix ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"]}]]], "InlineFormula"],
 " is strictly lower triangular, and at each time step only previously known \
values are needed."
}], "Notes",
 CellID->15275]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->32503],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["Implicit",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Implicit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiagonallyImplicit",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/DiagonallyImplicit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->32729]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->21528],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->532]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Explicit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 43.4064672}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "Explicit is a setting for the option RungeKuttaMethod specifying the \
type of Runge\\[Dash]Kutta method to be generated.", "synonyms" -> {}, 
    "title" -> "Explicit", "type" -> "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/Explicit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1552, 39, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2175, 66, 45, 1, 70, "ObjectName",
 CellID->6266],
Cell[2223, 69, 604, 17, 70, "Usage",
 CellID->27651]
}, Open  ]],
Cell[CellGroupData[{
Cell[2864, 91, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3342, 108, 341, 11, 70, "Notes",
 CellID->15275]
}, Closed]],
Cell[CellGroupData[{
Cell[3720, 124, 311, 9, 70, "SeeAlsoSection",
 CellID->32503],
Cell[4034, 135, 553, 18, 70, "SeeAlso",
 CellID->32729]
}, Open  ]],
Cell[CellGroupData[{
Cell[4624, 158, 314, 9, 70, "TutorialsSection",
 CellID->21528],
Cell[4941, 169, 237, 5, 70, "Tutorials",
 CellID->532]
}, Open  ]],
Cell[5193, 177, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

