(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      7066,        235]
NotebookOptionsPosition[      5237,        178]
NotebookOutlinePosition[      6425,        210]
CellTagsIndexPosition[      6382,        207]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"DiagonallyImplicit" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
DiagonallyImplicit"], "Explicit" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/Explicit"]}, #, 
         2]& , Evaluator -> Automatic], {1->"\<\"DiagonallyImplicit\"\>", 
       2->"\<\"Explicit\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Implicit", "ObjectName",
 CellID->12212],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData["Implicit"], "InlineFormula"],
     "\[LineSeparator]is a setting for the option ",
     Cell[BoxData[
      ButtonBox["RungeKuttaMethod",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"]],
       "InlineFormula"],
     " specifying the type of Runge\[Dash]Kutta method to be generated."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->21100]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "An implicit method is one where the matrix ",
 Cell[BoxData[
  SubscriptBox[
   StyleBox["a", "TI"], 
   RowBox[{
    StyleBox["i", "TI"], ",", 
    StyleBox["j", "TI"]}]]], "InlineFormula"],
 " is not strictly lower triangular, and requires the solution of a generally \
nonlinear system of equations for each time step."
}], "Notes",
 CellID->7551]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->3789],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["DiagonallyImplicit",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/DiagonallyImplicit"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["Explicit",
    BaseStyle->"Link",
    ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Explicit"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->361]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->25476],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->6379]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Implicit - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 43.9846070}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "Implicit is a setting for the option RungeKuttaMethod specifying the \
type of Runge\\[Dash]Kutta method to be generated.", "synonyms" -> {}, 
    "title" -> "Implicit", "type" -> "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/Implicit"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 1543, 38, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[2166, 65, 46, 1, 70, "ObjectName",
 CellID->12212],
Cell[2215, 68, 604, 17, 70, "Usage",
 CellID->21100]
}, Open  ]],
Cell[CellGroupData[{
Cell[2856, 90, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[3334, 107, 368, 11, 70, "Notes",
 CellID->7551]
}, Closed]],
Cell[CellGroupData[{
Cell[3739, 123, 310, 9, 70, "SeeAlsoSection",
 CellID->3789],
Cell[4052, 134, 551, 18, 70, "SeeAlso",
 CellID->361]
}, Open  ]],
Cell[CellGroupData[{
Cell[4640, 157, 314, 9, 70, "TutorialsSection",
 CellID->25476],
Cell[4957, 168, 238, 5, 70, "Tutorials",
 CellID->6379]
}, Open  ]],
Cell[5210, 176, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

