(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     12042,        400]
NotebookOptionsPosition[      9773,        330]
NotebookOutlinePosition[     11071,        363]
CellTagsIndexPosition[     11028,        360]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "SymbolColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE SYMBOL", 
     "PacletNameCell"], Cell[TextData[{
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"tutorials\"\>", 
       StyleBox["\<\"tutorials\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"NewtonCotesError" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
NewtonCotesError"], "GaussianQuadratureError" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureError"], "GaussianQuadratureWeights" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"]}, #, 2]& , Evaluator -> Automatic], {
       1->"\<\"NewtonCotesError\"\>", 2->"\<\"GaussianQuadratureError\"\>", 
       3->"\<\"GaussianQuadratureWeights\"\>"}, "\<\"see also\"\>", 
       StyleBox["\<\"see also\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9],
     "\[ThickSpace]\[ThickSpace]\[ThickSpace]|\[ThickSpace]\[ThickSpace]\
\[ThickSpace]",
     Cell[BoxData[
      PopupMenuBox[
       Dynamic[{"ActionMenu", None}, 
        Part[{"Numerical Differential Equation Analysis Package" :> 
          Documentation`HelpLookup[
           "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]}, #, 2]& , Evaluator -> 
        Automatic], {
       1->"\<\"Numerical Differential Equation Analysis Package\"\>"}, \
"\<\"more about\"\>", 
       StyleBox["\<\"more about\"\>",
        Background->Automatic],
       Appearance->Automatic,
       ImageSize->Automatic,
       MenuAppearance->"Menu"]],
      FontSize->9]
    }], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["NewtonCotesWeights", "ObjectName",
 CellID->25674],

Cell[BoxData[GridBox[{
   {"", Cell[TextData[{
     Cell[BoxData[
      RowBox[{"NewtonCotesWeights", "[", 
       RowBox[{
        StyleBox["n", "TI"], ",", 
        StyleBox["a", "TI"], ",", 
        StyleBox["b", "TI"]}], "]"}]], "InlineFormula"],
     " \[LineSeparator]gives a list of the ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     " pairs ",
     Cell[BoxData[
      RowBox[{"{", 
       RowBox[{
        SubscriptBox[
         StyleBox["x", "TI"], 
         StyleBox["i", "TI"]], ",", 
        SubscriptBox[
         StyleBox["w", "TI"], 
         StyleBox["i", "TI"]]}], "}"}]], "InlineFormula"],
     " of the elementary ",
     Cell[BoxData[
      StyleBox["n", "TI"]], "InlineFormula"],
     "-point Newton-Cotes formula for quadrature on the interval ",
     Cell[BoxData[
      StyleBox["a", "TI"]], "InlineFormula"],
     " to ",
     Cell[BoxData[
      StyleBox["b", "TI"]], "InlineFormula"],
     ", where ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " is the weight of the abscissa ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["x", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     "."
    }]]}
  }]], "Usage",
 GridBoxOptions->{
 GridBoxBackground->{
  "Columns" -> {{None}}, "ColumnsIndexed" -> {}, "Rows" -> {{None}}, 
   "RowsIndexed" -> {}}},
 CellID->3902]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[Cell[BoxData[
 ButtonBox[
  FrameBox[
   StyleBox[
    RowBox[{"MORE", " ", "INFORMATION"}], "NotesFrameText"],
   StripOnInput->False],
  BaseStyle->None,
  ButtonFrame->"None",
  ButtonFunction:>(FrontEndExecute[{
     FrontEnd`SelectionMove[
      FrontEnd`SelectedNotebook[], All, ButtonCell], 
     FrontEndToken["OpenCloseGroup"]}]& ),
  Evaluator->None,
  Method->"Preemptive"]]]], "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],

Cell[TextData[{
 "Newton-Cotes quadrature approximates the value of an integral as a linear \
combination of values of the integrand evaluated at equally spaced points: ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    RowBox[{
     SubsuperscriptBox["\[Integral]", 
      StyleBox["a", "TI"], 
      StyleBox["b", "TI"]], 
     RowBox[{
      RowBox[{
       StyleBox["f", "TI"], "(", 
       StyleBox["x", "TI"], ")"}], 
      RowBox[{"\[DifferentialD]", 
       StyleBox["x", "TI"]}]}]}], 
    StyleBox["\[TildeTilde]", "TR"], 
    RowBox[{
     UnderscriptBox["\[Sum]", 
      StyleBox["i", "TI"]], 
     RowBox[{
      SubscriptBox[
       StyleBox["w", "TI"], 
       StyleBox["i", "TI"]], " ", 
      RowBox[{
       StyleBox["f", "TI"], "(", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], ")"}]}]}]}], TraditionalForm]], 
  "InlineFormula"],
 "."
}], "Notes",
 CellID->8100],

Cell[TextData[{
 "The abscissas may or may not include the endpoints ",
 Cell[BoxData[
  StyleBox["a", "TI"]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  StyleBox["b", "TI"]], "InlineFormula"],
 " of the interval. The option ",
 Cell[BoxData[
  ButtonBox["QuadratureType",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/QuadratureType"]], 
  "InlineFormula"],
 " is used to control whether endpoints are included as abscissas."
}], "Notes",
 CellID->23071],

Cell[TextData[{
 "With the default setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["QuadratureType",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/QuadratureType"], "->",
    "Closed"}]], "InlineFormula"],
 ", the endpoints are included as abscissas. "
}], "Notes",
 CellID->18775],

Cell[TextData[{
 "With the setting ",
 Cell[BoxData[
  RowBox[{
   ButtonBox["QuadratureType",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/QuadratureType"], "->",
    "Open"}]], "InlineFormula"],
 ", the endpoints are not included as abscissas. In this case, the initial \
abscissa is chosen to be a half step above the lower endpoint."
}], "Notes",
 CellID->15009]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["SEE ALSO",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "SeeAlsoSection",
 CellID->6890],

Cell[TextData[{
 Cell[BoxData[
  StyleBox[
   ButtonBox["NewtonCotesError",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesError"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GaussianQuadratureError",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureError"],
   FontFamily->"Verdana"]], "InlineFormula"],
 "\[NonBreakingSpace]",
 StyleBox["\[FilledSmallSquare]", "InlineSeparator"],
 " ",
 Cell[BoxData[
  StyleBox[
   ButtonBox["GaussianQuadratureWeights",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"],
   FontFamily->"Verdana"]], "InlineFormula"]
}], "SeeAlso",
 CellID->5015]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["TUTORIALS",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "TutorialsSection",
 CellID->6430],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"]], "Tutorials",
 CellID->22794]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[ButtonBox["MORE ABOUT",
 BaseStyle->None,
 Evaluator->None,
 Method->"Preemptive",
 ButtonFunction:>(FrontEndExecute[{
    FrontEnd`SelectionMove[
     FrontEnd`SelectedNotebook[], All, ButtonCell], 
    FrontEndToken["OpenCloseGroup"]}]& ),
 ButtonFrame->"None"]], "MoreAboutSection",
 CellID->16776318],

Cell[TextData[ButtonBox["Numerical Differential Equation Analysis Package",
 BaseStyle->"Link",
 ButtonData->
  "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]], "MoreAbout",
 CellID->792944514]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"NewtonCotesWeights - Wolfram Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 50.5003988}", "context" -> 
    "NumericalIntegrationAnalysis`", "keywords" -> {}, "index" -> True, 
    "label" -> "Numerical Differential Equation Analysis Package Symbol", 
    "language" -> "en", "paclet" -> 
    "NumericalDifferentialEquationAnalysis Package", "status" -> "None", 
    "summary" -> 
    "NewtonCotesWeights[n, a, b] gives a list of the n pairs {x_i, w_i} of \
the elementary n-point Newton-Cotes formula for quadrature on the interval a \
to b, where w_i is the weight of the abscissa x_i.", "synonyms" -> {}, 
    "title" -> "NewtonCotesWeights", "type" -> "Symbol", "uri" -> 
    "NumericalDifferentialEquationAnalysis/ref/NewtonCotesWeights"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->FrontEnd`FileName[{"Wolfram"}, "Reference.nb", 
  CharacterEncoding -> "WindowsANSI"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 27, 0, 8, "SymbolColorBar"],
Cell[598, 23, 2491, 60, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[3114, 87, 56, 1, 70, "ObjectName",
 CellID->25674],
Cell[3173, 90, 1413, 47, 70, "Usage",
 CellID->3902]
}, Open  ]],
Cell[CellGroupData[{
Cell[4623, 142, 475, 15, 70, "NotesSection",
 CellGroupingRules->{"SectionGrouping", 50},
 CellID->1],
Cell[5101, 159, 912, 32, 70, "Notes",
 CellID->8100],
Cell[6016, 193, 503, 16, 70, "Notes",
 CellID->23071],
Cell[6522, 211, 332, 11, 70, "Notes",
 CellID->18775],
Cell[6857, 224, 416, 12, 70, "Notes",
 CellID->15009]
}, Closed]],
Cell[CellGroupData[{
Cell[7310, 241, 310, 9, 70, "SeeAlsoSection",
 CellID->6890],
Cell[7623, 252, 911, 31, 70, "SeeAlso",
 CellID->5015]
}, Open  ]],
Cell[CellGroupData[{
Cell[8571, 288, 313, 9, 70, "TutorialsSection",
 CellID->6430],
Cell[8887, 299, 239, 5, 70, "Tutorials",
 CellID->22794]
}, Open  ]],
Cell[CellGroupData[{
Cell[9163, 309, 318, 9, 70, "MoreAboutSection",
 CellID->16776318],
Cell[9484, 320, 247, 5, 70, "MoreAbout",
 CellID->792944514]
}, Open  ]],
Cell[9746, 328, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

