(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    105050,       3581]
NotebookOptionsPosition[     91801,       3128]
NotebookOutlinePosition[     94225,       3181]
CellTagsIndexPosition[     94182,       3178]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{
Cell[" ", "TutorialColorBar"],

Cell[BoxData[GridBox[{
   {Cell["NUMERICAL DIFFERENTIAL EQUATION ANALYSIS PACKAGE TUTORIAL", 
     "PacletNameCell"], Cell[TextData[Cell[BoxData[
     PopupMenuBox[
      Dynamic[{"ActionMenu", None}, 
       Part[{"ButcherAlpha" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherAlpha"], 
         "ButcherBeta" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherBeta"], 
         "ButcherBetaBar" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherBetaBar"], 
         "ButcherColumnConditions" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherColumnConditions"], "ButcherGamma" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherGamma"], 
         "ButcherHeight" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherHeight"], 
         "ButcherOrder" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherOrder"], 
         "ButcherPhi" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPhi"], 
         "ButcherPlot" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlot"], 
         "ButcherPlotColumns" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherPlotColumns"], "ButcherPlotLabel" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotLabel"]\
, "ButcherPlotNodeSize" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherPlotNodeSize"], "ButcherPlotRootSize" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherPlotRootSize"], "ButcherPrincipalError" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherPrincipalError"], "ButcherQuadratureConditions" :> 
         Documentation`HelpLookup[
          
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherQuadratureConditions"], "ButcherRowConditions" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherRowConditions"], "ButcherRowSum" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherRowSum"], 
         "ButcherSigma" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherSigma"], 
         "ButcherSimplify" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherSimplify"],
          "ButcherTreeCount" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeCount"]\
, "ButcherTreeQ" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeQ"], 
         "ButcherTrees" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTrees"], 
         "ButcherTreeSimplify" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherTreeSimplify"], "ButcherWidth" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherWidth"], 
         "DiagonallyImplicit" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
DiagonallyImplicit"], "Explicit" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/Explicit"], 
         "False" :> Documentation`HelpLookup["paclet:ref/False"], 
         "GaussianQuadratureError" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureError"], "GaussianQuadratureWeights" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"], "GraphicsGrid" :> 
         Documentation`HelpLookup["paclet:ref/GraphicsGrid"], "Implicit" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/Implicit"], 
         "NewtonCotesError" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesError"]\
, "NewtonCotesWeights" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
NewtonCotesWeights"], "RungeKuttaMethod" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"]\
, "RungeKuttaOrderConditions" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"], "True" :> 
         Documentation`HelpLookup["paclet:ref/True"], "$RungeKuttaMethod" :> 
         Documentation`HelpLookup[
          "paclet:NumericalDifferentialEquationAnalysis/ref/$\
RungeKuttaMethod"]}, #, 2]& , Evaluator -> Automatic], {
      1->"\<\"ButcherAlpha\"\>", 2->"\<\"ButcherBeta\"\>", 
      3->"\<\"ButcherBetaBar\"\>", 4->"\<\"ButcherColumnConditions\"\>", 
      5->"\<\"ButcherGamma\"\>", 6->"\<\"ButcherHeight\"\>", 
      7->"\<\"ButcherOrder\"\>", 8->"\<\"ButcherPhi\"\>", 
      9->"\<\"ButcherPlot\"\>", 10->"\<\"ButcherPlotColumns\"\>", 
      11->"\<\"ButcherPlotLabel\"\>", 12->"\<\"ButcherPlotNodeSize\"\>", 
      13->"\<\"ButcherPlotRootSize\"\>", 14->"\<\"ButcherPrincipalError\"\>", 
      15->"\<\"ButcherQuadratureConditions\"\>", 
      16->"\<\"ButcherRowConditions\"\>", 17->"\<\"ButcherRowSum\"\>", 
      18->"\<\"ButcherSigma\"\>", 19->"\<\"ButcherSimplify\"\>", 
      20->"\<\"ButcherTreeCount\"\>", 21->"\<\"ButcherTreeQ\"\>", 
      22->"\<\"ButcherTrees\"\>", 23->"\<\"ButcherTreeSimplify\"\>", 
      24->"\<\"ButcherWidth\"\>", 25->"\<\"DiagonallyImplicit\"\>", 
      26->"\<\"Explicit\"\>", 27->"\<\"False\"\>", 
      28->"\<\"GaussianQuadratureError\"\>", 
      29->"\<\"GaussianQuadratureWeights\"\>", 30->"\<\"GraphicsGrid\"\>", 
      31->"\<\"Implicit\"\>", 32->"\<\"NewtonCotesError\"\>", 
      33->"\<\"NewtonCotesWeights\"\>", 34->"\<\"RungeKuttaMethod\"\>", 
      35->"\<\"RungeKuttaOrderConditions\"\>", 36->"\<\"True\"\>", 
      37->"\<\"$RungeKuttaMethod\"\>"}, "\<\"functions\"\>", 
      StyleBox["\<\"functions\"\>",
       Background->Automatic],
      Appearance->Automatic,
      ImageSize->Automatic,
      MenuAppearance->"Menu"]],
     FontSize->9]], "AnchorBar"]}
  }]], "AnchorBarGrid"],

Cell[CellGroupData[{

Cell["Numerical Differential Equation Analysis Package", "Title",
 CellID->509267359],

Cell[TextData[{
 "The ",
 Cell[BoxData[
  ButtonBox["NumericalDifferentialEquationAnalysis",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]], "InlineFormula"],
 " package combines functionality for analyzing differential equations using \
Butcher trees, Gaussian quadrature, and Newton-Cotes quadrature."
}], "Text",
 CellID->1534169418],

Cell["This loads the package:", "MathCaption",
 CellID->836781195],

Cell[BoxData[
 RowBox[{"<<", "NumericalDifferentialEquationAnalysis`"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->2058623809],

Cell[CellGroupData[{

Cell["Butcher", "Section",
 CellID->6856],

Cell[TextData[{
 "Runge\[Hyphen]Kutta methods are useful for numerically solving certain \
types of ordinary differential equations. Deriving high\[Hyphen]order Runge\
\[Hyphen]Kutta methods is no easy task, however. There are several reasons \
for this. The first difficulty is in finding the so\[Hyphen]called order \
conditions. These are nonlinear equations in the coefficients for the method \
that must be satisfied to make the error in the method of order ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["O", "TI"], 
    RowBox[{"(", 
     SuperscriptBox[
      StyleBox["h", "TI"], 
      StyleBox["n", "TI"]], ")"}]}], TraditionalForm]], "InlineFormula"],
 " for some integer ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 " where ",
 Cell[BoxData[
  FormBox[
   StyleBox["h", "TI"], TraditionalForm]], "InlineFormula"],
 " is the step size. The second difficulty is in solving these equations. \
Besides being nonlinear, there is generally no unique solution, and many \
heuristics and simplifying assumptions are usually made. Finally, there is \
the problem of combinatorial explosion. For a twelfth\[Hyphen]order method \
there are 7813 order conditions! "
}], "Text",
 CellID->14705],

Cell[TextData[{
 "This package performs the first task: finding the order conditions that \
must be satisfied. The result is expressed in terms of unknown coefficients \
",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["ij", "TI"]], TraditionalForm]], "InlineFormula"],
 ", ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["b", "TI"], 
    StyleBox["j", "TI"]], TraditionalForm]], "InlineFormula"],
 ", and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["c", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"],
 ". The ",
 Cell[BoxData[
  FormBox[
   StyleBox["s", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]stage Runge\[Hyphen]Kutta method to advance from ",
 Cell[BoxData[
  FormBox[
   StyleBox["x", "TI"], TraditionalForm]], "InlineFormula"],
 " to ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["x", "TI"], "+", 
    StyleBox["h", "TI"]}], TraditionalForm]], "InlineFormula"],
 " is then "
}], "Text",
 CellID->3238],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    StyleBox["Y", "TI"], "(", 
    RowBox[{
     StyleBox["x", "TI"], "+", 
     StyleBox["h", "TI"]}], ")"}], "=", 
   RowBox[{
    RowBox[{
     StyleBox["y", "TI"], "(", 
     StyleBox["x", "TI"], ")"}], "+", 
    RowBox[{
     StyleBox["h", "TI"], 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{
        StyleBox["j", "TI"], "=", "1"}], 
       StyleBox["s", "TI"],
       LimitsPositioning->False], 
      RowBox[{
       SubscriptBox[
        StyleBox["b", "TI"], 
        StyleBox["j", "TI"]], " ", 
       RowBox[{
        StyleBox["f", "TI"], "(", 
        RowBox[{
         SubscriptBox[
          StyleBox["Y", "TI"], 
          StyleBox["j", "TI"]], "(", 
         RowBox[{
          StyleBox["x", "TI"], "+", 
          StyleBox["h", "TI"]}], ")"}], ")"}]}]}]}]}]}], 
  TraditionalForm]], "DisplayMath",
 CellID->21100],

Cell["where ", "Text",
 CellID->7194],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    RowBox[{
     SubscriptBox[
      StyleBox["Y", "TI"], 
      StyleBox["i", "TI"]], "(", 
     RowBox[{
      StyleBox["x", "TI"], "+", 
      StyleBox["h", "TI"]}], ")"}], "=", 
    RowBox[{
     RowBox[{
      StyleBox["y", "TI"], "(", 
      StyleBox["x", "TI"], ")"}], "+", 
     RowBox[{
      StyleBox["h", "TI"], 
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{
         StyleBox["j", "TI"], "=", "1"}], 
        StyleBox["s", "TI"],
        LimitsPositioning->False], 
       RowBox[{
        SubscriptBox[
         StyleBox["a", "TI"], 
         StyleBox["ij", "TI"]], " ", 
        RowBox[{
         StyleBox["f", "TI"], "(", 
         RowBox[{
          SubscriptBox[
           StyleBox["Y", "TI"], 
           StyleBox["j", "TI"]], "(", 
          RowBox[{
           StyleBox["x", "TI"], "+", 
           StyleBox["h", "TI"]}], ")"}], ")"}]}]}]}]}]}], ",", "    ", 
   RowBox[{
    StyleBox["i", "TI"], "=", "1"}], ",", "2", ",", "\[Ellipsis]", ",", 
   StyleBox["s", "TI"]}], TraditionalForm]], "DisplayMath",
 CellID->8825],

Cell[TextData[{
 "Sums of the elements in the rows of the matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["ij", "TI"]], "]"}], TraditionalForm]], "InlineFormula"],
 " occur repeatedly in the conditions imposed on ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["a", "TI"], 
    StyleBox["ij", "TI"]], TraditionalForm]], "InlineFormula"],
 " and ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["b", "TI"], 
    StyleBox["j", "TI"]], TraditionalForm]], "InlineFormula"],
 ". In recognition of this and as a notational convenience it is usual to \
introduce the coefficients ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["c", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"],
 " and the definition "
}], "Text",
 CellID->2002],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{
    SubscriptBox[
     StyleBox["c", "TI"], 
     StyleBox["i", "TI"]], "=", 
    RowBox[{
     UnderoverscriptBox["\[Sum]", 
      RowBox[{
       StyleBox["j", "TI"], "=", "1"}], 
      StyleBox["s", "TI"],
      LimitsPositioning->False], 
     SubscriptBox[
      StyleBox["a", "TI"], 
      StyleBox["ij", "TI"]]}]}], ",", "    ", 
   RowBox[{
    StyleBox["i", "TI"], "=", "1"}], ",", "2", ",", "\[Ellipsis]", ",", 
   StyleBox["s", "TI"]}], TraditionalForm]], "DisplayMath",
 CellID->18008],

Cell["\<\
This definition is referred to as the row\[Hyphen]sum condition and is the \
first in a sequence of row\[Hyphen]simplifying conditions. \
\>", "Text",
 CellID->30534],

Cell[TextData[{
 "If ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["ij", "TI"]], "=", "0"}], TraditionalForm]], "InlineFormula"],
 " for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i", "TI"], "<", "=", 
    StyleBox["j", "TI"]}], TraditionalForm]], "InlineFormula"],
 " the method is ",
 StyleBox["explicit",
  FontSlant->"Italic"],
 "; that is, each of the ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["Y", "TI"], 
     StyleBox["i", "TI"]], 
    RowBox[{"(", 
     RowBox[{
      StyleBox["x", "TI"], "+", 
      StyleBox["h", "TI"]}], ")"}]}], TraditionalForm]], "InlineFormula"],
 " is defined in terms of previously computed values. If the matrix ",
 Cell[BoxData[
  FormBox[
   RowBox[{"[", 
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["ij", "TI"]], "]"}], TraditionalForm]], "InlineFormula"],
 " is not strictly lower triangular, the method is ",
 StyleBox["implicit",
  FontSlant->"Italic"],
 " and requires the solution of a (generally nonlinear) system of equations \
for each timestep. A diagonally implicit method has ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SubscriptBox[
     StyleBox["a", "TI"], 
     StyleBox["ij", "TI"]], "=", "0"}], TraditionalForm]], "InlineFormula"],
 " for all ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    StyleBox["i", "TI"], "<", 
    StyleBox["j", "TI"]}], TraditionalForm]], "InlineFormula"],
 ". "
}], "Text",
 CellID->13933],

Cell[TextData[{
 "There are several ways to express the order conditions. If the number of \
stages ",
 Cell[BoxData[
  FormBox[
   StyleBox["s", "TI"], TraditionalForm]], "InlineFormula"],
 " is specified as a positive integer, the order conditions are expressed in \
terms of sums of explicit terms. If the number of stages is specified as a \
symbol, the order conditions will involve symbolic sums. If the number of \
stages is not specified at all, the order conditions will be expressed in \
stage\[Hyphen]independent tensor notation. In addition to the matrix ",
 StyleBox["a", "MR"],
 " and the vectors ",
 StyleBox["b", "MR"],
 " and ",
 StyleBox["c", "MR"],
 ", this notation involves the vector ",
 StyleBox["e", "MR"],
 ", which is composed of all ones. This notation has two distinct advantages: \
it is independent of the number of stages ",
 Cell[BoxData[
  FormBox[
   StyleBox["s", "TI"], TraditionalForm]], "InlineFormula"],
 " and it is independent of the particular Runge\[Hyphen]Kutta method. "
}], "Text",
 CellID->31953],

Cell["For further details of the theory see the references. ", "Text",
 CellID->28942],

Cell[BoxData[GridBox[{
   {
    SubscriptBox[
     StyleBox["a", "TI"], 
     RowBox[{
      StyleBox["i", "TI"], ",", 
      StyleBox["j", "TI"]}]], Cell[TextData[{
     "the coefficient of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "(", 
       SubscriptBox[
        StyleBox["Y", "TI"], 
        StyleBox["j", "TI"]], "(", 
       StyleBox["x", "TI"], ")", ")"}]], "InlineFormula"],
     " in the formula for ",
     Cell[BoxData[
      RowBox[{
       SubscriptBox[
        StyleBox["Y", "TI"], 
        StyleBox["i", "TI"]], "(", 
       StyleBox["x", "TI"], ")"}]], "InlineFormula"],
     " of the method"
    }], "TableText"]},
   {
    SubscriptBox[
     StyleBox["b", "TI"], 
     StyleBox["j", "TI"]], Cell[TextData[{
     "the coefficient of ",
     Cell[BoxData[
      RowBox[{
       StyleBox["f", "TI"], "(", 
       SubscriptBox[
        StyleBox["Y", "TI"], 
        StyleBox["j", "TI"]], "(", 
       StyleBox["x", "TI"], ")", ")"}]], "InlineFormula"],
     " in the formula for ",
     Cell[BoxData[
      RowBox[{
       StyleBox["Y", "TI"], "(", 
       StyleBox["x", "TI"], ")"}]], "InlineFormula"],
     " of the method"
    }], "TableText"]},
   {
    SubscriptBox[
     StyleBox["c", "TI"], 
     StyleBox["i", "TI"]], Cell[TextData[{
     "a notational convenience for ",
     Cell[BoxData[
      RowBox[{
       UnderoverscriptBox["\[Sum]", 
        RowBox[{
         StyleBox["j", "TI"], "=", "1"}], 
        StyleBox["s", "TI"],
        LimitsPositioning->True], 
       SubscriptBox[
        StyleBox["a", "TI"], 
        StyleBox["ij", "TI"]]}]], "InlineFormula"]
    }], "TableText"]},
   {
    StyleBox["e", "TI"], Cell[TextData[{
     "a notational convenience for the vector ",
     Cell[BoxData[
      RowBox[{"(", "1", ",", "1", ",", "1", ",", "\[Ellipsis]", ")"}]], 
      "InlineFormula"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->1359],

Cell["Notation used by functions for Butcher. ", "Caption",
 CellID->24595],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["RungeKuttaOrderConditions",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "give a list of the order conditions that any ",
     StyleBox["s", "TI"],
     "\[Hyphen]stage Runge\[Hyphen]Kutta method of order ",
     StyleBox["p", "TI"],
     " must satisfy"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherPrincipalError",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherPrincipalError"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "give a list of the order ",
     Cell[BoxData[
      RowBox[{
       StyleBox["p", "TI"], "+", "1"}]], "InlineFormula"],
     " terms appearing in the Taylor series expansion of the error for an \
order\[Hyphen]",
     StyleBox["p", "TI"],
     ", ",
     StyleBox["s", "TI"],
     "\[Hyphen]stage Runge\[Hyphen]Kutta method "
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["RungeKuttaOrderConditions",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"], "[", 
      StyleBox["p", "TI"], "]"}], ",", " ", 
     RowBox[{
      ButtonBox["ButcherPrincipalError",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherPrincipalError"], "[", 
      StyleBox["p", "TI"], "]"}]}], Cell["\<\
give the result in stage\[Hyphen]independent tensor notation \
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->2526],

Cell["\<\
Functions associated with the order conditions of Runge\[Hyphen]Kutta \
methods. \
\>", "Caption",
 CellID->7208],

Cell[BoxData[GridBox[{
   {
    ButtonBox["ButcherRowSum",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherRowSum"], Cell[
    TextData[{
     "specify whether the row\[Hyphen]sum conditions for the ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["c", "TI"], 
       StyleBox["i", "TI"]]], "InlineFormula"],
     " should be explicitly included in the list of order conditions"
    }], "TableText"]},
   {
    ButtonBox["ButcherSimplify",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherSimplify"], 
    Cell["\<\
specify whether to apply Butcher\[CloseCurlyQuote]s row and column \
simplifying assumptions\
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->15480],

Cell[TextData[{
 "Some options for ",
 Cell[BoxData[
  ButtonBox["RungeKuttaOrderConditions",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"]], "InlineFormula"],
 ". "
}], "Caption",
 CellID->880],

Cell[TextData[{
 "This gives the number of order conditions for each order up through order \
",
 Cell[BoxData[
  FormBox["10", TraditionalForm]], "InlineFormula"],
 ". Notice the combinatorial explosion. "
}], "MathCaption",
 CellID->10330],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Length", "/@", 
  RowBox[{"RungeKuttaOrderConditions", "[", "10", "]"}]}]], "Input",
 CellLabel->"In[2]:=",
 CellID->25998],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "4", ",", "9", ",", "20", ",", "48", ",", 
   "115", ",", "286", ",", "719"}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->502197435]
}, Open  ]],

Cell["\<\
This gives the order conditions that must be satisfied by any \
first\[Hyphen]order, 3\[Hyphen]stage Runge\[Hyphen]Kutta method, explicitly \
including the row\[Hyphen]sum conditions. \
\>", "MathCaption",
 CellID->10737],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RungeKuttaOrderConditions", "[", 
  RowBox[{"1", ",", "3", ",", 
   RowBox[{"ButcherRowSum", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->10291],

Cell[GraphicsData["CompressedBitmap", "\<\
eJy9WNtOGzEQdXazG6hUaHOD0lZKSvkBnnmGJz4iQkjwgFpRfqLqR7t2Yi/L
2WNmvCFEynrn6jlje+z19erp7vZh9XR/s1pcPa5+393f/Flc/np0rHJgTDE2
xhweG/du3dv6/89aa0r/tv6ZJdALoC8Eea4+9nfuH2YIXKRH7lE5cuZaz567
tnDtN8HuQ8JPAfzou5ENG1noMS31cZwEaQl+D4I18ttYStrfPCmNuJnfgyDH
PMT+Glmnv6Ok1HO/hrYS8r2OpxOVNCozoI+BPiG9+GjQD9JlhN5gce/mC9N6
RpzSaNE4e5i+j++Q5aETzxHTehEP5gPzqY3nM7MT8wMzPsyG1/pHmo2fiIdr
vZiZFZnpNbHaRm+c4CO9RzCySjMS6Fpph/Fr7SZ2s961FXdXcfS1mybix9mi
jR/pasfjps1/xpoQVzRaYe6rN7RiOMpGEH+4WpiVr1j7vfBpxjjfS7+sMaTd
fNQqXzEro3eM/z2zoMMVdzOuLdV5xMP35FwvurXA+tbOBane8XqB1Yh6Uc07
r8RRtvswQUuvjWc/PGF+7BVxqqrnVzoZkWQ90SAU88RWkD7LI5uDSLKeklja
8n6IYkx8RUoxxf23HyIcI0TETotterDW67c7e26RyMeu9nKvlb8r4/eM9zoE
BGzXrkGPyXP0efRsjLz1p+CNZY7lvU7oa06wGjsePd1RoEq8hoLlSBMNQ9Uf
BZ2NOznlFqa7u+H3f7WlnvTdjeuBr2/8vucrdK7S+kG5ky086rROKXeswqu7
9cjBi+O3xbdSuE/YzN6ZgoN3H5oa6cllaBeh/Wk362wK/NieBfkE+Euwf8Nc
tGicFUhL966YBf/Am2ceqVghzPNdZWy/W347ifdd/vFX8L+5wbThN82kzOA/
LZBCGw==\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{530, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->833034915]
}, Open  ]],

Cell["\<\
These are the order conditions that must be satisfied by any \
second\[Hyphen]order, 3\[Hyphen]stage Runge\[Hyphen]Kutta method. Here the \
row\[Hyphen]sum conditions are not included. \
\>", "MathCaption",
 CellID->28443],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RungeKuttaOrderConditions", "[", 
  RowBox[{"2", ",", "3"}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->6337],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"], "+", 
      SubscriptBox["b", "3"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "+", 
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["c", "2"]}], "+", 
      RowBox[{
       SubscriptBox["b", "3"], " ", 
       SubscriptBox["c", "3"]}]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->35809828]
}, Open  ]],

Cell["\<\
It should be noted that the sums involved on the left\[Hyphen]hand sides of \
the order conditions will be left in symbolic form and not expanded if the \
number of stages is left as a symbolic argument. This will greatly simplify \
the results for high\[Hyphen]order, many\[Hyphen]stage methods. An even more \
compact form results if you do not specify the number of stages at all and \
the answer is given in tensor form. \
\>", "Text",
 CellID->11928],

Cell[TextData[{
 "These are the order conditions that must be satisfied by any \
second\[Hyphen]order, ",
 Cell[BoxData[
  FormBox[
   StyleBox["s", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]stage method. "
}], "MathCaption",
 CellID->15357],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RungeKuttaOrderConditions", "[", 
  RowBox[{"2", ",", "s"}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->13760],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "s"], 
      SubscriptBox["b", "i"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"i", "=", "1"}], "s"], 
      RowBox[{
       SubscriptBox["b", "i"], " ", 
       SubscriptBox["c", "i"]}]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{185, 37},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->474088208]
}, Open  ]],

Cell[TextData[{
 "Replacing ",
 StyleBox["s", "MR"],
 " by 3 gives the same result as\[NonBreakingSpace]",
 Cell[BoxData[
  RowBox[{
   ButtonBox["RungeKuttaOrderConditions",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"], "[", 
   RowBox[{"2", ",", " ", "3"}], "]"}]], "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->15369],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", "\[InvisibleSpace]", 
  RowBox[{"s", "\[Rule]", "3"}]}]], "Input",
 CellLabel->"In[6]:=",
 CellID->23761],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"], "+", 
      SubscriptBox["b", "3"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "+", 
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["c", "2"]}], "+", 
      RowBox[{
       SubscriptBox["b", "3"], " ", 
       SubscriptBox["c", "3"]}]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->309912855]
}, Open  ]],

Cell[TextData[{
 "These are the order conditions that must be satisfied by any \
second\[Hyphen]order method. This uses tensor notation. The vector ",
 StyleBox["e", "MR"],
 " is a vector of ones whose length is the number of stages. "
}], "MathCaption",
 CellID->6864],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RungeKuttaOrderConditions", "[", "2", "]"}]], "Input",
 CellLabel->"In[7]:=",
 CellID->26000],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", ".", "e"}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", ".", "c"}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{152, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[7]=",
 CellID->185250287]
}, Open  ]],

Cell["\<\
The tensor notation can likewise be expanded to give the conditions in full. \
\
\>", "MathCaption",
 CellID->18934],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"%", "/.", "\[InvisibleSpace]", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"a", "\[Rule]", 
     RowBox[{"Array", "[", 
      RowBox[{"a", ",", 
       RowBox[{"{", 
        RowBox[{"3", ",", "3"}], "}"}]}], "]"}]}], ",", 
    RowBox[{"b", "\[Rule]", 
     RowBox[{"Array", "[", 
      RowBox[{"b", ",", "3"}], "]"}]}], ",", 
    RowBox[{"c", "\[Rule]", 
     RowBox[{"Array", "[", 
      RowBox[{"c", ",", "3"}], "]"}]}], ",", 
    RowBox[{"e", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1", ",", "1"}], "}"}]}]}], "}"}]}]], "Input",
 CellLabel->"In[8]:=",
 CellID->8106],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"], "+", 
      SubscriptBox["b", "3"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "+", 
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["c", "2"]}], "+", 
      RowBox[{
       SubscriptBox["b", "3"], " ", 
       SubscriptBox["c", "3"]}]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[8]=",
 CellID->28498656]
}, Open  ]],

Cell["\<\
These are the principal error coefficients for any third\[Hyphen]order \
method. \
\>", "MathCaption",
 CellID->20702],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ButcherPrincipalError", "[", "3", "]"}]], "Input",
 CellLabel->"In[9]:=",
 CellID->8985],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "24"]}], "+", 
    RowBox[{"b", ".", "a", ".", "a", ".", "c"}]}], ",", 
   RowBox[{
    FractionBox["1", "2"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "12"]}], "+", 
      RowBox[{"b", ".", "a", ".", 
       SuperscriptBox["c", "2"]}]}], ")"}]}], ",", 
   RowBox[{
    RowBox[{"-", 
     FractionBox["1", "8"]}], "+", 
    RowBox[{"b", ".", 
     RowBox[{"(", 
      RowBox[{"c", " ", 
       RowBox[{"a", ".", "c"}]}], ")"}]}]}], ",", 
   RowBox[{
    FractionBox["1", "6"], " ", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "4"]}], "+", 
      RowBox[{"b", ".", 
       SuperscriptBox["c", "3"]}]}], ")"}]}]}], "}"}]], "Output",
 ImageSize->{423, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[9]=",
 CellID->450027828]
}, Open  ]],

Cell[TextData[{
 "This is a bound on the local error of any third\[Hyphen]order method in the \
limit as ",
 StyleBox["h", "MR"],
 " approaches 0, normalized to eliminate the effects of the ODE. "
}], "MathCaption",
 CellID->10250],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{"Plus", "@@", 
    RowBox[{"Abs", "[", "%", "]"}]}], ")"}], "\[Times]", " ", 
  SuperscriptBox["h", "4"]}]], "Input",
 CellLabel->"In[10]:=",
 CellID->167],

Cell[BoxData[
 RowBox[{
  SuperscriptBox["h", "4"], " ", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{
     FractionBox["1", "6"], " ", 
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], "+", 
       RowBox[{"b", ".", 
        SuperscriptBox["c", "3"]}]}], "]"}]}], "+", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "8"]}], "+", 
      RowBox[{"b", ".", 
       RowBox[{"(", 
        RowBox[{"c", " ", 
         RowBox[{"a", ".", "c"}]}], ")"}]}]}], "]"}], "+", 
    RowBox[{
     FractionBox["1", "2"], " ", 
     RowBox[{"Abs", "[", 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "12"]}], "+", 
       RowBox[{"b", ".", "a", ".", 
        SuperscriptBox["c", "2"]}]}], "]"}]}], "+", 
    RowBox[{"Abs", "[", 
     RowBox[{
      RowBox[{"-", 
       FractionBox["1", "24"]}], "+", 
      RowBox[{"b", ".", "a", ".", "a", ".", "c"}]}], "]"}]}], 
   ")"}]}]], "Output",
 ImageSize->{555, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[10]=",
 CellID->115643467]
}, Open  ]],

Cell["\<\
Here are the order conditions that must be satisfied by any \
fourth\[Hyphen]order, 1\[Hyphen]stage Runge\[Hyphen]Kutta method. Note that \
there is no possible way for these order conditions to be satisfied; there \
need to be more stages (the second argument must be larger) for there to be \
sufficiently many unknowns to satisfy all of the conditions. \
\>", "MathCaption",
 CellID->4004],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RungeKuttaOrderConditions", "[", 
  RowBox[{"4", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[11]:=",
 CellID->25533],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     SubscriptBox["b", "1"], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], " ", 
      SubscriptBox["c", "1"]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["a", 
        RowBox[{"1", ",", "1"}]], " ", 
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "\[Equal]", 
      FractionBox["1", "6"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubsuperscriptBox["c", "1", "2"]}], "\[Equal]", 
      FractionBox["1", "3"]}]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubsuperscriptBox["a", 
        RowBox[{"1", ",", "1"}], "2"], " ", 
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "\[Equal]", 
      FractionBox["1", "24"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", 
        RowBox[{"1", ",", "1"}]], " ", 
       SubscriptBox["b", "1"], " ", 
       SubsuperscriptBox["c", "1", "2"]}], "\[Equal]", 
      FractionBox["1", "12"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["a", 
        RowBox[{"1", ",", "1"}]], " ", 
       SubscriptBox["b", "1"], " ", 
       SubsuperscriptBox["c", "1", "2"]}], "\[Equal]", 
      FractionBox["1", "8"]}], ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubsuperscriptBox["c", "1", "3"]}], "\[Equal]", 
      FractionBox["1", "4"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{381, 60},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[11]=",
 CellID->159903654]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    ButtonBox["RungeKuttaMethod",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"], 
    Cell["\<\
specify the type of Runge\[Hyphen]Kutta method for which order conditions are \
being sought\
\>", "TableText"]},
   {
    ButtonBox["Explicit",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Explicit"],
     Cell[TextData[{
     "a setting for the option ",
     ButtonBox["RungeKuttaMethod",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"],
     " specifying that the order conditions are to be for an explicit Runge\
\[Hyphen]Kutta method "
    }], "TableText"]},
   {
    ButtonBox["DiagonallyImplicit",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/DiagonallyImplicit"], 
    Cell[TextData[{
     "a setting for the option ",
     ButtonBox["RungeKuttaMethod",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"],
     " specifying that the order conditions are to be for a diagonally \
implicit Runge\[Hyphen]Kutta method "
    }], "TableText"]},
   {
    ButtonBox["Implicit",
     BaseStyle->"Link",
     ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Implicit"],
     Cell[TextData[{
     "a setting for the option ",
     ButtonBox["RungeKuttaMethod",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"],
     " specifying that the order conditions are to be for an implicit Runge\
\[Hyphen]Kutta method "
    }], "TableText"]},
   {
    ButtonBox["$RungeKuttaMethod",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/$RungeKuttaMethod"], 
    Cell[TextData[{
     "a global variable whose value can be set to ",
     ButtonBox["Explicit",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/Explicit"],
     ", ",
     ButtonBox["DiagonallyImplicit",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/DiagonallyImplicit"],
     
     ", or ",
     ButtonBox["Implicit",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/Implicit"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->4020],

Cell[TextData[{
 "Controlling the type of Runge\[Hyphen]Kutta method in ",
 Cell[BoxData[
  ButtonBox["RungeKuttaOrderConditions",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"]], "InlineFormula"],
 " and related functions. "
}], "Caption",
 CellID->4577],

Cell[TextData[{
 Cell[BoxData[
  ButtonBox["RungeKuttaOrderConditions",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"]], "InlineFormula"],
 " and certain related functions have the option ",
 Cell[BoxData[
  ButtonBox["RungeKuttaMethod",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/RungeKuttaMethod"]], 
  "InlineFormula"],
 " with default setting ",
 Cell[BoxData[
  ButtonBox["$RungeKuttaMethod",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/$RungeKuttaMethod"]], 
  "InlineFormula"],
 ". Normally you will want to determine the Runge\[Hyphen]Kutta method being \
considered by setting ",
 Cell[BoxData[
  ButtonBox["$RungeKuttaMethod",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/$RungeKuttaMethod"]], 
  "InlineFormula"],
 " to one of ",
 Cell[BoxData[
  ButtonBox["Implicit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Implicit"]], 
  "InlineFormula"],
 ", ",
 Cell[BoxData[
  ButtonBox["DiagonallyImplicit",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/DiagonallyImplicit"]], 
  "InlineFormula"],
 ", and ",
 Cell[BoxData[
  ButtonBox["Explicit",
   BaseStyle->"Link",
   ButtonData->"paclet:NumericalDifferentialEquationAnalysis/ref/Explicit"]], 
  "InlineFormula"],
 ", but you can specify an option setting or even change the default for an \
individual function. "
}], "Text",
 CellID->6990],

Cell["\<\
These are the order conditions that must be satisfied by any \
second\[Hyphen]order, 3\[Hyphen]stage diagonally implicit Runge\[Hyphen]Kutta \
method. \
\>", "MathCaption",
 CellID->26071],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RungeKuttaOrderConditions", "[", 
  RowBox[{"2", ",", "3", ",", 
   RowBox[{"RungeKuttaMethod", "\[Rule]", "DiagonallyImplicit"}]}], 
  "]"}]], "Input",
 CellLabel->"In[12]:=",
 CellID->19906],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"], "+", 
      SubscriptBox["b", "3"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "+", 
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["c", "2"]}], "+", 
      RowBox[{
       SubscriptBox["b", "3"], " ", 
       SubscriptBox["c", "3"]}]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[12]=",
 CellID->54397424]
}, Open  ]],

Cell[TextData[{
 "An alternative (but less efficient) way to get a diagonally implicit method \
is to force ",
 StyleBox["a", "MR"],
 " to be lower triangular by replacing upper\[Hyphen]triangular elements with \
0. "
}], "MathCaption",
 CellID->19605],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"RungeKuttaOrderConditions", "[", 
   RowBox[{"2", ",", "3"}], "]"}], "/.", "\[InvisibleSpace]", 
  RowBox[{
   RowBox[{"a", "[", 
    RowBox[{"i_", ",", "j_"}], "]"}], "\[RuleDelayed]", 
   RowBox[{"0", "/;", 
    RowBox[{"i", "<", "j"}]}]}]}]], "Input",
 CellLabel->"In[13]:=",
 CellID->18359],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"], "+", 
      SubscriptBox["b", "3"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      RowBox[{
       SubscriptBox["b", "1"], " ", 
       SubscriptBox["c", "1"]}], "+", 
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubscriptBox["c", "2"]}], "+", 
      RowBox[{
       SubscriptBox["b", "3"], " ", 
       SubscriptBox["c", "3"]}]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{282, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[13]=",
 CellID->76290986]
}, Open  ]],

Cell["\<\
These are the order conditions that must be satisfied by any \
third\[Hyphen]order, 2\[Hyphen]stage explicit Runge\[Hyphen]Kutta method. The \
contradiction in the order conditions indicates that no such method is \
possible, a result which holds for any explicit Runge\[Hyphen]Kutta method \
when the number of stages is less than the order. \
\>", "MathCaption",
 CellID->21774],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"RungeKuttaOrderConditions", "[", 
  RowBox[{"3", ",", "2", ",", 
   RowBox[{"RungeKuttaMethod", "\[Rule]", "Explicit"}]}], "]"}]], "Input",
 CellLabel->"In[14]:=",
 CellID->20697],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "1"], "+", 
      SubscriptBox["b", "2"]}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{
      SubscriptBox["b", "2"], " ", 
      SubscriptBox["c", "2"]}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"False", ",", 
     RowBox[{
      RowBox[{
       SubscriptBox["b", "2"], " ", 
       SubsuperscriptBox["c", "2", "2"]}], "\[Equal]", 
      FractionBox["1", "3"]}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{303, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[14]=",
 CellID->253404465]
}, Open  ]],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ButcherColumnConditions",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherColumnConditions"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "give the column simplifying conditions up to and including order ",
     StyleBox["p", "TI"],
     " for ",
     StyleBox["s", "TI"],
     " stages "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherRowConditions",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherRowConditions"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "give the row simplifying conditions up to and including order ",
     StyleBox["p", "TI"],
     " for ",
     StyleBox["s", "TI"],
     " stages "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherQuadratureConditions",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherQuadratureConditions"], "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "give the quadrature conditions up to and including order ",
     StyleBox["p", "TI"],
     " for ",
     StyleBox["s", "TI"],
     " stages "
    }], "TableText"]},
   {
    RowBox[{
     RowBox[{
      ButtonBox["ButcherColumnConditions",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherColumnConditions"], "[", 
      StyleBox["p", "TI"], "]"}], ",", " ", 
     RowBox[{
      ButtonBox["ButcherRowConditions",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/\
ButcherRowConditions"], "[", 
      StyleBox["p", "TI"], "]"}], ",", " ", 
     RowBox[{"etc", ".", " "}]}], Cell["\<\
give the result in stage\[Hyphen]independent tensor notation \
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->25661],

Cell["\<\
More functions associated with the order conditions of Runge\[Hyphen]Kutta \
methods. \
\>", "Caption",
 CellID->4361],

Cell[TextData[{
 "Butcher showed that the number and complexity of the order conditions can \
be reduced considerably at high orders by the adoption of so\[Hyphen]called \
simplifying assumptions. For example, this reduction can be accomplished by \
adopting sufficient row and column simplifying assumptions and quadrature\
\[Hyphen]type order conditions. The option ",
 Cell[BoxData[
  ButtonBox["ButcherSimplify",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherSimplify"]], 
  "InlineFormula"],
 " in ",
 Cell[BoxData[
  ButtonBox["RungeKuttaOrderConditions",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/\
RungeKuttaOrderConditions"]], "InlineFormula"],
 " can be used to determine these automatically. "
}], "Text",
 CellID->12877],

Cell["These are the column simplifying conditions up to order 4. ", \
"MathCaption",
 CellID->17210],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ButcherColumnConditions", "[", "4", "]"}]], "Input",
 CellLabel->"In[15]:=",
 CellID->12084],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"b", ".", "a"}], "\[Equal]", 
    RowBox[{"b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", "c"}], "+", "e"}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", " ", "c"}], ")"}], ".", "a"}], "\[Equal]", 
    RowBox[{
     FractionBox["1", "2"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "2"]}], "+", "e"}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "2"]}], ")"}], ".", "a"}], "\[Equal]", 
    RowBox[{
     FractionBox["1", "3"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "3"]}], "+", "e"}], ")"}]}]}], ",", 
   RowBox[{
    RowBox[{
     RowBox[{"(", 
      RowBox[{"b", " ", 
       SuperscriptBox["c", "3"]}], ")"}], ".", "a"}], "\[Equal]", 
    RowBox[{
     FractionBox["1", "4"], " ", "b", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"-", 
        SuperscriptBox["c", "4"]}], "+", "e"}], ")"}]}]}]}], "}"}]], "Output",\

 ImageSize->{579, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[15]=",
 CellID->80971349]
}, Open  ]],

Cell["These are the row simplifying conditions up to order 4. ", "MathCaption",
 CellID->31450],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ButcherRowConditions", "[", "4", "]"}]], "Input",
 CellLabel->"In[16]:=",
 CellID->19624],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{
    RowBox[{"a", ".", "e"}], "\[Equal]", "c"}], ",", 
   RowBox[{
    RowBox[{"a", ".", "c"}], "\[Equal]", 
    FractionBox[
     SuperscriptBox["c", "2"], "2"]}], ",", 
   RowBox[{
    RowBox[{"a", ".", 
     SuperscriptBox["c", "2"]}], "\[Equal]", 
    FractionBox[
     SuperscriptBox["c", "3"], "3"]}], ",", 
   RowBox[{
    RowBox[{"a", ".", 
     SuperscriptBox["c", "3"]}], "\[Equal]", 
    FractionBox[
     SuperscriptBox["c", "4"], "4"]}]}], "}"}]], "Output",
 ImageSize->{272, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[16]=",
 CellID->781618248]
}, Open  ]],

Cell["These are the quadrature conditions up to order 4. ", "MathCaption",
 CellID->6730],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ButcherQuadratureConditions", "[", "4", "]"}]], "Input",
 CellLabel->"In[17]:=",
 CellID->24607],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", ".", "e"}], "\[Equal]", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", ".", "c"}], "\[Equal]", 
     FractionBox["1", "2"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", ".", 
      SuperscriptBox["c", "2"]}], "\[Equal]", 
     FractionBox["1", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"b", ".", 
      SuperscriptBox["c", "3"]}], "\[Equal]", 
     FractionBox["1", "4"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{311, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[17]=",
 CellID->233357895]
}, Open  ]],

Cell[TextData[{
 "Trees are fundamental objects in Butcher\[CloseCurlyQuote]s formalism. They \
yield both the derivative in a power series expansion of a \
Runge\[Hyphen]Kutta method ",
 StyleBox["and",
  FontSlant->"Italic"],
 " the related order constraint on the coefficients. This package provides a \
number of functions related to Butcher trees. "
}], "Text",
 CellID->26013],

Cell[BoxData[GridBox[{
   {
    StyleBox["f", "InlineCode"], Cell["\<\
the elementary symbol used in the representation of Butcher trees\
\>", "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherTrees",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTrees"], "[", 
     
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "give a list, partitioned by order, of the trees for any \
Runge\[Hyphen]Kutta method of order ",
     StyleBox["p", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherTreeSimplify",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeSimplify"]\
, "[", 
     StyleBox["p", "TI"], ",", 
     StyleBox["\[Eta]", "InlineCode"], ",", 
     StyleBox["\[Xi]", "InlineCode"], "]"}], Cell[TextData[{
     "give the set of trees through order ",
     StyleBox["p", "TI"],
     " that are not reduced by Butcher\[CloseCurlyQuote]s simplifying \
assumptions, assuming that the quadrature conditions through order ",
     StyleBox["p", "TI"],
     ", the row simplifying conditions through order ",
     StyleBox["\[Eta]", "InlineCode"],
     ", and the column simplifying conditions through order ",
     StyleBox["\[Xi]", "InlineCode"],
     " all hold. The result is grouped by order, starting with the first \
nonvanishing trees"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherTreeCount",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeCount"], 
     "[", 
     StyleBox["p", "TI"], "]"}], Cell[TextData[{
     "give a list of the number of trees through order ",
     StyleBox["p", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherTreeQ",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeQ"], "[", 
     
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give ",
     ButtonBox["True",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/True"],
     " if the tree or list of trees ",
     StyleBox["tree", "TI"],
     " is valid functional syntax, and ",
     ButtonBox["False",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/False"],
     " otherwise"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->10674],

Cell["Constructing and enumerating Butcher trees. ", "Caption",
 CellID->28855],

Cell[TextData[{
 "This gives the trees that are needed for any third\[Hyphen]order method. \
The trees are represented in a functional form in terms of the elementary \
symbol ",
 StyleBox["f", "MR"],
 ". "
}], "MathCaption",
 CellID->21132],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ButcherTrees", "[", "3", "]"}]], "Input",
 CellLabel->"In[18]:=",
 CellID->30292],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", "f", "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"f", "[", "f", "]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"f", "[", 
      RowBox[{"f", "[", "f", "]"}], "]"}], ",", 
     RowBox[{"f", "[", 
      SuperscriptBox["f", "2"], "]"}]}], "}"}]}], "}"}]], "Output",
 ImageSize->{212, 18},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[18]=",
 CellID->308325065]
}, Open  ]],

Cell[TextData[{
 "This tests the validity of the syntax of two trees. Butcher trees must be \
constructed using multiplication, exponentiation or application of the \
function ",
 StyleBox["f", "MR"],
 ". "
}], "MathCaption",
 CellID->9914],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ButcherTreeQ", "/@", 
  RowBox[{"{", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"f", "[", 
      RowBox[{
       RowBox[{"f", "[", "f", "]"}], " ", 
       SuperscriptBox["f", "2"]}], "]"}], "]"}], ",", 
    RowBox[{"f", "[", 
     RowBox[{"f", " ", 
      RowBox[{"f", "[", 
       RowBox[{"f", "+", "f"}], "]"}]}], "]"}]}], "}"}]}]], "Input",
 CellLabel->"In[19]:=",
 CellID->7942],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"True", ",", "False"}], "}"}]], "Output",
 ImageSize->{93, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[19]=",
 CellID->626970872]
}, Open  ]],

Cell[TextData[{
 "This evaluates the number of trees at each order through order 10. The \
result is equivalent to ",
 StyleBox["Out[2]", "MR"],
 " but the calculation is much more efficient since it does not actually \
involve constructing order conditions or trees. "
}], "MathCaption",
 CellID->13484],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ButcherTreeCount", "[", "10", "]"}]], "Input",
 CellLabel->"In[20]:=",
 CellID->902],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "1", ",", "2", ",", "4", ",", "9", ",", "20", ",", "48", ",", 
   "115", ",", "286", ",", "719"}], "}"}]], "Output",
 ImageSize->{245, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[20]=",
 CellID->122808536]
}, Open  ]],

Cell[TextData[{
 "The previous result can be used to calculate the ",
 StyleBox["total",
  FontSlant->"Italic"],
 " number of trees required at each order through order\[NonBreakingSpace]10. \
"
}], "MathCaption",
 CellID->22606],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FoldList", "[", 
  RowBox[{"Plus", ",", 
   RowBox[{"First", "[", "%", "]"}], ",", 
   RowBox[{"Rest", "[", "%", "]"}]}], "]"}]], "Input",
 CellLabel->"In[21]:=",
 CellID->18972],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "1", ",", "2", ",", "4", ",", "8", ",", "17", ",", "37", ",", "85", ",", 
   "200", ",", "486", ",", "1205"}], "}"}]], "Output",
 ImageSize->{259, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[21]=",
 CellID->184945023]
}, Open  ]],

Cell[TextData[{
 "The number of constraints for a method using row and column simplifying \
assumptions depends upon the number of stages. ",
 Cell[BoxData[
  ButtonBox["ButcherTreeSimplify",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherTreeSimplify"]], 
  "InlineFormula"],
 " gives the Butcher trees that are not reduced assuming that these \
assumptions hold. "
}], "Text",
 CellID->26207],

Cell["\<\
This gives the additional trees that are necessary for a fourth\[Hyphen]order \
method assuming that the quadrature conditions through order 4 and the row \
and column simplifying assumptions of order 1 hold. The result is a single \
tree of order 4 (which corresponds to a single fourth\[Hyphen]order \
condition). \
\>", "MathCaption",
 CellID->8154],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ButcherTreeSimplify", "[", 
  RowBox[{"4", ",", "1", ",", "1"}], "]"}]], "Input",
 CellLabel->"In[22]:=",
 CellID->24455],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{"{", 
   RowBox[{"f", "[", 
    RowBox[{"f", " ", 
     RowBox[{"f", "[", "f", "]"}]}], "]"}], "}"}], "}"}]], "Output",
 ImageSize->{91, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[22]=",
 CellID->275301882]
}, Open  ]],

Cell["\<\
It is often useful to be able to visualize a tree or forest of trees \
graphically. For example, depicting trees yields insight, which can in turn \
be used to aid in the construction of Runge\[Hyphen]Kutta methods. \
\>", "Text",
 CellID->16354],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ButcherPlot",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlot"], "[", 
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give a plot of the tree ",
     StyleBox["tree", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherPlot",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlot"], 
     RowBox[{"[", "{"}], 
     SubscriptBox[
      StyleBox["tree", "TI"], "1"], ",", 
     SubscriptBox[
      StyleBox["tree", "TI"], "2"], ",", "\[Ellipsis]", 
     RowBox[{"}", "]"}]}], Cell[TextData[{
     "give an array of plots of the trees in the forest ",
     "{",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["tree", "TI"], "1"]], "InlineFormula"],
     ", ",
     Cell[BoxData[
      SubscriptBox[
       StyleBox["tree", "TI"], "2"]], "InlineFormula"],
     ",",
     "\[Ellipsis]",
     "}"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->11911],

Cell["Drawing Butcher trees. ", "Caption",
 CellID->24859],

Cell[BoxData[GridBox[{
   {
    ButtonBox["ButcherPlotColumns",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotColumns"], 
    Cell[TextData[{
     "specify the number of columns in the ",
     ButtonBox["GraphicsGrid",
      BaseStyle->"Link",
      ButtonData->"paclet:ref/GraphicsGrid"],
     " plot of a list of trees"
    }], "TableText"]},
   {
    ButtonBox["ButcherPlotLabel",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotLabel"], 
    Cell["\<\
specify a list of plot labels to be used to label the nodes of the plot\
\>", "TableText"]},
   {
    ButtonBox["ButcherPlotNodeSize",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotNodeSize"],
     Cell["\<\
specify a scaling factor for the nodes of the trees in the plot\
\>", "TableText"]},
   {
    ButtonBox["ButcherPlotRootSize",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlotRootSize"],
     Cell["\<\
specify a scaling factor for the highlighting of the root of each tree in the \
plot; a zero value does not highlight roots \
\>", "TableText"]}
  }]], "DefinitionBox",
 CellID->5956],

Cell[TextData[{
 "Options to ",
 Cell[BoxData[
  ButtonBox["ButcherPlot",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPlot"]], 
  "InlineFormula"],
 ". "
}], "Caption",
 CellID->28361],

Cell["This plots and labels the trees through order 4. ", "MathCaption",
 CellID->3881],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(", 
   RowBox[{
    RowBox[{"ButcherPlot", "[", 
     RowBox[{"#", ",", 
      RowBox[{"ButcherPlotLabel", "\[Rule]", 
       RowBox[{"InputForm", "/@", "#"}]}]}], "]"}], "&"}], ")"}], "[", 
  RowBox[{"Flatten", "[", 
   RowBox[{"ButcherTrees", "[", "4", "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[23]:=",
 CellID->14958],

Cell[GraphicsData["CompressedBitmap", "\<\
eJztWj1MG0kUnti79ikOhw9ziYlNZCWKgOogB8aRkKC5mCYSIqeAUmFFlpzi
dCiXAomCku6oTpSUlDSRKCkpKSmho6Sk3Hszb3ZndjyzO7tLiICs5N15b9/7
5v3t7ryBt50vve5fnS+fPnYa7c+d9d6nj/803vz9GVj5B4SQr/RXJTD2YMR+
Xz0PrlnOz+g5f3V1dXR0dHl5SVoKvSqknFartbCwMD4+Drdn+zgrTHKUnt2z
s7NKpQIWgsDx8TFp+txGowHcZrNJuSuSBdVqFW6srq5yC9rtNtATExPcAobr
nJycTE5OLi0tHRwcMAtcmBgx4XxxcUEkK5xer7e7u3t4eLi4uIjS29vbGxsb
IA18uMul6/RcAKRyuQxnoAAMjJ2h/CKgAgl8GnDPg/nBCvJe0tzZ2VlfX/fY
gWPUhAGQTJBqgs1guaxZRDDUFPP8zmxFX/EeAJAciwv6Tod/Mn6NcSFZkAc2
ZKe1tbW9vT06fMWwAq0QVjBDCAtysL+/L7AgU5BFOpxiNMaTDhlKAZ3DAyOO
aE+ZtPDKZXTgMZlUaIZWlNGE7jsJEXPI3GI0TNjtdunwN0aD8eCCsD9A5F6D
MkDQ4bKEClIwnUA9Pz9HRY4q7utRg/rgqM8ZFyueDnfuEPeFEoF/vaxvIfvz
AJxzMHWZXx/y64hCrzFpNVeUpiRxPP+phPOgJEVvulqpgsLFo2Sl+yvnthnp
aCtI0Or9wYTyrIJd+UmiBv2cEGVYof9IZXtRZ9uN+0Kz5PDsZPdJtimc+Zv3
LK420EP9XLrc5H1+rLSjlRq00o3zMonVsh0iG4Vb5UNBR39T6x95+J40PxGU
qau+PJ8j6r65tqO09F9WQeve5mkjbhelLBFm1jmC7pfQV0xB0iPs+EmSC+aP
lMhrLSzH6uX6bNYjqW8htJz653I//W+0TGNq/MOH+EWRynuiMv2qEN/O6+hp
Xit0XWjF9DitPg5bM4uup1QqEVPXw7mzPndoaEhwa5LlCLK8vMwtx5aF9kZo
+dzcHKfrYnYH2wvsOV4r+aE4ua2trVFJHhbxsJQ/PT0FR6LlscsJVoFwgPsQ
u5aFVtADeX4DFK1V83PD+7mcQs9aaKsdgFjxNy20MSFCG2aF5jReG/sI0VPh
m1X0azMW2qJjRG2MmEmbyXc6HTqsSygghW1s33dlWosyPz/Pn0dE+aBI4XMA
TwrEYWxsDEomSg47YDxHyLlQdoCEqLR7qmllWcwLQc/p+T1mlLTc7WI+9NIz
fn55l4n5Fh3piFGL5g3fgdBmQ7NtlsaIi/p1FDpKS2TfVaqjGqEFNDybQguC
zLMbpYUFI2pG0E+0Wit3iGvzTaEdhNxfvlRo9frYwG8EaPFd4zDnDlhJJ+EG
vaz2i+xkmG/Y03XJSCTtbSoKnVQ/6339SlJddSbt+6y81q+4EkeAVp1L+tdr
9yOSIe+vKaLsyQ2tkO9nbA1xMETZrmMqedFzRqAk4cb2d2rsIrrxdD5litIj
hVatvY1R0vqUKUoDCq3W822MktaniPcaFb2uvRb1fhx+Ur79WywNeipvM9Vf
/+6P2ovdhYq09NIQyTT7URF40qwGZBuONLv+LaTGr5gCOZFfhuiZ9s3kmqfX
iiSnXs27cuH1+0ODrmlO3er/+v4nIfH+3fT0tLx/ByQwtft3oZ26mP27crlM
tPt3Yr/Obv9O7UrDO0P34y7Jd7tdXn9yVCC/Msbm5iZi/BdC/B4U258JWXwz
fwGne3z0mXvl2e1IjARa8htoSqGj9wlqVtKJ/26Oz51UCVMKbdX7SHQ9oX66
3uqH7d/T9mc62+3WQhI9atZKua76YV1W68iD/wGtpq1N\
\>"], "Output",
 Evaluatable->False,
 ImageSize->{180, 180},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[23]=",
 CellID->23854453]
}, Open  ]],

Cell[TextData[{
 "In addition to generating and drawing Butcher trees, many functions are \
provided for measuring and manipulating them. For a complete description of \
the importance of these functions, see Butcher\[NonBreakingSpace]",
 Cell[BoxData[
  RowBox[{"[", 
   ButtonBox["1",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysisReferences"], "]"}]], "InlineFormula"],
 ". "
}], "Text",
 CellID->6145],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["ButcherHeight",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherHeight"], "[",
      
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give the height of the tree ",
     StyleBox["tree", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherWidth",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherWidth"], "[", 
     
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give the width of the tree ",
     StyleBox["tree", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherOrder",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherOrder"], "[", 
     
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give the order, or number of vertices, of the tree ",
     StyleBox["tree", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherAlpha",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherAlpha"], "[", 
     
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give the number of ways of labeling the vertices of the tree ",
     StyleBox["tree", "TI"],
     " with a totally ordered set of labels such that if ",
     Cell[BoxData[
      RowBox[{"(", 
       StyleBox["m", "TI"], ",", 
       StyleBox["n", "TI"], ")"}]], "InlineFormula"],
     " is an edge, then ",
     Cell[BoxData[
      RowBox[{
       StyleBox["m", "TI"], "<", 
       StyleBox["n", "TI"]}]], "InlineFormula"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherBeta",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherBeta"], "[", 
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give the number of ways of labeling the tree ",
     StyleBox["tree", "TI"],
     " with ",
     ButtonBox["ButcherOrder",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherOrder"],
     "[",
     StyleBox["tree", "TI"],
     "]",
     "-1",
     " distinct labels such that the root is not labeled, but every other \
vertex is labeled"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherBeta",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherBeta"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give the number of ways of labeling ",
     StyleBox["n", "TI"],
     " of the vertices of the tree with ",
     StyleBox["n", "TI"],
     " distinct labels such that every leaf is labeled and the root is not \
labeled"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherBetaBar",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherBetaBar"], 
     "[", 
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give the number of ways of labeling the tree ",
     StyleBox["tree", "TI"],
     " with ",
     ButtonBox["ButcherOrder",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherOrder"],
     "[",
     StyleBox["tree", "TI"],
     "]",
     " distinct labels such that every node, including the root, is labeled"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherBetaBar",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherBetaBar"], 
     "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give the number of ways of labeling ",
     StyleBox["n", "TI"],
     " of the vertices of the tree with ",
     StyleBox["n", "TI"],
     " distinct labels such that every leaf is labeled"
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherGamma",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherGamma"], "[", 
     
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give the density of the tree ",
     StyleBox["tree", "TI"],
     "; the reciprocal of the density is the right\[Hyphen]hand side of the \
order condition imposed by ",
     StyleBox["tree", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherPhi",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPhi"], "[", 
     StyleBox["tree", "TI"], ",", 
     StyleBox["s", "TI"], "]"}], Cell[TextData[{
     "give the weight of the tree ",
     StyleBox["tree", "TI"],
     "; the weight ",
     Cell[BoxData[
      RowBox[{"\[CapitalPhi]", "(", 
       StyleBox["tree", "TI"], ")"}]], "InlineFormula"],
     " is the left\[Hyphen]hand side of the order condition imposed by ",
     StyleBox["tree", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherPhi",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherPhi"], "[", 
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give ",
     Cell[BoxData[
      RowBox[{"\[CapitalPhi]", "(", 
       StyleBox["tree", "TI"], ")"}]], "InlineFormula"],
     " using tensor notation "
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["ButcherSigma",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/ButcherSigma"], "[", 
     
     StyleBox["tree", "TI"], "]"}], Cell[TextData[{
     "give the order of the symmetry group of isomorphisms of the tree ",
     StyleBox["tree", "TI"],
     " with itself"
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->14797],

Cell["Other functions associated with Butcher trees. ", "Caption",
 CellID->11861],

Cell[TextData[{
 "This gives the order of the tree ",
 StyleBox["f[f[f[f]", "MR"],
 " ",
 StyleBox["f^2]]", "MR"],
 ". "
}], "MathCaption",
 CellID->9384],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ButcherOrder", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", "f", "]"}], " ", 
     SuperscriptBox["f", "2"]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[24]:=",
 CellID->24800],

Cell[BoxData["6"], "Output",
 ImageSize->{11, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[24]=",
 CellID->102725931]
}, Open  ]],

Cell[TextData[{
 "This gives the density of the tree ",
 StyleBox["f[f[f[f]", "MR"],
 " ",
 StyleBox["f^2]]", "MR"],
 ". "
}], "MathCaption",
 CellID->25762],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ButcherGamma", "[", 
  RowBox[{"f", "[", 
   RowBox[{"f", "[", 
    RowBox[{
     RowBox[{"f", "[", "f", "]"}], " ", 
     SuperscriptBox["f", "2"]}], "]"}], "]"}], "]"}]], "Input",
 CellLabel->"In[25]:=",
 CellID->8182],

Cell[BoxData["60"], "Output",
 ImageSize->{18, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[25]=",
 CellID->319992184]
}, Open  ]],

Cell[TextData[{
 "This gives the elementary weight function imposed by ",
 StyleBox["f[f[f[f]", "MR"],
 " ",
 StyleBox["f^2]]", "MR"],
 " for an ",
 Cell[BoxData[
  FormBox[
   StyleBox["s", "TI"], TraditionalForm]], "InlineFormula"],
 "\[Hyphen]stage method. "
}], "MathCaption",
 CellID->24882],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ButcherPhi", "[", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"f", "[", 
     RowBox[{
      RowBox[{"f", "[", "f", "]"}], " ", 
      SuperscriptBox["f", "2"]}], "]"}], "]"}], ",", "s"}], "]"}]], "Input",
 CellLabel->"In[26]:=",
 CellID->16750],

Cell[BoxData[
 RowBox[{
  UnderoverscriptBox["\[Sum]", 
   RowBox[{"i", "=", "1"}], "s"], 
  RowBox[{
   SubscriptBox["b", "i"], " ", 
   RowBox[{
    UnderoverscriptBox["\[Sum]", 
     RowBox[{"j", "=", "1"}], "s"], 
    RowBox[{
     SubscriptBox["a", 
      RowBox[{"i", ",", "j"}]], " ", 
     SubsuperscriptBox["c", "j", "2"], " ", 
     RowBox[{
      UnderoverscriptBox["\[Sum]", 
       RowBox[{"k", "=", "1"}], "s"], 
      RowBox[{
       SubscriptBox["a", 
        RowBox[{"j", ",", "k"}]], " ", 
       SubscriptBox["c", "k"]}]}]}]}]}]}]], "Output",
 ImageSize->{153, 39},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[26]=",
 CellID->32058240]
}, Open  ]],

Cell[TextData[{
 "The subscript notation is a formatting device and the subscripts are really \
just the indexed variable ",
 StyleBox["NumericalDifferentialEquationAnalysis`Private`$i", "MR"],
 ". "
}], "MathCaption",
 CellID->20847],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"FullForm", "[", 
  RowBox[{"%", "\[LeftDoubleBracket]", 
   RowBox[{"1", ",", "1"}], "\[RightDoubleBracket]"}], "]"}]], "Input",
 CellLabel->"In[27]:=",
 CellID->6368],

Cell[BoxData[
 TagBox[
  StyleBox[
   RowBox[{
   "b", "[", "NumericalDifferentialEquationAnalysis`Private`$i1", "]"}],
   ShowSpecialCharacters->False,
   ShowStringCharacters->True,
   NumberMarks->True],
  FullForm]], "Output",
 GeneratedCell->False,
 CellAutoOverwrite->False,
 ImageSize->{368, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[27]//FullForm=",
 CellID->63746708]
}, Open  ]],

Cell[TextData[{
 "It is also possible to obtain solutions to the order conditions using ",
 Cell[BoxData[
  ButtonBox["Solve",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/Solve"]], "InlineFormula"],
 " and related functions. Many issues related to the construction Runge\
\[Hyphen]Kutta methods using this package can be found in Sofroniou\
\[NonBreakingSpace]",
 Cell[BoxData[
  RowBox[{"[", 
   ButtonBox["6",
    BaseStyle->"Link",
    ButtonData->
     "paclet:NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysisReferences"], "]"}]], "InlineFormula"],
 ". The article also contains details concerning algorithms used in ",
 StyleBox["Butcher.m", "MR"],
 " and discusses applications. "
}], "Text",
 CellID->23615]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gaussian Quadrature", "Section",
 CellID->32120],

Cell[TextData[{
 "As one of its methods, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " uses a fairly sophisticated Gauss\[Hyphen]Kronrod\[Hyphen]based algorithm. \
The Gaussian quadrature functionality provided in ",
 Cell[BoxData[
  ButtonBox["NumericalDifferentialEquationAnalysis",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/guide/\
NumericalDifferentialEquationAnalysisPackage"]], "InlineFormula"],
 " allows you to easily study some of the theory behind ordinary Gaussian \
quadrature which is a little less sophisticated. "
}], "Text",
 CellID->24966],

Cell["\<\
The basic idea behind Gaussian quadrature is to approximate the value if an \
integral as a linear combination of values of the integrand evaluated at \
specific points: \
\>", "Text",
 CellID->11976],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    StyleBox["a", "TI"], 
    StyleBox["b", "TI"]], 
   StyleBox["f", "TI"], 
   RowBox[{"(", 
    StyleBox["x", "TI"], ")"}], "\[DifferentialD]", 
   StyleBox["x", "TI"], "=", 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["i", "TI"], "=", "1"}], 
    StyleBox["n", "TI"],
    LimitsPositioning->False], 
   SubscriptBox[
    StyleBox["w", "TI"], 
    StyleBox["i", "TI"]], 
   StyleBox["f", "TI"], 
   RowBox[{"(", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ")"}]}], TraditionalForm]], "DisplayMath",
 CellID->15468],

Cell[TextData[{
 "Since there are ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    StyleBox["n", "TI"]}], TraditionalForm]], "InlineFormula"],
 " free parameters to be chosen (both the abscissas ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["x", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"],
 " and the weights ",
 Cell[BoxData[
  FormBox[
   SubscriptBox[
    StyleBox["w", "TI"], 
    StyleBox["i", "TI"]], TraditionalForm]], "InlineFormula"],
 ") and since both integration and the sum are linear operations, you can \
expect to be able to make the formula correct for all polynomials of degree \
less than about ",
 Cell[BoxData[
  FormBox[
   RowBox[{"2", 
    StyleBox["n", "TI"]}], TraditionalForm]], "InlineFormula"],
 ". In addition to knowing what the optimal abscissas and weights are, it is \
often desirable to know how large the error in the approximation will be. \
This package allows you to answer both of these questions. "
}], "Text",
 CellID->20018],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["GaussianQuadratureWeights",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"], "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "give a list of the pairs ",
     Cell[BoxData[
      RowBox[{"(", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], ",", 
       SubscriptBox[
        StyleBox["w", "TI"], 
        StyleBox["i", "TI"]], ")"}]], "InlineFormula"],
     " to machine precision for quadrature on the interval ",
     StyleBox["a", "TI"],
     " to ",
     StyleBox["b", "TI"]
    }], "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["GaussianQuadratureError",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureError"], "[", 
      StyleBox["n", "TI"], ",", 
      StyleBox["f", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell["give the error to machine precision", "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["GaussianQuadratureWeights",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureWeights"], "[", 
      StyleBox["n", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["prec", "TI"], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give a list of the pairs ",
     Cell[BoxData[
      RowBox[{"(", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], ",", 
       SubscriptBox[
        StyleBox["w", "TI"], 
        StyleBox["i", "TI"]], ")"}]], "InlineFormula"],
     " to precision ",
     StyleBox["prec", "TI"]
    }], "TableText"]},
   {
    StyleBox[
     RowBox[{
      ButtonBox["GaussianQuadratureError",
       BaseStyle->"Link",
       ButtonData->
        "paclet:NumericalDifferentialEquationAnalysis/ref/\
GaussianQuadratureError"], "[", 
      StyleBox["n", "TI"], ",", 
      StyleBox["f", "TI"], ",", 
      StyleBox["a", "TI"], ",", 
      StyleBox["b", "TI"], ",", 
      StyleBox["prec", "TI"], "]"}],
     GridElementStyleOptions -> {ColumnAlignments -> Left}], 
    "\[SpanFromLeft]"},
   {"", Cell[TextData[{
     "give the error to precision ",
     StyleBox["prec", "TI"]
    }], "TableText"]}
  }]], "DefinitionBox",
 CellID->22522],

Cell["Finding formulas for Gaussian quadrature. ", "Caption",
 CellID->28612],

Cell[TextData[{
 "This gives the abscissas and weights for the five\[Hyphen]point Gaussian \
quadrature formula on the interval (",
 Cell[BoxData[
  FormBox["-", TraditionalForm]], "InlineFormula"],
 "3, 7). "
}], "MathCaption",
 CellID->22773],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GaussianQuadratureWeights", "[", 
  RowBox[{"5", ",", 
   RowBox[{"-", "3"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->13766],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2.5308992296933193`"}], ",", "1.1846344252809495`"}], 
    "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "0.692346550528415`"}], ",", "2.3931433524968293`"}], "}"}],
    ",", 
   RowBox[{"{", 
    RowBox[{"2.`", ",", "2.8444444444444406`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4.6923465505284145`", ",", "2.3931433524968293`"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6.530899229693318`", ",", "1.1846344252809495`"}], "}"}]}], 
  "}"}]], "Output",
 ImageSize->{368, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->160642560]
}, Open  ]],

Cell[TextData[{
 "Here is the error in that formula. Unfortunately it involves the tenth \
derivative of ",
 Cell[BoxData[
  FormBox[
   StyleBox["f", "TI"], TraditionalForm]], "InlineFormula"],
 " at an unknown point so you don\[CloseCurlyQuote]t really know what the \
error itself is. "
}], "MathCaption",
 CellID->22990],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GaussianQuadratureError", "[", 
  RowBox[{"5", ",", "f", ",", 
   RowBox[{"-", "3"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->21987],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "0.039449654172081794`"}], " ", 
  SuperscriptBox["f", 
   TagBox[
    RowBox[{"(", "10", ")"}],
    Derivative],
   MultilineFunction->None]}]], "Output",
 ImageSize->{106, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->347019929]
}, Open  ]],

Cell["\<\
You can see that the error decreases rapidly with the length of the interval. \
\
\>", "MathCaption",
 CellID->3993],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"GaussianQuadratureError", "[", 
  RowBox[{"5", ",", "f", ",", "a", ",", 
   RowBox[{"a", "+", "h"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->7662],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", "3.944965417208179`*^-13"}], " ", 
  SuperscriptBox["h", "11"], " ", 
  SuperscriptBox["f", 
   TagBox[
    RowBox[{"(", "10", ")"}],
    Derivative],
   MultilineFunction->None]}]], "Output",
 ImageSize->{153, 15},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->189162340]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Newton\[Hyphen]Cotes", "Section",
 CellID->12503],

Cell[TextData[{
 "As one of its methods, the ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " function ",
 Cell[BoxData[
  ButtonBox["NIntegrate",
   BaseStyle->"Link",
   ButtonData->"paclet:ref/NIntegrate"]], "InlineFormula"],
 " uses a fairly sophisticated Gauss\[Hyphen]Kronrod based algorithm. Other \
types of quadrature formulas exist, each with their own advantages. For \
example, Gaussian quadrature uses values of the integrand at oddly spaced \
abscissas. If you want to integrate a function presented in tabular form at \
equally spaced abscissas, it won\[CloseCurlyQuote]t work very well. An \
alternative is to use Newton\[Hyphen]Cotes quadrature. "
}], "Text",
 CellID->20661],

Cell["\<\
The basic idea behind Newton\[Hyphen]Cotes quadrature is to approximate the \
value of an integral as a linear combination of values of the integrand \
evaluated at equally spaced points: \
\>", "Text",
 CellID->1918],

Cell[BoxData[
 FormBox[
  RowBox[{
   SubsuperscriptBox["\[Integral]", 
    StyleBox["a", "TI"], 
    StyleBox["b", "TI"]], 
   StyleBox["f", "TI"], 
   RowBox[{"(", 
    StyleBox["x", "TI"], ")"}], "\[DifferentialD]", 
   StyleBox["x", "TI"], "=", 
   UnderoverscriptBox["\[Sum]", 
    RowBox[{
     StyleBox["i", "TI"], "=", "1"}], 
    StyleBox["n", "TI"],
    LimitsPositioning->False], 
   SubscriptBox[
    StyleBox["w", "TI"], 
    StyleBox["i", "TI"]], 
   StyleBox["f", "TI"], 
   RowBox[{"(", 
    SubscriptBox[
     StyleBox["x", "TI"], 
     StyleBox["i", "TI"]], ")"}]}], TraditionalForm]], "DisplayMath",
 CellID->31012],

Cell["\<\
In addition, there is the question of whether or not to include the end \
points in the sum. If they are included, the quadrature formula is referred \
to as a closed formula. If not, it is an open formula. If the formula is open \
there is some ambiguity as to where the first abscissa is to be placed. The \
open formulas given in this package have the first abscissa one half step \
from the lower end point. \
\>", "Text",
 CellID->5788],

Cell[TextData[{
 "Since there are ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 " free parameters to be chosen (the weights) and since both integration and \
the sum are linear operations, you can expect to be able to make the formula \
correct for all polynomials of degree less than about ",
 Cell[BoxData[
  FormBox[
   StyleBox["n", "TI"], TraditionalForm]], "InlineFormula"],
 ". In addition to knowing what the weights are, it is often desirable to \
know how large the error in the approximation will be. This package allows \
you to answer both of these questions. "
}], "Text",
 CellID->2474],

Cell[BoxData[GridBox[{
   {
    RowBox[{
     ButtonBox["NewtonCotesWeights",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesWeights"],
      "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[TextData[{
     "give a list of the ",
     StyleBox["n", "TI"],
     " pairs ",
     Cell[BoxData[
      RowBox[{"(", 
       SubscriptBox[
        StyleBox["x", "TI"], 
        StyleBox["i", "TI"]], ",", 
       SubscriptBox[
        StyleBox["w", "TI"], 
        StyleBox["i", "TI"]], ")"}]], "InlineFormula"],
     " for quadrature on the interval ",
     StyleBox["a", "TI"],
     " to ",
     StyleBox["b", "TI"]
    }], "TableText"]},
   {
    RowBox[{
     ButtonBox["NewtonCotesError",
      BaseStyle->"Link",
      ButtonData->
       "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesError"], 
     "[", 
     StyleBox["n", "TI"], ",", 
     StyleBox["f", "TI"], ",", 
     StyleBox["a", "TI"], ",", 
     StyleBox["b", "TI"], "]"}], Cell[
    "give the error in the formula", "TableText"]}
  }]], "DefinitionBox",
 CellID->9743],

Cell["\<\
Finding formulas for Newton\[Hyphen]Cotes quadrature. \
\>", "Caption",
 CellID->10337],

Cell[BoxData[GridBox[{
   {
    StyleBox[
     RowBox[{"option", " ", "name"}], "TableHeader"], 
    StyleBox[
     RowBox[{"default", " ", "value"}], "TableHeader"], ""},
   {
    ButtonBox["QuadratureType",
     BaseStyle->"Link",
     ButtonData->
      "paclet:NumericalDifferentialEquationAnalysis/ref/QuadratureType"], 
    "Closed", Cell["the type of quadrature, Open or Closed", "TableText"]}
  }]], "DefinitionBox3Col",
 GridBoxOptions->{
 GridBoxDividers->{
  "Columns" -> {{False}}, "ColumnsIndexed" -> {}, 
   "Rows" -> {False, {True}, False}, "RowsIndexed" -> {}},
 GridBoxSpacings->{
  "Columns" -> {0.28, {0.56}, 0.28}, "ColumnsIndexed" -> {}, 
   "Rows" -> {0.2, {0.16}, 0.2}, "RowsIndexed" -> {}}},
 CellID->12893],

Cell[TextData[{
 "Option for ",
 Cell[BoxData[
  ButtonBox["NewtonCotesWeights",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesWeights"]], 
  "InlineFormula"],
 " and ",
 Cell[BoxData[
  ButtonBox["NewtonCotesError",
   BaseStyle->"Link",
   ButtonData->
    "paclet:NumericalDifferentialEquationAnalysis/ref/NewtonCotesError"]], 
  "InlineFormula"],
 "."
}], "Caption",
 CellID->23362],

Cell[TextData[{
 "Here are the abscissas and weights for the five\[Hyphen]point closed Newton\
\[Hyphen]Cotes quadrature formula on the interval ",
 Cell[BoxData[
  FormBox[
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "3"}], ",", "7"}], ")"}], TraditionalForm]], 
  "InlineFormula"],
 ". "
}], "MathCaption",
 CellID->25567],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewtonCotesWeights", "[", 
  RowBox[{"5", ",", 
   RowBox[{"-", "3"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[2]:=",
 CellID->1209],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "3"}], ",", 
     FractionBox["7", "9"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", 
      FractionBox["1", "2"]}], ",", 
     FractionBox["32", "9"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     FractionBox["4", "3"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{
     FractionBox["9", "2"], ",", 
     FractionBox["32", "9"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"7", ",", 
     FractionBox["7", "9"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{317, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[2]=",
 CellID->108031862]
}, Open  ]],

Cell[TextData[{
 "Here is the error in that formula. Unfortunately it involves the sixth \
derivative of ",
 Cell[BoxData[
  FormBox[
   StyleBox["f", "TI"], TraditionalForm]], "InlineFormula"],
 " at an unknown point so you don\[CloseCurlyQuote]t really know what the \
error itself is. "
}], "MathCaption",
 CellID->32421],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewtonCotesError", "[", 
  RowBox[{"5", ",", "f", ",", 
   RowBox[{"-", "3"}], ",", "7"}], "]"}]], "Input",
 CellLabel->"In[3]:=",
 CellID->5162],

Cell[BoxData[
 FractionBox[
  RowBox[{"15625", " ", 
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", "6", ")"}],
     Derivative],
    MultilineFunction->None]}], "3024"]], "Output",
 ImageSize->{71, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[3]=",
 CellID->313385813]
}, Open  ]],

Cell["\<\
You can see that the error decreases rapidly with the length of the interval. \
\
\>", "MathCaption",
 CellID->16255],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewtonCotesError", "[", 
  RowBox[{"5", ",", "f", ",", "a", ",", 
   RowBox[{"a", "+", "h"}]}], "]"}]], "Input",
 CellLabel->"In[4]:=",
 CellID->18824],

Cell[BoxData[
 FractionBox[
  RowBox[{
   SuperscriptBox["h", "7"], " ", 
   SuperscriptBox["f", 
    TagBox[
     RowBox[{"(", "6", ")"}],
     Derivative],
    MultilineFunction->None]}], "1935360"]], "Output",
 ImageSize->{62, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[4]=",
 CellID->2041744]
}, Open  ]],

Cell[TextData[{
 "This gives the abscissas and weights for the five\[Hyphen]point open Newton\
\[Hyphen]Cotes quadrature formula on the interval (",
 Cell[BoxData[
  FormBox["-", TraditionalForm]], "InlineFormula"],
 "3, 7). "
}], "MathCaption",
 CellID->27445],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewtonCotesWeights", "[", 
  RowBox[{"5", ",", 
   RowBox[{"-", "3"}], ",", "7", ",", 
   RowBox[{"QuadratureType", "\[Rule]", "Open"}]}], "]"}]], "Input",
 CellLabel->"In[5]:=",
 CellID->2524],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "2"}], ",", 
     FractionBox["1375", "576"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"0", ",", 
     FractionBox["125", "144"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"2", ",", 
     FractionBox["335", "96"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"4", ",", 
     FractionBox["125", "144"]}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"6", ",", 
     FractionBox["1375", "576"]}], "}"}]}], "}"}]], "Output",
 ImageSize->{371, 30},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[5]=",
 CellID->98611689]
}, Open  ]],

Cell["Here is the error in that formula. ", "MathCaption",
 CellID->24385],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"NewtonCotesError", "[", 
  RowBox[{"5", ",", "f", ",", 
   RowBox[{"-", "3"}], ",", "7", ",", 
   RowBox[{"QuadratureType", "\[Rule]", "Open"}]}], "]"}]], "Input",
 CellLabel->"In[6]:=",
 CellID->14352],

Cell[BoxData[
 RowBox[{"-", 
  FractionBox[
   RowBox[{"5575", " ", 
    SuperscriptBox["f", 
     TagBox[
      RowBox[{"(", "6", ")"}],
      Derivative],
     MultilineFunction->None]}], "1512"]}]], "Output",
 ImageSize->{70, 33},
 ImageMargins->{{0, 0}, {0, 0}},
 ImageRegion->{{0, 1}, {0, 1}},
 CellLabel->"Out[6]=",
 CellID->281015617]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[" ", "FooterCell"]
},
Saveable->False,
ScreenStyleEnvironment->"Working",
WindowSize->{725, 750},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
WindowTitle->"Numerical Differential Equation Analysis Package - Wolfram \
Mathematica",
TaggingRules->{
 "ModificationHighlight" -> False, 
  "Metadata" -> {
   "built" -> "{2007, 4, 20, 21, 4, 51.5785514}", "context" -> "", 
    "keywords" -> {}, "index" -> True, "label" -> 
    "Numerical Differential Equation Analysis Package Tutorial", "language" -> 
    "en", "paclet" -> "NumericalDifferentialEquationAnalysis Package", 
    "status" -> "None", "summary" -> 
    "The NumericalDifferentialEquationAnalysis package combines functionality \
for analyzing differential equations using Butcher trees, Gaussian \
quadrature, and Newton-Cotes quadrature. This loads the package: Runge-Kutta \
methods are useful for numerically solving certain types of ordinary \
differential equations. Deriving high-order Runge-Kutta methods is no easy \
task, however. There are several reasons for this. The first difficulty is in \
finding the so-called order conditions. These are nonlinear equations in the \
coefficients for the method that must be satisfied to make the error in the \
method of order O(h^n) for some integer n where h is the step size. The \
second difficulty is in solving these equations. Besides being nonlinear, \
there is generally no unique solution, and many heuristics and simplifying \
assumptions are usually made. Finally, there is the problem of combinatorial \
explosion. For a twelfth-order method there are 7813 order conditions! ", 
    "synonyms" -> {}, "title" -> 
    "Numerical Differential Equation Analysis Package", "type" -> "Tutorial", 
    "uri" -> "NumericalDifferentialEquationAnalysis/tutorial/\
NumericalDifferentialEquationAnalysis"}},
FrontEndVersion->"6.0 for Microsoft Windows (32-bit) (April 17, 2007)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[
    StyleDefinitions -> FrontEnd`FileName[{"Wolfram"}, "Reference.nb"]]], 
   Cell[
    StyleData["Input"], CellContext -> "Global`"], 
   Cell[
    StyleData["Output"], CellContext -> "Global`"]}, Visible -> False, 
  FrontEndVersion -> "6.0 for Microsoft Windows (32-bit) (April 17, 2007)", 
  StyleDefinitions -> "Default.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[568, 21, 29, 0, 8, "TutorialColorBar"],
Cell[600, 23, 6884, 138, 70, "AnchorBarGrid"],
Cell[CellGroupData[{
Cell[7509, 165, 85, 1, 70, "Title",
 CellID->509267359],
Cell[7597, 168, 433, 11, 70, "Text",
 CellID->1534169418],
Cell[8033, 181, 66, 1, 70, "MathCaption",
 CellID->836781195],
Cell[8102, 184, 126, 3, 70, "Input",
 CellID->2058623809],
Cell[CellGroupData[{
Cell[8253, 191, 41, 1, 70, "Section",
 CellID->6856],
Cell[8297, 194, 1247, 29, 70, "Text",
 CellID->14705],
Cell[9547, 225, 1017, 37, 70, "Text",
 CellID->3238],
Cell[10567, 264, 898, 34, 70, "DisplayMath",
 CellID->21100],
Cell[11468, 300, 37, 1, 70, "Text",
 CellID->7194],
Cell[11508, 303, 1111, 39, 70, "DisplayMath",
 CellID->8825],
Cell[12622, 344, 843, 29, 70, "Text",
 CellID->2002],
Cell[13468, 375, 544, 19, 70, "DisplayMath",
 CellID->18008],
Cell[14015, 396, 176, 4, 70, "Text",
 CellID->30534],
Cell[14194, 402, 1485, 54, 70, "Text",
 CellID->13933],
Cell[15682, 458, 1043, 25, 70, "Text",
 CellID->31953],
Cell[16728, 485, 86, 1, 70, "Text",
 CellID->28942],
Cell[16817, 488, 1909, 67, 70, "DefinitionBox",
 CellID->1359],
Cell[18729, 557, 75, 1, 70, "Caption",
 CellID->24595],
Cell[18807, 560, 1764, 55, 70, "DefinitionBox",
 CellID->2526],
Cell[20574, 617, 123, 4, 70, "Caption",
 CellID->7208],
Cell[20700, 623, 790, 24, 70, "DefinitionBox",
 CellID->15480],
Cell[21493, 649, 270, 10, 70, "Caption",
 CellID->880],
Cell[21766, 661, 241, 7, 70, "MathCaption",
 CellID->10330],
Cell[CellGroupData[{
Cell[22032, 672, 147, 4, 70, "Input",
 CellID->25998],
Cell[22182, 678, 299, 9, 36, "Output",
 CellID->502197435]
}, Open  ]],
Cell[22496, 690, 231, 5, 70, "MathCaption",
 CellID->10737],
Cell[CellGroupData[{
Cell[22752, 699, 195, 5, 28, "Input",
 CellID->10291],
Cell[22950, 706, 1135, 23, 36, "Output",
 Evaluatable->False,
 CellID->833034915]
}, Open  ]],
Cell[24100, 732, 232, 5, 70, "MathCaption",
 CellID->28443],
Cell[CellGroupData[{
Cell[24357, 741, 139, 4, 70, "Input",
 CellID->6337],
Cell[24499, 747, 732, 26, 51, "Output",
 CellID->35809828]
}, Open  ]],
Cell[25246, 776, 465, 8, 70, "Text",
 CellID->11928],
Cell[25714, 786, 254, 8, 70, "MathCaption",
 CellID->15357],
Cell[CellGroupData[{
Cell[25993, 798, 140, 4, 70, "Input",
 CellID->13760],
Cell[26136, 804, 629, 22, 58, "Output",
 CellID->474088208]
}, Open  ]],
Cell[26780, 829, 406, 14, 70, "MathCaption",
 CellID->15369],
Cell[CellGroupData[{
Cell[27211, 847, 139, 4, 70, "Input",
 CellID->23761],
Cell[27353, 853, 733, 26, 51, "Output",
 CellID->309912855]
}, Open  ]],
Cell[28101, 882, 269, 6, 70, "MathCaption",
 CellID->6864],
Cell[CellGroupData[{
Cell[28395, 892, 117, 3, 70, "Input",
 CellID->26000],
Cell[28515, 897, 392, 14, 51, "Output",
 CellID->185250287]
}, Open  ]],
Cell[28922, 914, 126, 4, 70, "MathCaption",
 CellID->18934],
Cell[CellGroupData[{
Cell[29073, 922, 606, 19, 70, "Input",
 CellID->8106],
Cell[29682, 943, 732, 26, 51, "Output",
 CellID->28498656]
}, Open  ]],
Cell[30429, 972, 128, 4, 70, "MathCaption",
 CellID->20702],
Cell[CellGroupData[{
Cell[30582, 980, 112, 3, 70, "Input",
 CellID->8985],
Cell[30697, 985, 927, 34, 51, "Output",
 CellID->450027828]
}, Open  ]],
Cell[31639, 1022, 231, 6, 70, "MathCaption",
 CellID->10250],
Cell[CellGroupData[{
Cell[31895, 1032, 206, 7, 70, "Input",
 CellID->167],
Cell[32104, 1041, 1096, 39, 51, "Output",
 CellID->115643467]
}, Open  ]],
Cell[33215, 1083, 402, 7, 70, "MathCaption",
 CellID->4004],
Cell[CellGroupData[{
Cell[33642, 1094, 141, 4, 70, "Input",
 CellID->25533],
Cell[33786, 1100, 1732, 58, 81, "Output",
 CellID->159903654]
}, Open  ]],
Cell[35533, 1161, 2516, 74, 70, "DefinitionBox",
 CellID->4020],
Cell[38052, 1237, 330, 10, 70, "Caption",
 CellID->4577],
Cell[38385, 1249, 1610, 51, 70, "Text",
 CellID->6990],
Cell[39998, 1302, 198, 5, 70, "MathCaption",
 CellID->26071],
Cell[CellGroupData[{
Cell[40221, 1311, 216, 6, 70, "Input",
 CellID->19906],
Cell[40440, 1319, 733, 26, 51, "Output",
 CellID->54397424]
}, Open  ]],
Cell[41188, 1348, 252, 7, 70, "MathCaption",
 CellID->19605],
Cell[CellGroupData[{
Cell[41465, 1359, 329, 10, 70, "Input",
 CellID->18359],
Cell[41797, 1371, 733, 26, 51, "Output",
 CellID->76290986]
}, Open  ]],
Cell[42545, 1400, 390, 7, 70, "MathCaption",
 CellID->21774],
Cell[CellGroupData[{
Cell[42960, 1411, 203, 5, 70, "Input",
 CellID->20697],
Cell[43166, 1418, 709, 25, 51, "Output",
 CellID->253404465]
}, Open  ]],
Cell[43890, 1446, 2041, 66, 70, "DefinitionBox",
 CellID->25661],
Cell[45934, 1514, 128, 4, 70, "Caption",
 CellID->4361],
Cell[46065, 1520, 835, 21, 70, "Text",
 CellID->12877],
Cell[46903, 1543, 100, 2, 70, "MathCaption",
 CellID->17210],
Cell[CellGroupData[{
Cell[47028, 1549, 116, 3, 70, "Input",
 CellID->12084],
Cell[47147, 1554, 1263, 46, 51, "Output",
 CellID->80971349]
}, Open  ]],
Cell[48425, 1603, 95, 1, 70, "MathCaption",
 CellID->31450],
Cell[CellGroupData[{
Cell[48545, 1608, 113, 3, 70, "Input",
 CellID->19624],
Cell[48661, 1613, 653, 23, 54, "Output",
 CellID->781618248]
}, Open  ]],
Cell[49329, 1639, 89, 1, 70, "MathCaption",
 CellID->6730],
Cell[CellGroupData[{
Cell[49443, 1644, 120, 3, 70, "Input",
 CellID->24607],
Cell[49566, 1649, 681, 24, 51, "Output",
 CellID->233357895]
}, Open  ]],
Cell[50262, 1676, 382, 9, 70, "Text",
 CellID->26013],
Cell[50647, 1687, 2363, 71, 70, "DefinitionBox",
 CellID->10674],
Cell[53013, 1760, 79, 1, 70, "Caption",
 CellID->28855],
Cell[53095, 1763, 241, 7, 70, "MathCaption",
 CellID->21132],
Cell[CellGroupData[{
Cell[53361, 1774, 105, 3, 70, "Input",
 CellID->30292],
Cell[53469, 1779, 464, 16, 39, "Output",
 CellID->308325065]
}, Open  ]],
Cell[53948, 1798, 240, 7, 70, "MathCaption",
 CellID->9914],
Cell[CellGroupData[{
Cell[54213, 1809, 413, 14, 70, "Input",
 CellID->7942],
Cell[54629, 1825, 211, 7, 36, "Output",
 CellID->626970872]
}, Open  ]],
Cell[54855, 1835, 304, 7, 70, "MathCaption",
 CellID->13484],
Cell[CellGroupData[{
Cell[55184, 1846, 108, 3, 70, "Input",
 CellID->902],
Cell[55295, 1851, 300, 9, 36, "Output",
 CellID->122808536]
}, Open  ]],
Cell[55610, 1863, 229, 7, 70, "MathCaption",
 CellID->22606],
Cell[CellGroupData[{
Cell[55864, 1874, 202, 6, 70, "Input",
 CellID->18972],
Cell[56069, 1882, 302, 9, 36, "Output",
 CellID->184945023]
}, Open  ]],
Cell[56386, 1894, 446, 12, 70, "Text",
 CellID->26207],
Cell[56835, 1908, 362, 7, 70, "MathCaption",
 CellID->8154],
Cell[CellGroupData[{
Cell[57222, 1919, 145, 4, 70, "Input",
 CellID->24455],
Cell[57370, 1925, 289, 10, 36, "Output",
 CellID->275301882]
}, Open  ]],
Cell[57674, 1938, 256, 5, 70, "Text",
 CellID->16354],
Cell[57933, 1945, 1070, 37, 70, "DefinitionBox",
 CellID->11911],
Cell[59006, 1984, 58, 1, 70, "Caption",
 CellID->24859],
Cell[59067, 1987, 1297, 39, 70, "DefinitionBox",
 CellID->5956],
Cell[60367, 2028, 239, 10, 70, "Caption",
 CellID->28361],
Cell[60609, 2040, 87, 1, 70, "MathCaption",
 CellID->3881],
Cell[CellGroupData[{
Cell[60721, 2045, 361, 11, 28, "Input",
 CellID->14958],
Cell[61085, 2058, 2087, 38, 201, "Output",
 Evaluatable->False,
 CellID->23854453]
}, Open  ]],
Cell[63187, 2099, 498, 13, 70, "Text",
 CellID->6145],
Cell[63688, 2114, 5795, 183, 70, "DefinitionBox",
 CellID->14797],
Cell[69486, 2299, 82, 1, 70, "Caption",
 CellID->11861],
Cell[69571, 2302, 154, 7, 70, "MathCaption",
 CellID->9384],
Cell[CellGroupData[{
Cell[69750, 2313, 245, 8, 70, "Input",
 CellID->24800],
Cell[69998, 2323, 159, 5, 36, "Output",
 CellID->102725931]
}, Open  ]],
Cell[70172, 2331, 157, 7, 70, "MathCaption",
 CellID->25762],
Cell[CellGroupData[{
Cell[70354, 2342, 244, 8, 70, "Input",
 CellID->8182],
Cell[70601, 2352, 160, 5, 36, "Output",
 CellID->319992184]
}, Open  ]],
Cell[70776, 2360, 296, 11, 70, "MathCaption",
 CellID->24882],
Cell[CellGroupData[{
Cell[71097, 2375, 271, 9, 70, "Input",
 CellID->16750],
Cell[71371, 2386, 692, 24, 60, "Output",
 CellID->32058240]
}, Open  ]],
Cell[72078, 2413, 234, 6, 70, "MathCaption",
 CellID->20847],
Cell[CellGroupData[{
Cell[72337, 2423, 191, 5, 70, "Input",
 CellID->6368],
Cell[72531, 2430, 421, 15, 50, "Output",
 CellID->63746708]
}, Open  ]],
Cell[72967, 2448, 757, 20, 70, "Text",
 CellID->23615]
}, Open  ]],
Cell[CellGroupData[{
Cell[73761, 2473, 54, 1, 70, "Section",
 CellID->32120],
Cell[73818, 2476, 753, 20, 70, "Text",
 CellID->24966],
Cell[74574, 2498, 210, 5, 70, "Text",
 CellID->11976],
Cell[74787, 2505, 634, 23, 70, "DisplayMath",
 CellID->15468],
Cell[75424, 2530, 1008, 29, 70, "Text",
 CellID->20018],
Cell[76435, 2561, 2679, 87, 70, "DefinitionBox",
 CellID->22522],
Cell[79117, 2650, 77, 1, 70, "Caption",
 CellID->28612],
Cell[79197, 2653, 244, 7, 70, "MathCaption",
 CellID->22773],
Cell[CellGroupData[{
Cell[79466, 2664, 169, 5, 70, "Input",
 CellID->13766],
Cell[79638, 2671, 695, 22, 54, "Output",
 CellID->160642560]
}, Open  ]],
Cell[80348, 2696, 324, 9, 70, "MathCaption",
 CellID->22990],
Cell[CellGroupData[{
Cell[80697, 2709, 177, 5, 70, "Input",
 CellID->21987],
Cell[80877, 2716, 325, 12, 36, "Output",
 CellID->347019929]
}, Open  ]],
Cell[81217, 2731, 126, 4, 70, "MathCaption",
 CellID->3993],
Cell[CellGroupData[{
Cell[81368, 2739, 181, 5, 70, "Input",
 CellID->7662],
Cell[81552, 2746, 362, 13, 36, "Output",
 CellID->189162340]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[81963, 2765, 55, 1, 70, "Section",
 CellID->12503],
Cell[82021, 2768, 698, 16, 70, "Text",
 CellID->20661],
Cell[82722, 2786, 227, 5, 70, "Text",
 CellID->1918],
Cell[82952, 2793, 634, 23, 70, "DisplayMath",
 CellID->31012],
Cell[83589, 2818, 451, 8, 70, "Text",
 CellID->5788],
Cell[84043, 2828, 646, 15, 70, "Text",
 CellID->2474],
Cell[84692, 2845, 1167, 40, 70, "DefinitionBox",
 CellID->9743],
Cell[85862, 2887, 97, 3, 70, "Caption",
 CellID->10337],
Cell[85962, 2892, 731, 20, 70, "DefinitionBox3Col",
 CellID->12893],
Cell[86696, 2914, 443, 17, 70, "Caption",
 CellID->23362],
Cell[87142, 2933, 328, 11, 70, "MathCaption",
 CellID->25567],
Cell[CellGroupData[{
Cell[87495, 2948, 161, 5, 70, "Input",
 CellID->1209],
Cell[87659, 2955, 692, 26, 51, "Output",
 CellID->108031862]
}, Open  ]],
Cell[88366, 2984, 324, 9, 70, "MathCaption",
 CellID->32421],
Cell[CellGroupData[{
Cell[88715, 2997, 169, 5, 70, "Input",
 CellID->5162],
Cell[88887, 3004, 318, 12, 54, "Output",
 CellID->313385813]
}, Open  ]],
Cell[89220, 3019, 127, 4, 70, "MathCaption",
 CellID->16255],
Cell[CellGroupData[{
Cell[89372, 3027, 175, 5, 70, "Input",
 CellID->18824],
Cell[89550, 3034, 340, 13, 54, "Output",
 CellID->2041744]
}, Open  ]],
Cell[89905, 3050, 261, 7, 70, "MathCaption",
 CellID->27445],
Cell[CellGroupData[{
Cell[90191, 3061, 217, 6, 70, "Input",
 CellID->2524],
Cell[90411, 3069, 640, 23, 51, "Output",
 CellID->98611689]
}, Open  ]],
Cell[91066, 3095, 74, 1, 70, "MathCaption",
 CellID->24385],
Cell[CellGroupData[{
Cell[91165, 3100, 226, 6, 70, "Input",
 CellID->14352],
Cell[91394, 3108, 341, 13, 54, "Output",
 CellID->281015617]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[91774, 3126, 23, 0, 70, "FooterCell"]
}
]
*)

(* End of internal cache information *)

